#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>

main(int argc, char *argv[])
{
	FILE *in,*out1,*out2;
	int numspr1,numspr2,numspr3,width,height,total;
	unsigned long int sproffset,addoffset;
	unsigned char inbyte,keyboard;
	int counter1,counter2;
	struct spriteheader
	{
		  unsigned long int sproffset;
		  int width,height;
		  struct spriteheader * next;
		  struct spriteheader * last;
	};
	struct spriteheader * new=NULL;
	struct spriteheader * working=NULL;
	struct spriteheader * first=NULL;

	char spr1name[9]="    .spr";
	char spr2name[9]="    .spr";
	char spr3name[9]="    .spr";

	if(argc==5)
	{
		spr1name[0]=argv[1][0];
		spr1name[1]=argv[1][1];
		spr1name[2]=argv[1][2];
		spr1name[3]=argv[1][3];
		spr2name[0]=argv[2][0];
		spr2name[1]=argv[2][1];
		spr2name[2]=argv[2][2];
		spr2name[3]=argv[2][3];
		spr3name[0]=argv[3][0];
		spr3name[1]=argv[3][1];
		spr3name[2]=argv[3][2];
		spr3name[3]=argv[3][3];
		numspr2=atoi(argv[4]);
	}
	else
	{
		fprintf(stderr,"Usage is SPLITSPR file1 file2 file3 # where filenames are 4 characters\n");
		fprintf(stderr,"long without the extension and all three filenames are different.\n");
		fprintf(stderr,"# is the number of sprites to go into file2.  The program must be\n");
		fprintf(stderr,"run from within the images directory.\n");
		return(1);
	}
	if((in=fopen(spr1name,"rb"))==NULL)
	{
		fprintf(stderr,"Cannot open ");
		fprintf(stderr,spr1name);
		fprintf(stderr,"\n");
		return(1);
	}
	printf("Opened %s \n",spr1name);
	if((out1=fopen(spr2name,"rb"))!=NULL)
	{
		fprintf(stderr,spr2name);
		fprintf(stderr," already exists.  Overwrite? (Y/N) ");
		do
			keyboard=getch();
		while((keyboard!='n')&&(keyboard!='N')&&(keyboard!='y')&&(keyboard!='Y'));
		fprintf(stderr,"\n");
		if((keyboard=='n')||(keyboard=='N'))
		{
			fclose(in);
			fclose(out1);
			return(0);
		}
	}
	fclose(out1);
	out1=fopen(spr2name,"wb");
	if((out2=fopen(spr3name,"rb"))!=NULL)
	{
		fprintf(stderr,spr3name);
		fprintf(stderr," already exists.  Overwrite? (Y/N) ");
		do
			keyboard=getch();
		while((keyboard!='n')&&(keyboard!='N')&&(keyboard!='y')&&(keyboard!='Y'));
		fprintf(stderr,"\n");
		if((keyboard=='n')||(keyboard=='N'))
		{
			fclose(in);
			fclose(out1);
			fclose(out2);
			return(0);
		}
	}
	fclose(out2);
	out2=fopen(spr3name,"wb");
	fread(&numspr1,2,1,in);
	if(numspr1<numspr2)
	{
		printf("Not enough sprites to perform the split.  Need %i.\n",numspr2);
		return(1);
	}
	numspr3=numspr1-numspr2;

	fprintf(stdout,"Reading in headers.\n");

	addoffset=2+(numspr2*8);
	for(counter1=1;counter1<=numspr1;counter1++)
	{
		new=(struct spriteheader *)malloc(sizeof(struct spriteheader));
		if(new==NULL) return(1);
		if(working!=NULL) working->next=new; else first=new;
		new->last=working;
		working=new;
		fread(&sproffset,1,4,in);
		fread(&width,1,2,in);
		fread(&height,1,2,in);
		working->sproffset=addoffset;
		working->width=width;
		working->height=height;
		total=width*height;
		addoffset+=total;
		if(counter1==numspr2) addoffset=2+(numspr3*8);
	}

	fprintf(stdout,"Writing out first new sprite file header.\n");

	fwrite(&numspr2,2,1,out1);
	working=first;
	for(counter1=1;counter1<=numspr2;counter1++)
	{
		sproffset=working->sproffset;
		width=working->width;
		height=working->height;
		fwrite(&sproffset,1,4,out1);
		fwrite(&width,1,2,out1);
		fwrite(&height,1,2,out1);
		working=working->next;
	}
	inbyte=0;
	fwrite(&inbyte,1,1,out1);
	fwrite(&inbyte,1,1,out1);

	fprintf(stdout,"Writing out second new sprite file header.\n");

	fwrite(&numspr3,2,1,out2);
	for(counter1=1;counter1<=numspr3;counter1++)
	{
		sproffset=working->sproffset;
		width=working->width;
		height=working->height;
		fwrite(&sproffset,1,4,out2);
		fwrite(&width,1,2,out2);
		fwrite(&height,1,2,out2);
		working=working->next;
	}
	fwrite(&inbyte,1,1,out2);
	fwrite(&inbyte,1,1,out2);

	fprintf(stdout,"Processing data for first output file.\n");

	working=first;
	fread(&inbyte,1,1,in);
	fread(&inbyte,1,1,in);
	for(counter1=1;counter1<=numspr2;counter1++)
	{
		total=working->width*working->height;
		for(counter2=1;counter2<=total;counter2++)
		{
			fread(&inbyte,1,1,in);
			fwrite(&inbyte,1,1,out1);
		}
		printf("Sprite # %i is %i x %i\n",counter1,working->width,working->height);
		working=working->next;
	}

	fprintf(stdout,"Processing data for second output file.\n");

	for(counter1=1;counter1<=numspr3;counter1++)
	{
		total=working->width*working->height;
		for(counter2=1;counter2<=total;counter2++)
		{
			fread(&inbyte,1,1,in);
			fwrite(&inbyte,1,1,out2);
		}
		printf("Sprite # %i is %i x %i\n",counter1,working->width,working->height);
		working=working->next;
	}

	fclose(in);
	fclose(out1);
	fclose(out2);

	fprintf(stdout,"Freeing memory allocations.\n");
	working=first;
	while(working->next!=NULL)	working=working->next;
	while(working->last!=NULL)
	{
		new=working->last;
		free(working);
		working=new;
	};

	printf("# Sprites in %s = %u\n",spr1name,numspr1);
	printf("# Sprites in %s = %u\n",spr2name,numspr2);
	printf("# Sprites in %s = %u\n",spr3name,numspr3);
	fprintf(stdout,"Press any key to continue . . .");
	keyboard=getch();
	return(0);
}
