VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmSpriteEditor 
   Caption         =   "Sprite Editor"
   ClientHeight    =   5445
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   5775
   Icon            =   "SpriteEditor.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   OLEDropMode     =   1  'Manual
   ScaleHeight     =   363
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   385
   StartUpPosition =   2  'CenterScreen
   Begin MSComDlg.CommonDialog ctlCommonDialog 
      Left            =   5280
      Top             =   4920
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
      CancelError     =   -1  'True
      Flags           =   4102
      MaxFileSize     =   4096
   End
   Begin VB.Frame fraAnimation 
      Caption         =   "Animation"
      Height          =   1020
      Left            =   1440
      OLEDropMode     =   1  'Manual
      TabIndex        =   5
      Top             =   4110
      Width           =   4335
      Begin VB.CommandButton cmdAnimClear 
         Caption         =   "C&lear"
         Height          =   315
         Left            =   2400
         OLEDropMode     =   1  'Manual
         TabIndex        =   8
         Top             =   180
         Width           =   855
      End
      Begin VB.CommandButton cmdAnimType 
         Caption         =   "&Creature"
         Height          =   315
         Left            =   3360
         OLEDropMode     =   1  'Manual
         TabIndex        =   9
         Top             =   180
         Width           =   855
      End
      Begin VB.CheckBox chkAnimChooseSequence 
         BeginProperty Font 
            Name            =   "Symbol"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   270
         Left            =   3600
         OLEDropMode     =   1  'Manual
         Picture         =   "SpriteEditor.frx":0442
         Style           =   1  'Graphical
         TabIndex        =   12
         Top             =   607
         Width           =   270
      End
      Begin VB.CommandButton cmdAnimPlay 
         Height          =   270
         Left            =   3960
         OLEDropMode     =   1  'Manual
         Picture         =   "SpriteEditor.frx":074C
         Style           =   1  'Graphical
         TabIndex        =   13
         Top             =   607
         Width           =   270
      End
      Begin VB.TextBox txtAnimSequence 
         Height          =   285
         Left            =   600
         MaxLength       =   32
         OLEDropMode     =   1  'Manual
         TabIndex        =   11
         Top             =   600
         Width           =   2895
      End
      Begin VB.TextBox txtAnimBase 
         Height          =   285
         Left            =   600
         OLEDropMode     =   1  'Manual
         TabIndex        =   7
         Top             =   240
         Width           =   495
      End
      Begin VB.Label lblAnimSequence 
         AutoSize        =   -1  'True
         Caption         =   "&Anim:"
         Height          =   195
         Left            =   120
         OLEDropMode     =   1  'Manual
         TabIndex        =   10
         Top             =   645
         Width           =   390
      End
      Begin VB.Label lblAnimBase 
         AutoSize        =   -1  'True
         Caption         =   "&Base:"
         Height          =   195
         Left            =   120
         OLEDropMode     =   1  'Manual
         TabIndex        =   6
         Top             =   285
         Width           =   405
      End
   End
   Begin VB.Frame fraSpriteType 
      Caption         =   "Sprite Type"
      Height          =   1020
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   1
      Top             =   4110
      Width           =   1335
      Begin VB.OptionButton optS16565 
         Caption         =   "S16 - 5&65"
         Height          =   255
         Left            =   120
         OLEDropMode     =   1  'Manual
         TabIndex        =   4
         Top             =   720
         Width           =   1095
      End
      Begin VB.OptionButton optS16555 
         Caption         =   "S16 - 5&55"
         Height          =   255
         Left            =   120
         OLEDropMode     =   1  'Manual
         TabIndex        =   3
         Top             =   480
         Width           =   1095
      End
      Begin VB.OptionButton optSPR 
         Caption         =   "&SPR"
         Height          =   255
         Left            =   120
         OLEDropMode     =   1  'Manual
         TabIndex        =   2
         Top             =   240
         Width           =   1095
      End
   End
   Begin VB.PictureBox picContainer 
      Height          =   3900
      Left            =   120
      ScaleHeight     =   256
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   365
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   120
      Width           =   5535
      Begin VB.HScrollBar hscPicture 
         Height          =   195
         Left            =   0
         TabIndex        =   16
         TabStop         =   0   'False
         Top             =   3480
         Width           =   4095
      End
      Begin VB.VScrollBar vscPicture 
         Height          =   3735
         Left            =   4020
         TabIndex        =   15
         TabStop         =   0   'False
         Top             =   0
         Width           =   195
      End
      Begin VB.PictureBox picSprite 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00000000&
         BorderStyle     =   0  'None
         ForeColor       =   &H00FFFFFF&
         Height          =   3375
         Left            =   0
         OLEDropMode     =   1  'Manual
         ScaleHeight     =   225
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   249
         TabIndex        =   0
         Top             =   0
         Width           =   3735
      End
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Ready..."
      Height          =   255
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   17
      Top             =   5190
      Width           =   5775
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileNew 
         Caption         =   "&New..."
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open..."
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileSeparator3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFileSaveAs 
         Caption         =   "Save &As..."
      End
      Begin VB.Menu mnuFileSeparator1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileMRUFile 
         Caption         =   "File0"
         Index           =   0
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileMRUFile 
         Caption         =   "File1"
         Index           =   1
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileMRUFile 
         Caption         =   "File2"
         Index           =   2
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileMRUFile 
         Caption         =   "File3"
         Index           =   3
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileSeparator2 
         Caption         =   "-"
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mnuEditCut 
         Caption         =   "Cu&t Image(s)"
      End
      Begin VB.Menu mnuEditCopy 
         Caption         =   "&Copy Image(s)"
      End
      Begin VB.Menu mnuEditPaste 
         Caption         =   "&Paste Image(s)"
      End
      Begin VB.Menu mnuEditDeleteImage 
         Caption         =   "&Delete Image(s)"
      End
      Begin VB.Menu mnueEditSeparator1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuEditImport 
         Caption         =   "Import..."
         Shortcut        =   ^I
      End
      Begin VB.Menu mnuEditExport 
         Caption         =   "&Export..."
         Shortcut        =   ^E
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuViewZoom 
         Caption         =   "Zoom to image"
      End
   End
   Begin VB.Menu mnuTools 
      Caption         =   "&Tools"
      Begin VB.Menu mnuToolsMultipleFileConverter 
         Caption         =   "&Multiple File Converter..."
      End
      Begin VB.Menu mnuToolsSeparator1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuToolsPreferences 
         Caption         =   "&Preferences..."
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpTopics 
         Caption         =   "Help &Topics"
         Shortcut        =   {F1}
      End
      Begin VB.Menu mnuHelpSeparator1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "frmSpriteEditor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Const cResDragCursor = 101
Const cResNoDragCursor = 102

Public Enum AnimTypes
    atObject = 0
    atCreature = 1
End Enum

Private m_nThumbnailGridWidth As Integer
Private m_nThumbnailGridHeight As Integer
Private m_nThumnbailCaptionHeight As Integer

Private m_bDisplayingThumbnails As Boolean
Private m_nDisplayedSprite As Integer

Private nPictureBoxWidthDiff As Integer
Private nPictureBoxHeightDiff As Integer
Private nSpriteFrameYDiff As Integer
Private nStatusLabelYDiff As Integer
Private nStatusLabelWidthDiff As Integer
Private nAnimationFrameYDiff As Integer
Private nAnimPlayXDiff As Integer
Private nAnimRecXDiff As Integer
Private nAnimSeqWidthDiff As Integer
Private nAnimTypeXDiff As Integer
Private nAnimClearXDiff As Integer
Private m_nPictureDrawWidth As Long
Private m_nPictureDrawHeight As Long
Private m_nFocusedThumbnail As Long
Private m_aSelectedThumbnails() As Boolean
Private m_nShiftSelectStart As Long
Private m_nSelectedThumbnailAtX As Long
Private m_nSelectedThumbnailAtY As Long
Private m_bNoDrag As Boolean
Private m_nDropThumbnail As Long
Private m_nDropThumbnailI As Long
Private m_nDropThumbnailJ As Long
Private m_bDraggingThumbnail As Boolean
Private m_eAnimType As AnimTypes
Private m_nAnimBase As Long

Private bChanged As Boolean

Private nDropEffect As Long

Private Function CheckSpriteType() As Boolean
    CheckSpriteType = False
    
    If optSPR.Value Or optS16555.Value Or optS16565.Value Then
        CheckSpriteType = True
    End If
End Function

Private Sub SetCaption()
    Dim sFilename As String
    Dim I As Integer
    
    If g_sSpriteFilename = "" Then
        sFilename = "Untitled"
    Else
        sFilename = g_sSpriteFilename
        For I = Len(g_sSpriteFilename) To 1 Step -1
            If Mid(g_sSpriteFilename, I, 1) = "\" Then
                sFilename = Mid(g_sSpriteFilename, I + 1)
                Exit For
            End If
        Next
    End If
    
    If bChanged Then
        sFilename = sFilename & "*"
    End If
    
    Me.Caption = "Sprite Editor - [" & sFilename & "]"
End Sub

Private Sub InitialiseMRUFiles()
    Dim I As Integer
    Dim bAnyFiles As Boolean
    
    bAnyFiles = False
    
    For I = 0 To 3
        If g_oMRUFiles(I) <> "" Then
            mnuFileMRUFile(I).Caption = "&" & CStr(I + 1) & " " & g_oMRUFiles(I)
            mnuFileMRUFile(I).Visible = True
            bAnyFiles = True
        Else
            mnuFileMRUFile(I).Visible = False
        End If
    Next
    
    mnuFileSeparator2.Visible = bAnyFiles
End Sub

Private Sub InitialiseSelectedThumbnails(Optional bClear As Boolean = False)
    If g_oCurrentSprite.NumberOfSpritesInFile > 0 Then
        If bClear Then
            ReDim m_aSelectedThumbnails(0 To g_oCurrentSprite.NumberOfSpritesInFile - 1)
        Else
            ReDim Preserve m_aSelectedThumbnails(0 To g_oCurrentSprite.NumberOfSpritesInFile - 1)
        End If
    Else
        Erase m_aSelectedThumbnails
    End If
End Sub

Private Sub ClearSelection()
    m_nDisplayedSprite = 0
    m_bDisplayingThumbnails = True
    m_nFocusedThumbnail = -1
    InitialiseSelectedThumbnails True
    txtAnimBase.Text = ""
    txtAnimSequence.Text = ""
End Sub

Private Sub PopulateControls()
    Dim I As Integer
    Dim J As Integer
    
    SetCaption
    
    Select Case g_oCurrentSprite.SpriteType
        Case stcSPR
            optSPR.Value = True
            
        Case stcS16_555
            optS16555.Value = True
            
        Case stcS16_565
            optS16565.Value = True
            
        Case Else
            optSPR.Value = False
            optS16555.Value = False
            optS16565.Value = False
    End Select
    
    Select Case m_eAnimType
        Case atObject
            cmdAnimType.Caption = "&Object"
            
        Case atCreature
            cmdAnimType.Caption = "&Creature"
    End Select
    
    If m_bDisplayingThumbnails Then
        DisplayThumbnails
        EnsureFocusedThumbnailVisible
    Else
        DisplaySprite m_nDisplayedSprite
    End If
    
    If Me.Visible Then
        picSprite.SetFocus
    End If
End Sub

Private Sub DisplaySprite(ByVal nIndex As Integer)
    m_bDisplayingThumbnails = False
    m_nDisplayedSprite = nIndex
    
    hscPicture.Value = 0
    vscPicture.Value = 0
    
    vscPicture.SmallChange = 1
    vscPicture.LargeChange = 10
    hscPicture.SmallChange = 1
    hscPicture.LargeChange = 10
    hscPicture.Enabled = True
    vscPicture.Enabled = True
    
    picContainer_Resize
    
    DrawSprite nIndex
End Sub

Private Sub DrawSprite(ByVal nIndex As Integer)
    Dim I As Integer
    Dim J As Integer
    Dim nWidth As Integer
    Dim oSpriteImage As Bitmap
    Dim aPixels() As Byte
    
    If nIndex < 1 Or nIndex > g_oCurrentSprite.NumberOfSpritesInFile Then
        Exit Sub
    End If
    
    'picSprite.Visible = False
    
    picSprite.DrawMode = vbCopyPen
    picSprite.BackColor = vbWhite
    picSprite.FillColor = vbBlack
    picSprite.FillStyle = vbDiagonalCross
    picSprite.Line (-1, -1)-(picSprite.ScaleWidth, picSprite.ScaleHeight), , B
    
    Set oSpriteImage = g_oCurrentSprite.SpriteImages(nIndex)
    
    If oSpriteImage.Width > 0 And oSpriteImage.Height > 0 Then
        oSpriteImage.GetPixelArray aPixels
        DrawBitmapXY picSprite.hDC, -hscPicture.Value, -vscPicture.Value, g_oCurrentSprite.SpriteType, oSpriteImage.Width, oSpriteImage.Height, aPixels(0)
    End If
    
    'picSprite.Visible = True
End Sub

Private Sub DisplayThumbnails()
    m_nThumbnailGridWidth = g_nThumbnailSize + g_nThumbnailSpacing * 2
    m_nThumbnailGridHeight = g_nThumbnailSize + m_nThumnbailCaptionHeight * 2 + g_nThumbnailSpacing * 2 + 4
    
    m_nDisplayedSprite = 0
    vscPicture.SmallChange = m_nThumbnailGridHeight
    vscPicture.LargeChange = vscPicture.SmallChange
    vscPicture.Value = 0
    hscPicture.Enabled = False
    
    If g_oCurrentSprite.NumberOfSpritesInFile > 0 And m_nFocusedThumbnail < 0 Then
        m_nFocusedThumbnail = 0
        InitialiseSelectedThumbnails True
        m_aSelectedThumbnails(0) = True
    End If
    
    m_bDisplayingThumbnails = True
    
    picContainer_Resize
    
    DrawThumbnails
End Sub

Private Sub DrawThumbnail(ByVal oImage As Bitmap, ByVal I As Integer, ByVal J As Integer, ByVal bFocused As Boolean, ByVal bSelected As Boolean, ByVal nImageNumber As Long)
    Dim nDrawWidth As Long
    Dim nDrawHeight As Long
    Dim tCaptionRect As RECT
    Dim sImageNumber As String
    Dim sScale As String
    Dim sDimensions As String
    Dim aPixels() As Byte
    Dim nScale As Integer
    Dim nBoxLeft As Integer
    Dim nBoxTop As Integer
    Dim nBoxRight As Integer
    Dim nBoxBottom As Integer
    
    nBoxLeft = I * m_nThumbnailGridWidth
    nBoxTop = J * m_nThumbnailGridHeight - vscPicture.Value
    nBoxRight = nBoxLeft + m_nThumbnailGridWidth - 1
    nBoxBottom = nBoxTop + m_nThumbnailGridHeight - 1
    
    If bSelected Then
        picSprite.Line (nBoxLeft, nBoxTop)-(nBoxRight, nBoxBottom), vbHighlight, BF
    Else
        picSprite.Line (nBoxLeft, nBoxTop)-(nBoxRight, nBoxBottom), vbBlack, BF
    End If
    
    If g_bThumbnailShowImages Then
        oImage.GetPixelArray aPixels
        
        If oImage.Width <= g_nThumbnailSize And oImage.Height <= g_nThumbnailSize Then
            nDrawWidth = oImage.Width
            nDrawHeight = oImage.Height
            nScale = 100
        Else
            If oImage.Width > oImage.Height Then
                nDrawWidth = g_nThumbnailSize
                nDrawHeight = Int((CLng(oImage.Height) * CLng(g_nThumbnailSize)) / CLng(oImage.Width))
                nScale = Int((100 * g_nThumbnailSize) / oImage.Width)
            ElseIf oImage.Width < oImage.Height Then
                nDrawWidth = Int((CLng(oImage.Width) * CLng(g_nThumbnailSize)) / CLng(oImage.Height))
                nDrawHeight = g_nThumbnailSize
                nScale = Int((100 * g_nThumbnailSize) / oImage.Height)
            ElseIf oImage.Width = oImage.Height Then
                nDrawWidth = g_nThumbnailSize
                nDrawHeight = g_nThumbnailSize
                nScale = Int((100 * g_nThumbnailSize) / oImage.Width)
            End If
        End If
        
        DrawBitmapXYScale picSprite.hDC, nBoxLeft + (m_nThumbnailGridWidth - nDrawWidth) / 2, nBoxTop + m_nThumnbailCaptionHeight + (m_nThumbnailGridHeight - m_nThumnbailCaptionHeight * 2 - nDrawHeight) / 2, nDrawWidth, nDrawHeight, g_oCurrentSprite.SpriteType, oImage.Width, oImage.Height, aPixels(0)
    End If
    
    If g_bThumbnailShowCaptions Then
        sImageNumber = CStr(nImageNumber)
        sScale = CStr(nScale) & "%"
        sDimensions = "[" & CStr(oImage.Width) & "x" & CStr(oImage.Height) & "]"
        
        With tCaptionRect
            .Left = nBoxLeft
            .Top = nBoxTop + 2
            .Right = nBoxRight
            .Bottom = nBoxBottom - 2
        End With
        
        If g_bThumbnailShowImages Then
            DrawText picSprite.hDC, sImageNumber, Len(sImageNumber), tCaptionRect, DT_EXTERNALLEADING Or DT_CENTER Or DT_SINGLELINE
            'DrawText picSprite.hDC, sScale, Len(sScale), tCaptionRect, DT_EXTERNALLEADING Or DT_LEFT Or DT_BOTTOM Or DT_SINGLELINE
            DrawText picSprite.hDC, sDimensions, Len(sDimensions), tCaptionRect, DT_EXTERNALLEADING Or DT_CENTER Or DT_BOTTOM Or DT_SINGLELINE
        Else
            DrawText picSprite.hDC, sImageNumber, Len(sImageNumber), tCaptionRect, DT_EXTERNALLEADING Or DT_CENTER Or DT_VCENTER Or DT_SINGLELINE
            DrawText picSprite.hDC, sDimensions, Len(sDimensions), tCaptionRect, DT_EXTERNALLEADING Or DT_CENTER Or DT_BOTTOM Or DT_SINGLELINE
        End If
    End If
    
    If bFocused Then
        picSprite.DrawWidth = 1
        picSprite.DrawStyle = vbDot
        picSprite.DrawMode = vbXorPen
        picSprite.Line (nBoxLeft, nBoxTop)-(nBoxRight, nBoxBottom), vbWhite, B
        picSprite.DrawMode = vbCopyPen
        picSprite.DrawStyle = vbSolid
    End If
End Sub

Private Sub DrawThumbnails()
    Dim nXCount As Integer
    Dim nYCount As Integer
    Dim I As Integer
    Dim J As Integer
    Dim oImage As Bitmap
    Dim aPixels() As Byte
    Dim nDrawWidth As Long
    Dim nDrawHeight As Long
    Dim nIndexOffset As Long
    Dim nIndex As Long
    Dim sCaption As String
    Dim tCaptionRect As RECT
    
    picSprite.DrawMode = vbCopyPen
    picSprite.BackColor = vbBlack
    picSprite.FillStyle = vbFSTransparent
    
    m_nDropThumbnail = -1
    
    If g_oCurrentSprite.NumberOfSpritesInFile <= 0 Then
        m_nFocusedThumbnail = -1
        picSprite.Cls
        vscPicture.Enabled = False
        Exit Sub
    End If
    
    nXCount = Int(picSprite.Width / m_nThumbnailGridWidth)
    nYCount = Int(picSprite.Height / m_nThumbnailGridHeight) + 1
    
    I = 0
    J = 0
    
    nIndexOffset = Int(vscPicture.Value / m_nThumbnailGridHeight)
    
    picSprite.Cls
    
    Do While (I + (J + nIndexOffset) * nXCount) < g_oCurrentSprite.NumberOfSpritesInFile And J <= nYCount
        nIndex = I + (J + nIndexOffset) * nXCount
        Set oImage = g_oCurrentSprite.SpriteImages(nIndex + 1)
        
        DrawThumbnail oImage, I, J + nIndexOffset, (nIndex = m_nFocusedThumbnail), m_aSelectedThumbnails(nIndex), nIndex + g_nSpriteNumbering
        
        I = I + 1
        If I = nXCount Then
            I = 0
            J = J + 1
        End If
    Loop
End Sub

Private Sub EnsureFocusedThumbnailVisible()
    Dim nXCount As Integer
    Dim J As Integer
    
    nXCount = Int(picSprite.Width / m_nThumbnailGridWidth)
    J = Int(m_nFocusedThumbnail / nXCount) * m_nThumbnailGridHeight
    
    If vscPicture.Enabled Then
        If J < vscPicture.Value Then
            If J < vscPicture.Min Then
                vscPicture.Value = vscPicture.Min
            Else
                vscPicture.Value = J
            End If
        ElseIf (J + m_nThumbnailGridHeight) > (vscPicture.Value + picSprite.ScaleHeight) Then
            If (J + m_nThumbnailGridHeight - picSprite.ScaleHeight) > vscPicture.Max Then
                vscPicture.Value = vscPicture.Max
            Else
                vscPicture.Value = J + m_nThumbnailGridHeight - picSprite.ScaleHeight
            End If
        End If
    End If
End Sub

Private Sub DrawInsertionMark(ByVal I As Integer, ByVal J As Integer)
    picSprite.DrawMode = vbXorPen
    picSprite.DrawWidth = 2
    picSprite.Line (I * m_nThumbnailGridWidth - 5, J * m_nThumbnailGridHeight - vscPicture.Value)-(I * m_nThumbnailGridWidth, J * m_nThumbnailGridHeight + 5 - vscPicture.Value), vbHighlight
    picSprite.Line (I * m_nThumbnailGridWidth + 5, J * m_nThumbnailGridHeight - vscPicture.Value)-(I * m_nThumbnailGridWidth, J * m_nThumbnailGridHeight + 5 - vscPicture.Value), vbHighlight
    picSprite.Line (I * m_nThumbnailGridWidth, J * m_nThumbnailGridHeight + 5 - vscPicture.Value)-(I * m_nThumbnailGridWidth, J * m_nThumbnailGridHeight - 4 + m_nThumbnailGridHeight - vscPicture.Value), vbHighlight
    picSprite.Line (I * m_nThumbnailGridWidth - 5, J * m_nThumbnailGridHeight + m_nThumbnailGridHeight - vscPicture.Value)-(I * m_nThumbnailGridWidth, J * m_nThumbnailGridHeight + m_nThumbnailGridHeight - 5 - vscPicture.Value), vbHighlight
    picSprite.Line (I * m_nThumbnailGridWidth + 5, J * m_nThumbnailGridHeight + m_nThumbnailGridHeight - vscPicture.Value)-(I * m_nThumbnailGridWidth, J * m_nThumbnailGridHeight + m_nThumbnailGridHeight - 5 - vscPicture.Value), vbHighlight
    picSprite.DrawWidth = 1
    picSprite.DrawMode = vbCopyPen
End Sub

Private Sub SelectThumbnailAtIndex(ByVal Index As Long, ByVal Modifiers As Integer)
    Dim nXCount As Integer
    Dim I As Long
    Dim J As Long
    
    m_nFocusedThumbnail = Index
    
    If Modifiers = vbCtrlMask Then
        m_aSelectedThumbnails(m_nFocusedThumbnail) = Not m_aSelectedThumbnails(m_nFocusedThumbnail)
        m_nShiftSelectStart = m_nFocusedThumbnail
    ElseIf Modifiers = vbShiftMask Then
        If m_nShiftSelectStart <= m_nFocusedThumbnail Then
            For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
                If I >= m_nShiftSelectStart And I <= m_nFocusedThumbnail Then
                    m_aSelectedThumbnails(I) = True
                Else
                    m_aSelectedThumbnails(I) = False
                End If
            Next
        Else
            For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
                If I >= m_nFocusedThumbnail And I <= m_nShiftSelectStart Then
                    m_aSelectedThumbnails(I) = True
                Else
                    m_aSelectedThumbnails(I) = False
                End If
            Next
        End If
    ElseIf Modifiers = 0 Then
        For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
            If m_aSelectedThumbnails(I) And Not I = m_nFocusedThumbnail Then
                m_aSelectedThumbnails(I) = False
            ElseIf I = m_nFocusedThumbnail Then
                m_aSelectedThumbnails(I) = True
            End If
        Next
        
        m_nShiftSelectStart = m_nFocusedThumbnail
    End If
    
    EnsureFocusedThumbnailVisible
    
    DrawThumbnails
    
'    Else
'        If Modifiers = 0 Then
'            For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
'                If m_aSelectedThumbnails(I) Then
'                    m_aSelectedThumbnails(I) = False
'                End If
'            Next
'            DrawThumbnails
'        End If
'        m_nShiftSelectStart = -1
'    End If
    
    If chkAnimChooseSequence.Value = vbChecked Then
        If m_nAnimBase < 0 Then
            txtAnimBase.Text = CStr(m_nFocusedThumbnail)
            m_nAnimBase = m_nFocusedThumbnail
        End If
        
        If m_nFocusedThumbnail >= m_nAnimBase Then
            Select Case m_eAnimType
                Case atObject
                    If (m_nFocusedThumbnail - m_nAnimBase) > 9 Then
                        MsgBox "An object animation step can only be up to 9 images away from the base.", vbOKOnly Or vbExclamation
                    Else
                        txtAnimSequence.Text = txtAnimSequence.Text & Format(m_nFocusedThumbnail - m_nAnimBase, "0")
                    End If
                    
                Case atCreature
                    If (m_nFocusedThumbnail - m_nAnimBase) > 999 Then
                        MsgBox "A creature animation step can only be up to 999 steps images from the base.", vbOKOnly Or vbExclamation
                    Else
                        txtAnimSequence.Text = txtAnimSequence.Text & Format(m_nFocusedThumbnail - m_nAnimBase, "000")
                    End If
            End Select
        Else
            MsgBox "An animation step must be on or after the base.", vbOKOnly Or vbExclamation
        End If
    End If
End Sub

Private Sub SelectThumbnailAtXY(ByVal X As Long, ByVal Y As Long, ByVal Modifiers As Integer)
    Dim nXCount As Integer
    Dim I As Integer
    Dim J As Integer
    Dim nIndex As Long
    
    nXCount = Int(picSprite.Width / m_nThumbnailGridWidth)
    
    I = Int(X / m_nThumbnailGridWidth)
    J = Int((Y + vscPicture.Value) / m_nThumbnailGridHeight)
    
    If I >= nXCount Then
        Exit Sub
    Else
        If J * nXCount + I >= g_oCurrentSprite.NumberOfSpritesInFile Then
            Exit Sub
        Else
            nIndex = J * nXCount + I
            m_nSelectedThumbnailAtX = X
            m_nSelectedThumbnailAtY = Y
        End If
    End If
    
    SelectThumbnailAtIndex nIndex, Modifiers
End Sub

Private Function CountThumbnailsSelected() As Long
    Dim I As Long
    Dim nCount As Long
    
    For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
        If m_aSelectedThumbnails(I) Then
            nCount = nCount + 1
        End If
    Next
    
    CountThumbnailsSelected = nCount
End Function

Private Sub RemoveSprite(ByVal Index As Long)
    Dim I As Long
    
    For I = Index To g_oCurrentSprite.NumberOfSpritesInFile - 2
        m_aSelectedThumbnails(I) = m_aSelectedThumbnails(I + 1)
    Next
    
    g_oCurrentSprite.DeleteSpriteImage Index + 1
    
    If g_oCurrentSprite.NumberOfSpritesInFile > 0 Then
        ReDim Preserve m_aSelectedThumbnails(0 To g_oCurrentSprite.NumberOfSpritesInFile - 1)
    End If
End Sub

Public Sub OpenSpriteFile(sFilename As String)
    Dim I As Integer
    Dim oNewSprite As New Sprite
    
    MousePointer = vbHourglass
    lblStatus = "Loading " & sFilename & "..."
    DoEvents
    
    If LCase(Right(sFilename, 3)) = "spr" Then
        If Not oNewSprite.LoadSpriteFile(sFilename) Then
            lblStatus = "Ready..."
            MousePointer = vbDefault
            Exit Sub
        End If
    ElseIf LCase(Right(sFilename, 3)) = "s16" Then
        If Not oNewSprite.LoadS16File(sFilename) Then
            lblStatus = "Ready..."
            MousePointer = vbDefault
            Exit Sub
        End If
    End If
    
    Set g_oCurrentSprite = oNewSprite
    
    g_sSpriteFilename = sFilename
   
    bChanged = False
    
    g_oMRUFiles.Add sFilename
    InitialiseMRUFiles
    
    Select Case g_oCurrentSprite.SpriteType
        Case stcSPR
            Me.PaletteMode = vbPaletteModeUseZOrder
            Set picSprite.Picture = LoadResPicture(ID_PALETTE, vbResBitmap)
            
        Case stcS16_555, stcS16_565
            Me.PaletteMode = vbPaletteModeHalftone
            Set picSprite.Picture = Nothing
    End Select
    
    ClearSelection
    
    PopulateControls
    
    lblStatus = "Ready..."
    MousePointer = vbDefault
    'DoEvents
End Sub

Private Function CheckChanged() As Boolean
    Dim nYesNoCancel As Integer
    
    CheckChanged = False
    
    If bChanged Then
        CheckChanged = True
        nYesNoCancel = MsgBox("Save changes to sprite file?", vbYesNoCancel + vbQuestion)
        
        If nYesNoCancel = vbYes Then
            CheckChanged = Not Save
        ElseIf nYesNoCancel = vbNo Then
            CheckChanged = False
            Exit Function
        End If
    End If
End Function

Private Function SaveAs() As Boolean
    Dim I As Integer
    
    SaveAs = False
    
    If Not CheckSpriteType Then
        MsgBox "Please select a sprite type first.", vbOKOnly Or vbExclamation
        Exit Function
    End If
    
    If StrComp(CurDir, g_sCurrentSaveFolder, vbTextCompare) <> 0 Then
        ChDrive g_sCurrentSaveFolder
        ChDir g_sCurrentSaveFolder
    End If
    
    m_bNoDrag = True
    
    With ctlCommonDialog
        .filename = StripPath(g_sSpriteFilename)
        .DialogTitle = "Save File As..."
        
        Select Case g_oCurrentSprite.SpriteType
            Case stcSPR
                .Filter = sSPRFilesFilter
            Case stcS16_555, stcS16_565
                .Filter = sS16FilesFilter
        End Select
        
        On Error Resume Next
        
        .ShowSave
        
        If Err = cdlCancel Then
            Err.Clear
            m_bNoDrag = False
            Exit Function
        ElseIf Err <> 0 Then
            MsgBox "Error " & Err & ": " & Error
            Err.Clear
            m_bNoDrag = False
            Exit Function
        End If
        
        On Error GoTo 0
        
        g_sCurrentSaveFolder = Left(.filename, InStr(.filename, .FileTitle) - 1)
        
        MousePointer = vbHourglass
        lblStatus = "Saving " & g_sSpriteFilename & "..."
        DoEvents
        
        If g_oCurrentSprite.Save(.filename) Then
            g_sSpriteFilename = .filename
            SaveAs = True
            SetCaption
            g_oMRUFiles.Add .filename
            InitialiseMRUFiles
            bChanged = False
        End If
        
        lblStatus = "Ready..."
        MousePointer = vbDefault
    End With
    
    m_bNoDrag = False
End Function

Private Function Save() As Boolean
    Save = False
    
    If Not CheckSpriteType Then
        MsgBox "Please select a sprite type first.", vbOKOnly Or vbExclamation
        Exit Function
    End If
    
    If g_sSpriteFilename <> "" Then
        MousePointer = vbHourglass
        lblStatus = "Saving " & g_sSpriteFilename & "..."
        DoEvents
        
        Save = g_oCurrentSprite.Save(g_sSpriteFilename)
        
        lblStatus = "Ready..."
        MousePointer = vbDefault
    Else
        Save = SaveAs
    End If
    
    If Save Then
        bChanged = False
    End If
End Function

Private Sub ImportImage(sFilename As String, nPosition As Integer)
    Dim oSpriteImage As Bitmap
    
    Set oSpriteImage = g_oCurrentSprite.NewSpriteImage
    
    MousePointer = vbHourglass
    lblStatus = "Importing from " & sFilename & "..."
    DoEvents
    
    If Not oSpriteImage.LoadBitmapFile(sFilename) Then
        lblStatus = "Ready..."
        MousePointer = vbDefault
        'DoEvents
        Exit Sub
    End If
    
    g_oCurrentSprite.InsertSpriteImage nPosition, oSpriteImage
    
    lblStatus = "Ready..."
    MousePointer = vbDefault

    If oSpriteImage.Width Mod 4 <> 0 And g_oCurrentSprite.SpriteType = stcSPR Then
        MsgBox "Bitmap width is not a multiple of 4.", vbOKOnly + vbInformation
    End If

    bChanged = True
End Sub

Private Sub ImportSprite(sFilename As String, nPosition As Integer)
    Dim oSprite As New Sprite
    Dim oSpriteImage As Bitmap
    Dim I As Integer
    
    MousePointer = vbHourglass
    lblStatus = "Importing from " & sFilename & "..."
    DoEvents
    
    Select Case LCase(Right(sFilename, 3))
        Case "spr"
            If Not oSprite.LoadSpriteFile(sFilename) Then
                lblStatus = "Ready..."
                MousePointer = vbDefault
                'DoEvents
                Exit Sub
            End If
            
        Case "s16"
            If Not oSprite.LoadS16File(sFilename) Then
                lblStatus = "Ready..."
                MousePointer = vbDefault
                'DoEvents
                Exit Sub
            End If
    End Select
    
    If oSprite.NumberOfSpritesInFile <= 0 Then
        lblStatus = "Ready..."
        MousePointer = vbDefault
        'DoEvents
        Exit Sub
    End If
    
    For I = 1 To oSprite.NumberOfSpritesInFile
        Set oSpriteImage = oSprite.SpriteImages(I)
        g_oCurrentSprite.InsertSpriteImage nPosition + I - 1, oSpriteImage
    Next
    
    lblStatus = "Ready..."
    MousePointer = vbDefault
    'DoEvents
    
    bChanged = True
End Sub

Private Sub Import(sFilename As String, nPosition As Integer)
    Select Case LCase(Right(sFilename, 3))
        Case "bmp"
            ImportImage sFilename, nPosition
            
        Case "spr", "s16"
            ImportSprite sFilename, nPosition
    End Select
End Sub

Private Sub ImportFiles(Filenames As Collection, ByVal nPosition As Integer)
    Dim I As Integer
    Dim nIndex As Integer
    Dim sFilename As String
    Dim oNewFilenames As New Collection
    
    Do While Filenames.Count > 0
        sFilename = Filenames(1)
        nIndex = 1
        For I = 2 To Filenames.Count
            If StrComp(sFilename, Filenames(I), vbTextCompare) > 0 Then
                sFilename = Filenames(I)
                nIndex = I
            End If
        Next
        oNewFilenames.Add sFilename
        Filenames.Remove nIndex
    Loop
    
    For I = 1 To oNewFilenames.Count
        Import oNewFilenames(I), nPosition + I - 1
    Next
    
    Set Filenames = oNewFilenames
End Sub

Private Function CheckDroppedFiles(Data As DataObject) As Boolean
    Dim I As Integer
    Dim sFilename As String
    
    CheckDroppedFiles = False
    
    If Data.GetFormat(vbCFFiles) Then
        For I = 1 To Data.Files.Count
            sFilename = Data.Files.Item(I)
            Select Case LCase(Right(sFilename, 3))
                Case "bmp", "spr", "s16"
                    
                Case Else
                    Exit Function
            End Select
        Next
    Else
        Exit Function
    End If
    
    CheckDroppedFiles = True
End Function

Private Sub chkAnimChooseSequence_Click()
    Dim I As Integer
    Dim sNewBase As String
    Dim nNewBase As Integer
    Dim sNewSequence As String
    
    If chkAnimChooseSequence.Value = vbChecked Then
        cmdAnimPlay.Enabled = False
        cmdAnimType.Enabled = False
        
        If CountThumbnailsSelected > 0 Then
            For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
                If m_aSelectedThumbnails(I) Then
                    sNewBase = CStr(I)
                    nNewBase = I
                    Exit For
                End If
            Next
            
            Do While I < g_oCurrentSprite.NumberOfSpritesInFile
                If m_aSelectedThumbnails(I) Then
                    Select Case m_eAnimType
                        Case atObject
                            If (I - nNewBase) > 9 Then
                                MsgBox "An object animation step can only be up to 9 images away from the base.", vbOKOnly Or vbExclamation
                                chkAnimChooseSequence.Value = vbUnchecked
                                Exit Sub
                            Else
                                sNewSequence = sNewSequence & Format(I - nNewBase, "0")
                            End If
                            
                        Case atCreature
                            If (I - nNewBase) > 999 Then
                                MsgBox "A creature animation step can only be up to 999 steps images from the base.", vbOKOnly Or vbExclamation
                                chkAnimChooseSequence.Value = vbUnchecked
                                Exit Sub
                            Else
                                sNewSequence = sNewSequence & Format(I - nNewBase, "000")
                            End If
                    End Select
                End If
                
                I = I + 1
            Loop
            
            m_nAnimBase = nNewBase
            txtAnimBase.Text = sNewBase
            txtAnimSequence.Text = sNewSequence
        End If
        
        picSprite.SetFocus
    Else
        cmdAnimPlay.Enabled = True
        cmdAnimType.Enabled = True
        txtAnimSequence.SetFocus
    End If
End Sub

Private Sub chkAnimChooseSequence_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub chkAnimChooseSequence_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdAnimClear_Click()
    m_nAnimBase = -1
    txtAnimBase.Text = ""
    txtAnimSequence.Text = ""
End Sub

Private Sub cmdAnimClear_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdAnimClear_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdAnimPlay_Click()
    Dim oImage As Bitmap
    Dim nIndex As Long
    
    If m_nAnimBase < 0 Then
        MsgBox "Select an animation base first.", vbOKOnly Or vbExclamation
        Exit Sub
    End If
    
    If Trim(txtAnimSequence.Text) = "" Then
        MsgBox "Select an animation sequence first.", vbOKOnly Or vbExclamation
        Exit Sub
    End If
    
    frmAnimation.Display m_nAnimBase, txtAnimSequence.Text, m_eAnimType
End Sub

Private Sub cmdAnimPlay_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdAnimPlay_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdAnimType_Click()
    If m_eAnimType = atCreature Then
        cmdAnimType.Caption = "&Object"
        m_eAnimType = atObject
    Else
        cmdAnimType.Caption = "&Creature"
        m_eAnimType = atCreature
    End If
End Sub

Private Sub cmdAnimType_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdAnimType_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    lblStatus.Caption = "Ready..."
End Sub

Private Sub Form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim I As Integer
    Dim nStartSpriteNumber As Integer
    Dim oFilenames As Collection
    
    If Effect And vbDropEffectCopy Then
        If Data.GetFormat(vbCFFiles) Then
            If Data.Files.Count = 1 Then
                Select Case LCase(Right(Data.Files(1), 3))
                    Case "spr", "s16"
                        Effect = vbDropEffectCopy
                        
                    Case Else
                        Effect = vbDropEffectNone
                        Exit Sub
                End Select
            Else
                Effect = vbDropEffectNone
                Exit Sub
            End If
        Else
            Effect = vbDropEffectNone
            Exit Sub
        End If
    Else
        Effect = vbDropEffectNone
        Exit Sub
    End If
    
    If CheckChanged Then
        Exit Sub
    End If
    
    OpenSpriteFile Data.Files(1)
End Sub

Private Sub Form_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    If State = vbEnter Or State = vbOver Then
        If Effect And vbDropEffectCopy Then
            If Data.GetFormat(vbCFFiles) Then
                If Data.Files.Count = 1 Then
                    Select Case LCase(Right(Data.Files(1), 3))
                        Case "spr", "s16"
                            Effect = vbDropEffectCopy
                            
                        Case Else
                            Effect = vbDropEffectNone
                    End Select
                Else
                    Effect = vbDropEffectNone
                End If
            Else
                Effect = vbDropEffectNone
            End If
        Else
            Effect = vbDropEffectNone
        End If
    End If
End Sub

Private Sub fraAnimation_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub fraAnimation_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub fraSpriteType_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub fraSpriteType_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub hscPicture_Change()
    DrawSprite m_nDisplayedSprite
End Sub

Private Sub hscPicture_Scroll()
    DrawSprite m_nDisplayedSprite
    DoEvents
End Sub

Private Sub lblAnimBase_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lblAnimBase_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lblAnimSequence_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lblAnimSequence_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lblStatus_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lblStatus_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub mnuEditCopy_Click()
    Dim I As Long
    Dim nCount As Long
    Dim oImage As Bitmap
    Dim nBitsPerPixel As Byte
    Dim nWidth As Integer
    Dim nHeight As Integer
    Dim nPixelCount As Long
    Dim aPixels() As Byte
    
    If m_bDisplayingThumbnails Then
        nCount = CountThumbnailsSelected
        If nCount > 0 Then
            Clipboard.Clear
            
            If StartClipboardCopy("SpriteEditorImages", 0) = 0 Then
                MsgBox "Could not copy SpriteEditorImages to clipboard!", vbExclamation
                Exit Sub
            End If
            
            If AddToClipboard(nCount, 4) = 0 Then
                MsgBox "Could not copy SpriteEditorImages to clipboard!", vbExclamation
                Exit Sub
            End If
            
            For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
                If m_aSelectedThumbnails(I) Then
                    Set oImage = g_oCurrentSprite.SpriteImages(I + 1)
                    nBitsPerPixel = oImage.BitsPerPixel
                    nWidth = oImage.Width
                    nHeight = oImage.Height
                    AddToClipboard nBitsPerPixel, 1
                    AddToClipboard nWidth, 2
                    AddToClipboard nHeight, 2
                    oImage.GetPixelArray aPixels
                    nPixelCount = UBound(aPixels) - LBound(aPixels) + 1
                    AddToClipboard nPixelCount, 4
                    AddToClipboard aPixels(0), nPixelCount
                End If
            Next
            
            FinishClipboardCopy
            
            If nCount = 1 Then
                If StartClipboardCopy(vbNullString, CF_DIB) = 0 Then
                    MsgBox "Could not copy DIB to clipboard!", vbExclamation
                    Exit Sub
                End If
                
                For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
                    If m_aSelectedThumbnails(I) Then
                        Set oImage = g_oCurrentSprite.SpriteImages(I + 1)
                        nBitsPerPixel = oImage.BitsPerPixel
                        nWidth = oImage.Width
                        nHeight = oImage.Height
                        oImage.GetPixelArray aPixels
                        AddImageToClipboard g_oCurrentSprite.SpriteType, nWidth, nHeight, aPixels(0)
                        Exit For
                    End If
                Next
                
                FinishClipboardCopy
            End If
        End If
    End If
End Sub

Private Sub mnuEditCut_Click()
    mnuEditCopy_Click
    mnuEditDeleteImage_Click
End Sub

Private Sub mnuEditPaste_Click()
    Dim nInsertionStart As Long
    Dim I As Long
    Dim nCount As Long
    Dim oImage As Bitmap
    Dim nBitsPerPixel As Byte
    Dim nWidth As Integer
    Dim nHeight As Integer
    Dim nWidth2 As Long
    Dim nHeight2 As Long
    Dim nPixelCount As Long
    Dim aPixels() As Byte
    Dim aPalette() As Byte
    
    If m_nFocusedThumbnail >= 0 Then
        If g_nBeforeAfter > 0 Then
            nInsertionStart = m_nFocusedThumbnail + 2
        Else
            nInsertionStart = m_nFocusedThumbnail + 1
        End If
    Else
        nInsertionStart = 1
    End If
    
    If m_bDisplayingThumbnails Then
        If StartClipboardPaste("SpriteEditorImages", 0) <> 0 Then
            GetFromClipboard nCount, 4
            
            For I = 0 To nCount - 1
                Set oImage = New Bitmap
                GetFromClipboard nBitsPerPixel, 1
                GetFromClipboard nWidth, 2
                GetFromClipboard nHeight, 2
                GetFromClipboard nPixelCount, 4
                oImage.BitsPerPixel = nBitsPerPixel
                oImage.Width = nWidth
                oImage.Height = nHeight
                oImage.AllocatePixelArray
                oImage.GetPixelArray aPixels
                GetFromClipboard aPixels(0), nPixelCount
                oImage.SetPixelArray aPixels
                
                If g_nBeforeAfter > 0 Then
                    g_oCurrentSprite.InsertSpriteImage nInsertionStart + I, oImage
                Else
                    g_oCurrentSprite.InsertSpriteImage nInsertionStart + I, oImage
                End If
            Next
            
            FinishClipboardPaste
            
            InitialiseSelectedThumbnails True
            
            m_nFocusedThumbnail = nInsertionStart - 1
            
            For I = m_nFocusedThumbnail To m_nFocusedThumbnail + nCount - 1
                m_aSelectedThumbnails(I) = True
            Next
            
            bChanged = True
            
            SetCaption
            
            DisplayThumbnails
            
            EnsureFocusedThumbnailVisible
        ElseIf StartClipboardPaste(vbNullString, CF_DIB) <> 0 Then
            If GetImageInfoFromClipboard(nBitsPerPixel, nWidth2, nHeight2) <> 0 Then
                Set oImage = New Bitmap
                oImage.BitsPerPixel = nBitsPerPixel
                oImage.Width = nWidth2
                oImage.Height = nHeight2
                oImage.AllocatePixelArray
                oImage.GetPixelArray aPixels
                
                If GetImagePixelsFromClipboard(aPixels(0)) <> 0 Then
                    oImage.SetPixelArray aPixels
                    
                    If g_nBeforeAfter > 0 Then
                        g_oCurrentSprite.InsertSpriteImage nInsertionStart, oImage
                    Else
                        g_oCurrentSprite.InsertSpriteImage nInsertionStart, oImage
                    End If
                    
                    InitialiseSelectedThumbnails True
                    
                    m_nFocusedThumbnail = nInsertionStart - 1
                    
                    m_aSelectedThumbnails(m_nFocusedThumbnail) = True
                    
                    bChanged = True
                    
                    SetCaption
                    
                    DisplayThumbnails
                    
                    EnsureFocusedThumbnailVisible
                End If
            End If
            
            FinishClipboardPaste
        End If
    End If
End Sub

Private Sub mnuFileMRUFile_Click(Index As Integer)
    Dim sFilename As String
    
    If CheckChanged Then
        Exit Sub
    End If
    
    sFilename = g_oMRUFiles(Index)
    OpenSpriteFile sFilename
End Sub

Private Sub mnuHelpAbout_Click()
    frmAbout.Show vbModal, Me
End Sub

Private Sub mnuHelpTopics_Click()
    With ctlCommonDialog
        .HelpCommand = HELP_FINDER
        .ShowHelp
    End With
End Sub

Private Sub mnuToolsMultipleFileConverter_Click()
    frmMultipleFileConverter.Show vbModal, Me
End Sub

Private Sub mnuViewZoom_Click()
    If m_bDisplayingThumbnails And m_nFocusedThumbnail >= 0 Then
        DisplaySprite m_nFocusedThumbnail + 1
        mnuViewZoom.Caption = "Show thumbnails"
    Else
        DisplayThumbnails
        EnsureFocusedThumbnailVisible
        mnuViewZoom.Caption = "Zoom to image"
    End If
End Sub

Private Sub optS16555_Click()
    If g_oCurrentSprite.SpriteType = stcS16_555 Then
        Exit Sub
    End If
    
    MousePointer = vbHourglass
    lblStatus = "Converting to S16 - 565 (this could take a while)..."
    DoEvents
    
    g_oCurrentSprite.SpriteType = stcS16_555
    
    bChanged = True
    
    If g_sSpriteFilename <> "" Then
        g_sSpriteFilename = Left(g_sSpriteFilename, Len(g_sSpriteFilename) - 3) & "s16"
        SetCaption
    End If
    
    lblStatus = "Ready..."
    MousePointer = vbDefault
    
    DisplayThumbnails
End Sub

Private Sub optS16555_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub optS16555_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub optS16565_Click()
    If g_oCurrentSprite.SpriteType = stcS16_565 Then
        Exit Sub
    End If
    
    MousePointer = vbHourglass
    lblStatus = "Converting to S16 - 565 (this could take a while)..."
    DoEvents
    
    g_oCurrentSprite.SpriteType = stcS16_565
    
    bChanged = True
    
    If g_sSpriteFilename <> "" Then
        g_sSpriteFilename = Left(g_sSpriteFilename, Len(g_sSpriteFilename) - 3) & "s16"
        SetCaption
    End If
    
    lblStatus = "Ready..."
    MousePointer = vbDefault
    
    DisplayThumbnails
End Sub

Private Sub optS16565_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub optS16565_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub optSPR_Click()
    If g_oCurrentSprite.SpriteType = stcSPR Then
        Exit Sub
    End If
    
    MousePointer = vbHourglass
    lblStatus = "Converting to SPR (this could take a while)..."
    DoEvents
    
    g_oCurrentSprite.SpriteType = stcSPR
    
    bChanged = True
    
    If g_sSpriteFilename <> "" Then
        g_sSpriteFilename = Left(g_sSpriteFilename, Len(g_sSpriteFilename) - 3) & "spr"
        SetCaption
    End If
    
    lblStatus = "Ready..."
    MousePointer = vbDefault
    
    DisplayThumbnails
End Sub

Private Sub Form_Load()
    ctlCommonDialog.HelpFile = App.Path & "\SpriteEd.hlp"
    
    GetSpriteEditorSettings
    
    InitialiseMRUFiles
    
    LoadCreaturesPalette
    
    nPictureBoxWidthDiff = ScaleWidth - picContainer.Width
    nPictureBoxHeightDiff = ScaleHeight - picContainer.Height
    nSpriteFrameYDiff = ScaleHeight - fraSpriteType.Top
    nStatusLabelYDiff = ScaleHeight - lblStatus.Top
    nStatusLabelWidthDiff = ScaleWidth - lblStatus.Width
    nAnimationFrameYDiff = ScaleHeight - fraAnimation.Top
    nAnimPlayXDiff = fraAnimation.Width * Screen.TwipsPerPixelX - cmdAnimPlay.Left
    nAnimRecXDiff = fraAnimation.Width * Screen.TwipsPerPixelX - chkAnimChooseSequence.Left
    nAnimSeqWidthDiff = fraAnimation.Width * Screen.TwipsPerPixelX - txtAnimSequence.Width
    nAnimTypeXDiff = fraAnimation.Width * Screen.TwipsPerPixelX - cmdAnimType.Left
    nAnimClearXDiff = fraAnimation.Width * Screen.TwipsPerPixelX - cmdAnimClear.Left
    
    m_nThumnbailCaptionHeight = picSprite.TextHeight("1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")
    
    vscPicture.Enabled = False
    hscPicture.Enabled = False
    
    picContainer_Resize
    
    g_oCurrentSprite.SpriteType = g_nDefaultSpriteType
    
    m_nAnimBase = -1
    m_bDisplayingThumbnails = True
    m_nDisplayedSprite = 0
    
    Me.Show
    
    PopulateControls
    
    DoEvents
    
    If InStr(1, Command, "-loadspr", vbTextCompare) > 0 Then
        OpenSpriteFile Mid(Command, InStr(1, Command, "-loadspr", vbTextCompare) + 9)
    ElseIf InStr(1, Command, "-loads16", vbTextCompare) > 0 Then
        OpenSpriteFile Mid(Command, InStr(1, Command, "-loads16", vbTextCompare) + 9)
    End If
    
    bChanged = False
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    If CheckChanged Then
        Cancel = 1
        Exit Sub
    End If
End Sub

Private Sub Form_Resize()
    If WindowState <> vbMinimized Then
        If picContainer.Visible Then
            If ScaleWidth - nPictureBoxWidthDiff > 0 Then
                picContainer.Width = ScaleWidth - nPictureBoxWidthDiff
            Else
                picContainer.Width = 0
            End If
            
            If ScaleHeight - nPictureBoxHeightDiff > 0 Then
                picContainer.Height = ScaleHeight - nPictureBoxHeightDiff
            Else
                picContainer.Height = 0
            End If
            
            If m_bDisplayingThumbnails Then
                DrawThumbnails
            Else
                If g_oCurrentSprite.NumberOfSpritesInFile > 0 Then
                    If m_nDisplayedSprite > 0 Then
                        DrawSprite m_nDisplayedSprite
                    End If
                End If
            End If
        End If
        
        fraSpriteType.Top = ScaleHeight - nSpriteFrameYDiff
        
        lblStatus.Top = ScaleHeight - nStatusLabelYDiff
        lblStatus.Width = ScaleWidth - nStatusLabelWidthDiff
        
        fraAnimation.Top = ScaleHeight - nAnimationFrameYDiff
        If ScaleWidth > fraAnimation.Left Then
            fraAnimation.Width = ScaleWidth - fraAnimation.Left
        End If
        cmdAnimPlay.Left = fraAnimation.Width * Screen.TwipsPerPixelX - nAnimPlayXDiff
        chkAnimChooseSequence.Left = fraAnimation.Width * Screen.TwipsPerPixelX - nAnimRecXDiff
        If fraAnimation.Width * Screen.TwipsPerPixelX > nAnimSeqWidthDiff Then
            txtAnimSequence.Width = fraAnimation.Width * Screen.TwipsPerPixelX - nAnimSeqWidthDiff
        End If
        cmdAnimType.Left = fraAnimation.Width * Screen.TwipsPerPixelX - nAnimTypeXDiff
        cmdAnimClear.Left = fraAnimation.Width * Screen.TwipsPerPixelX - nAnimClearXDiff
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    WriteSpriteEditorSettings
End Sub

Private Sub mnuEditDeleteImage_Click()
    Dim I As Integer
    
    If g_oCurrentSprite.NumberOfSpritesInFile <= 0 Then
        Exit Sub
    End If
    
    If m_bDisplayingThumbnails Then
        Do While CountThumbnailsSelected > 0
            For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
                If m_aSelectedThumbnails(I) Then
                    RemoveSprite I
                    Exit For
                End If
            Next
        Loop
        
        If m_nFocusedThumbnail >= g_oCurrentSprite.NumberOfSpritesInFile Then
            SelectThumbnailAtIndex g_oCurrentSprite.NumberOfSpritesInFile - 1, 0
            'm_nFocusedThumbnail = g_oCurrentSprite.NumberOfSpritesInFile - 1
        End If
        
        DrawThumbnails
    Else
        RemoveSprite m_nDisplayedSprite - 1
        If m_nDisplayedSprite > g_oCurrentSprite.NumberOfSpritesInFile Then
            m_nDisplayedSprite = g_oCurrentSprite.NumberOfSpritesInFile
        End If
        
        DrawSprite m_nDisplayedSprite
    End If
    
    bChanged = True
    SetCaption
End Sub

Private Sub mnuEditExport_Click()
    Dim oExportForm As New frmExport
    Dim sFilename As String
    Dim I As Integer
    Dim nOption As Integer
    Dim sPrefix As String
    Dim nStartSuffixAt As Integer
    Dim bPadWithZeroes As Boolean
    Dim nHowManyZeroes As Integer
    Dim nFileType As Integer
    Dim oSprite As Sprite
    Dim oImage As Bitmap
    Dim oNewImage As Bitmap
    Dim aPixels() As Byte

    If g_oCurrentSprite.NumberOfSpritesInFile <= 0 Then
        Exit Sub
    End If
    
    nOption = 1
    sPrefix = g_sCurrentExportFolder
    nStartSuffixAt = 0
    bPadWithZeroes = False
    nHowManyZeroes = 3
    nFileType = 0
    
    m_bNoDrag = True
    
    If Not m_bDisplayingThumbnails Or (m_bDisplayingThumbnails And CountThumbnailsSelected = 1) Then
        If Not m_bDisplayingThumbnails Then
            Set oImage = g_oCurrentSprite.SpriteImages(m_nDisplayedSprite)
        Else
            Set oImage = g_oCurrentSprite.SpriteImages(m_nFocusedThumbnail + 1)
        End If
        
        If StrComp(CurDir, g_sCurrentExportFolder, vbTextCompare) <> 0 Then
            ChDrive g_sCurrentExportFolder
            ChDir g_sCurrentExportFolder
        End If
        
        With ctlCommonDialog
            .filename = ""
            .DialogTitle = "Export..."
            .Filter = sExportFilter
            .FilterIndex = 1
            .Flags = cdlOFNExplorer Or cdlOFNLongNames Or cdlOFNOverwritePrompt Or cdlOFNPathMustExist
            On Error Resume Next
            .ShowSave
            If Err = cdlCancel Then
                Err.Clear
                m_bNoDrag = False
                Exit Sub
            ElseIf Err <> 0 Then
                MsgBox "Error " & Err & ": " & Error
                Err.Clear
                m_bNoDrag = False
                Exit Sub
            End If
            On Error GoTo 0
            g_sCurrentExportFolder = Left(.filename, InStr(.filename, .FileTitle) - 1)
            sFilename = .filename
            nFileType = .FilterIndex - 1
        End With
        
        MousePointer = vbHourglass
        lblStatus = "Exporting to " & sFilename & "..."
        DoEvents
        
        Select Case nFileType
            Case 0
                oImage.SaveBitmapFile sFilename
                
            Case 1
                Set oSprite = New Sprite
                oSprite.SpriteType = stcSPR
                oSprite.AddSpriteImage oImage
                oSprite.Save sFilename
                
            Case 2
                Set oSprite = New Sprite
                oSprite.SpriteType = stcS16_555
                oSprite.AddSpriteImage oImage
                oSprite.Save sFilename
                
            Case 3
                Set oSprite = New Sprite
                oSprite.SpriteType = stcS16_565
                oSprite.AddSpriteImage oImage
                oSprite.Save sFilename
        End Select
        
        lblStatus = "Ready..."
        MousePointer = vbDefault
        DoEvents
    Else
        If Not oExportForm.Display(nFileType, nOption, sPrefix, nStartSuffixAt, bPadWithZeroes, nHowManyZeroes) Then
            m_bNoDrag = False
            Exit Sub
        End If
        
        If nFileType = 0 Then
            If nOption = 1 Then
                If StrComp(CurDir, g_sCurrentExportFolder, vbTextCompare) <> 0 Then
                    ChDrive g_sCurrentExportFolder
                    ChDir g_sCurrentExportFolder
                End If
                
                'sFilename = sPrefix & ".bmp"
                For I = 1 To g_oCurrentSprite.NumberOfSpritesInFile
                    If m_aSelectedThumbnails(I - 1) Then
                        With ctlCommonDialog
                            .filename = ""
                            .DialogTitle = "Export..."
                            .Filter = sExportBMPFilter
                            .FilterIndex = 1
                            .Flags = cdlOFNExplorer Or cdlOFNLongNames Or cdlOFNOverwritePrompt Or cdlOFNPathMustExist
                            On Error Resume Next
                            .ShowSave
                            If Err = cdlCancel Then
                                Err.Clear
                                m_bNoDrag = False
                                Exit Sub
                            ElseIf Err <> 0 Then
                                MsgBox "Error " & Err & ": " & Error
                                Err.Clear
                                m_bNoDrag = False
                                Exit Sub
                            End If
                            On Error GoTo 0
                            g_sCurrentExportFolder = Left(.filename, InStr(.filename, .FileTitle) - 1)
                            sFilename = .filename
                        End With
                        
                        MousePointer = vbHourglass
                        lblStatus = "Exporting to " & sFilename & "..."
                        DoEvents
                    
                        g_oCurrentSprite.SpriteImages(I).SaveBitmapFile sFilename
                    
                        lblStatus = "Ready..."
                        MousePointer = vbDefault
                        DoEvents
                    End If
                Next
            ElseIf nOption = 2 Then
                For I = 1 To g_oCurrentSprite.NumberOfSpritesInFile
                    If m_aSelectedThumbnails(I - 1) Then
                        If bPadWithZeroes Then
                            sFilename = sPrefix & Format(I + nStartSuffixAt - 1, String(nHowManyZeroes, "0")) & ".bmp"
                        Else
                            sFilename = sPrefix & CStr(I + nStartSuffixAt - 1) & ".bmp"
                        End If
                        
                        MousePointer = vbHourglass
                        lblStatus = "Exporting to " & sFilename & "..."
                        DoEvents
                        
                        g_oCurrentSprite.SpriteImages(I).SaveBitmapFile sFilename
                        
                        lblStatus = "Ready..."
                        MousePointer = vbDefault
                        DoEvents
                    End If
                Next
            End If
        Else
            If StrComp(CurDir, g_sCurrentExportFolder, vbTextCompare) <> 0 Then
                ChDrive g_sCurrentExportFolder
                ChDir g_sCurrentExportFolder
            End If
            
            With ctlCommonDialog
                .DialogTitle = "Export..."
                .filename = ""
                Select Case nFileType
                    Case 1
                        .Filter = "Creatures 1 Sprite Files (*.spr)|*.spr"
                        .FilterIndex = 1
                        
                    Case 2, 3
                        .Filter = "Creatures 2 Sprite Files (*.s16)|*.s16"
                        .FilterIndex = 1
                End Select
                On Error Resume Next
                .Flags = cdlOFNExplorer Or cdlOFNLongNames Or cdlOFNOverwritePrompt Or cdlOFNPathMustExist
                .ShowSave
                If Err = cdlCancel Then
                    Err.Clear
                    m_bNoDrag = False
                    Exit Sub
                ElseIf Err <> 0 Then
                    MsgBox "Error " & Err & ": " & Error
                    Err.Clear
                    m_bNoDrag = False
                    Exit Sub
                End If
                On Error GoTo 0
                g_sCurrentExportFolder = Left(.filename, InStr(.filename, .FileTitle) - 1)
                sFilename = .filename
            End With
            
            MousePointer = vbHourglass
            lblStatus = "Exporting to " & sFilename & "..."
            DoEvents
            
            Set oSprite = New Sprite
            
            Select Case nFileType
                Case 1
                    oSprite.SpriteType = stcSPR
                    
                Case 2
                    oSprite.SpriteType = stcS16_555
                    
                Case 3
                    oSprite.SpriteType = stcS16_565
            End Select
            
            For I = 1 To g_oCurrentSprite.NumberOfSpritesInFile
                If m_aSelectedThumbnails(I - 1) Then
                    Set oImage = g_oCurrentSprite.SpriteImages(I)
                    Set oNewImage = New Bitmap
                    
                    oNewImage.BitsPerPixel = oImage.BitsPerPixel
                    oNewImage.Width = oImage.Width
                    oNewImage.Height = oImage.Height
                    oImage.GetPixelArray aPixels
                    oNewImage.SetPixelArray aPixels
                    
                    oSprite.AddSpriteImage oNewImage
                End If
            Next
            
            oSprite.Save sFilename
            
            lblStatus = "Ready..."
            MousePointer = vbDefault
            DoEvents
        End If
    End If
    
    m_bNoDrag = False
End Sub

Private Sub mnuEditImport_Click()
    Dim sFilename As String
    Dim nOKCancel
    Dim oSpriteImage As Bitmap
    Dim I As Integer
    Dim J As Integer
    Dim sPrefix As String
    Dim nStartingSpriteNumber As Integer
    Dim oFilenames As Collection
    
    If Not CheckSpriteType Then
        MsgBox "Please select a sprite type first.", vbOKOnly Or vbExclamation
        Exit Sub
    End If

    If StrComp(CurDir, g_sCurrentImportFolder, vbTextCompare) <> 0 Then
        ChDrive g_sCurrentImportFolder
        ChDir g_sCurrentImportFolder
    End If
    
    m_bNoDrag = True
    
    With ctlCommonDialog
        .filename = ""
        .DialogTitle = "Import..."
        .Flags = cdlOFNAllowMultiselect Or cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNLongNames Or cdlOFNPathMustExist
        .Filter = sImportFilter
        .FilterIndex = 1
        On Error Resume Next
        .ShowOpen
        If Err = cdlCancel Then
            Err.Clear
            m_bNoDrag = False
            Exit Sub
        ElseIf Err <> 0 Then
            MsgBox "Error " & Err & ": " & Error
            Err.Clear
            m_bNoDrag = False
            Exit Sub
        End If
        On Error GoTo 0
        sFilename = .filename
        If InStr(.filename, Chr(0)) Then
            g_sCurrentImportFolder = Left(.filename, InStr(.filename, Chr(0)) - 1)
        Else
            g_sCurrentImportFolder = Left(.filename, InStr(.filename, .FileTitle) - 1)
        End If
    End With

    If sFilename = "" Then
        m_bNoDrag = False
        Exit Sub
    End If
    
    If g_oCurrentSprite.NumberOfSpritesInFile = 0 Then
        nStartingSpriteNumber = 1
    Else
        If m_bDisplayingThumbnails Then
            nStartingSpriteNumber = m_nFocusedThumbnail + 1
        Else
            nStartingSpriteNumber = m_nDisplayedSprite
        End If
        
        If g_nBeforeAfter > 0 And g_oCurrentSprite.NumberOfSpritesInFile > 0 Then
            nStartingSpriteNumber = nStartingSpriteNumber + 1
        End If
    End If
    
    I = InStr(sFilename, Chr(0))
    If I > 0 Then
        sPrefix = Left(sFilename, I - 1) & "\"
        
        Set oFilenames = New Collection
        
        Do
            I = I + 1
            J = InStr(I, sFilename, Chr(0))
            If J > 0 Then
                oFilenames.Add sPrefix & Mid(sFilename, I, J - I)
            Else
                oFilenames.Add sPrefix & Mid(sFilename, I)
            End If
            I = J
        Loop While I > 0
        
        ImportFiles oFilenames, nStartingSpriteNumber
    Else
        Import sFilename, nStartingSpriteNumber
    End If
    
    InitialiseSelectedThumbnails True
    
    DisplayThumbnails
    
    m_bNoDrag = False
End Sub

Private Sub mnuFileExit_Click()
    Unload Me
End Sub

Private Sub mnuFileNew_Click()
    If CheckChanged Then
        Exit Sub
    End If
    
    g_sSpriteFilename = ""
    
    Set g_oCurrentSprite = New Sprite
    g_oCurrentSprite.SpriteType = g_nDefaultSpriteType
    
    picSprite.DrawMode = vbCopyPen
    picSprite.BackColor = vbBlack
    picSprite.FillStyle = vbFSTransparent
    picSprite.Cls
    
    ClearSelection
    
    PopulateControls
    
    Me.Caption = "Sprite Editor"
    
    bChanged = False
End Sub

Private Sub mnuFileSave_Click()
    Save
End Sub

Private Sub mnuFileSaveAs_Click()
    SaveAs
End Sub

Private Sub mnuFileOpen_Click()
    If CheckChanged Then
        Exit Sub
    End If
    
    If StrComp(CurDir, g_sCurrentLoadFolder, vbTextCompare) <> 0 Then
        ChDrive g_sCurrentLoadFolder
        ChDir g_sCurrentLoadFolder
    End If
    
    m_bNoDrag = True
    
    With ctlCommonDialog
        .filename = ""
        .DialogTitle = "Open Sprite File..."
        .Filter = sLoadSpriteFileFilter
        .FilterIndex = 1
        On Error Resume Next
        .ShowOpen
        If Err = cdlCancel Then
            Err.Clear
            m_bNoDrag = False
            Exit Sub
        ElseIf Err <> 0 Then
            MsgBox "Error " & Err & ": " & Error
            Err.Clear
            m_bNoDrag = False
            Exit Sub
        End If
        On Error GoTo 0
        
        g_sCurrentLoadFolder = Left(.filename, InStr(.filename, .FileTitle) - 1)
        OpenSpriteFile .filename
    End With
    
    m_bNoDrag = False
End Sub

Private Sub mnuToolsPreferences_Click()
    frmPreferences.Show vbModal
    PopulateControls
End Sub

Private Sub optSPR_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub optSPR_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub picContainer_Resize()
    Dim oSpriteImage As Bitmap
    Dim nThumbnailXCount As Long
    Dim nThumbnailYSize As Long
    
    If m_nDisplayedSprite >= 1 And m_nDisplayedSprite <= g_oCurrentSprite.NumberOfSpritesInFile Then
        Set oSpriteImage = g_oCurrentSprite.SpriteImages(m_nDisplayedSprite)
    End If
    
    vscPicture.Top = 0
    vscPicture.Left = picContainer.ScaleWidth - vscPicture.Width
    If picContainer.ScaleHeight > hscPicture.Height Then
        vscPicture.Height = picContainer.ScaleHeight - hscPicture.Height
    End If
    
    If Not oSpriteImage Is Nothing Then
        If vscPicture.Height >= oSpriteImage.Height Then
            vscPicture.Value = 0
            vscPicture.Enabled = False
        Else
            vscPicture.Enabled = True
            vscPicture.Max = oSpriteImage.Height - vscPicture.Height
        End If
    End If
    
    hscPicture.Top = picContainer.ScaleHeight - hscPicture.Height
    hscPicture.Left = 0
    If picContainer.ScaleWidth > vscPicture.Width Then
        hscPicture.Width = picContainer.ScaleWidth - vscPicture.Width
    End If
    
    If Not oSpriteImage Is Nothing Then
        If hscPicture.Width >= oSpriteImage.Width Then
            hscPicture.Value = 0
            hscPicture.Enabled = False
        Else
            hscPicture.Enabled = True
            hscPicture.Max = oSpriteImage.Width - hscPicture.Width
        End If
    End If
    
    picSprite.Width = hscPicture.Width
    picSprite.Height = vscPicture.Height
    
    If m_bDisplayingThumbnails Then
        If g_oCurrentSprite.NumberOfSpritesInFile > 0 Then
            nThumbnailXCount = Int(picSprite.Width / m_nThumbnailGridWidth)
            If nThumbnailXCount <= 0 Then
                nThumbnailXCount = 1
            End If
            
            nThumbnailYSize = Int(g_oCurrentSprite.NumberOfSpritesInFile / nThumbnailXCount) * m_nThumbnailGridHeight
            
            If g_oCurrentSprite.NumberOfSpritesInFile Mod nThumbnailXCount Then
                nThumbnailYSize = nThumbnailYSize + m_nThumbnailGridHeight
            End If
            
            If nThumbnailYSize > picSprite.Height Then
                vscPicture.Max = nThumbnailYSize - picSprite.Height
                vscPicture.Enabled = True
            Else
                vscPicture.Enabled = False
                vscPicture.Value = 0
                vscPicture.Max = 0
            End If
        Else
            vscPicture.Enabled = False
            vscPicture.Value = 0
            vscPicture.Max = 0
        End If
    End If
End Sub

Private Sub picSprite_DblClick()
    mnuViewZoom_Click
End Sub

Private Sub picSprite_DragDrop(Source As Control, X As Single, Y As Single)
    Dim oSpriteImage As Bitmap
    
    m_bDraggingThumbnail = False
    If m_nDropThumbnail >= 0 Then
        DrawInsertionMark m_nDropThumbnailI, m_nDropThumbnailJ
    End If
    
    If m_nFocusedThumbnail = m_nDropThumbnail Or m_nFocusedThumbnail + 1 = m_nDropThumbnail Or m_nDropThumbnail < 0 Then
        Exit Sub
    End If
    
    m_aSelectedThumbnails(m_nFocusedThumbnail) = False
    
    Set oSpriteImage = g_oCurrentSprite.SpriteImages(m_nFocusedThumbnail + 1)
    If m_nFocusedThumbnail > m_nDropThumbnail Then
        m_nFocusedThumbnail = m_nFocusedThumbnail + 1
    End If
    g_oCurrentSprite.InsertSpriteImage m_nDropThumbnail + 1, oSpriteImage
    g_oCurrentSprite.DeleteSpriteImage m_nFocusedThumbnail + 1
    
    If m_nFocusedThumbnail > m_nDropThumbnail Then
        m_aSelectedThumbnails(m_nDropThumbnail) = True
        m_nFocusedThumbnail = m_nDropThumbnail
    Else
        m_aSelectedThumbnails(m_nDropThumbnail - 1) = True
        m_nFocusedThumbnail = m_nDropThumbnail - 1
    End If
    
    m_nDropThumbnail = -1
    
    bChanged = True
    
    SetCaption
    DrawThumbnails
End Sub

Private Sub picSprite_DragOver(Source As Control, X As Single, Y As Single, State As Integer)
    Dim nXCount As Integer
    Dim I As Integer
    Dim J As Integer
    Dim nBeforeAfter As Integer
    Dim nIndexOffset As Integer
    
    nXCount = Int(picSprite.Width / m_nThumbnailGridWidth)
    'nIndexOffset = Int(vscPicture.Value / nThumbnailGridSize)
    
    If m_nDropThumbnail >= 0 Then
        DrawInsertionMark m_nDropThumbnailI, m_nDropThumbnailJ
    End If
    
    If State = vbEnter Or State = vbOver Then
        Set Source.DragIcon = LoadResPicture(cResDragCursor, vbResCursor)
        
        I = Int(X / m_nThumbnailGridWidth)
        J = Int((Y + vscPicture.Value) / m_nThumbnailGridHeight)
        
        If (J * nXCount + I) >= g_oCurrentSprite.NumberOfSpritesInFile Then
            I = (g_oCurrentSprite.NumberOfSpritesInFile - 1) Mod nXCount
            J = Int((g_oCurrentSprite.NumberOfSpritesInFile - 1) / nXCount)
            m_nDropThumbnail = g_oCurrentSprite.NumberOfSpritesInFile - 1
            nBeforeAfter = 1
        ElseIf I >= nXCount Then
            nBeforeAfter = 1
            I = nXCount - 1
            m_nDropThumbnail = J * nXCount + I
        Else
            m_nDropThumbnail = J * nXCount + I
            If m_nDropThumbnail >= g_oCurrentSprite.NumberOfSpritesInFile Then
                m_nDropThumbnail = g_oCurrentSprite.NumberOfSpritesInFile - 1
                nBeforeAfter = 1
            Else
                If X >= (I * m_nThumbnailGridWidth + m_nThumbnailGridWidth / 2) Then
                    nBeforeAfter = 1
                Else
                    nBeforeAfter = 0
                End If
            End If
        End If
        
        m_nDropThumbnail = m_nDropThumbnail + nBeforeAfter
        I = I + nBeforeAfter
        
        m_nDropThumbnailI = I
        m_nDropThumbnailJ = J
        
        DrawInsertionMark m_nDropThumbnailI, m_nDropThumbnailJ
    ElseIf State = vbLeave Then
        m_nDropThumbnail = -1
        Set Source.DragIcon = LoadResPicture(cResNoDragCursor, vbResCursor)
    End If
End Sub

Private Sub picSprite_KeyDown(KeyCode As Integer, Shift As Integer)
    Dim I As Integer
    Dim nXCount As Integer
    Dim nYCount As Integer
    Dim nTopIndex As Integer
    Dim nXPos As Integer
    Dim nYPos As Integer
    
    nXCount = Int(picSprite.Width / m_nThumbnailGridWidth)
    nYCount = Int(picSprite.Height / m_nThumbnailGridHeight)
    
    Select Case KeyCode
        Case vbKeyA
            If Shift = vbCtrlMask And m_bDisplayingThumbnails Then
                For I = 0 To g_oCurrentSprite.NumberOfSpritesInFile - 1
                    m_aSelectedThumbnails(I) = True
                Next
                DrawThumbnails
            End If
            
        Case vbKeyC
            If Shift = vbCtrlMask Then
                mnuEditCopy_Click
            End If
            
        Case vbKeyX
            If Shift = vbCtrlMask Then
                mnuEditCut_Click
            End If
            
        Case vbKeyV
            If Shift = vbCtrlMask Then
                mnuEditPaste_Click
            End If
                    
        Case vbKeySpace
            If m_nFocusedThumbnail >= 0 And m_bDisplayingThumbnails Then
                If Shift = vbCtrlMask Then
                    m_aSelectedThumbnails(m_nFocusedThumbnail) = Not m_aSelectedThumbnails(m_nFocusedThumbnail)
                    DrawThumbnails
                End If
            End If
            
        Case vbKeyReturn
            mnuViewZoom_Click
            
        Case vbKeyHome
            If m_bDisplayingThumbnails Then
                If vscPicture.Enabled Then
                    vscPicture.Value = vscPicture.Min
                End If
                
                m_nFocusedThumbnail = 0
                
                If Shift = vbCtrlMask Then
                    DrawThumbnails
                Else
                    SelectThumbnailAtIndex m_nFocusedThumbnail, Shift
                End If
            End If
            
        Case vbKeyEnd
            If m_bDisplayingThumbnails Then
                If vscPicture.Enabled Then
                    vscPicture.Value = vscPicture.Max
                End If
                
                m_nFocusedThumbnail = g_oCurrentSprite.NumberOfSpritesInFile - 1
                
                If Shift = vbCtrlMask Then
                    DrawThumbnails
                Else
                    SelectThumbnailAtIndex m_nFocusedThumbnail, Shift
                End If
            End If
            
        Case vbKeyPageUp
            If m_bDisplayingThumbnails Then
                If m_nFocusedThumbnail > nXCount * nYCount Then
                    m_nFocusedThumbnail = m_nFocusedThumbnail - nXCount * nYCount
                Else
                    m_nFocusedThumbnail = 0
                End If
                
                If Shift = vbCtrlMask Then
                    EnsureFocusedThumbnailVisible
                    DrawThumbnails
                Else
                    SelectThumbnailAtIndex m_nFocusedThumbnail, Shift
                End If
            End If
            
        Case vbKeyPageDown
            If m_bDisplayingThumbnails Then
                If m_nFocusedThumbnail < (g_oCurrentSprite.NumberOfSpritesInFile - nXCount * nYCount) Then
                    m_nFocusedThumbnail = m_nFocusedThumbnail + nXCount * nYCount
                Else
                    m_nFocusedThumbnail = g_oCurrentSprite.NumberOfSpritesInFile - 1
                End If
                
                If Shift = vbCtrlMask Then
                    EnsureFocusedThumbnailVisible
                    DrawThumbnails
                Else
                    SelectThumbnailAtIndex m_nFocusedThumbnail, Shift
                End If
            End If
            
        Case vbKeyLeft
            If m_bDisplayingThumbnails Then
                If m_nFocusedThumbnail > 0 Then
                    m_nFocusedThumbnail = m_nFocusedThumbnail - 1
                    nYPos = Int(m_nFocusedThumbnail / nXCount) * m_nThumbnailGridHeight
                    
                    EnsureFocusedThumbnailVisible
                    
                    If Shift = vbCtrlMask Then
                        DrawThumbnails
                    Else
                        SelectThumbnailAtIndex m_nFocusedThumbnail, Shift
                    End If
                End If
            End If
            
        Case vbKeyRight
            If m_bDisplayingThumbnails Then
                If m_nFocusedThumbnail < g_oCurrentSprite.NumberOfSpritesInFile - 1 Then
                    m_nFocusedThumbnail = m_nFocusedThumbnail + 1
                    nYPos = Int(m_nFocusedThumbnail / nXCount) * m_nThumbnailGridHeight
                    
                    If Shift = vbCtrlMask Then
                        DrawThumbnails
                    Else
                        SelectThumbnailAtIndex m_nFocusedThumbnail, Shift
                    End If
                End If
            End If
            
        Case vbKeyUp
            If m_bDisplayingThumbnails Then
                If m_nFocusedThumbnail >= nXCount Then
                    m_nFocusedThumbnail = m_nFocusedThumbnail - nXCount
                Else
                    m_nFocusedThumbnail = 0
                End If
                
                nYPos = Int(m_nFocusedThumbnail / nXCount) * m_nThumbnailGridHeight
                
                If Shift = vbCtrlMask Then
                    DrawThumbnails
                Else
                    SelectThumbnailAtIndex m_nFocusedThumbnail, Shift
                End If
            End If
            
        Case vbKeyDown
            If m_bDisplayingThumbnails Then
                If m_nFocusedThumbnail < g_oCurrentSprite.NumberOfSpritesInFile - nXCount - 1 Then
                    m_nFocusedThumbnail = m_nFocusedThumbnail + nXCount
                Else
                    m_nFocusedThumbnail = g_oCurrentSprite.NumberOfSpritesInFile - 1
                End If
                
                nYPos = Int(m_nFocusedThumbnail / nXCount) * m_nThumbnailGridHeight
                
                If Shift = vbCtrlMask Then
                    DrawThumbnails
                Else
                    SelectThumbnailAtIndex m_nFocusedThumbnail, Shift
                End If
            End If
            
        Case vbKeyDelete
            If Shift = 0 Then
                mnuEditDeleteImage_Click
            End If
    End Select
End Sub

Private Sub picSprite_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = vbLeftButton Then
        If m_bDisplayingThumbnails Then
            SelectThumbnailAtXY X, Y, Shift
        Else
            m_nSelectedThumbnailAtX = -1
            m_nSelectedThumbnailAtY = -1
        End If
    End If
End Sub

Private Sub picSprite_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim oImage As Bitmap
    
    If Not m_bDisplayingThumbnails Then
        Set oImage = g_oCurrentSprite.SpriteImages(m_nDisplayedSprite)
        If X + hscPicture.Value < oImage.Width And Y + vscPicture.Value < oImage.Height Then
            lblStatus.Caption = "(" & CStr(X + hscPicture.Value) & ", " & CStr(Y + vscPicture.Value) & ")"
        Else
            lblStatus.Caption = "Ready..."
        End If
    End If
    
    If Button = vbLeftButton And m_bDisplayingThumbnails And m_nFocusedThumbnail >= 0 And Not m_bDraggingThumbnail And m_nSelectedThumbnailAtX >= 0 Then
        If ((X - m_nSelectedThumbnailAtX) ^ 2) + ((Y - m_nSelectedThumbnailAtY) ^ 2) >= 25 Then
            m_bDraggingThumbnail = True
            m_nDropThumbnail = -1
            picSprite.Drag vbBeginDrag
            'picSprite.DrawMode = vbXorPen
            Set picSprite.DragIcon = LoadResPicture(cResDragCursor, vbResCursor)
        End If
    ElseIf Button = 0 And m_bDraggingThumbnail Then
        'picSprite.DrawMode = vbCopyPen
        m_bDraggingThumbnail = False
    End If
End Sub

Private Sub picSprite_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim oSpriteImage As Bitmap
    Dim oFilenames As Collection
    Dim I As Integer
    
    If Effect And vbDropEffectCopy Then
        If Not CheckDroppedFiles(Data) Then
            Effect = vbDropEffectNone
            Exit Sub
        Else
            Effect = vbDropEffectCopy
        End If
    Else
        Effect = vbDropEffectNone
        Exit Sub
    End If
    
    Set oFilenames = New Collection
    For I = 1 To Data.Files.Count
        oFilenames.Add Data.Files(I)
    Next
    
    If m_bDisplayingThumbnails Then
        If m_nDropThumbnail >= 0 Then
            DrawInsertionMark m_nDropThumbnailI, m_nDropThumbnailJ
        End If
        'picSprite.DrawMode = vbCopyPen
        
        ImportFiles oFilenames, m_nDropThumbnail + 1
        
        m_nDropThumbnail = -1
    Else
        If g_nBeforeAfter > 0 Then
            ImportFiles oFilenames, m_nDisplayedSprite + 1
        Else
            ImportFiles oFilenames, m_nDisplayedSprite
        End If
    End If
    
    InitialiseSelectedThumbnails True
    
    bChanged = True
    
    SetCaption
    DisplayThumbnails
    EnsureFocusedThumbnailVisible
End Sub

Private Sub picSprite_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Dim I As Integer
    Dim nXCount As Integer
    Dim J As Integer
    Dim nBeforeAfter As Integer
    Dim nIndexOffset As Integer
    
    If State = vbEnter Or State = vbOver Then
        If Effect And vbDropEffectCopy Then
            If Not CheckDroppedFiles(Data) Then
                Effect = vbDropEffectNone
                Exit Sub
            Else
                Effect = vbDropEffectCopy
            End If
        Else
            Effect = vbDropEffectNone
            Exit Sub
        End If
    End If
    
    If m_bDisplayingThumbnails Then
        nXCount = Int(picSprite.Width / m_nThumbnailGridWidth)
        nIndexOffset = Int(vscPicture.Value / m_nThumbnailGridHeight)
        
        'picSprite.DrawMode = vbXorPen
        
        If m_nDropThumbnail >= 0 Then
            DrawInsertionMark m_nDropThumbnailI, m_nDropThumbnailJ
        End If
        
        If State = vbEnter Or State = vbOver Then
            I = Int(X / m_nThumbnailGridWidth)
            J = Int((Y + vscPicture.Value) / m_nThumbnailGridHeight)
            
            If g_oCurrentSprite.NumberOfSpritesInFile = 0 Then
                I = 0
                J = 0
                m_nDropThumbnail = 0
                nBeforeAfter = 0
            ElseIf ((J + nIndexOffset) * nXCount + I) >= g_oCurrentSprite.NumberOfSpritesInFile Then
                I = (g_oCurrentSprite.NumberOfSpritesInFile - 1) Mod nXCount
                J = Int((g_oCurrentSprite.NumberOfSpritesInFile - 1) / nXCount)
                m_nDropThumbnail = g_oCurrentSprite.NumberOfSpritesInFile - 1
                nBeforeAfter = 1
            ElseIf I >= nXCount Then
                nBeforeAfter = 1
                I = nXCount - 1
                m_nDropThumbnail = (J + nIndexOffset) * nXCount + I
            Else
                m_nDropThumbnail = (J + nIndexOffset) * nXCount + I
                If m_nDropThumbnail >= g_oCurrentSprite.NumberOfSpritesInFile Then
                    m_nDropThumbnail = g_oCurrentSprite.NumberOfSpritesInFile - 1
                    nBeforeAfter = 1
                Else
                    If X >= (I * m_nThumbnailGridWidth + m_nThumbnailGridWidth / 2) Then
                        nBeforeAfter = 1
                    Else
                        nBeforeAfter = 0
                    End If
                End If
            End If
            
            m_nDropThumbnail = m_nDropThumbnail + nBeforeAfter
            I = I + nBeforeAfter
            
            m_nDropThumbnailI = I
            m_nDropThumbnailJ = J
            
            DrawInsertionMark m_nDropThumbnailI, m_nDropThumbnailJ
        ElseIf State = vbLeave Then
            m_nDropThumbnail = -1
        End If
        
        'picSprite.DrawMode = vbCopyPen
    End If
End Sub

Private Sub txtAnimBase_LostFocus()
    txtAnimBase.Text = Trim(txtAnimBase.Text)
    If txtAnimBase.Text <> "" Then
        m_nAnimBase = CLng(txtAnimBase.Text)
    Else
        m_nAnimBase = -1
    End If
End Sub

Private Sub txtAnimBase_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub txtAnimBase_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub txtAnimSequence_KeyPress(KeyAscii As Integer)
    CheckNumeric KeyAscii
End Sub

Private Sub txtAnimSequence_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub txtAnimSequence_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub vscPicture_Change()
    If m_bDisplayingThumbnails Then
        DrawThumbnails
    Else
        DrawSprite m_nDisplayedSprite
    End If
End Sub

Private Sub vscPicture_Scroll()
    If m_bDisplayingThumbnails Then
        DrawThumbnails
    Else
        DrawSprite m_nDisplayedSprite
    End If
End Sub

