VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Bitmap"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_nBitsPerPixel As Integer
Private m_nWidth As Integer
Private m_nHeight As Integer
Private m_aPixels() As Byte
Private m_aPalette() As RGBQUAD

Public Property Get BitsPerPixel() As Integer
    BitsPerPixel = m_nBitsPerPixel
End Property

Public Property Let BitsPerPixel(vNewValue As Integer)
    m_nBitsPerPixel = vNewValue
End Property

Public Property Get BytesPerPixel() As Long
    BytesPerPixel = Int(m_nBitsPerPixel / 8)
    If m_nBitsPerPixel Mod 8 Then
        BytesPerPixel = BytesPerPixel + 1
    End If
End Property

Public Property Get Width() As Integer
    Width = m_nWidth
End Property

Public Property Let Width(vNewValue As Integer)
    m_nWidth = vNewValue
End Property

Public Property Get Height() As Integer
    Height = m_nHeight
End Property

Public Property Let Height(vNewValue As Integer)
    m_nHeight = vNewValue
End Property

Public Sub AllocatePixelArray()
    Dim nBytesPerPixel As Long
    
    nBytesPerPixel = BytesPerPixel
    
    If m_nWidth > 0 And m_nHeight > 0 Then
        ReDim m_aPixels(0 To CLng(m_nWidth) * CLng(m_nHeight) * nBytesPerPixel - 1)
    End If
End Sub

Public Property Get Pixels(ByVal X As Long, ByVal Y As Long) As Long
    Dim nOffset As Long
    Dim nBytesPerPixel As Integer
    Dim nPixel As Long
    Dim nRed As Long
    Dim nGreen As Long
    Dim nBlue As Long

    nBytesPerPixel = BytesPerPixel

    nOffset = Y * m_nWidth * nBytesPerPixel + X * nBytesPerPixel

    Select Case m_nBitsPerPixel
        Case 8
            nPixel = m_aPixels(nOffset)
            Pixels = RGB(aCreaturesPalette(nPixel).Red, aCreaturesPalette(nPixel).Green, aCreaturesPalette(nPixel).Blue)

        Case 15
            nPixel = CLng(m_aPixels(nOffset)) Or (CLng(m_aPixels(nOffset + 1)) * 256)
            nBlue = (nPixel And 31) * 8
            nGreen = Int((nPixel And 992) / 4)
            nRed = Int((nPixel And 31744) / 128)
            Pixels = RGB(nRed, nGreen, nBlue)
            'nBlue = nPixel And 31
            'nGreen = (nPixel And 992) / 32
            'nRed = (nPixel And 31744) / 1024
            'Pixels = RGB((nRed * 255) / 31, (nGreen * 255) / 31, (nBlue * 255) / 31)

        Case 16
            nPixel = CLng(m_aPixels(nOffset)) Or (CLng(m_aPixels(nOffset + 1)) * 256)
            nBlue = (nPixel And 31) * 8
            nGreen = Int((nPixel And 2016) / 8)
            nRed = Int((nPixel And 63488) / 256)
            Pixels = RGB(nRed, nGreen, nBlue)
            'nBlue = nPixel And 31
            'nGreen = (nPixel And 2016) / 32
            'nRed = (nPixel And 63488) / 2048
            'Pixels = RGB((nRed * 255) / 31, (nGreen * 255) / 63, (nBlue * 255) / 31)
    End Select
End Property

'Public Property Let Pixels(ByVal X As Long, ByVal Y As Long, vNewValue As Long)
'    Dim nOffset As Long
'    Dim nBytesPerPixel As Integer
'    Dim nPixel As Long
'    Dim nRed As Long
'    Dim nGreen As Long
'    Dim nBlue As Long
'
'    nBytesPerPixel = BytesPerPixel
'
'    nOffset = Y * m_nWidth * nBytesPerPixel + X * nBytesPerPixel
'
'    Select Case m_nBitsPerPixel
'        Case 8
'            'nPixel = MatchRGB(vNewValue, aCreaturesPalette)
'            nPixel = MatchRGB(vNewValue)
'            m_aPixels(nOffset) = nPixel
'
'        Case 15
'            nBlue = (vNewValue And 16711680) / 65536
'            nGreen = (vNewValue And 65280) / 256
'            nRed = vNewValue And 255
'            nPixel = Int((nBlue And 248) / 8) Or Int((nGreen And 248) * 4) Or Int((nRed And 248) * 128)
'            m_aPixels(nOffset) = nPixel And 255
'            m_aPixels(nOffset + 1) = (nPixel And 65280) / 256
'
'        Case 16
'            nBlue = (vNewValue And 16711680) / 65536
'            nGreen = (vNewValue And 65280) / 256
'            nRed = vNewValue And 255
'            nPixel = Int((nBlue And 248) / 8) Or Int((nGreen And 252) * 8) Or Int((nRed And 248) * 256)
'            m_aPixels(nOffset) = nPixel And 255
'            m_aPixels(nOffset + 1) = (nPixel And 65280) / 256
'    End Select
'End Property

Public Sub GetPixelArray(aPixels() As Byte)
    Erase aPixels
    
    ReDim aPixels(0 To UBound(m_aPixels)) As Byte
    aPixels = m_aPixels
End Sub

Public Sub SetPixelArray(aNewPixels)
    Erase m_aPixels
    ReDim m_aPixels(0 To UBound(aNewPixels)) As Byte
    m_aPixels = aNewPixels
End Sub

Public Sub FlipPixelArray()
    Dim aNewPixels() As Byte
    Dim I As Integer
    Dim J As Integer
    
    ReDim aNewPixels(0 To UBound(m_aPixels))
    
    For I = 0 To m_nHeight - 1
        For J = 0 To m_nWidth - 1
            aNewPixels((m_nHeight - 1 - I) * m_nWidth + J) = m_aPixels(I * m_nWidth + J)
        Next
    Next
    
    m_aPixels = aNewPixels
End Sub

Public Sub SetPalette(aPalette() As Byte)
    Dim I As Integer
    
    Erase m_aPalette
    ReDim m_aPalette(0 To UBound(aPalette))
    
    For I = 0 To 1023 Step 4
        m_aPalette(Int(I / 4)).rgbBlue = aPalette(I)
        m_aPalette(Int(I / 4)).rgbGreen = aPalette(I + 1)
        m_aPalette(Int(I / 4)).rgbRed = aPalette(I + 2)
    Next
End Sub

Public Function LoadBitmapFile(sFilename As String) As Boolean
    Dim nFile As Integer
    Dim I As Integer
    Dim tBitmap As BITMAPTYPE
    Dim nBytesPerPixel As Long
    Dim nBytesPerLine As Long
    
    LoadBitmapFile = False
    
    nFile = FreeFile
    
    On Error Resume Next
    
    FileLen sFilename
    
    If Err <> 0 Then
        MsgBox "Error loading '" & sFilename & "': " & Err.Description, vbOKOnly + vbExclamation
        Err.Clear
        Exit Function
    End If
    
    On Error GoTo 0
    
    Open sFilename For Binary Access Read As nFile
    
    Get nFile, , tBitmap.FileHeader
    Get nFile, , tBitmap.InfoHeader
    
    If tBitmap.FileHeader.bfType <> &H4D42 Then
        MsgBox "Error loading '" & sFilename & "': Not a Windows Bitmap.", vbOKOnly + vbExclamation
        Exit Function
    End If
    
    If tBitmap.InfoHeader.biBitCount <> 8 And tBitmap.InfoHeader.biBitCount <> 24 Then
        MsgBox "Error loading '" & sFilename & "': Unsupported bit depth. Only 8 and 24 bit bitmaps supported.", vbOKOnly + vbExclamation
        Exit Function
    End If
    
    If tBitmap.InfoHeader.biBitCount = 8 Then
        If tBitmap.InfoHeader.biClrUsed > 0 Then
            ReDim tBitmap.ColorTable(0 To tBitmap.InfoHeader.biClrUsed - 1)
        Else
            ReDim tBitmap.ColorTable(0 To (2 ^ tBitmap.InfoHeader.biBitCount) - 1)
        End If
        
        For I = 0 To UBound(tBitmap.ColorTable)
            Get nFile, , tBitmap.ColorTable(I)
        Next
    End If
    
    nBytesPerPixel = Int(tBitmap.InfoHeader.biBitCount / 8)
    nBytesPerLine = nBytesPerPixel * tBitmap.InfoHeader.biWidth
    If nBytesPerLine Mod 4 Then
        nBytesPerLine = nBytesPerLine + 4 - (nBytesPerLine Mod 4)
    End If
    
    ReDim tBitmap.PixelData(0 To Abs(tBitmap.InfoHeader.biHeight) * nBytesPerLine - 1)
    
    If tBitmap.InfoHeader.biCompression = BI_RGB Then
        Get nFile, tBitmap.FileHeader.bfOffBits + 1, tBitmap.PixelData
    ElseIf tBitmap.InfoHeader.biCompression = BI_RLE4 Then
        MsgBox "Error loading '" & sFilename & "': Unsupported compression RLE4.", vbOKOnly + vbExclamation
        Exit Function
    ElseIf tBitmap.InfoHeader.biCompression = BI_RLE8 Then
        MsgBox "Error loading '" & sFilename & "': Unsupported compression RLE8.", vbOKOnly + vbExclamation
        Exit Function
    End If
    
    Close nFile
    
    SetFromBitmap tBitmap
    
    LoadBitmapFile = True
End Function

Public Function SaveBitmapFile(sFilename As String) As Boolean
    Dim nFile As Integer
    Dim I As Integer
    Dim tBitmap As BITMAPTYPE
    Dim nColorTable
    
    SaveBitmapFile = False
    
    GetToBitmap tBitmap
    
    nFile = FreeFile
    
    On Error Resume Next

    Open sFilename For Binary Access Write As nFile

    If Err <> 0 Then
        MsgBox "An error occurred while trying to open '" & sFilename & "' for writing:" & vbCrLf & _
               "Error " & Err & ": " & Err.Description
        Err.Clear
        Exit Function
    End If
    On Error GoTo 0
    
    Put nFile, , tBitmap.FileHeader
    Put nFile, , tBitmap.InfoHeader
    
    If tBitmap.InfoHeader.biBitCount = 8 Then
        For I = 0 To UBound(tBitmap.ColorTable)
            Put nFile, , tBitmap.ColorTable(I)
        Next
    End If
    
    Put nFile, , tBitmap.PixelData
    
    Close nFile
    
    SaveBitmapFile = True
End Function

Private Sub SetFromBitmap(tBitmap As BITMAPTYPE)
    Dim I As Long
    Dim J As Long
    Dim aMatchedPalette(0 To 255) As Integer
    Dim nBitmapPixel As Byte
    Dim nPixelOffset As Long
    Dim nBitmapOffset As Long
    Dim nPixel As Long
    Dim nRed As Long
    Dim nGreen As Long
    Dim nBlue As Long
    Dim nBitmapBytesPerPixel As Long
    Dim nBitmapBytesPerLine As Long
    Dim eNewType As SpriteTypeConstants
    Dim tRGB As RGBQUAD

    m_nWidth = tBitmap.InfoHeader.biWidth
    m_nHeight = tBitmap.InfoHeader.biHeight

    Erase m_aPixels
    
    nBitmapBytesPerPixel = tBitmap.InfoHeader.biBitCount / 8
    nBitmapBytesPerLine = m_nWidth * nBitmapBytesPerPixel
    If nBitmapBytesPerLine Mod 4 Then
        nBitmapBytesPerLine = nBitmapBytesPerLine + 4 - (nBitmapBytesPerLine Mod 4)
    End If
    
    If tBitmap.InfoHeader.biBitCount = 8 Then
        ReDim m_aPixels(0 To (CLng(m_nWidth) * CLng(m_nHeight) * BytesPerPixel) - 1)
        
        m_nBitsPerPixel = 8
        
        For I = 0 To 255
            aMatchedPalette(I) = -1
        Next

        If m_nHeight < 0 Then
            'If top down bitmap then keep and match colours
            For I = 0 To m_nHeight - 1
                For J = 0 To m_nWidth - 1
                    nBitmapPixel = tBitmap.PixelData(I * nBitmapBytesPerLine + J)
                    nPixelOffset = I * CLng(m_nWidth) + J
                    If aMatchedPalette(nBitmapPixel) > -1 Then
                        m_aPixels(nPixelOffset) = aMatchedPalette(nBitmapPixel)
                    Else
                        'm_aPixels(nPixelOffset) = MatchColour(nBitmapPixel, tBitmap.ColorTable, aCreaturesPalette)
                        tRGB = tBitmap.ColorTable(nBitmapPixel)
                        m_aPixels(nPixelOffset) = MatchRGB(RGB(tRGB.rgbRed, tRGB.rgbGreen, tRGB.rgbBlue))
                        aMatchedPalette(nBitmapPixel) = m_aPixels(nPixelOffset)
                    End If
                Next
            Next
        Else
            'otherwise flip and match colours
            m_nHeight = Abs(m_nHeight)
            For I = 0 To m_nHeight - 1
                For J = 0 To m_nWidth - 1
                    nBitmapPixel = tBitmap.PixelData((CLng(m_nHeight) - 1 - I) * nBitmapBytesPerLine + J)
                    nPixelOffset = I * CLng(m_nWidth) + J
                    If aMatchedPalette(nBitmapPixel) > -1 Then
                        m_aPixels(nPixelOffset) = aMatchedPalette(nBitmapPixel)
                    Else
                        'm_aPixels(nPixelOffset) = MatchColour(nBitmapPixel, tBitmap.ColorTable, aCreaturesPalette)
                        tRGB = tBitmap.ColorTable(nBitmapPixel)
                        m_aPixels(nPixelOffset) = MatchRGB(RGB(tRGB.rgbRed, tRGB.rgbGreen, tRGB.rgbBlue))
                        aMatchedPalette(nBitmapPixel) = m_aPixels(nPixelOffset)
                    End If
                Next
            Next
        End If
    ElseIf tBitmap.InfoHeader.biBitCount = 24 Then
'        Select Case m_nBitsPerPixel
'            Case 8
'                eNewType = stcSPR
'
'            Case 15
'                eNewType = stcS16_555
'
'            Case 16
'                eNewType = stcS16_565
'        End Select
        
        ReDim m_aPixels(0 To UBound(tBitmap.PixelData) - LBound(tBitmap.PixelData))
        
        m_aPixels = tBitmap.PixelData
        
        m_nBitsPerPixel = 24
        
'        ConvertToImageType eNewType
        
'        If m_nHeight < 0 Then
'            'Top Down bitmap
'            For I = 0 To m_nHeight - 1
'                For J = 0 To m_nWidth - 1
'                    nBitmapOffset = I * nBitmapBytesPerLine + J * 3
'                    nRed = tBitmap.PixelData(nBitmapOffset + 2)
'                    nGreen = tBitmap.PixelData(nBitmapOffset + 1)
'                    nBlue = tBitmap.PixelData(nBitmapOffset)
'                    Pixels(J, I) = RGB(nRed, nGreen, nBlue)
'                Next
'            Next
'        Else
'            For I = 0 To m_nHeight - 1
'                For J = 0 To m_nWidth - 1
'                    nBitmapOffset = (CLng(m_nHeight) - 1 - I) * nBitmapBytesPerLine + J * 3
'                    nRed = tBitmap.PixelData(nBitmapOffset + 2)
'                    nGreen = tBitmap.PixelData(nBitmapOffset + 1)
'                    nBlue = tBitmap.PixelData(nBitmapOffset)
'                    Pixels(J, I) = RGB(nRed, nGreen, nBlue)
'                Next
'            Next
'        End If
    End If
End Sub

Private Sub GetToBitmap(tBitmap As BITMAPTYPE)
    Dim I As Long
    Dim J As Long
    Dim nPixelOffset As Long
    Dim nBitmapOffset As Long
    Dim nPixel As Long
    Dim nRed As Long
    Dim nGreen As Long
    Dim nBlue As Long
    Dim nBytesPerLine As Long

    With tBitmap.FileHeader
        .bfType = &H4D42
    End With

    If m_nBitsPerPixel = 8 Then
        nBytesPerLine = m_nWidth
        If nBytesPerLine Mod 4 Then
            nBytesPerLine = nBytesPerLine + 4 - (nBytesPerLine Mod 4)
        End If
        
        With tBitmap.FileHeader
            .bfSize = Len(tBitmap.FileHeader) + Len(tBitmap.InfoHeader) + 1024 + nBytesPerLine * CLng(m_nHeight)
            .bfOffBits = Len(tBitmap.FileHeader) + Len(tBitmap.InfoHeader) + 1024
        End With
        
        With tBitmap.InfoHeader
            .biBitCount = 8
            .biClrImportant = 256
            .biClrUsed = 256
            .biCompression = BI_RGB
            .biWidth = m_nWidth
            .biHeight = m_nHeight
            .biPlanes = 1
            .biSize = 40
            .biSizeImage = nBytesPerLine * CLng(m_nHeight)
            .biXPelsPerMeter = 2834
            .biYPelsPerMeter = 2834
        End With

        ReDim tBitmap.ColorTable(0 To 255)

        For I = 0 To 255
            tBitmap.ColorTable(I).rgbRed = aCreaturesPalette(I).Red
            tBitmap.ColorTable(I).rgbGreen = aCreaturesPalette(I).Green
            tBitmap.ColorTable(I).rgbBlue = aCreaturesPalette(I).Blue
        Next

        ReDim tBitmap.PixelData(0 To UBound(m_aPixels))

        For I = 0 To m_nHeight - 1
            For J = 0 To m_nWidth - 1
                tBitmap.PixelData((CLng(m_nHeight) - 1 - I) * nBytesPerLine + J) = m_aPixels(I * CLng(m_nWidth) + J)
            Next
        Next
    ElseIf m_nBitsPerPixel = 15 Or m_nBitsPerPixel = 16 Then
        nBytesPerLine = m_nWidth * 3
        If nBytesPerLine Mod 4 Then
            nBytesPerLine = nBytesPerLine + 4 - (nBytesPerLine Mod 4)
        End If
        
        With tBitmap.FileHeader
            .bfSize = Len(tBitmap.FileHeader) + Len(tBitmap.InfoHeader) + nBytesPerLine * CLng(m_nHeight)
            .bfOffBits = Len(tBitmap.FileHeader) + Len(tBitmap.InfoHeader)
        End With
        
        With tBitmap.InfoHeader
            .biBitCount = 24
            .biClrImportant = 0
            .biClrUsed = 0
            .biCompression = BI_RGB
            .biWidth = m_nWidth
            .biHeight = m_nHeight
            .biPlanes = 1
            .biSize = 40
            .biSizeImage = nBytesPerLine * CLng(m_nHeight)
            .biXPelsPerMeter = 2834
            .biYPelsPerMeter = 2834
        End With
        
        ReDim tBitmap.PixelData(0 To tBitmap.InfoHeader.biSizeImage - 1)

        If m_nBitsPerPixel = 15 Then
            For I = 0 To m_nHeight - 1
                For J = 0 To m_nWidth - 1
                    'nPixelOffset = I * CLng(m_nWidth) * 2 + J * 2
                    nBitmapOffset = (CLng(m_nHeight) - 1 - I) * nBytesPerLine + J * 3
                    'nPixel = CLng(m_aPixels(nPixelOffset)) Or (CLng(m_aPixels(nPixelOffset + 1)) * 256)
                    'nBlue = (nPixel And 31) * 8
                    'nGreen = Int((nPixel And 992) / 8)
                    'nRed = Int((nPixel And 31744) / 128)
                    nPixel = Pixels(J, I)
                    nRed = nPixel And 255
                    nGreen = Int(nPixel / 256) And 255
                    nBlue = Int(nPixel / 65536) And 255
                    tBitmap.PixelData(nBitmapOffset + 2) = nRed
                    tBitmap.PixelData(nBitmapOffset + 1) = nGreen
                    tBitmap.PixelData(nBitmapOffset) = nBlue
                Next
            Next
        ElseIf m_nBitsPerPixel = 16 Then
            For I = 0 To m_nHeight - 1
                For J = 0 To m_nWidth - 1
                    'nPixelOffset = I * CLng(m_nWidth) * 2 + J * 2
                    nBitmapOffset = (CLng(m_nHeight) - 1 - I) * nBytesPerLine + J * 3
                    'nPixel = CLng(m_aPixels(nPixelOffset)) Or (CLng(m_aPixels(nPixelOffset + 1)) * 256)
                    'nBlue = (nPixel And 31) * 8
                    'nGreen = Int((nPixel And 2016) / 8)
                    'nRed = Int((nPixel And 63488) / 256)
                    nPixel = Pixels(J, I)
                    nRed = nPixel And 255
                    nGreen = Int(nPixel / 256) And 255
                    nBlue = Int(nPixel / 65536) And 255
                    tBitmap.PixelData(nBitmapOffset + 2) = nRed
                    tBitmap.PixelData(nBitmapOffset + 1) = nGreen
                    tBitmap.PixelData(nBitmapOffset) = nBlue
                Next
            Next
        End If
    End If
End Sub

'Private Function MatchColour(nPixel As Byte, aSourcePalette() As RGBQUAD, aDestPalette() As PaletteEntry) As Integer
'    Dim I As Integer
'    Dim nDistance As Long
'    Dim nBestDistance As Long
'    Dim nBestIndex As Integer
'    Dim nSourceRed As Integer
'    Dim nSourceGreen As Integer
'    Dim nSourceBlue As Integer
'
'    If (nPixel >= 0 And nPixel <= 10) Or (nPixel >= 243 And nPixel <= 255) Then
'        MatchColour = nPixel
'        Exit Function
'    End If
'
'    nSourceRed = aSourcePalette(nPixel).rgbRed
'    nSourceGreen = aSourcePalette(nPixel).rgbGreen
'    nSourceBlue = aSourcePalette(nPixel).rgbBlue
'
'    nBestDistance = 768
'    nBestIndex = -1
'
'    For I = 11 To 242
'        nDistance = Abs(aDestPalette(I).Red - nSourceRed) + Abs(aDestPalette(I).Green - nSourceGreen) + Abs(aDestPalette(I).Blue - nSourceBlue) / 3
'        If nDistance = 0 Then
'            MatchColour = I
'            Exit Function
'        ElseIf nDistance < nBestDistance Then
'            nBestDistance = nDistance
'            nBestIndex = I
'        End If
'    Next
'
'    MatchColour = nBestIndex
'End Function

Public Function ConvertToImageType(ByVal eNewType As SpriteTypeConstants) As Boolean
    Dim eOldType As ImageTypes
    Dim oNewImage As Bitmap
    Dim aPixels() As Byte
    Dim aNewPixels() As Byte
    Dim X As Long
    Dim Y As Long
    
    ConvertToImageType = False
    
    Set oNewImage = New Bitmap
    
    With oNewImage
        Select Case eNewType
            Case imageTypeSPR
                .BitsPerPixel = 8
                
            Case imageTypeS16_555
                .BitsPerPixel = 15
                
            Case imageTypeS16_565
                .BitsPerPixel = 16
        End Select
        
        .Width = m_nWidth
        .Height = m_nHeight
    End With
    
    Select Case m_nBitsPerPixel
        Case 8
            eOldType = imageTypeSPR
            
        Case 15
            eOldType = imageTypeS16_555
            
        Case 16
            eOldType = imageTypeS16_565
            
        Case 24
            eOldType = imageTypeBMP24
    End Select
    
    If oNewImage.Width > 0 And oNewImage.Height > 0 Then
        oNewImage.AllocatePixelArray
        oNewImage.GetPixelArray aNewPixels
        
        GetPixelArray aPixels
        
        ConvertImage m_nWidth, m_nHeight, eOldType, aPixels(0), eNewType, aNewPixels(0)
        
        SetPixelArray aNewPixels
        
        m_nBitsPerPixel = oNewImage.BitsPerPixel
    End If
    
    ConvertToImageType = True
End Function

Public Sub ConvertToCreaturesPalette()
    Dim I As Long
    Dim J As Long
    Dim aMatchedPalette(0 To 255) As Integer
    Dim nBitmapPixel As Byte
    Dim tRGB As RGBQUAD
    Dim nPixelOffset As Long
    
    For I = 0 To 255
        aMatchedPalette(I) = -1
    Next
    
    For I = 0 To m_nHeight - 1
        For J = 0 To m_nWidth - 1
            nPixelOffset = I * CLng(m_nWidth) + J
            nBitmapPixel = m_aPixels(nPixelOffset)
            If aMatchedPalette(nBitmapPixel) > -1 Then
                m_aPixels(nPixelOffset) = aMatchedPalette(nBitmapPixel)
            Else
                tRGB = m_aPalette(nBitmapPixel)
                m_aPixels(nPixelOffset) = MatchRGB(RGB(tRGB.rgbRed, tRGB.rgbGreen, tRGB.rgbBlue))
                aMatchedPalette(nBitmapPixel) = m_aPixels(nPixelOffset)
            End If
        Next
    Next
End Sub

Public Sub Draw(ByVal hDC As Long, ByVal X As Long, ByVal Y As Long)
    Dim eType As SpriteTypeConstants
    
    Select Case m_nBitsPerPixel
        Case 8
            eType = imageTypeSPR
            
        Case 15
            eType = imageTypeS16_555
            
        Case 16
            eType = imageTypeS16_565
    End Select
    
    DrawBitmapXY hDC, X, Y, eType, m_nWidth, m_nHeight, m_aPixels(0)
End Sub

