VERSION 5.00
Begin VB.Form frmAnimation 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Animation"
   ClientHeight    =   3495
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   3495
   Icon            =   "Animation.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   233
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   233
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.Timer ctlTimer 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   0
      Top             =   0
   End
   Begin VB.PictureBox picSprite 
      BackColor       =   &H00000000&
      ForeColor       =   &H00FFFFFF&
      Height          =   3255
      Left            =   120
      OLEDropMode     =   1  'Manual
      ScaleHeight     =   213
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   213
      TabIndex        =   0
      TabStop         =   0   'False
      Top             =   120
      Width           =   3255
   End
End
Attribute VB_Name = "frmAnimation"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_nBase As Long
Private m_sSequence As String
Private m_eAnimType As AnimTypes
Private m_nIndex As Long

Public Sub Display(ByVal nBase As Long, ByVal sSequence As String, eAnimType As AnimTypes)
    m_nBase = nBase
    m_sSequence = sSequence
    m_eAnimType = eAnimType
    m_nIndex = 1
    
    CalculateFormSize
    
    ctlTimer.Enabled = True
    
    Show vbModal
End Sub

Private Sub CalculateFormSize()
    Dim oImage As Bitmap
    Dim I As Integer
    Dim nMaxWidth As Integer
    Dim nMaxHeight As Integer
    
    For I = 1 To Len(m_sSequence)
        Set oImage = g_oCurrentSprite.SpriteImages(CInt(Mid(m_sSequence, I, 1)) + m_nBase + 1)
        
        If oImage.Width > nMaxWidth Then
            nMaxWidth = oImage.Width
        End If
        
        If oImage.Height > nMaxHeight Then
            nMaxHeight = oImage.Height
        End If
    Next
    
    nMaxWidth = nMaxWidth + (picSprite.Width - picSprite.ScaleWidth)
    nMaxHeight = nMaxHeight + (picSprite.Height - picSprite.ScaleHeight)
    
    Me.Width = (((Me.Width / Screen.TwipsPerPixelX) - Me.ScaleWidth) + (Me.ScaleWidth - picSprite.Width) + nMaxWidth) * Screen.TwipsPerPixelX
    Me.Height = (((Me.Height / Screen.TwipsPerPixelY) - Me.ScaleHeight) + (Me.ScaleHeight - picSprite.Height) + nMaxHeight) * Screen.TwipsPerPixelY
    picSprite.Width = nMaxWidth
    picSprite.Height = nMaxHeight
End Sub

Private Sub ctlTimer_Timer()
    Dim oImage As Bitmap
    
    Select Case m_eAnimType
        Case atObject
            Set oImage = g_oCurrentSprite.SpriteImages(m_nBase + CLng(Mid(m_sSequence, m_nIndex, 1)) + 1)
            m_nIndex = m_nIndex + 1
            
        Case atCreature
            Set oImage = g_oCurrentSprite.SpriteImages(m_nBase + CLng(Mid(m_sSequence, m_nIndex, 3)) + 1)
            m_nIndex = m_nIndex + 3
    End Select
    
    picSprite.Cls
    
    oImage.Draw picSprite.hDC, 0, 0
    
    DoEvents
    
    If m_nIndex > Len(m_sSequence) Then
        m_nIndex = 1
    End If
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = vbKeyEscape And Shift = 0 Then
        Unload Me
    End If
End Sub
