VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "RegistryKey"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Enum RegistryHKEYS
    HKEY_CLASSES_ROOT = &H80000000
    HKEY_CURRENT_USER = &H80000001
    HKEY_LOCAL_MACHINE = &H80000002
End Enum

Public Enum RegistryValueTypes
    REG_NONE = 0
    REG_SZ = 1
    REG_DWORD = 4
End Enum

Private Declare Function RegOpenKey Lib "advapi32.dll" Alias "RegOpenKeyA" (ByVal hKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Private Declare Function RegQueryValue Lib "advapi32.dll" Alias "RegQueryValueA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal lpValue As String, lpcbValue As Long) As Long
Private Declare Function RegQueryValueExString Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, ByVal lpData As String, lpcbData As Long) As Long         ' Note that if you declare the lpData parameter as String, you must pass it By Value.
Private Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Private Declare Function RegCreateKey Lib "advapi32.dll" Alias "RegCreateKeyA" (ByVal hKey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Private Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpSubKey As String) As Long
Private Declare Function RegSetValue Lib "advapi32.dll" Alias "RegSetValueA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal dwType As Long, ByVal lpData As String, ByVal cbData As Long) As Long
Private Declare Function RegSetValueExString Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpData As String, ByVal cbData As Long) As Long         ' Note that if you declare the lpData parameter as String, you must pass it By Value.
Private Declare Function RegSetValueEx Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Any, ByVal cbData As Long) As Long
Private Declare Function RegDeleteValue Lib "advapi32.dll" Alias "RegDeleteValueA" (ByVal hKey As Long, ByVal lpValueName As String) As Long
Private Declare Function RegEnumKey Lib "advapi32.dll" Alias "RegEnumKeyA" (ByVal hKey As Long, ByVal dwIndex As Long, ByVal lpName As String, ByVal cbName As Long) As Long

Private m_hKey As Long

Public Function OpenKey(ByVal hKey As Long, ByVal sSubKey As String, Optional ByVal bCreate As Boolean = False) As Boolean
    Dim nRes As Long
    Dim hResKey As Long
    
    OpenKey = False
    
    If m_hKey <> 0 Then
        If Not CloseKey Then
            Exit Function
        End If
    End If
    
    nRes = RegOpenKey(hKey, sSubKey, hResKey)
    
    If hResKey = 0 Then
        If Not bCreate Then
            Exit Function
        Else
            nRes = RegCreateKey(hKey, sSubKey, hResKey)
            If hResKey = 0 Then
                Exit Function
            End If
        End If
    End If
    
    m_hKey = hResKey
    OpenKey = True
End Function

Public Function SetKeyDefaultValue(ByVal sSubKey As String, ByVal sValue As String) As Boolean
    Dim nRes As Long
    Dim sTemp As String * 256
    Dim nLen As Long
    
    SetKeyDefaultValue = False
    
    If m_hKey = 0 Then
        Exit Function
    End If
    
    sTemp = sValue & Chr(0)
    nLen = Len(sValue)
    
    nRes = RegSetValue(m_hKey, sSubKey, REG_SZ, sTemp, nLen)
    
    If nRes <> 0 Then
        Exit Function
    End If
    
    SetKeyDefaultValue = True
End Function

Public Function SetKeyValue(ByVal sName As String, ByVal nType As RegistryValueTypes, ByVal vValue) As Boolean
    Dim nRes As Long
    Dim sTemp As String * 256
    Dim nLen As Long
    Dim nDword As Long
    
    SetKeyValue = False
    
    If m_hKey = 0 Then
        Exit Function
    End If
    
    Select Case nType
        Case REG_SZ
            sTemp = vValue & Chr(0)
            nLen = Len(vValue)
            nRes = RegSetValueExString(m_hKey, sName, 0, nType, sTemp, nLen)
            
        Case REG_DWORD
            nDword = vValue
            nRes = RegSetValueEx(m_hKey, sName, 0, nType, nDword, 4)
    End Select
    
    If nRes <> 0 Then
        Exit Function
    End If
    
    SetKeyValue = True
End Function

Public Function GetKeyDefaultValue(ByVal sSubKey As String, sValue As String, Optional ByVal bIgnoreFailure As Boolean = False) As Boolean
    Dim sTemp As String
    Dim nLen As Long
    Dim nRes As Long
    
    GetKeyDefaultValue = False
    
    If m_hKey = 0 Then
        Exit Function
    End If
    
    nRes = RegQueryValue(m_hKey, sSubKey, vbNullString, nLen)
    sTemp = String(nLen, Chr(0))
    nRes = RegQueryValue(m_hKey, sSubKey, sTemp, nLen)
    
    If nRes = 0 Then
        sValue = Left(sTemp, nLen - 1)
    ElseIf nRes <> 0 And bIgnoreFailure Then
        sValue = ""
    ElseIf nRes <> 0 Then
        Exit Function
    End If
    
    GetKeyDefaultValue = True
End Function

Public Function GetKeyValue(ByVal sName As String, ByVal nType As RegistryValueTypes, vValue, Optional ByVal bIgnoreFailure As Boolean = False) As Boolean
    Dim sTemp As String
    Dim nLen As Long
    Dim nRes As Long
    Dim nDword As Long
    
    GetKeyValue = False
    
    If m_hKey = 0 Then
        Exit Function
    End If
    
    Select Case nType
        Case REG_SZ
            nRes = RegQueryValueExString(m_hKey, sName, 0, nType, vbNullString, nLen)
            sTemp = String(nLen, Chr(0))
            nRes = RegQueryValueExString(m_hKey, sName, 0, nType, sTemp, nLen)
            If nRes = 0 Then
                If nLen > 0 Then
                    vValue = Left(sTemp, nLen - 1)
                Else
                    vValue = ""
                End If
            ElseIf nRes <> 0 And bIgnoreFailure Then
                vValue = ""
            End If
            
        Case REG_DWORD
            nRes = RegQueryValueEx(m_hKey, sName, 0, nType, nDword, 4)
            If nRes = 0 Then
                vValue = nDword
            ElseIf nRes <> 0 And bIgnoreFailure Then
                vValue = 0
            End If
    End Select
    
    If nRes <> 0 And Not bIgnoreFailure Then
        Exit Function
    End If
    
    GetKeyValue = True
End Function

Public Function DeleteKeyValue(ByVal sName As String) As Boolean
    Dim nRes As Long
    
    DeleteKeyValue = False
    
    If m_hKey = 0 Then
        Exit Function
    End If
    
    nRes = RegDeleteValue(m_hKey, sName)
    
    If nRes <> 0 Then
        Exit Function
    End If
    
    DeleteKeyValue = True
End Function

Public Function DeleteKey(ByVal sSubKey As String) As Boolean
    Dim nRes As Long
    
    DeleteKey = False
    
    If m_hKey = 0 Then
        Exit Function
    End If
    
    nRes = RegDeleteKey(m_hKey, sSubKey)
    
    If nRes <> 0 Then
        Exit Function
    End If
    
    DeleteKey = True
End Function

Public Function EnumKey(ByVal nIndex As Long, sName As String) As Boolean
    Dim nRes As Long
    Dim sTemp As String * 256
    Dim nLen As Long
    
    EnumKey = False
    
    If m_hKey = 0 Then
        Exit Function
    End If
    
    nLen = 256
    nRes = RegEnumKey(m_hKey, nIndex, sTemp, nLen)
    
    If nRes <> 0 Then
        sName = ""
        Exit Function
    End If
    
    sName = Left(sTemp, InStr(sTemp, Chr(0)) - 1)
    
    EnumKey = True
End Function

Public Function CloseKey() As Boolean
    Dim nRes As Long
    
    CloseKey = False
    
    If m_hKey = 0 Then
        Exit Function
    End If
    
    nRes = RegCloseKey(m_hKey)
    
    If nRes <> 0 Then
        Exit Function
    End If
    
    m_hKey = 0
    
    CloseKey = True
End Function

Private Sub Class_Initialize()
    m_hKey = 0
End Sub

Private Sub Class_Terminate()
    If m_hKey <> 0 Then
        CloseKey
    End If
End Sub
