VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmEmbeddedFiles 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Embedded Files"
   ClientHeight    =   2055
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   3735
   Icon            =   "EmbeddedFiles.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   OLEDropMode     =   1  'Manual
   ScaleHeight     =   2055
   ScaleWidth      =   3735
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin MSComDlg.CommonDialog ctlCommonDialog 
      Left            =   3240
      Top             =   1560
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
   End
   Begin VB.CommandButton cmdExtract 
      Caption         =   "&Extract..."
      Height          =   375
      Left            =   2520
      OLEDropMode     =   1  'Manual
      TabIndex        =   4
      Top             =   1080
      Width           =   1095
   End
   Begin VB.CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "&Close"
      Height          =   375
      Left            =   2520
      OLEDropMode     =   1  'Manual
      TabIndex        =   3
      Top             =   1560
      Width           =   1095
   End
   Begin VB.CommandButton cmdDeleteEmbeddedFile 
      Caption         =   "&Delete"
      Height          =   375
      Left            =   2520
      OLEDropMode     =   1  'Manual
      TabIndex        =   2
      Top             =   600
      Width           =   1095
   End
   Begin VB.CommandButton cmdAddEmbeddedFile 
      Caption         =   "&Add..."
      Height          =   375
      Left            =   2520
      OLEDropMode     =   1  'Manual
      TabIndex        =   1
      Top             =   120
      Width           =   1095
   End
   Begin VB.ListBox lstEmbeddedFiles 
      Height          =   1815
      ItemData        =   "EmbeddedFiles.frx":000C
      Left            =   120
      List            =   "EmbeddedFiles.frx":000E
      MultiSelect     =   2  'Extended
      OLEDropMode     =   1  'Manual
      TabIndex        =   0
      Top             =   120
      Width           =   2295
   End
End
Attribute VB_Name = "frmEmbeddedFiles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private nDropEffect As Long

Private Sub AddEmbeddedFile(ByVal sFileTitle As String, ByVal sFilename As String)
    Dim nFile As Long
    Dim aData() As Byte
    Dim I As Long
    Dim finddata As WIN32_FIND_DATA
    
    If Trim(sFileTitle) = "" Then
        FindFirstFile sFilename, finddata
        sFileTitle = Left(finddata.cFileName, InStr(finddata.cFileName, Chr(0)) - 1)
    End If
    
    For I = 0 To lstEmbeddedFiles.ListCount
        If Trim(LCase(sFileTitle)) = Trim(LCase(lstEmbeddedFiles.List(I))) Then
            MsgBox "A file called '" & sFileTitle & "' already exists in this COB.", vbOKOnly Or vbExclamation
            Exit Sub
        End If
    Next
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Open sFilename For Binary Access Read As nFile
    If Err Then
        MsgBox "Error opening file '" & sFilename & "':" & vbCrLf & vbCrLf & Err.Description, vbOKOnly Or vbExclamation, "Adding File..."
        Err.Clear
        Exit Sub
    End If
    
    On Error GoTo 0
    
    ReDim aData(0 To LOF(nFile) - 1)
    
    Get nFile, , aData
    
    Close nFile
    
    tCurrentCOB.AddEmbeddedFile sFileTitle, aData
    
    lstEmbeddedFiles.AddItem sFileTitle
    
    'Scan agents in current COB for references to added file
    Dim sSearch As String
    Dim nOldSelectedAgent As Long
    Dim bAddFile As Boolean
    Dim J As Long
    
    sSearch = Left(sFileTitle, InStr(sFileTitle, ".") - 1)
    nOldSelectedAgent = tCurrentCOB.SelectedAgent
    
    For I = 0 To tCurrentCOB.NumberOfAgents - 1
        bAddFile = False
        
        tCurrentCOB.SelectedAgent = I
        
        If InStr(tCurrentCOB.sInjectionScript, sSearch) > 0 Or InStr(tCurrentCOB.sRemoverScript, sSearch) > 0 Then
            bAddFile = True
        End If
        
        For J = 0 To tCurrentCOB.nNumberOfObjectScripts - 1
            If InStr(tCurrentCOB.aObjectScripts(J), sSearch) > 0 Then
                bAddFile = True
                Exit For
            End If
        Next
        
        If bAddFile Then
            tCurrentCOB.AddRequiredFile sFileTitle
        End If
    Next
    
    tCurrentCOB.SelectedAgent = nOldSelectedAgent
End Sub

Private Sub ExtractEmbeddedFile(sFilename As String, ByVal Index As Long)
    Dim nFile As Long
    Dim aData() As Byte
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Open sFilename For Binary Access Write As nFile
    If Err Then
        MsgBox "Error opening file '" & sFilename & "':" & vbCrLf & vbCrLf & Err.Description, vbOKOnly Or vbExclamation, "Extracting File..."
        Err.Clear
        Exit Sub
    End If
    
    On Error GoTo 0
    
    tCurrentCOB.GetEmbeddedFileDataArray Index, aData
    
    Put nFile, , aData
    
    Close nFile
End Sub

Private Sub cmdAddEmbeddedFile_Click()
    Dim sPrefix As String
    Dim sName As String
    Dim I As Integer
    Dim J As Integer
    
    With ctlCommonDialog
        .FileName = ""
        .DialogTitle = "Add File..."
        .Filter = sEmbeddableFilesFilter
        .FilterIndex = 1
        .Flags = cdlOFNAllowMultiselect Or cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist
        .CancelError = True
        On Error Resume Next
        .ShowOpen
        If Err = cdlCancel Then
            Err.Clear
            Exit Sub
        End If
        On Error GoTo 0
        
        I = InStr(.FileName, Chr(0))
        If I > 0 Then
            sPrefix = Left(.FileName, I - 1) & "\"
            Do
                I = I + 1
                J = InStr(I, .FileName, Chr(0))
                If J > 0 Then
                    sName = Mid(.FileName, I, J - I)
                Else
                    sName = Mid(.FileName, I)
                End If
                If InStr(sName, ".") = 5 Then
                    AddEmbeddedFile sName, sPrefix & sName
                Else
                    MsgBox "The part of the filename before the . must be 4 characters."
                End If
                I = J
            Loop While I > 0
        Else
            If InStr(.FileTitle, ".") = 5 Then
                AddEmbeddedFile .FileTitle, .FileName
            Else
                MsgBox "The part of the filename before the . must be 4 characters."
            End If
        End If
    End With
End Sub

Private Sub cmdAddEmbeddedFile_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdAddEmbeddedFile_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdClose_Click()
    Unload Me
End Sub

Private Sub cmdClose_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdClose_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdDeleteEmbeddedFile_Click()
    Dim I As Long
    
    If lstEmbeddedFiles.SelCount <= 0 Then
        Exit Sub
    End If
    
    Do While lstEmbeddedFiles.SelCount > 0
        For I = 0 To lstEmbeddedFiles.ListCount - 1
            If lstEmbeddedFiles.Selected(I) Then
                tCurrentCOB.DeleteEmbeddedFile I
                lstEmbeddedFiles.RemoveItem I
                Exit For
            End If
        Next
    Loop
End Sub

Private Sub cmdDeleteEmbeddedFile_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdDeleteEmbeddedFile_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdExtract_Click()
    Dim I As Long
    
    If lstEmbeddedFiles.SelCount <= 0 Then
        Exit Sub
    End If
    
    For I = 0 To lstEmbeddedFiles.ListCount - 1
        If lstEmbeddedFiles.Selected(I) Then
            With ctlCommonDialog
                .FileName = tCurrentCOB.EmbeddedFileName(I)
                .DialogTitle = "Extract File..."
                .Filter = sEmbeddableFilesFilter
                .Flags = cdlOFNExplorer Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist Or cdlOFNOverwritePrompt
                .CancelError = True
                Select Case tCurrentCOB.EmbeddedFileType(I)
                    Case rftcSprite
                        .FilterIndex = 2
                        
                    Case rftcSound
                        .FilterIndex = 3
                End Select
                On Error Resume Next
                .ShowSave
                If Err = cdlCancel Then
                    Err.Clear
                    Exit Sub
                End If
                On Error GoTo 0
                
                ExtractEmbeddedFile .FileName, I
            End With
        End If
    Next
End Sub

Private Sub cmdExtract_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdExtract_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub Form_Load()
    Dim I As Integer
    
    lstEmbeddedFiles.Clear
    For I = 0 To tCurrentCOB.NumberOfEmbeddedFiles - 1
        lstEmbeddedFiles.AddItem tCurrentCOB.EmbeddedFileName(I)
    Next
    
    lstEmbeddedFiles.ListIndex = -1
End Sub

Private Sub Form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim I As Integer
    
    If Data.GetFormat(vbCFFiles) And (Effect And vbDropEffectCopy) Then
        For I = 1 To Data.Files.Count
            AddEmbeddedFile "", Data.Files.Item(I)
        Next
    End If
End Sub

Private Sub Form_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Dim I As Integer
    Dim sFilename As String
    
    If State = vbEnter Then
        nDropEffect = vbDropEffectNone
        
        If Data.GetFormat(vbCFFiles) And (Effect And vbDropEffectCopy) Then
            nDropEffect = vbDropEffectCopy
            For I = 1 To Data.Files.Count
                sFilename = Data.Files.Item(I)
                Select Case LCase(Right(sFilename, 3))
                    Case "wav", "s16"
                        nDropEffect = vbDropEffectCopy
                        
                    Case Else
                        nDropEffect = vbDropEffectNone
                        Exit For
                End Select
            Next
        Else
            nDropEffect = vbDropEffectNone
        End If
    End If
    
    Effect = nDropEffect
End Sub

Private Sub lstEmbeddedFiles_DblClick()
    cmdExtract_Click
End Sub

Private Sub lstEmbeddedFiles_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lstEmbeddedFiles_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub
