VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmCommandLineInterface 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Command Line Interface"
   ClientHeight    =   2070
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5535
   Icon            =   "CommandLineInterface.frx":0000
   LinkTopic       =   "frmCommandLineInterface"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2070
   ScaleWidth      =   5535
   StartUpPosition =   2  'CenterScreen
   Begin VB.ComboBox cboScript 
      Height          =   315
      Left            =   720
      TabIndex        =   8
      Top             =   120
      Width           =   3255
   End
   Begin VB.CheckBox chkCreatures2 
      Caption         =   "Creatures &2"
      Height          =   255
      Left            =   4080
      TabIndex        =   7
      Top             =   1800
      Width           =   1215
   End
   Begin VB.CheckBox chkAlwaysOnTop 
      Caption         =   "&Always On Top"
      Height          =   255
      Left            =   4080
      TabIndex        =   6
      Top             =   1560
      Width           =   1455
   End
   Begin MSComDlg.CommonDialog ctlCommandCommonDialog 
      Left            =   0
      Top             =   1320
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
   End
   Begin VB.CommandButton cmdHelp 
      Cancel          =   -1  'True
      Caption         =   "&Help"
      Height          =   375
      Left            =   4320
      TabIndex        =   5
      Top             =   1080
      Width           =   1095
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "&Close"
      Height          =   375
      Left            =   4320
      TabIndex        =   2
      Top             =   600
      Width           =   1095
   End
   Begin VB.CommandButton cmdExecute 
      Caption         =   "&Execute"
      Default         =   -1  'True
      Height          =   375
      Left            =   4320
      TabIndex        =   1
      Top             =   120
      Width           =   1095
   End
   Begin VB.TextBox txtReply 
      Height          =   1125
      Left            =   720
      LinkItem        =   "Macro"
      LinkTopic       =   "Vivarium|Macro"
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   720
      Width           =   3255
   End
   Begin VB.Label lblReply 
      AutoSize        =   -1  'True
      Caption         =   "&Reply:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   720
      Width           =   450
   End
   Begin VB.Label lblMacro 
      AutoSize        =   -1  'True
      Caption         =   "&Macro:"
      Height          =   195
      Left            =   120
      TabIndex        =   3
      Top             =   165
      Width           =   495
   End
End
Attribute VB_Name = "frmCommandLineInterface"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub LoadCLIHistory()
    Dim oRegKey As New RegistryKey
    Dim I As Integer
    Dim sLine As String
    
    cboScript.Clear
    
    If Not oRegKey.OpenKey(HKEY_CURRENT_USER, sBoBCoBRegistryKey) Then
        Exit Sub
    End If
    
    I = 0
    Do
        If Not oRegKey.GetKeyValue("CLIHistory" & CStr(I), REG_SZ, sLine) Then
            'MsgBox "Could not load Command Line history from BoBCOB registry key!", vbOKOnly Or vbExclamation
            Exit Do
        End If
        cboScript.AddItem sLine
        I = I + 1
    Loop While True
End Sub

Private Sub SaveCLIHistory()
    Dim oRegKey As New RegistryKey
    Dim I As Integer
    
    If Not oRegKey.OpenKey(HKEY_CURRENT_USER, sBoBCoBRegistryKey, True) Then
        MsgBox "Could not open BoBCoB registry key for saving Command Line history!", vbOKOnly Or vbExclamation
        Exit Sub
    End If
    
    For I = 0 To cboScript.ListCount - 1
        If Not oRegKey.SetKeyValue("CLIHistory" & CStr(I), REG_SZ, cboScript.List(I)) Then
            MsgBox "Could not save Command Line history to BoBCOB registry key!", vbOKOnly Or vbExclamation
            Exit Sub
        End If
    Next
End Sub

Private Sub AddToCLIHistory(ByVal sLine As String)
    Dim I As Integer
    
    For I = 0 To cboScript.ListCount - 1
        If cboScript.List(I) = sLine Then
            cboScript.RemoveItem I
            Exit For
        End If
    Next
    
    cboScript.AddItem sLine, 0
    cboScript.ListIndex = 0
    
    Do While cboScript.ListCount > 10
        cboScript.RemoveItem cboScript.ListCount - 1
    Loop
End Sub

Private Sub chkAlwaysOnTop_Click()
    If chkAlwaysOnTop.Value = vbChecked Then
        SetWindowPos hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE + SWP_SHOWWINDOW + SWP_NOSIZE + SWP_NOMOVE
        bCommandLineInterfaceAlwaysOnTop = True
    Else
        SetWindowPos hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE + SWP_SHOWWINDOW + SWP_NOSIZE + SWP_NOMOVE
        bCommandLineInterfaceAlwaysOnTop = False
    End If
End Sub

Private Sub cmdClose_Click()
    Unload Me
    frmBoBCoB.Show
End Sub

Private Sub cmdExecute_Click()
    Dim nOKCancel As Integer
    Dim sResult As String
    
    AddToCLIHistory cboScript.Text
    
    SendCreaturesCommand IIf(chkCreatures2.Value = vbChecked, cvcCreatures2, cvcCreatures1), cboScript.Text, sResult
    
    txtReply.Text = sResult
    
    cboScript.SelStart = 0
    cboScript.SelLength = Len(cboScript.Text)
End Sub

Private Sub cmdHelp_Click()
    With ctlCommandCommonDialog
        .HelpKey = HelpStringSearch(txtString)
        .HelpCommand = cdlHelpPartialKey
        .ShowHelp
    End With
End Sub

Private Sub Form_Load()
    chkCreatures2.Value = IIf(nCreaturesVersion = cvcCreatures2, vbChecked, vbUnchecked)
    
    LoadCLIHistory
    
    cboScript.Text = "inst,,endm"
    cboScript.SelStart = 5
    ctlCommandCommonDialog.HelpFile = frmBoBCoB.ctlCommonDialog.HelpFile

    chkAlwaysOnTop.Value = IIf(bCommandLineInterfaceAlwaysOnTop, vbChecked, vbUnchecked)
End Sub

Private Sub Form_Unload(Cancel As Integer)
    SaveCLIHistory
    frmBoBCoB.Show
End Sub

Private Sub cboScript_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = vbKeyF1 And Shift = 0 Then
        cmdHelp_Click
    End If
End Sub

Public Function txtString() As Control
    Set txtString = cboScript
End Function
