VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmAutoScript 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "AutoScript"
   ClientHeight    =   3375
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   3255
   Icon            =   "AutoScript.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3375
   ScaleWidth      =   3255
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.TextBox txtSpecies 
      Height          =   285
      Left            =   840
      TabIndex        =   8
      Top             =   960
      Width           =   975
   End
   Begin MSComDlg.CommonDialog ctlCommonDialog 
      Left            =   2640
      Top             =   1440
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
      CancelError     =   -1  'True
      Flags           =   4102
   End
   Begin VB.ComboBox cmbObjectClass 
      Height          =   315
      Left            =   120
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   10
      Top             =   1440
      Width           =   3015
   End
   Begin VB.CommandButton cmdBuild 
      Caption         =   "&Build"
      Default         =   -1  'True
      Height          =   375
      Left            =   2040
      TabIndex        =   0
      Top             =   240
      Width           =   1095
   End
   Begin VB.Frame fraType 
      Caption         =   "Output Type"
      Height          =   855
      Left            =   1680
      TabIndex        =   14
      Top             =   1920
      Width           =   1455
      Begin VB.OptionButton optTypeRCB 
         Caption         =   "RCB"
         Height          =   255
         Left            =   120
         TabIndex        =   16
         Top             =   480
         Width           =   1215
      End
      Begin VB.OptionButton optTypeCOB 
         Caption         =   "COB"
         Height          =   255
         Left            =   120
         TabIndex        =   15
         Top             =   240
         Width           =   1215
      End
   End
   Begin VB.Frame fraSource 
      Caption         =   "Source Type"
      Height          =   1095
      Left            =   120
      TabIndex        =   11
      Top             =   1920
      Width           =   1455
      Begin VB.OptionButton optSourceCreatures2 
         Caption         =   "Creatures 2"
         Height          =   255
         Left            =   120
         TabIndex        =   20
         Top             =   480
         Width           =   1215
      End
      Begin VB.OptionButton optSourceCOB 
         Caption         =   "COB"
         Height          =   255
         Left            =   120
         TabIndex        =   13
         Top             =   720
         Width           =   1215
      End
      Begin VB.OptionButton optSourceCreatures1 
         Caption         =   "Creatures 1"
         Height          =   255
         Left            =   120
         TabIndex        =   12
         Top             =   240
         Width           =   1215
      End
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   2040
      TabIndex        =   17
      Top             =   720
      Width           =   1095
   End
   Begin VB.TextBox txtGenus 
      Height          =   285
      Left            =   840
      TabIndex        =   5
      Top             =   600
      Width           =   975
   End
   Begin VB.TextBox txtFamily 
      Height          =   285
      Left            =   840
      TabIndex        =   2
      Top             =   240
      Width           =   975
   End
   Begin VB.ComboBox cboSpecies 
      Height          =   315
      Left            =   840
      Style           =   2  'Dropdown List
      TabIndex        =   9
      Top             =   960
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.ComboBox cboGenus 
      Height          =   315
      Left            =   840
      Style           =   2  'Dropdown List
      TabIndex        =   6
      Top             =   600
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.ComboBox cboFamily 
      Height          =   315
      Left            =   840
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   240
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Ready..."
      Height          =   255
      Left            =   0
      TabIndex        =   19
      Top             =   3120
      Width           =   3255
   End
   Begin VB.Label lblDDEScript 
      Caption         =   "lblDDEScript"
      Height          =   255
      Left            =   2040
      LinkItem        =   "Macro"
      LinkTopic       =   "Vivarium|Macro"
      TabIndex        =   18
      Top             =   1560
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.Label lblSpecies 
      AutoSize        =   -1  'True
      Caption         =   "&Species:"
      Height          =   195
      Left            =   120
      TabIndex        =   7
      Top             =   1005
      Width           =   615
   End
   Begin VB.Label lblGenus 
      AutoSize        =   -1  'True
      Caption         =   "&Genus:"
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   645
      Width           =   510
   End
   Begin VB.Label lblFamily 
      AutoSize        =   -1  'True
      Caption         =   "&Family:"
      Height          =   195
      Left            =   120
      TabIndex        =   1
      Top             =   285
      Width           =   480
   End
End
Attribute VB_Name = "frmAutoScript"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const cKnownObjectsStartResID = 10000
Private Const cKnownObjectsEndResID = 10001

Private Sub LoadKnownObjects()
    Dim nStartResID As Integer
    Dim nEndResID As Integer
    Dim I As Integer
    Dim sObject As String
    
    nStartResID = CInt(LoadResString(cKnownObjectsStartResID))
    nEndResID = CInt(LoadResString(cKnownObjectsEndResID))
    
    For I = nStartResID To nEndResID
        sObject = LoadResString(I)
        cmbObjectClass.AddItem Left(sObject, InStr(sObject, ";") - 1)
        cmbObjectClass.ItemData(cmbObjectClass.NewIndex) = Mid(sObject, InStr(sObject, ";") + 1)
    Next
End Sub

Private Function LoadC2Families() As Boolean
    Dim sFamilies As String
    Dim nOldPos As Integer
    Dim nPos As Integer
    Dim sResult As String
    
    LoadC2Families = False
    
    cboFamily.Clear
    
    SendCreaturesCommand cvcCreatures2, "inst,dde: gids root,endm", sResult
    
    If sResult <> "" Then
        sFamilies = sResult
        
        nOldPos = 1
        nPos = InStr(sFamilies, " ")
        Do While nPos > 0
            cboFamily.AddItem Mid(sFamilies, nOldPos, nPos - nOldPos)
            nOldPos = nPos + 1
            nPos = InStr(nOldPos, sFamilies, " ")
        Loop
    End If
    
    LoadC2Families = True
End Function

Private Sub LoadC2Genus(ByVal nFamily As Integer)
    Dim sGenus As String
    Dim nOldPos As Integer
    Dim nPos As Integer
    Dim sResult As String
    
    cboGenus.Clear
    
    SendCreaturesCommand cvcCreatures2, "inst,dde: gids fmly " & nFamily & ",endm", sResult
    
    If sResult <> "" Then
        sGenus = sResult
        
        nOldPos = 1
        nPos = InStr(sGenus, " ")
        Do While nPos > 0
            cboGenus.AddItem Mid(sGenus, nOldPos, nPos - nOldPos)
            nOldPos = nPos + 1
            nPos = InStr(nOldPos, sGenus, " ")
        Loop
    End If
End Sub

Private Sub LoadC2Species(ByVal nFamily As Integer, ByVal nGenus As Integer)
    Dim sSpecies As String
    Dim nOldPos As Integer
    Dim nPos As Integer
    Dim sResult As String
    
    cboSpecies.Clear
    
    SendCreaturesCommand cvcCreatures2, "inst,dde: gids gnus " & nFamily & " " & nGenus & ",endm", sResult
    
    If sResult <> "" Then
        sSpecies = sResult
        
        nOldPos = 1
        nPos = InStr(sSpecies, " ")
        Do While nPos > 0
            cboSpecies.AddItem Mid(sSpecies, nOldPos, nPos - nOldPos)
            nOldPos = nPos + 1
            nPos = InStr(nOldPos, sSpecies, " ")
        Loop
    End If
End Sub

Private Sub SetStatus(sMessage As String)
    lblStatus.Caption = sMessage
End Sub

Private Function BuildRCB() As Boolean
    Dim I As Integer
    Dim J As Integer
    Dim sClass As String
    Dim bRCBChanged As Boolean
    Dim sSCRXScript As String
    Dim sRemovalScript As String
    Dim tCOB As COB
    Dim sObjectScript As String
    Dim aClasses As Variant
    Dim sEndm As String
    Dim nOldPos As Integer
    Dim nPos As Integer
    Dim sEvents As String
    Dim sResult As String
    
    BuildRCB = False
    bRCBChanged = False

    If tCurrentCOB.COBType = ctcCreatures2 Then
        If tCurrentCOB.NumberOfAgents <= 0 Then
            tCurrentCOB.SelectedAgent = tCurrentCOB.AddAgent
        End If
    End If
    
    If optSourceCOB.Value = True Then
        If tCurrentCOB.COBType = ctcCreatures1 Then
            With ctlCommonDialog
                .FileName = ""
                .DialogTitle = "Select COB..."
                .Filter = sLoadCOBFilter
                .FilterIndex = 1
                .DefaultExt = ".cob"
                .Flags = cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist
                On Error Resume Next
                .ShowOpen
                If Err = cdlCancel Then
                    Err.Clear
                    Exit Function
                End If
                On Error GoTo 0
            End With
            
            Set tCOB = New COB
            tCOB.LoadCOBFile ctlCommonDialog.FileName
        Else
            Set tCOB = tCurrentCOB
        End If
        
        For I = 0 To tCOB.nNumberOfObjectScripts - 1
            SetStatus "Scanning object script " & I & " (" & Format(CDbl(I) / CDbl(tCOB.nNumberOfObjectScripts), "Percent") & ")..."
            sObjectScript = COStoCOB(tCOB.aObjectScripts(I))
            If Left(sObjectScript, 4) = "scrp" Then
                sSCRXScript = sSCRXScript & "scrx " & Mid(sObjectScript, 6, InStr(sObjectScript, ",") - 6) & ","
                sClass = Mid(sObjectScript, 6, InStr(sObjectScript, ",") - 6)
                For J = Len(sClass) To 1 Step -1
                    If Mid(sClass, J, 1) = " " Then
                        sClass = Left(sClass, J - 1)
                        Exit For
                    End If
                Next
                
                If IsEmpty(aClasses) Then
                    ReDim aClasses(0 To 0) As String
                    aClasses(0) = sClass
                Else
                    For J = 0 To UBound(aClasses)
                        If aClasses(J) = sClass Then
                            Exit For
                        End If
                    Next
                    
                    If J > UBound(aClasses) Then
                        ReDim Preserve aClasses(0 To J)
                        aClasses(J) = sClass
                    End If
                End If
                
                bRCBChanged = True
            End If
        Next
        
        If bRCBChanged Then
            For I = 0 To UBound(aClasses)
                sRemovalScript = sRemovalScript & "enum " & aClasses(I) & "," & "kill targ,next" & ","
            Next
            sRemovalScript = sRemovalScript & sSCRXScript
        Else
            MsgBox "No valid object scripts found.", vbExclamation
        End If
    ElseIf optSourceCreatures1.Value Or optSourceCreatures2.Value Then
        sClass = txtFamily.Text & " " & txtGenus.Text & " " & txtSpecies.Text
        
        If optSourceCreatures1.Value Then
            For I = 0 To 72
                SetStatus "Scanning for event " & I & " (" & Format(CDbl(I) / 72, "Percent") & ")..."
                SendCreaturesCommand cvcCreatures1, "inst,dde: scrp " & sClass & " " & I & ",endm", sResult
                
                If sResult <> "" Then
                    sRemovalScript = sRemovalScript & "scrx " & sClass & " " & I & ","
                    bRCBChanged = True
                End If
            Next
        ElseIf optSourceCreatures2.Value Then
            If tCurrentCOB.NumberOfAgents <= 0 Then
                tCurrentCOB.SelectedAgent = tCurrentCOB.AddAgent
            End If
            
            SetStatus "Getting event list for class " & sClass & "..."
            SendCreaturesCommand cvcCreatures2, "inst,dde: gids spcs " & sClass & ",endm", sResult
            
            If sResult <> "" Then
                sEvents = sResult
                
                nOldPos = 1
                nPos = InStr(sEvents, " ")
                Do While nPos > 0
                    I = CInt(Mid(sEvents, nOldPos, nPos - nOldPos))
                    
                    sRemovalScript = sRemovalScript & "scrx " & sClass & " " & I & ","
                    
                    nOldPos = nPos + 1
                    nPos = InStr(nOldPos, sEvents, " ")
                Loop
                
                bRCBChanged = True
            End If
        End If
        
        If bRCBChanged Then
            sRemovalScript = "enum " & sClass & "," & "kill targ,next" & "," & sRemovalScript
        Else
            MsgBox "No COBs of Class " & sClass & " found in the World.", vbExclamation
        End If
    End If
    
    If bRCBChanged Then
        SetStatus "Creating script..."
        
        Select Case tCurrentCOB.COBType
            Case ctcCreatures1
                sRemovalScript = "inst," & sRemovalScript & "endm"
                tCurrentCOB.AddInstallScript COBtoCOS(sRemovalScript)
                
            Case ctcCreatures2
                If tCurrentCOB.sRemoverScript <> "" Then
                    If InStr(tCurrentCOB.sRemoverScript, "endm") Then
                        sEndm = Mid(tCurrentCOB.sRemoverScript, InStr(tCurrentCOB.sRemoverScript, "endm"))
                        tCurrentCOB.sRemoverScript = Left(tCurrentCOB.sRemoverScript, InStr(tCurrentCOB.sRemoverScript, "endm") - 1)
                    Else
                        sRemovalScript = "," & sRemovalScript
                        sEndm = "endm"
                    End If
                    tCurrentCOB.sRemoverScript = tCurrentCOB.sRemoverScript & sRemovalScript & sEndm
                Else
                    tCurrentCOB.sRemoverScript = "inst," & sRemovalScript & "endm"
                End If
                tCurrentCOB.sRemoverScript = COBtoCOS(tCurrentCOB.sRemoverScript)
        End Select
        
        tCurrentCOB.bChanged = True
        BuildRCB = True
    End If
End Function

Private Function BuildCOB() As Boolean
    Dim I As Integer
    Dim sClass As String
    Dim bCOBChanged As Boolean
    Dim sObjectScript As String
    Dim nOldPos As Integer
    Dim nPos As Integer
    Dim sEvents As String
    Dim sResult As String
    
    BuildCOB = False
    bCOBChanged = False
    
    sClass = txtFamily.Text & " " & txtGenus.Text & " " & txtSpecies.Text
    
    If optSourceCreatures1.Value Then
        For I = 0 To 72
            SetStatus "Scanning for event " & I & " (" & Format(CDbl(I) / 72, "Percent") & ")..."
            SendCreaturesCommand cvcCreatures1, "inst,dde: scrp " & sClass & " " & I & ",endm", sResult
            
            If sResult <> "" Then
                sObjectScript = "scrp " & sClass & " " & I & "," & sResult
                tCurrentCOB.AddObjectScript COBtoCOS(sObjectScript)
                bCOBChanged = True
            End If
        Next
    Else
        If tCurrentCOB.NumberOfAgents <= 0 Then
            tCurrentCOB.SelectedAgent = tCurrentCOB.AddAgent
        End If
        
        SetStatus "Getting event list for class " & sClass & "..."
        SendCreaturesCommand cvcCreatures2, "inst,dde: gids spcs " & sClass & ",endm", sResult
        
        If sResult <> "" Then
            sEvents = sResult
            
            nOldPos = 1
            nPos = InStr(sEvents, " ")
            Do While nPos > 0
                I = CInt(Mid(sEvents, nOldPos, nPos - nOldPos))
                
                SetStatus "Getting script for event " & sClass & " " & I & "..."
                SendCreaturesCommand cvcCreatures2, "inst,dde: scrp " & sClass & " " & I & ",endm", sResult
                
                If sResult <> "" Then
                    sObjectScript = "scrp " & sClass & " " & I & "," & sResult
                    tCurrentCOB.AddObjectScript COBtoCOS(sObjectScript)
                    bCOBChanged = True
                End If
                
                nOldPos = nPos + 1
                nPos = InStr(nOldPos, sEvents, " ")
            Loop
        End If
    End If
    
    If Not bCOBChanged Then
        MsgBox "No event scripts for Class " & sClass & " found in the World.", vbExclamation
        Exit Function
    Else
        tCurrentCOB.bChanged = True
        
        BuildCOB = True
    End If
End Function

Private Sub cboFamily_Click()
    If cboFamily.ListIndex >= 0 Then
        txtFamily.Text = cboFamily.Text
        LoadC2Genus CInt(cboFamily.Text)
        lblGenus.Enabled = True
        cboGenus.Enabled = True
    End If
End Sub

Private Sub cboGenus_Click()
    If cboGenus.ListIndex >= 0 Then
        txtGenus.Text = cboGenus.Text
        LoadC2Species CInt(cboFamily.Text), CInt(cboGenus.Text)
        lblSpecies.Enabled = True
        cboSpecies.Enabled = True
    End If
End Sub

Private Sub cboSpecies_Click()
    If cboSpecies.ListIndex >= 0 Then
        txtSpecies.Text = cboSpecies.Text
    End If
End Sub

Private Sub cmbObjectClass_Click()
    Dim nItemData As Long
    Dim nFamily As Integer
    Dim nGenus As Integer
    Dim nSpecies As Integer
    
    If cmbObjectClass.ListIndex < 0 Then
        Exit Sub
    End If
    
    nItemData = cmbObjectClass.ItemData(cmbObjectClass.ListIndex)
    
    nSpecies = nItemData Mod 1000
    txtSpecies = CStr(nSpecies)
    nItemData = (nItemData - nSpecies) / 1000
    nGenus = nItemData Mod 1000
    txtGenus = CStr(nGenus)
    nFamily = (nItemData - nGenus) / 1000
    txtFamily = CStr(nFamily)
End Sub

Private Sub cmdBuild_Click()
    If optSourceCOB.Value = True Or (optSourceCreatures1.Value = True And txtFamily.Text <> "" And txtGenus.Text <> "" And txtSpecies.Text <> "") Or (optSourceCreatures2.Value And cboFamily.ListIndex >= 0 And cboGenus.ListIndex >= 0 And cboSpecies.ListIndex >= 0) Then
        If optTypeCOB.Value = True Then
            If Not BuildCOB Then
                SetStatus "Ready..."
                Exit Sub
            End If
        ElseIf optTypeRCB.Value = True Then
            If Not BuildRCB Then
                SetStatus "Ready..."
                Exit Sub
            End If
        Else
            Exit Sub
        End If
    Else
        Exit Sub
    End If
    
    Unload Me
End Sub

Private Sub cmdCancel_Click()
    Unload Me
End Sub

Private Sub Form_Load()
    optSourceCreatures1.Enabled = g_bC1Installed
    optSourceCreatures2.Enabled = g_bC2Installed
    
    lblFamily.Enabled = False
    txtFamily.Enabled = False
    cboFamily.Enabled = False
    lblGenus.Enabled = False
    txtGenus.Enabled = False
    cboGenus.Enabled = False
    lblSpecies.Enabled = False
    txtSpecies.Enabled = False
    cboSpecies.Enabled = False
    cmbObjectClass.Enabled = False
End Sub

Private Sub optSourceCOB_Click()
    If optSourceCOB.Value = True Then
        optTypeRCB.Value = True
        optTypeCOB.Enabled = False
        lblFamily.Enabled = False
        txtFamily.Enabled = False
        cboFamily.Enabled = False
        lblGenus.Enabled = False
        txtGenus.Enabled = False
        cboGenus.Enabled = False
        lblSpecies.Enabled = False
        txtSpecies.Enabled = False
        cboSpecies.Enabled = False
        cmbObjectClass.Enabled = False
    End If
End Sub

Private Sub optSourceCreatures1_Click()
    If optSourceCreatures1.Value = True Then
        cboFamily.Visible = False
        cboGenus.Visible = False
        cboSpecies.Visible = False
        txtFamily.Visible = True
        txtGenus.Visible = True
        txtSpecies.Visible = True
        cboFamily.Enabled = False
        cboGenus.Enabled = False
        cboSpecies.Enabled = False
        txtFamily.Enabled = True
        txtGenus.Enabled = True
        txtSpecies.Enabled = True
        LoadKnownObjects
        cmbObjectClass.ListIndex = 0
        
        lblFamily.Enabled = True
        txtFamily.Enabled = True
        
        lblGenus.Enabled = True
        txtGenus.Enabled = True
        
        lblSpecies.Enabled = True
        txtSpecies.Enabled = True
        
        cmbObjectClass.Enabled = True
        optTypeCOB.Enabled = True
    End If
End Sub

Private Sub optSourceCreatures2_Click()
    If optSourceCreatures2.Value Then
        cmbObjectClass.Enabled = False
        optSourceCOB.Caption = "Agent"
        optTypeCOB.Caption = "Agent"
        optTypeRCB.Caption = "Remover"
        cboFamily.Visible = True
        cboGenus.Visible = True
        cboSpecies.Visible = True
        txtFamily.Visible = False
        txtGenus.Visible = False
        txtSpecies.Visible = False
        cboFamily.Enabled = False
        cboGenus.Enabled = False
        cboSpecies.Enabled = False
        
        If Not LoadC2Families Then
            optSourceCreatures2.Value = False
            Exit Sub
        End If
        
        lblFamily.Enabled = True
        cboFamily.Enabled = True
        
        lblGenus.Enabled = False
        cboGenus.Enabled = False
        
        lblSpecies.Enabled = False
        cboSpecies.Enabled = False
        
        cmbObjectClass.Enabled = False
    End If
End Sub

Private Sub optTypeCOB_Click()
    If optTypeCOB.Value = True Then
        'optSourceCreatures.Value = True
        optSourceCOB.Enabled = False
    End If
End Sub

Private Sub optTypeRCB_Click()
    If optTypeRCB.Value = True Then
        optSourceCOB.Enabled = True
    End If
End Sub

Private Sub txtFamily_GotFocus()
    SelectText txtFamily
End Sub

Private Sub txtFamily_KeyPress(KeyAscii As Integer)
    CheckNumeric KeyAscii
End Sub

Private Sub txtGenus_GotFocus()
    SelectText txtGenus
End Sub

Private Sub txtGenus_KeyPress(KeyAscii As Integer)
    CheckNumeric KeyAscii
End Sub

Private Sub txtSpecies_GotFocus()
    SelectText txtSpecies
End Sub

Private Sub txtSpecies_KeyPress(KeyAscii As Integer)
    CheckNumeric KeyAscii
End Sub
