VERSION 5.00
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Begin VB.Form frmPreferences 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Preferences"
   ClientHeight    =   3735
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4695
   Icon            =   "SpriteEditorPreferences.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3735
   ScaleWidth      =   4695
   ShowInTaskbar   =   0   'False
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   3480
      TabIndex        =   31
      Top             =   3240
      Width           =   1095
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   2280
      TabIndex        =   30
      Top             =   3240
      Width           =   1095
   End
   Begin TabDlg.SSTab tabPreferences 
      Height          =   2895
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4455
      _ExtentX        =   7858
      _ExtentY        =   5106
      _Version        =   327681
      Style           =   1
      TabsPerRow      =   4
      TabHeight       =   520
      TabCaption(0)   =   "General"
      TabPicture(0)   =   "SpriteEditorPreferences.frx":000C
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "fraDefaultSpriteType"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).Control(1)=   "fraSpriteNumbering"
      Tab(0).Control(1).Enabled=   0   'False
      Tab(0).Control(2)=   "fraInsertImage"
      Tab(0).Control(2).Enabled=   0   'False
      Tab(0).ControlCount=   3
      TabCaption(1)   =   "Thumbnails"
      TabPicture(1)   =   "SpriteEditorPreferences.frx":0028
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "chkThumbnailShowCaptions"
      Tab(1).Control(1)=   "chkThumbnailShowImages"
      Tab(1).Control(2)=   "txtThumbnailSpacing"
      Tab(1).Control(3)=   "cboThumbnailSize"
      Tab(1).Control(4)=   "lblThumbnailSpacing"
      Tab(1).Control(5)=   "lblThumbnailSize"
      Tab(1).ControlCount=   6
      TabCaption(2)   =   "Default Folders"
      TabPicture(2)   =   "SpriteEditorPreferences.frx":0044
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "lblSaveFolder"
      Tab(2).Control(1)=   "lblLoadFolder"
      Tab(2).Control(2)=   "lblImportFolder"
      Tab(2).Control(3)=   "lblExportFolder"
      Tab(2).Control(4)=   "cmdBrowseForSaveFolder"
      Tab(2).Control(5)=   "cmdBrowseForLoadFolder"
      Tab(2).Control(6)=   "txtLoadFolder"
      Tab(2).Control(7)=   "txtSaveFolder"
      Tab(2).Control(8)=   "txtExportFolder"
      Tab(2).Control(9)=   "txtImportFolder"
      Tab(2).Control(10)=   "cmdBrowseForImportFolder"
      Tab(2).Control(11)=   "cmdBrowseForExportFolder"
      Tab(2).ControlCount=   12
      Begin VB.CheckBox chkThumbnailShowCaptions 
         Caption         =   "Show captions"
         Height          =   255
         Left            =   -74880
         TabIndex        =   17
         Top             =   1440
         Width           =   2295
      End
      Begin VB.CheckBox chkThumbnailShowImages 
         Caption         =   "Show images"
         Height          =   255
         Left            =   -74880
         TabIndex        =   16
         Top             =   1200
         Width           =   2295
      End
      Begin VB.CommandButton cmdBrowseForExportFolder 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Symbol"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   -70920
         TabIndex        =   29
         Top             =   1575
         Width           =   255
      End
      Begin VB.CommandButton cmdBrowseForImportFolder 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Symbol"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   -70920
         TabIndex        =   26
         Top             =   1215
         Width           =   255
      End
      Begin VB.TextBox txtImportFolder 
         Height          =   285
         Left            =   -74280
         TabIndex        =   25
         Top             =   1200
         Width           =   3255
      End
      Begin VB.TextBox txtExportFolder 
         Height          =   285
         Left            =   -74280
         TabIndex        =   28
         Top             =   1560
         Width           =   3255
      End
      Begin VB.TextBox txtSaveFolder 
         Height          =   285
         Left            =   -74280
         TabIndex        =   22
         Top             =   840
         Width           =   3255
      End
      Begin VB.TextBox txtLoadFolder 
         Height          =   285
         Left            =   -74280
         TabIndex        =   19
         Top             =   480
         Width           =   3255
      End
      Begin VB.CommandButton cmdBrowseForLoadFolder 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Symbol"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   -70920
         TabIndex        =   20
         Top             =   495
         Width           =   255
      End
      Begin VB.CommandButton cmdBrowseForSaveFolder 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Symbol"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   -70920
         TabIndex        =   23
         Top             =   855
         Width           =   255
      End
      Begin VB.TextBox txtThumbnailSpacing 
         Height          =   285
         Left            =   -74040
         TabIndex        =   15
         Top             =   840
         Width           =   1455
      End
      Begin VB.Frame fraInsertImage 
         Caption         =   "Insert Image"
         Height          =   855
         Left            =   120
         TabIndex        =   1
         Top             =   480
         Width           =   2055
         Begin VB.OptionButton optInsertImageAfter 
            Caption         =   "&After"
            Height          =   255
            Left            =   120
            TabIndex        =   3
            Top             =   480
            Width           =   1095
         End
         Begin VB.OptionButton optInsertImageBefore 
            Caption         =   "&Before"
            Height          =   255
            Left            =   120
            TabIndex        =   2
            Top             =   240
            Width           =   1095
         End
      End
      Begin VB.Frame fraSpriteNumbering 
         Caption         =   "Sprite Numbering"
         Height          =   855
         Left            =   2280
         TabIndex        =   4
         Top             =   480
         Width           =   2055
         Begin VB.OptionButton optSpriteNumbering1 
            Caption         =   "Starts at 1"
            Height          =   255
            Left            =   120
            TabIndex        =   6
            Top             =   480
            Width           =   1815
         End
         Begin VB.OptionButton optSpriteNumbering0 
            Caption         =   "Starts at 0"
            Height          =   255
            Left            =   120
            TabIndex        =   5
            Top             =   240
            Width           =   1815
         End
      End
      Begin VB.Frame fraDefaultSpriteType 
         Caption         =   "Default sprite type"
         Height          =   1335
         Left            =   120
         TabIndex        =   7
         Top             =   1440
         Width           =   2055
         Begin VB.OptionButton optDefaultTypeS16565 
            Caption         =   "S16 - 565"
            Height          =   255
            Left            =   120
            TabIndex        =   11
            Top             =   960
            Width           =   1815
         End
         Begin VB.OptionButton optDefaultTypeS16555 
            Caption         =   "S16 - 555"
            Height          =   255
            Left            =   120
            TabIndex        =   10
            Top             =   720
            Width           =   1815
         End
         Begin VB.OptionButton optDefaultTypeSPR 
            Caption         =   "SPR"
            Height          =   255
            Left            =   120
            TabIndex        =   9
            Top             =   480
            Width           =   1815
         End
         Begin VB.CheckBox chkUseDefaultSpriteType 
            Caption         =   "Use default"
            Height          =   255
            Left            =   120
            TabIndex        =   8
            Top             =   240
            Width           =   1815
         End
      End
      Begin VB.ComboBox cboThumbnailSize 
         Height          =   315
         ItemData        =   "SpriteEditorPreferences.frx":0060
         Left            =   -74040
         List            =   "SpriteEditorPreferences.frx":0075
         Style           =   2  'Dropdown List
         TabIndex        =   13
         Top             =   480
         Width           =   1455
      End
      Begin VB.Label lblExportFolder 
         AutoSize        =   -1  'True
         Caption         =   "&Export:"
         Height          =   195
         Left            =   -74880
         TabIndex        =   27
         Top             =   1605
         Width           =   495
      End
      Begin VB.Label lblImportFolder 
         AutoSize        =   -1  'True
         Caption         =   "&Import:"
         Height          =   195
         Left            =   -74880
         TabIndex        =   24
         Top             =   1245
         Width           =   480
      End
      Begin VB.Label lblLoadFolder 
         AutoSize        =   -1  'True
         Caption         =   "&Load:"
         Height          =   195
         Left            =   -74880
         TabIndex        =   18
         Top             =   525
         Width           =   405
      End
      Begin VB.Label lblSaveFolder 
         AutoSize        =   -1  'True
         Caption         =   "&Save:"
         Height          =   195
         Left            =   -74880
         TabIndex        =   21
         Top             =   885
         Width           =   420
      End
      Begin VB.Label lblThumbnailSpacing 
         AutoSize        =   -1  'True
         Caption         =   "Spacing:"
         Height          =   195
         Left            =   -74880
         TabIndex        =   14
         Top             =   885
         Width           =   630
      End
      Begin VB.Label lblThumbnailSize 
         AutoSize        =   -1  'True
         Caption         =   "Size:"
         Height          =   195
         Left            =   -74880
         TabIndex        =   12
         Top             =   540
         Width           =   345
      End
   End
End
Attribute VB_Name = "frmPreferences"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub LoadGeneralTab()
    If g_nBeforeAfter > 0 Then
        optInsertImageAfter.Value = True
    ElseIf g_nBeforeAfter < 0 Then
        optInsertImageBefore.Value = True
    End If
    
    If g_nSpriteNumbering = 0 Then
        optSpriteNumbering0.Value = True
    ElseIf g_nSpriteNumbering = 1 Then
        optSpriteNumbering1.Value = True
    End If
    
    If g_nDefaultSpriteType = stcNone Then
        chkUseDefaultSpriteType.Value = vbUnchecked
        chkUseDefaultSpriteType_Click
    ElseIf g_nDefaultSpriteType = stcSPR Then
        chkUseDefaultSpriteType.Value = vbChecked
        optDefaultTypeSPR.Value = True
    ElseIf g_nDefaultSpriteType = stcS16_555 Then
        chkUseDefaultSpriteType.Value = vbChecked
        optDefaultTypeS16555.Value = True
    ElseIf g_nDefaultSpriteType = stcS16_565 Then
        chkUseDefaultSpriteType.Value = vbChecked
        optDefaultTypeS16565.Value = True
    End If
End Sub

Private Sub LoadThumbnailsTab()
    Dim I As Integer
    
    cboThumbnailSize.ListIndex = -1
    
    For I = 0 To cboThumbnailSize.ListCount - 1
        If cboThumbnailSize.ItemData(I) = g_nThumbnailSize Then
            cboThumbnailSize.ListIndex = I
            Exit For
        End If
    Next
    
    txtThumbnailSpacing.Text = CStr(g_nThumbnailSpacing)
    
    If g_bThumbnailShowImages Then
        chkThumbnailShowImages.Value = vbChecked
    Else
        chkThumbnailShowImages.Value = vbUnchecked
    End If
    
    If g_bThumbnailShowCaptions Then
        chkThumbnailShowCaptions.Value = vbChecked
    Else
        chkThumbnailShowCaptions.Value = vbUnchecked
    End If
End Sub

Private Sub LoadDefaultFoldersTab()
    txtLoadFolder.Text = g_sDefaultLoadFolder
    txtSaveFolder.Text = g_sDefaultSaveFolder
    txtImportFolder.Text = g_sDefaultImportFolder
    txtExportFolder.Text = g_sDefaultExportFolder
End Sub

Private Function SaveGeneralTab() As Boolean
    If optInsertImageAfter.Value = True Then
        g_nBeforeAfter = 1
    ElseIf optInsertImageBefore.Value = True Then
        g_nBeforeAfter = -1
    End If
    
    If optSpriteNumbering0.Value = True Then
        g_nSpriteNumbering = 0
    ElseIf optSpriteNumbering1.Value = True Then
        g_nSpriteNumbering = 1
    End If
    
    If chkUseDefaultSpriteType.Value = vbUnchecked Then
        g_nDefaultSpriteType = stcNone
    ElseIf optDefaultTypeSPR.Value = True Then
        g_nDefaultSpriteType = stcSPR
    ElseIf optDefaultTypeS16555.Value = True Then
        g_nDefaultSpriteType = stcS16_555
    ElseIf optDefaultTypeS16565.Value = True Then
        g_nDefaultSpriteType = stcS16_565
    End If
    
    SaveGeneralTab = True
End Function

Private Function SaveThumbnailsTab() As Boolean
    SaveThumbnailsTab = False
    
    If cboThumbnailSize.ListIndex < 0 Then
        MsgBox "Please select a thumbnail size.", vbOKOnly Or vbExclamation
        cboThumbnailSize.SetFocus
        Exit Function
    End If
    
    g_nThumbnailSize = cboThumbnailSize.ItemData(cboThumbnailSize.ListIndex)
    g_nThumbnailSpacing = CInt(txtThumbnailSpacing.Text)
    
    If chkThumbnailShowImages.Value = vbChecked Then
        g_bThumbnailShowImages = True
    ElseIf chkThumbnailShowImages.Value = vbUnchecked Then
        g_bThumbnailShowImages = False
    End If
    
    If chkThumbnailShowCaptions.Value = vbChecked Then
        g_bThumbnailShowCaptions = True
    ElseIf chkThumbnailShowCaptions.Value = vbUnchecked Then
        g_bThumbnailShowCaptions = False
    End If
    
    SaveThumbnailsTab = True
End Function

Private Function SaveDefaultFoldersTab() As Boolean
    Dim nAttr As Integer
    
    SaveDefaultFoldersTab = False
    
    txtLoadFolder.Text = Trim(txtLoadFolder.Text)
    txtSaveFolder.Text = Trim(txtSaveFolder.Text)
    txtImportFolder.Text = Trim(txtImportFolder.Text)
    txtExportFolder.Text = Trim(txtExportFolder.Text)
    
    If txtLoadFolder.Text <> "" Then
        On Error Resume Next
        
        nAttr = GetAttr(txtLoadFolder.Text)
        
        If (nAttr And vbDirectory) = 0 Or Err <> 0 Then
            Err.Clear
            MsgBox txtLoadFolder.Text & " does not exist or is not a folder.", vbOKOnly Or vbExclamation
            txtLoadFolder.SetFocus
            Exit Function
        End If
        
        On Error GoTo 0
    End If
    
    g_sDefaultLoadFolder = txtLoadFolder.Text
    
    If txtSaveFolder.Text <> "" Then
        On Error Resume Next
        
        nAttr = GetAttr(txtSaveFolder.Text)
        
        If (nAttr And vbDirectory) = 0 Or Err <> 0 Then
            Err.Clear
            MsgBox txtSaveFolder.Text & " does not exist or is not a folder.", vbOKOnly Or vbExclamation
            txtSaveFolder.SetFocus
            Exit Function
        End If
        
        On Error GoTo 0
    End If
    
    g_sDefaultSaveFolder = txtSaveFolder.Text
    
    If txtImportFolder.Text <> "" Then
        On Error Resume Next
        
        nAttr = GetAttr(txtImportFolder.Text)
        
        If (nAttr And vbDirectory) = 0 Or Err <> 0 Then
            Err.Clear
            MsgBox txtImportFolder.Text & " does not exist or is not a folder.", vbOKOnly Or vbExclamation
            txtImportFolder.SetFocus
            Exit Function
        End If
        
        On Error GoTo 0
    End If
    
    g_sDefaultImportFolder = txtImportFolder.Text
    
    If txtExportFolder.Text <> "" Then
        On Error Resume Next
        
        nAttr = GetAttr(txtExportFolder.Text)
        
        If (nAttr And vbDirectory) = 0 Or Err <> 0 Then
            Err.Clear
            MsgBox txtExportFolder.Text & " does not exist or is not a folder.", vbOKOnly Or vbExclamation
            txtExportFolder.SetFocus
            Exit Function
        End If
        
        On Error GoTo 0
    End If
    
    g_sDefaultExportFolder = txtExportFolder.Text
    
    SaveDefaultFoldersTab = True
End Function

Private Sub chkThumbnailShowCaptions_Click()
    If chkThumbnailShowCaptions.Value = vbUnchecked Then
        chkThumbnailShowImages.Value = vbChecked
        chkThumbnailShowImages.Enabled = False
    Else
        chkThumbnailShowImages.Enabled = True
    End If
End Sub

Private Sub chkThumbnailShowImages_Click()
    If chkThumbnailShowImages.Value = vbUnchecked Then
        chkThumbnailShowCaptions.Value = vbChecked
        chkThumbnailShowCaptions.Enabled = False
    Else
        chkThumbnailShowCaptions.Enabled = True
    End If
End Sub

Private Sub chkUseDefaultSpriteType_Click()
    If chkUseDefaultSpriteType.Value = vbChecked Then
        optDefaultTypeSPR.Enabled = True
        optDefaultTypeS16555.Enabled = True
        optDefaultTypeS16565.Enabled = True
    ElseIf chkUseDefaultSpriteType.Value = vbUnchecked Then
        optDefaultTypeSPR.Enabled = False
        optDefaultTypeS16555.Enabled = False
        optDefaultTypeS16565.Enabled = False
    End If
End Sub

Private Sub cmdBrowseForLoadFolder_Click()
    Dim sFolder As String * 512
    Dim nRet As Long
    
    sFolder = txtLoadFolder.Text
    nRet = BrowseForFolder(Me.hwnd, "Select default folder from which to load sprites:", sFolder)
    
    If nRet Then
        txtLoadFolder.Text = Trim(sFolder)
    End If
End Sub

Private Sub cmdBrowseForSaveFolder_Click()
    Dim sFolder As String * 512
    Dim nRet As Long
    
    sFolder = txtSaveFolder.Text
    nRet = BrowseForFolder(Me.hwnd, "Select default folder in which to save sprites:", sFolder)
    
    If nRet Then
        txtSaveFolder.Text = Trim(sFolder)
    End If
End Sub

Private Sub cmdBrowseForImportFolder_Click()
    Dim sFolder As String * 512
    Dim nRet As Long
    
    sFolder = txtImportFolder.Text
    nRet = BrowseForFolder(Me.hwnd, "Select default folder from which to import files:", sFolder)
    
    If nRet Then
        txtImportFolder.Text = Trim(sFolder)
    End If
End Sub

Private Sub cmdBrowseForExportFolder_Click()
    Dim sFolder As String * 512
    Dim nRet As Long
    
    sFolder = txtExportFolder.Text
    nRet = BrowseForFolder(Me.hwnd, "Select default folder in which to export files:", sFolder)
    
    If nRet Then
        txtExportFolder.Text = Trim(sFolder)
    End If
End Sub

Private Sub cmdCancel_Click()
    Unload Me
End Sub

Private Sub cmdOK_Click()
    If Not SaveGeneralTab Then
        Exit Sub
    End If
    
    If Not SaveThumbnailsTab Then
        Exit Sub
    End If
    
    If Not SaveDefaultFoldersTab Then
        Exit Sub
    End If
    
    Unload Me
End Sub

Private Sub Form_Load()
    LoadGeneralTab
    LoadThumbnailsTab
    LoadDefaultFoldersTab
End Sub
