VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmPackager 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "COB Packager"
   ClientHeight    =   4215
   ClientLeft      =   1380
   ClientTop       =   1575
   ClientWidth     =   6855
   Icon            =   "Packager.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   OLEDropMode     =   1  'Manual
   ScaleHeight     =   4215
   ScaleWidth      =   6855
   StartUpPosition =   2  'CenterScreen
   Begin VB.CheckBox chkCreatures2 
      Caption         =   "&Creatures 2"
      Height          =   255
      Left            =   5520
      OLEDropMode     =   1  'Manual
      TabIndex        =   9
      Top             =   3600
      Width           =   1155
   End
   Begin VB.CheckBox chkCompress 
      Caption         =   "&Compress"
      Height          =   255
      Left            =   5520
      OLEDropMode     =   1  'Manual
      TabIndex        =   10
      Top             =   3360
      Width           =   1095
   End
   Begin VB.CommandButton cmdBuild 
      Caption         =   "&Build"
      Height          =   375
      Left            =   5520
      TabIndex        =   6
      Top             =   315
      Width           =   1095
   End
   Begin MSComDlg.CommonDialog ctlCommonDialog 
      Left            =   6360
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
   End
   Begin VB.TextBox txtTitle 
      Height          =   285
      Left            =   120
      MaxLength       =   30
      TabIndex        =   1
      Top             =   360
      Width           =   2535
   End
   Begin VB.Frame fraFiles 
      Caption         =   "F&iles"
      Height          =   3255
      Left            =   120
      OLEDropMode     =   1  'Manual
      TabIndex        =   2
      Top             =   840
      Width           =   6615
      Begin VB.CommandButton cmdFileExtract 
         Caption         =   "&Extract..."
         Height          =   375
         Left            =   5400
         TabIndex        =   8
         Top             =   1200
         Width           =   1095
      End
      Begin VB.CommandButton cmdFileAdd 
         Caption         =   "&Add..."
         Height          =   375
         Left            =   5400
         TabIndex        =   4
         Top             =   240
         Width           =   1095
      End
      Begin VB.CommandButton cmdFileRemove 
         Caption         =   "&Remove"
         Height          =   375
         Left            =   5400
         TabIndex        =   5
         Top             =   720
         Width           =   1095
      End
      Begin VB.ListBox lstFiles 
         Height          =   2790
         Left            =   120
         MultiSelect     =   2  'Extended
         OLEDropMode     =   1  'Manual
         Sorted          =   -1  'True
         TabIndex        =   3
         Top             =   240
         Width           =   5175
      End
   End
   Begin VB.Label lblStatus 
      Alignment       =   1  'Right Justify
      Height          =   255
      Left            =   2760
      OLEDropMode     =   1  'Manual
      TabIndex        =   7
      Top             =   375
      Width           =   2655
   End
   Begin VB.Label lblPackageTitle 
      Caption         =   "&Package Title"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2535
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileNew 
         Caption         =   "&New Package Definition"
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open..."
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileSeparator1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save Package Definition"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFileSaveAs 
         Caption         =   "Save Package Definition &As..."
      End
      Begin VB.Menu mnuFileSeparator2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileBuild 
         Caption         =   "&Build Package"
         Shortcut        =   ^B
      End
      Begin VB.Menu mnuFileSeparator3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileMRUFile 
         Caption         =   "File0"
         Index           =   0
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileMRUFile 
         Caption         =   "File1"
         Index           =   1
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileMRUFile 
         Caption         =   "File2"
         Index           =   2
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileMRUFile 
         Caption         =   "File3"
         Index           =   3
         Visible         =   0   'False
      End
      Begin VB.Menu mnuFileSeparator4 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
         Shortcut        =   ^Q
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "frmPackager"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function BrowseForFolder Lib "BoBCoBUtils.dll" (ByVal hwndOwner As Long, ByVal sPath As String) As Long

Const sCOBPackagerRegistryKey = "SOFTWARE\BoBWare\COBPackager\1.x"

Const CreaturesFilesFilter = "Creatures Files (*.cob;*.rcb;*.spr;*.s16;*.wav;*.txt)|*.cob;*.rcb;*.spr;*.s16;*.wav|COB Files (*.cob)|*.cob|RCB Files (*.rcb)|*.rcb|SPR Files (*.spr;*.s16)|*.spr;*.s16|WAV Files (*.wav)|*.wav|Text Files (*.txt)|*.txt"
Const PackageDefinitionFilesFilter = "Package Definition Files (*.pkd)|*.pkd|All Files (*.*)|*.*"
Const PackageFilesFilter = "Self-extracting Package Files (*.exe)|*.exe|Package Files (*.pkg)|*.pkg|All Files (*.*)|*.*"
Const AllPackageFilesFilter = "All Package Files (*.pkd;*.exe;*.pkg)|*.pkd;*.exe;*.pkg|Package Definition Files (*.pkd)|*.pkd|Package Files (*.exe;*.pkg)|*.exe;*.pkg|All Files (*.*)|*.*"
Const DescriptionFilesFilter = "Text Files (*.txt)|*.txt|All Files (*.*)|*.*"

Private m_tPackageDefinition As PackageDefinition
Private m_tPackage As Package
Private m_sPackageDefinitionFilename As String
Private m_sPackageFilename As String
Private m_oMRUFiles As New MRUFiles

Private Sub GetCOBPackagerSettings()
    Dim oRegKey As New RegistryKey
    
    'COB Packager specific settings
    If oRegKey.OpenKey(HKEY_CURRENT_USER, sCOBPackagerRegistryKey, True) Then
        m_oMRUFiles.ReadFromRegistry oRegKey
    End If
End Sub

Private Sub WriteCOBPackagerSettings()
    Dim oRegKey As New RegistryKey
    
    'COB Packager specific settings
    If oRegKey.OpenKey(HKEY_CURRENT_USER, sCOBPackagerRegistryKey, True) Then
        m_oMRUFiles.WriteToRegistry oRegKey
    End If
End Sub

Private Sub ClearPackage()
    With m_tPackageDefinition
        .Title = ""
        .FileCount = 0
        .CompressFiles = True
        .Creatures2 = False
        .PackageFilename = ""
        Erase .Files
        .Changed = False
    End With
    
    With m_tPackage
        .Title = ""
        .FileCount = 0
        Erase .Files
        .Version = ""
    End With
    
    m_sPackageDefinitionFilename = ""
    m_sPackageFilename = ""
End Sub

Private Sub InitialiseMRUFiles()
    Dim I As Integer
    Dim bAnyFiles As Boolean
    
    bAnyFiles = False
    
    For I = 0 To 3
        If m_oMRUFiles(I) <> "" Then
            mnuFileMRUFile(I).Caption = "&" & CStr(I + 1) & " " & m_oMRUFiles(I)
            mnuFileMRUFile(I).Visible = True
            bAnyFiles = True
        Else
            mnuFileMRUFile(I).Visible = False
        End If
    Next
    
    mnuFileSeparator4.Visible = bAnyFiles
End Sub

Private Sub InitialiseControls()
    Me.Caption = "UntitledPackage - COB Packager"
    txtTitle = ""
    lstFiles.Clear
    cmdFileExtract.Enabled = False
    chkCompress.Value = vbUnchecked
    chkCreatures2.Value = vbUnchecked
End Sub

Private Sub UpdateControls()
    Dim I As Integer
    
    If m_sPackageDefinitionFilename <> "" Then
        For I = Len(m_sPackageDefinitionFilename) To 1 Step -1
            If Mid(m_sPackageDefinitionFilename, I, 1) = "\" Then
                Me.Caption = Mid(m_sPackageDefinitionFilename, I + 1) & " - COB Packager"
                Exit For
            ElseIf I = 1 Then
                Me.Caption = m_sPackageDefinitionFilename & " - COB Packager"
            End If
        Next
    Else
        Me.Caption = "UntitledPackage - COB Packager"
    End If
    txtTitle = m_tPackageDefinition.Title
    lstFiles.Clear
    
    For I = 0 To m_tPackageDefinition.FileCount - 1
        lstFiles.AddItem m_tPackageDefinition.Files(I)
        lstFiles.ItemData(lstFiles.NewIndex) = I
    Next
    
    If m_tPackage.FileCount > 0 Then
        cmdFileExtract.Enabled = True
    Else
        cmdFileExtract.Enabled = False
    End If
    
    If m_tPackageDefinition.CompressFiles Then
        chkCompress.Value = vbChecked
    Else
        chkCompress.Value = vbUnchecked
    End If
    
    If m_tPackageDefinition.Creatures2 Then
        chkCreatures2.Value = vbChecked
    Else
        chkCreatures2.Value = vbUnchecked
    End If
    
    If Me.Visible Then
        txtTitle.SetFocus
    End If
End Sub

Private Sub SaveControls()
    If Trim(txtTitle.Text) <> m_tPackageDefinition.Title Then
        m_tPackageDefinition.Title = txtTitle.Text
        m_tPackageDefinition.Changed = True
    End If
    
    If (chkCompress.Value = vbChecked) <> m_tPackageDefinition.CompressFiles Then
        m_tPackageDefinition.CompressFiles = (chkCompress.Value = vbChecked)
        m_tPackageDefinition.Changed = True
    End If
    
    If (chkCreatures2.Value = vbChecked) <> m_tPackageDefinition.Creatures2 Then
        m_tPackageDefinition.Creatures2 = (chkCreatures2.Value = vbChecked)
        m_tPackageDefinition.Changed = True
    End If
End Sub

Private Function Load(sFilename As String) As Boolean
    Load = False
    
    If m_tPackageDefinition.Changed Then
        Dim nYesNoCancel As VbMsgBoxResult
        
        nYesNoCancel = MsgBox("Save changes to this package definition?", vbYesNoCancel, "COB Packager")
        
        If nYesNoCancel = vbYes Then
            Save
        ElseIf nYesNoCancel = vbCancel Then
            Exit Function
        End If
    End If
    
    Select Case LCase(Right(sFilename, 3))
        Case "pkd"
            Dim tNewPackageDefinition As PackageDefinition
            
            If LoadPackageDefinitionFile(sFilename, tNewPackageDefinition) Then
                m_tPackageDefinition = tNewPackageDefinition
                m_sPackageDefinitionFilename = sFilename
                
                UpdateControls
                
                m_oMRUFiles.Add sFilename
                InitialiseMRUFiles
            End If
            
        Case "pkg"
            LoadPackage sFilename
            
        Case "exe"
            LoadPackageExe sFilename
    End Select
    
    m_tPackageDefinition.Changed = False
    
    Load = True
End Function

Private Function LoadPackage(sFilename As String) As Boolean
    Dim I As Integer
    
    LoadPackage = LoadPackageFile(sFilename, m_tPackage)
    
    If LoadPackage Then
        m_sPackageDefinitionFilename = m_tPackage.Title & ".pkd"
        m_tPackageDefinition.Title = m_tPackage.Title
        
        If m_tPackage.Flags And cPFCompressed Then
            m_tPackageDefinition.CompressFiles = True
        Else
            m_tPackageDefinition.CompressFiles = False
        End If
        If m_tPackage.Flags And cPFCreatures2 Then
            m_tPackageDefinition.Creatures2 = True
        Else
            m_tPackageDefinition.Creatures2 = False
        End If
        
        m_tPackageDefinition.FileCount = m_tPackage.FileCount
        
        ReDim m_tPackageDefinition.Files(0 To m_tPackage.FileCount - 1)
        
        For I = 0 To m_tPackage.FileCount - 1
            m_tPackageDefinition.Files(I) = m_tPackage.Files(I).Filename
        Next
        
        UpdateControls
        
        m_oMRUFiles.Add sFilename
        InitialiseMRUFiles
    End If
End Function

Private Function LoadPackageExe(sFilename As String) As Boolean
    Dim I As Integer
    
    LoadPackageExe = LoadPackageFromExe(sFilename, m_tPackage)
    
    If LoadPackageExe Then
        m_sPackageDefinitionFilename = m_tPackage.Title & ".pkd"
        m_tPackageDefinition.Title = m_tPackage.Title
        
        If m_tPackage.Flags And cPFCompressed Then
            m_tPackageDefinition.CompressFiles = True
        Else
            m_tPackageDefinition.CompressFiles = False
        End If
        If m_tPackage.Flags And cPFCreatures2 Then
            m_tPackageDefinition.Creatures2 = True
        Else
            m_tPackageDefinition.Creatures2 = False
        End If
        
        m_tPackageDefinition.FileCount = m_tPackage.FileCount
        
        ReDim m_tPackageDefinition.Files(0 To m_tPackage.FileCount - 1)
        
        For I = 0 To m_tPackage.FileCount - 1
            m_tPackageDefinition.Files(I) = m_tPackage.Files(I).Filename
        Next
        
        UpdateControls
        
        m_oMRUFiles.Add sFilename
        InitialiseMRUFiles
    End If
End Function

Private Function Save() As Boolean
    Save = False
    
    SaveControls
    
    If m_sPackageDefinitionFilename = "" Then
        Save = SaveAs
        Exit Function
    End If
    
    If Not SavePackageDefinitionFile(m_sPackageDefinitionFilename, m_tPackageDefinition) Then
        MsgBox "Unable to save package definition to " & m_sPackageDefinitionFilename & "!", vbOKOnly, "COB Packager"
        Exit Function
    End If
        
    m_tPackageDefinition.Changed = False
    
    m_oMRUFiles.Add m_sPackageDefinitionFilename
    InitialiseMRUFiles
    
    Save = True
End Function

Private Function SaveAs() As Boolean
    SaveAs = False
    
    With ctlCommonDialog
        .CancelError = True
        .DialogTitle = "Save Package Definition As..."
        .Filter = PackageDefinitionFilesFilter
        .FilterIndex = 0
        .Flags = cdlOFNExplorer Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist Or cdlOFNOverwritePrompt
        .Filename = ""
        
        On Error Resume Next
        .ShowSave
        If Err = cdlCancel Then
            Exit Function
        ElseIf Err <> 0 Then
            MsgBox "Error " & Err & ": " & Error, vbOKOnly, "COB Packager"
            Exit Function
        End If
        On Error GoTo 0
        
        m_sPackageDefinitionFilename = .Filename
        
        UpdateControls
    End With
    
    Save
    
    SaveAs = True
End Function

Private Function Build() As Boolean
    Build = False
    
    SaveControls
    
    With ctlCommonDialog
        .CancelError = True
        .DialogTitle = "Build Package..."
        .Filter = PackageFilesFilter
        .Flags = cdlOFNExplorer Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist Or cdlOFNOverwritePrompt
        
        If m_tPackageDefinition.PackageFilename = "" Then
            .Filename = m_tPackageDefinition.Title & ".exe"
        Else
            .Filename = m_tPackageDefinition.PackageFilename
        End If
        
        Select Case LCase(Right(.Filename, 4))
            Case ".exe"
                .FilterIndex = 1
                
            Case ".pkg"
                .FilterIndex = 2
                
            Case Else
                .FilterIndex = 3
        End Select
        
        On Error Resume Next
        .ShowSave
        If Err = cdlCancel Then
            Exit Function
        ElseIf Err <> 0 Then
            MsgBox "Error " & Err & ": " & Error, vbOKOnly, "COB Packager"
            Exit Function
        End If
        On Error GoTo 0
        
        If m_tPackageDefinition.PackageFilename <> .Filename Then
            m_tPackageDefinition.PackageFilename = .Filename
            m_tPackageDefinition.Changed = True
        End If
    End With
    
    DoEvents
    lblStatus.Caption = "Building package..."
    DoEvents
    
    If Not BuildPackage(m_tPackageDefinition, m_tPackage) Then
        lblStatus.Caption = ""
        Exit Function
    End If
    
    lblStatus.Caption = "Writing package..."
    DoEvents
    
    If LCase(Right(m_tPackageDefinition.PackageFilename, 3)) = "exe" Then
        SavePackageToExe m_tPackageDefinition.PackageFilename, m_tPackage
    Else
        SavePackageFile m_tPackageDefinition.PackageFilename, m_tPackage
    End If
    
    lblStatus.Caption = ""
    
    UpdateControls
    
    Build = True
End Function

Private Sub AddFile(sFilename As String)
    m_tPackageDefinition.FileCount = m_tPackageDefinition.FileCount + 1
    ReDim Preserve m_tPackageDefinition.Files(0 To m_tPackageDefinition.FileCount - 1)
    m_tPackageDefinition.Files(m_tPackageDefinition.FileCount - 1) = sFilename
    
    lstFiles.AddItem sFilename
    
    m_tPackageDefinition.Changed = True
End Sub

Private Sub chkCompress_Click()
    If (chkCompress.Value = vbChecked) <> m_tPackageDefinition.CompressFiles Then
        m_tPackageDefinition.CompressFiles = (chkCompress.Value = vbChecked)
        m_tPackageDefinition.Changed = True
    End If
End Sub

Private Sub chkCompress_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub chkCompress_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub chkCreatures2_Click()
    If (chkCreatures2.Value = vbChecked) <> m_tPackageDefinition.Creatures2 Then
        m_tPackageDefinition.Creatures2 = (chkCreatures2.Value = vbChecked)
        m_tPackageDefinition.Changed = True
    End If
End Sub

Private Sub chkCreatures2_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub chkCreatures2_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdBuild_Click()
    Build
End Sub

Private Sub cmdFileAdd_Click()
    Dim sFilename As String
    Dim I As Integer
    Dim J As Integer
    Dim sPrefix As String
    
    With ctlCommonDialog
        .CancelError = True
        .DialogTitle = "Add File..."
        .Filter = CreaturesFilesFilter
        .FilterIndex = 0
        .Flags = cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist Or cdlOFNAllowMultiselect
        .Filename = ""
        
        On Error Resume Next
        .ShowOpen
        If Err = cdlCancel Then
            Exit Sub
        ElseIf Err <> 0 Then
            MsgBox "Error " & Err & ": " & Error, vbOKOnly, "COB Packager"
            Exit Sub
        End If
        On Error GoTo 0
        
        sFilename = .Filename
    End With
    
    I = InStr(sFilename, Chr(0))
    If I > 0 Then
        sPrefix = Left(sFilename, I - 1) & "\"
        Do
            I = I + 1
            J = InStr(I, sFilename, Chr(0))
            If J > 0 Then
                AddFile sPrefix & Mid(sFilename, I, J - I)
            Else
                AddFile sPrefix & Mid(sFilename, I)
            End If
            I = J
        Loop While I > 0
    Else
        AddFile sFilename
    End If
End Sub

Private Sub cmdFileExtract_Click()
    Dim I As Integer
    Dim sFolder As String
    Dim sFilename As String
    Dim nHandle As Integer
    Dim nYesNoCancel As VbMsgBoxResult
    
    If lstFiles.SelCount = 0 Then
        Exit Sub
    End If
    
    'Dim oForm As New frmBrowseForFolder
    'sFolder = oForm.Display(Me)
    
    sFolder = String(256, Chr(0))
    If BrowseForFolder(Me.hwnd, sFolder) = 0 Then
        Exit Sub
    End If
    
    sFolder = Left(sFolder, InStr(sFolder, Chr(0)) - 1)
    If Right(sFolder, 1) <> "\" Then
        sFolder = sFolder & "\"
    End If
    
    'If sFolder = "" Then
    '    Exit Sub
    'End If
    
    For I = 0 To lstFiles.ListCount - 1
        If lstFiles.Selected(I) Then
            sFilename = sFolder & m_tPackage.Files(lstFiles.ItemData(I)).Filename
            
            nHandle = FreeFile
            
            On Error Resume Next
            
            FileDateTime sFilename
            If Err = 0 Then
                nYesNoCancel = MsgBox(sFilename & " already exists. Overwrite?", vbYesNoCancel, "COB Packager")
                
                If nYesNoCancel = vbYes Then
                    Kill sFilename
                ElseIf nYesNoCancel = vbCancel Then
                    UpdateControls
                    Exit Sub
                End If
            Else
                Err.Clear
                nYesNoCancel = vbYes
            End If
            
            If nYesNoCancel = vbYes Then
                Open sFilename For Binary Access Write As #nHandle
                If Err <> 0 Then
                    Err.Clear
                    MsgBox "Error " & Err & ": " & Error, vbOKOnly, "COB Packager"
                    UpdateControls
                    Exit Sub
                End If
                On Error GoTo 0
                
                Put nHandle, , m_tPackage.Files(I).Data
                
                Close #nHandle
                
                If m_tPackageDefinition.Files(lstFiles.ItemData(I)) = m_tPackage.Files(lstFiles.ItemData(I)).Filename Then
                    m_tPackageDefinition.Files(lstFiles.ItemData(I)) = sFilename
                End If
            End If
        End If
    Next
    
    UpdateControls
End Sub

Private Sub cmdFileRemove_Click()
    Dim I As Integer
    
    Do While lstFiles.SelCount > 0
        For I = 0 To lstFiles.ListCount - 1
            If lstFiles.Selected(I) Then
                lstFiles.RemoveItem I
                PackageDefinitionRemoveFile m_tPackageDefinition, I
                Exit For
            End If
        Next
    Loop
    
    m_tPackageDefinition.Changed = True
End Sub

Private Sub Form_Load()
    GetCOBPackagerSettings
    InitialiseMRUFiles
    InitialiseControls
    ClearPackage
    UpdateControls
End Sub

Private Sub Form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim I As Integer
    Dim sFilename As String
    
    If Data.GetFormat(vbCFFiles) And (Effect And vbDropEffectCopy) Then
        For I = 1 To Data.Files.Count
            sFilename = Data.Files.Item(I)
            Select Case LCase(Right(sFilename, 3))
                Case "cob", "rcb", "spr", "s16", "wav", "txt"
                    AddFile sFilename
                    
                Case "pkd", "pkg", "exe"
                    Load sFilename
            End Select
        Next
    End If
End Sub

Private Sub Form_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Dim I As Integer
    Dim nNewEffect As Long
    
    nNewEffect = vbDropEffectNone
    
    If Data.GetFormat(vbCFFiles) And (Effect And vbDropEffectCopy) Then
        nNewEffect = vbDropEffectCopy
    End If
    
    Effect = nNewEffect
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    SaveControls
    
    If m_tPackageDefinition.Changed Then
        Dim nYesNoCancel As VbMsgBoxResult
        
        nYesNoCancel = MsgBox("Save changes to this package definition?", vbYesNoCancel, "COB Packager")
        
        If nYesNoCancel = vbYes Then
            If Not Save Then
                Cancel = 1
            End If
        ElseIf nYesNoCancel = vbCancel Then
            Cancel = 1
        End If
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    WriteCOBPackagerSettings
End Sub

Private Sub fraFiles_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub fraFiles_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lblPackageTitle_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lblPackageTitle_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lblStatus_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lblStatus_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lstFiles_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    Form_OLEDragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lstFiles_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    Form_OLEDragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub mnuFileBuild_Click()
    Build
End Sub

Private Sub mnuFileMRUFile_Click(Index As Integer)
    Load m_oMRUFiles(Index)
End Sub

Private Sub mnuFileNew_Click()
    SaveControls
    
    If m_tPackageDefinition.Changed Then
        Dim nYesNoCancel As VbMsgBoxResult
        
        nYesNoCancel = MsgBox("Do you want to save changes to this package definition?", vbYesNoCancel, "COB Packager")
        
        If nYesNoCancel = vbYes Then
            If Not Save Then
                Exit Sub
            End If
        ElseIf nYesNoCancel = vbCancel Then
            Exit Sub
        End If
    End If
    
    ClearPackage
    
    UpdateControls
End Sub

Private Sub mnuFileOpen_Click()
    Dim sFilename As String
    
    With ctlCommonDialog
        .CancelError = True
        .DialogTitle = "Open File..."
        .Filter = AllPackageFilesFilter
        .FilterIndex = 0
        .Flags = cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist 'Or cdlOFNAllowMultiselect
        .Filename = ""
        
        On Error Resume Next
        .ShowOpen
        If Err = cdlCancel Then
            Exit Sub
        ElseIf Err <> 0 Then
            MsgBox "Error " & Err & ": " & Error, vbOKOnly, "COB Packager"
            Exit Sub
        End If
        On Error GoTo 0
        
        sFilename = .Filename
    End With
    
    Load sFilename
End Sub

Private Sub mnuFileSave_Click()
    Save
End Sub

Private Sub mnuFileSaveAs_Click()
    SaveAs
End Sub

Private Sub mnuHelpAbout_Click()
    frmAbout.Show vbModal, Me
End Sub

Private Sub txtTitle_GotFocus()
    txtTitle.SelStart = 0
    txtTitle.SelLength = Len(txtTitle.Text)
End Sub

Private Sub txtTitle_LostFocus()
    If Trim(txtTitle.Text) <> m_tPackageDefinition.Title Then
        m_tPackageDefinition.Title = txtTitle.Text
        m_tPackageDefinition.Changed = True
    End If
End Sub
