Attribute VB_Name = "modDDEFunctions"
Option Explicit

Private m_oSFC As Object

Public Function ConnectDDE(oForm As Object) As Integer
    ConnectDDE = 0
    
    On Error Resume Next
    
    If m_oSFC Is Nothing Then
        If nCreaturesVersion = cvcCreatures1 Then
            Set m_oSFC = CreateObject("SFC.OLE")
        ElseIf nCreaturesVersion = cvcCreatures2 Then
            Set m_oSFC = CreateObject("SFC2.OLE")
        End If
        
        If Err <> 0 Or m_oSFC Is Nothing Then
            If Err <> 0 Then
                Err.Clear
                MsgBox "An error occurred while trying to connect to Creatures: " & vbCrLf & Err.Description, vbOKOnly Or vbExclamation
            Else
                MsgBox "An unknown error occurred while trying to connect to Creatures", vbOKOnly Or vbExclamation
            End If
            ConnectDDE = -1
            Exit Function
        End If
    End If
    
'    If oForm.DDEControl.LinkMode = vbLinkManual Then
'        ConnectDDE = 1
'        Exit Function
'    End If
'
'    On Error Resume Next
'
'    oForm.DDEControl.LinkMode = vbLinkManual
'    If Err = 282 Then
'        Err.Clear
'        Exit Function
'    ElseIf Err <> 0 Then
'        Err.Clear
'        ConnectDDE = -1
'        MsgBox "An unknown error occurred while initiating a DDE link to Creatures: [" & Err & "] " & Err.Description, vbCritical
'        Exit Function
'    End If
'
'    On Error GoTo 0
    
    ConnectDDE = 1
End Function

Public Sub DisconnectDDE(oForm As Object)
'    oForm.DDEControl.LinkMode = vbLinkNone
    Set m_oSFC = Nothing
End Sub

Public Function SendDDE(oForm As Object) As Boolean
    Dim nConnected As Integer
    Dim nOKCancel As Integer
    Dim nOrigPointer As Integer
    Dim sData As String
    
    nOrigPointer = Screen.MousePointer
    
    SendDDE = False
    
    nConnected = ConnectDDE(oForm)
    If nConnected = 0 Then
        nOKCancel = MsgBox("Creatures must be running to execute a macro. Start Creatures?", vbOKCancel + vbCritical)
        
        If nOKCancel = vbOK Then
            If Not StartCreatures(oForm) Then
                'AppActivate oForm.Caption
            End If
        Else
            Exit Function
        End If
    ElseIf nConnected = -1 Then
        Exit Function
    End If
    
    On Error Resume Next

    Screen.MousePointer = vbHourglass
    
    m_oSFC.FireCommand 1, oForm.DDEControl.Caption, sData
    If Err <> 0 Then
        MsgBox Err.Number & ": " & Err.Description
        Err.Clear
        Exit Function
    End If
    
    oForm.DDEControl.Caption = sData

'    oForm.DDEControl.LinkPoke
'
'    If Err = 286 Then
'        Err.Clear
'        MsgBox "The Creatures DDE link has timed out. Close any Creatures dialog boxes that might be open and then click OK to continue.", vbCritical
'        oForm.DDEControl.LinkPoke
'        If Err <> 0 Then
'            Err.Clear
'            Screen.MousePointer = nOrigPointer
'            Exit Function
'        End If
'    ElseIf Err <> 0 Then
'        Err.Clear
'        MsgBox "An unknown error occurred while sending a macro to Creatures: [" & Err & "] " & Err.Description, vbCritical
'        Screen.MousePointer = nOrigPointer
'        Exit Function
'    End If
'
'    oForm.DDEControl.LinkRequest
'
'    If Err = 286 Then
'        Err.Clear
'        MsgBox "The Creatures DDE link has timed out, probably because of a macro error.", vbCritical
'        Screen.MousePointer = nOrigPointer
'        Exit Function
'    ElseIf Err <> 0 Then
'        Err.Clear
'        MsgBox "An unknown error occurred while retrieving the result from Creatures: [" & Err & "] " & Err.Description, vbCritical
'        Screen.MousePointer = nOrigPointer
'        Exit Function
'    End If

    On Error GoTo 0

    Screen.MousePointer = nOrigPointer
    
    SendDDE = True
End Function

Public Function StartCreatures(oForm As Object) As Boolean
    If sLauncherPath = "" Then
        Exit Function
    End If
    If ConnectDDE(oForm) <> 1 Then
        Shell sLauncherPath, vbNormalFocus
        Do While ConnectDDE(oForm) = 0
        Loop
        StartCreatures = False
    Else
        StartCreatures = True
    End If
End Function

