VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "SpriteImage"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_nBitsPerPixel As Integer
Private m_nSpriteWidth As Integer
Private m_nSpriteHeight As Integer
Private m_aPixels() As Byte

Public Property Get BitsPerPixel() As Integer
    BitsPerPixel = m_nBitsPerPixel
End Property

Public Property Let BitsPerPixel(vNewValue As Integer)
    m_nBitsPerPixel = vNewValue
End Property

Public Property Get SpriteWidth() As Integer
    SpriteWidth = m_nSpriteWidth
End Property

Public Property Let SpriteWidth(vNewValue As Integer)
    m_nSpriteWidth = vNewValue
End Property

Public Property Get SpriteHeight() As Integer
    SpriteHeight = m_nSpriteHeight
End Property

Public Property Let SpriteHeight(vNewValue As Integer)
    m_nSpriteHeight = vNewValue
End Property

Public Property Get Pixels(ByVal X As Long, ByVal Y As Long) As Long
    Dim nOffset As Long
    Dim nBytesPerPixel As Integer
    Dim nPixel As Long
    Dim nRed As Integer
    Dim nGreen As Integer
    Dim nBlue As Integer
    
    nBytesPerPixel = m_nBitsPerPixel / 8
    
    nOffset = Y * m_nSpriteWidth * nBytesPerPixel + X * nBytesPerPixel
    
    Select Case m_nBitsPerPixel
        Case 8
            nPixel = m_aPixels(nOffset)
            Pixels = RGB(aCreaturesPalette(nPixel).Red, aCreaturesPalette(nPixel).Green, aCreaturesPalette(nPixel).Blue)
            
        Case 15
            nPixel = CLng(m_aPixels(nOffset)) Or (CLng(m_aPixels(nOffset + 1)) * 256)
            nBlue = nPixel And 31
            nGreen = (nPixel And 992) / 32
            nRed = (nPixel And 31744) / 1024
            Pixels = RGB((nRed * 255) / 31, (nGreen * 255) / 31, (nBlue * 255) / 31)
            
        Case 16
            nPixel = CLng(m_aPixels(nOffset)) Or (CLng(m_aPixels(nOffset + 1)) * 256)
            nBlue = nPixel And 31
            nGreen = (nPixel And 2016) / 32
            nRed = (nPixel And 63488) / 2048
            Pixels = RGB((nRed * 255) / 31, (nGreen * 255) / 63, (nBlue * 255) / 31)
    End Select
End Property

Public Sub GetPixelArray(aPixels)
    Erase aPixels
    
    ReDim aPixels(0 To UBound(m_aPixels))
    aPixels = m_aPixels
End Sub

Public Sub SetPixelArray(aNewPixels)
    Erase m_aPixels
    ReDim m_aPixels(0 To UBound(aNewPixels)) As Byte
    m_aPixels = aNewPixels
End Sub
