Attribute VB_Name = "modSpriteFunctions"
Option Explicit

Public Const sCreatures2RegistryKey = "SOFTWARE\Cyberlife Technology\Creatures 2\1.0"
Public Const sSpriteEditorRegistryKey = "SOFTWARE\BoBWare\SpriteEditor\1.x"

Public Const sLoadSpriteFileFilter = "All Sprite Files (*.spr;*.s16)|*.spr;*.s16|Creatures 1 Sprite Files (*.spr)|*.spr|Creatures 2 Sprite Files (*.s16)|*.s16|All Files (*.*)|*.*"
'Public Const sSaveSpriteFileFilter = "Creatures 1 Sprite Files (*.spr)|*.spr|Creatures 2 Sprite Files (*.s16)|*.s16|All Files (*.*)|*.*"
Public Const sSPRFilesFilter = "Creatures 1 Sprite Files (*.spr)|*.spr"
Public Const sS16FilesFilter = "Creatures 2 Sprite Files (*.s16)|*.s16"
Public Const sImportFilter = "Windows Bitmap Files (*.bmp)|*.bmp|Creatures Sprite Files (*.spr;*.s16)|*.spr;*.s16|All Files (*.*)|*.*"
Public Const sExportFilter = "Windows Bitmap Files (*.bmp)|*.bmp|Creatures 1 Sprite Files (*.spr)|*.spr|Creatures 2 Sprite Files (*.s16)|*.s16|All Files (*.*)|*.*"
Public Const sExportBMPFilter = "Windows Bitmap Files (*.bmp)|*.bmp"

Public g_nBeforeAfter As Integer
Public g_nSpriteNumbering As Integer
Public g_nDefaultSpriteType As SpriteTypeConstants
Public g_nThumbnailSize As Integer
Public g_nThumbnailSpacing As Integer
Public g_bThumbnailShowImages As Boolean
Public g_bThumbnailShowCaptions As Boolean
Public g_sDefaultLoadFolder As String
Public g_sDefaultSaveFolder As String
Public g_sDefaultImportFolder As String
Public g_sDefaultExportFolder As String
Public g_sCurrentLoadFolder As String
Public g_sCurrentSaveFolder As String
Public g_sCurrentImportFolder As String
Public g_sCurrentExportFolder As String

Public g_sSpriteFilename As String

Public g_oCurrentSprite As New Sprite
Public g_oMRUFiles As New MRUFiles

Public Sub GetSpriteEditorSettings()
    Dim oRegKey As New RegistryKey
    
    GetCommonSettings
    
    'SpriteEditor Registry settings
    If oRegKey.OpenKey(HKEY_CURRENT_USER, sSpriteEditorRegistryKey, True) Then
        'Get Insert Image Before/After setting
        Dim sInsertImageBeforeAfter As String
        
        If oRegKey.GetKeyValue("InsertImageBeforeAfter", REG_SZ, sInsertImageBeforeAfter) Then
            g_nBeforeAfter = CInt(sInsertImageBeforeAfter)
        Else
            g_nBeforeAfter = -1
        End If
        
        'Get Sprite Numbering setting
        Dim sSpriteNumbering As String
        
        If oRegKey.GetKeyValue("SpriteNumbering", REG_SZ, sSpriteNumbering) Then
            g_nSpriteNumbering = CInt(sSpriteNumbering)
        Else
            g_nSpriteNumbering = 0
        End If
        
        'Get Default Sprite Type setting
        Dim sDefaultSpriteType As String
        
        If oRegKey.GetKeyValue("DefaultSpriteType", REG_SZ, sDefaultSpriteType) Then
            g_nDefaultSpriteType = CInt(sDefaultSpriteType)
        Else
            g_nDefaultSpriteType = stcNone
        End If
        
        'Get Thumbnail Size setting
        Dim sThumbnailSize As String
        
        If oRegKey.GetKeyValue("ThumbnailSize", REG_SZ, sThumbnailSize) Then
            g_nThumbnailSize = CInt(sThumbnailSize)
        Else
            g_nThumbnailSize = 64
        End If
        
        'Get Thumbnail Spacing setting
        Dim sThumbnailSpacing As String
        
        If oRegKey.GetKeyValue("ThumbnailSpacing", REG_SZ, sThumbnailSpacing) Then
            g_nThumbnailSpacing = CInt(sThumbnailSpacing)
        Else
            g_nThumbnailSpacing = 8
        End If
        
        'Get Thumbnail Show Images setting
        Dim sThumbnailShowImages As String
        
        If oRegKey.GetKeyValue("ThumbnailShowImages", REG_SZ, sThumbnailShowImages) Then
            g_bThumbnailShowImages = CBool(sThumbnailShowImages)
        Else
            g_bThumbnailShowImages = True
        End If
        
        'Get Thumbnail Show Captions setting
        Dim sThumbnailShowCaptions As String
        
        If oRegKey.GetKeyValue("ThumbnailShowCaptions", REG_SZ, sThumbnailShowCaptions) Then
            g_bThumbnailShowCaptions = CBool(sThumbnailShowCaptions)
        Else
            g_bThumbnailShowCaptions = True
        End If
        
        'Get DefaultLoadFolder setting
        Dim sDefaultLoadFolder As String
        
        If oRegKey.GetKeyValue("DefaultLoadFolder", REG_SZ, sDefaultLoadFolder) Then
            g_sDefaultLoadFolder = sDefaultLoadFolder
        Else
            g_sDefaultLoadFolder = ""
        End If
        
        'Get DefaultSaveFolder setting
        Dim sDefaultSaveFolder As String
        
        If oRegKey.GetKeyValue("DefaultSaveFolder", REG_SZ, sDefaultSaveFolder) Then
            g_sDefaultSaveFolder = sDefaultSaveFolder
        Else
            g_sDefaultSaveFolder = ""
        End If
        
        'Get DefaultImportFolder setting
        Dim sDefaultImportFolder As String
        
        If oRegKey.GetKeyValue("DefaultImportFolder", REG_SZ, sDefaultImportFolder) Then
            g_sDefaultImportFolder = sDefaultImportFolder
        Else
            g_sDefaultImportFolder = ""
        End If
        
        'Get DefaultExportFolder setting
        Dim sDefaultExportFolder As String
        
        If oRegKey.GetKeyValue("DefaultExportFolder", REG_SZ, sDefaultExportFolder) Then
            g_sDefaultExportFolder = sDefaultExportFolder
        Else
            g_sDefaultExportFolder = ""
        End If
        
        g_oMRUFiles.ReadFromRegistry oRegKey
        
        oRegKey.CloseKey
    End If
    
    If g_sDefaultLoadFolder <> "" Then
        g_sCurrentLoadFolder = g_sDefaultLoadFolder
    Else
        g_sCurrentLoadFolder = CurDir
    End If
    
    If g_sDefaultSaveFolder <> "" Then
        g_sCurrentSaveFolder = g_sDefaultSaveFolder
    Else
        g_sCurrentSaveFolder = CurDir
    End If
    
    If g_sDefaultImportFolder <> "" Then
        g_sCurrentImportFolder = g_sDefaultImportFolder
    Else
        g_sCurrentImportFolder = CurDir
    End If
    
    If g_sDefaultExportFolder <> "" Then
        g_sCurrentExportFolder = g_sDefaultExportFolder
    Else
        g_sCurrentExportFolder = CurDir
    End If
End Sub

Public Sub WriteSpriteEditorSettings()
    Dim oRegKey As New RegistryKey
    
    'SpriteEditor Registry settings
    If oRegKey.OpenKey(HKEY_CURRENT_USER, sSpriteEditorRegistryKey, True) Then
        'Set Insert Image Before/After setting
        Dim sInsertImageBeforeAfter As String
        
        sInsertImageBeforeAfter = CStr(g_nBeforeAfter)
        oRegKey.SetKeyValue "InsertImageBeforeAfter", REG_SZ, sInsertImageBeforeAfter
        
        'Set Sprite Numbering setting
        Dim sSpriteNumbering As String
        
        sSpriteNumbering = CStr(g_nSpriteNumbering)
        oRegKey.SetKeyValue "SpriteNumbering", REG_SZ, sSpriteNumbering
        
        'Set Default Sprite Type setting
        Dim sDefaultSpriteType As String
        
        sDefaultSpriteType = CStr(g_nDefaultSpriteType)
        oRegKey.SetKeyValue "DefaultSpriteType", REG_SZ, sDefaultSpriteType
        
        'Set Thumbnail Size setting
        Dim sThumbnailSize As String
        
        sThumbnailSize = CStr(g_nThumbnailSize)
        oRegKey.SetKeyValue "ThumbnailSize", REG_SZ, sThumbnailSize
        
        'Set Thumbnail Spacing setting
        Dim sThumbnailSpacing As String
        
        sThumbnailSpacing = CStr(g_nThumbnailSpacing)
        oRegKey.SetKeyValue "ThumbnailSpacing", REG_SZ, sThumbnailSpacing
        
        'Set Thumbnail Show Images setting
        Dim sThumbnailShowImages As String
        
        sThumbnailShowImages = CStr(g_bThumbnailShowImages)
        oRegKey.SetKeyValue "ThumbnailShowImages", REG_SZ, sThumbnailShowImages
        
        'Set Thumbnail Show Captions setting
        Dim sThumbnailShowCaptions As String
        
        sThumbnailShowCaptions = CStr(g_bThumbnailShowCaptions)
        oRegKey.SetKeyValue "ThumbnailShowCaptions", REG_SZ, sThumbnailShowCaptions
        
        'Set DefaultLoadFolder setting
        Dim sDefaultLoadFolder As String
        
        sDefaultLoadFolder = g_sDefaultLoadFolder
        oRegKey.SetKeyValue "DefaultLoadFolder", REG_SZ, sDefaultLoadFolder
        
        'Set DefaultSaveFolder setting
        Dim sDefaultSaveFolder As String
        
        sDefaultSaveFolder = g_sDefaultSaveFolder
        oRegKey.SetKeyValue "DefaultSaveFolder", REG_SZ, sDefaultSaveFolder
        
        'Set DefaultImportFolder setting
        Dim sDefaultImportFolder As String
        
        sDefaultImportFolder = g_sDefaultImportFolder
        oRegKey.SetKeyValue "DefaultImportFolder", REG_SZ, sDefaultImportFolder
        
        'Set DefaultExportFolder setting
        Dim sDefaultExportFolder As String
        
        sDefaultExportFolder = g_sDefaultExportFolder
        oRegKey.SetKeyValue "DefaultExportFolder", REG_SZ, sDefaultExportFolder
        
        g_oMRUFiles.WriteToRegistry oRegKey
        
        oRegKey.CloseKey
    End If
End Sub
