VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmMultipleFileConverter 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Multiple File Converter"
   ClientHeight    =   3975
   ClientLeft      =   240
   ClientTop       =   330
   ClientWidth     =   6870
   Icon            =   "MultipleFileConverter.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3975
   ScaleWidth      =   6870
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin MSComDlg.CommonDialog ctlCommonDialog 
      Left            =   4680
      Top             =   1320
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
   End
   Begin VB.TextBox txtOutputFolder 
      Height          =   285
      Left            =   120
      TabIndex        =   5
      Top             =   2040
      Width           =   4695
   End
   Begin VB.CommandButton cmdBrowseOutputFolder 
      Caption         =   ""
      BeginProperty Font 
         Name            =   "Symbol"
         Size            =   8.25
         Charset         =   2
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   4920
      TabIndex        =   6
      Top             =   2055
      Width           =   255
   End
   Begin VB.Frame fraOutputOptions 
      Caption         =   "Output options"
      Height          =   1335
      Left            =   120
      TabIndex        =   7
      Top             =   2520
      Width           =   6615
      Begin VB.TextBox txtPrefix 
         Height          =   285
         Left            =   2400
         TabIndex        =   10
         Top             =   585
         Width           =   2655
      End
      Begin VB.TextBox txtSuffix 
         Height          =   285
         Left            =   2400
         TabIndex        =   12
         Top             =   945
         Width           =   2655
      End
      Begin VB.OptionButton optSuffix 
         Caption         =   "&Suffix original filename with:"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   960
         Width           =   2295
      End
      Begin VB.OptionButton optOriginalFilename 
         Caption         =   "&Use original filename (will overwrite existing files)"
         Height          =   255
         Left            =   120
         TabIndex        =   8
         Top             =   240
         Width           =   3735
      End
      Begin VB.OptionButton optPrefix 
         Caption         =   "&Prefix original filename with:"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   600
         Width           =   2415
      End
   End
   Begin VB.CommandButton cmdRemoveFile 
      Caption         =   "&Remove"
      Height          =   375
      Left            =   4080
      TabIndex        =   3
      Top             =   840
      Width           =   1095
   End
   Begin VB.CommandButton cmdAddFile 
      Caption         =   "&Add..."
      Height          =   375
      Left            =   4080
      TabIndex        =   2
      Top             =   360
      Width           =   1095
   End
   Begin VB.CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   375
      Left            =   5640
      TabIndex        =   18
      Top             =   600
      Width           =   1095
   End
   Begin VB.CommandButton cmdConvert 
      Caption         =   "&Convert"
      Default         =   -1  'True
      Height          =   375
      Left            =   5640
      TabIndex        =   17
      Top             =   120
      Width           =   1095
   End
   Begin VB.ListBox lstFiles 
      Height          =   1230
      Left            =   120
      MultiSelect     =   2  'Extended
      TabIndex        =   1
      Top             =   360
      Width           =   3855
   End
   Begin VB.Frame fraConvertTo 
      Caption         =   "Convert to..."
      Height          =   1095
      Left            =   5400
      TabIndex        =   13
      Top             =   1200
      Width           =   1335
      Begin VB.OptionButton optS16565 
         Caption         =   "S16 - 5&65"
         Height          =   255
         Left            =   120
         OLEDropMode     =   1  'Manual
         TabIndex        =   16
         Top             =   720
         Width           =   1095
      End
      Begin VB.OptionButton optS16555 
         Caption         =   "S16 - 5&55"
         Height          =   255
         Left            =   120
         OLEDropMode     =   1  'Manual
         TabIndex        =   15
         Top             =   480
         Width           =   1095
      End
      Begin VB.OptionButton optSPR 
         Caption         =   "S&PR"
         Height          =   255
         Left            =   120
         OLEDropMode     =   1  'Manual
         TabIndex        =   14
         Top             =   240
         Width           =   1095
      End
   End
   Begin VB.Label lblOutputFolder 
      Caption         =   "&Output folder:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   1800
      Width           =   1095
   End
   Begin VB.Label lblFiles 
      Caption         =   "&Files:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   495
   End
End
Attribute VB_Name = "frmMultipleFileConverter"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdAddFile_Click()
    Dim sFilename As String
    Dim sPrefix As String
    Dim I As Integer
    Dim J As Integer
    
    With ctlCommonDialog
        .filename = ""
        .DialogTitle = "Add Sprite File..."
        .Filter = sLoadSpriteFileFilter
        .Flags = cdlOFNAllowMultiselect Or cdlOFNExplorer Or cdlOFNFileMustExist Or cdlOFNHideReadOnly Or cdlOFNLongNames Or cdlOFNPathMustExist
        .FilterIndex = 1
        .MaxFileSize = 32767
        On Error Resume Next
        .ShowOpen
        If Err = cdlCancel Then
            Err.Clear
            Exit Sub
        ElseIf Err <> 0 Then
            MsgBox "Error " & Err & ": " & Error
            Err.Clear
            Exit Sub
        End If
        On Error GoTo 0
        sFilename = .filename
    End With
    
    I = InStr(sFilename, Chr(0))
    If I > 0 Then
        sPrefix = Left(sFilename, I - 1) & "\"
        Do
            I = I + 1
            J = InStr(I, sFilename, Chr(0))
            If J > 0 Then
                lstFiles.AddItem sPrefix & Mid(sFilename, I, J - I)
            Else
                lstFiles.AddItem sPrefix & Mid(sFilename, I)
            End If
            I = J
        Loop While I > 0
    Else
        lstFiles.AddItem sFilename
    End If
End Sub

Private Sub cmdBrowseOutputFolder_Click()
    Dim sFolder As String * 512
    Dim nRet As Long
    
    sFolder = txtOutputFolder.Text
    nRet = BrowseForFolder(Me.hwnd, "Select folder in which to put converted files:", sFolder)
    
    If nRet Then
        txtOutputFolder.Text = Trim(sFolder)
    End If
End Sub

Private Sub cmdClose_Click()
    Unload Me
End Sub

Private Sub cmdConvert_Click()
    Dim I As Long
    Dim sFilename As String
    Dim oSprite As Sprite
    Dim eConvertTo As SpriteTypeConstants
    Dim sOutputFolder As String
    Dim J As Integer
    Dim sOutputFilename As String
    
    If lstFiles.ListCount <= 0 Then
        MsgBox "Please select some files to convert.", vbOKOnly Or vbExclamation
        Exit Sub
    End If
    
    If Not (optSPR.Value Or optS16555.Value Or optS16565.Value) Then
        MsgBox "Please select a format to convert to.", vbOKOnly Or vbExclamation
        Exit Sub
    End If
    
    If optSPR.Value Then
        eConvertTo = stcSPR
    ElseIf optS16555.Value Then
        eConvertTo = stcS16_555
    ElseIf optS16565.Value Then
        eConvertTo = stcS16_565
    End If
    
    If Not (optOriginalFilename.Value Or optPrefix.Value Or optSuffix.Value) Then
        MsgBox "Please select an output option.", vbOKOnly Or vbExclamation
        Exit Sub
    End If
    
    sOutputFolder = Trim(txtOutputFolder.Text)
    If sOutputFolder <> "" Then
        If Dir(sOutputFolder, vbDirectory) = "" Then
            If MsgBox(sOutputFolder & " does not exist. Shall I create it?", vbOKCancel Or vbQuestion) <> vbOK Then
                Exit Sub
            End If
            
            On Error Resume Next
            
            Err.Clear
            MkDir sOutputFolder
            
            If Err <> 0 Then
                Err.Clear
                MsgBox "Could not create folder! Make sure that the parent folder exists and try again.", vbOKOnly Or vbExclamation
                Exit Sub
            End If
        End If
        If Right(sOutputFolder, 1) <> "\" Then
            sOutputFolder = sOutputFolder & "\"
        End If
    End If
    
    Me.MousePointer = vbHourglass
    
    For I = 0 To lstFiles.ListCount - 1
        sFilename = lstFiles.List(I)
        
        Me.Caption = "Converting " & sFilename & "..."
        
        Set oSprite = New Sprite
        
        If StrComp(Right(sFilename, 3), "spr", vbTextCompare) = 0 Then
            If Not oSprite.LoadSpriteFile(sFilename) Then
                MsgBox "Could not load " & sFilename & "!", vbOKOnly Or vbExclamation
                Me.Caption = "Multiple File Converter"
                Me.MousePointer = vbDefault
                Exit Sub
            End If
        ElseIf StrComp(Right(sFilename, 3), "s16", vbTextCompare) = 0 Then
            If Not oSprite.LoadS16File(sFilename) Then
                MsgBox "Could not load " & sFilename & "!", vbOKOnly Or vbExclamation
                Me.Caption = "Multiple File Converter"
                Me.MousePointer = vbDefault
                Exit Sub
            End If
        End If
        
        oSprite.SpriteType = eConvertTo
        
        For J = Len(sFilename) To 1 Step -1
            If Mid(sFilename, J, 1) = "\" Then
                If sOutputFolder <> "" Then
                    sOutputFilename = sOutputFolder
                Else
                    sOutputFilename = Left(sFilename, J)
                End If
                
                If optPrefix.Value Then
                    sOutputFilename = sOutputFilename & txtPrefix.Text
                End If
                
                sOutputFilename = sOutputFilename & Mid(sFilename, J + 1)
                
                Exit For
            End If
        Next
        
        For J = Len(sOutputFilename) To 1 Step -1
            If Mid(sOutputFilename, J, 1) = "\" Then
                Exit For
            ElseIf Mid(sOutputFilename, J, 1) = "." Then
                sOutputFilename = Left(sOutputFilename, J - 1)
                
                If optSuffix.Value Then
                    sOutputFilename = sOutputFilename & txtSuffix.Text
                End If
                
                Exit For
            End If
        Next
        
        If oSprite.SpriteType = stcSPR Then
            sOutputFilename = sOutputFilename & ".spr"
        ElseIf oSprite.SpriteType = stcS16_555 Or oSprite.SpriteType = stcS16_565 Then
            sOutputFilename = sOutputFilename & ".s16"
        End If
        
        If Not oSprite.Save(sOutputFilename) Then
            MsgBox "Could not save " & sOutputFilename & "!", vbOKOnly Or vbExclamation
            Me.Caption = "Multiple File Converter"
            Me.MousePointer = vbDefault
            Exit Sub
        End If
    Next
    
    Me.Caption = "Multiple File Converter"
    Me.MousePointer = vbDefault
    
    MsgBox "Conversion completed.", vbOKOnly Or vbInformation
End Sub

Private Sub cmdRemoveFile_Click()
    Dim I As Integer
    
    Do While lstFiles.SelCount > 0
        For I = 0 To lstFiles.ListCount - 1
            If lstFiles.Selected(I) Then
                lstFiles.RemoveItem I
                Exit For
            End If
        Next
    Loop
End Sub

Private Sub Form_Load()
    txtPrefix.Enabled = False
    txtSuffix.Enabled = False
End Sub

Private Sub optOriginalFilename_Click()
    If optOriginalFilename.Value = True Then
        txtPrefix.Enabled = False
        txtSuffix.Enabled = False
    End If
End Sub

Private Sub optPrefix_Click()
    If optPrefix.Value = True Then
        txtPrefix.Enabled = True
        txtSuffix.Enabled = False
    End If
End Sub

Private Sub optSuffix_Click()
    If optSuffix.Value = True Then
        txtPrefix.Enabled = False
        txtSuffix.Enabled = True
    End If
End Sub
