Attribute VB_Name = "modZLib"
Option Explicit

Declare Function compress2 Lib "zlib.dll" (dest As Any, destLen As Any, src As Any, ByVal srcLen As Long, ByVal level As Integer) As Long
Declare Function uncompress Lib "zlib.dll" (dest As Any, destLen As Any, src As Any, ByVal srcLen As Long) As Long

Public Function CompressData(aSource() As Byte, aDest() As Byte) As Boolean
    Dim nRes As Integer
    Dim nSourceLen As Long
    Dim nDestLen As Long
    
    CompressData = False
    
    nSourceLen = UBound(aSource) - LBound(aSource) + 1
    nDestLen = (nSourceLen * 1.1) + 12
    
    ReDim aDest(0 To nDestLen - 1)
    
    nRes = compress2(aDest(0), nDestLen, aSource(0), nSourceLen, 9)
    If nRes <> 0 Then
        Exit Function
    End If
    
    ReDim Preserve aDest(0 To nDestLen - 1)
    
    CompressData = True
End Function

Public Function DecompressData(aSource() As Byte, aDest() As Byte) As Boolean
    Dim nRes As Integer
    Dim nSourceLen As Long
    Dim nDestLen As Long
    
    DecompressData = False
    
    nSourceLen = UBound(aSource) - LBound(aSource) + 1
    nDestLen = UBound(aDest) - LBound(aDest) + 1
    
    nRes = uncompress(aDest(0), nDestLen, aSource(0), nSourceLen)
    If nRes <> 0 Then
        MsgBox "Compress error: " & nRes
        End
    End If
    
    ReDim Preserve aDest(0 To nDestLen)
    
    DecompressData = True
End Function

