// Package

#pragma once

const int cPackageVersionLength = 5;

extern const char *cPackageVersion01;

extern const unsigned char cPFCompressed;
extern const unsigned char cPFCreatures2;

typedef struct
{
	char *Filename;
	unsigned long DataLength;
	unsigned char *Data;
} PackagedFile;

typedef struct
{
    char Version[cPackageVersionLength];
	unsigned char Flags;
	char *Title;
    short FileCount;
    PackagedFile *Files;
} Package;

bool LoadPackageFile(const char *filename, Package *package);
bool LoadPackageFromExe(const char *filename, Package *package);
