VERSION 5.00
Begin VB.Form frmStim 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Stim"
   ClientHeight    =   4335
   ClientLeft      =   1020
   ClientTop       =   1860
   ClientWidth     =   3255
   Icon            =   "Stim.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4335
   ScaleWidth      =   3255
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.CheckBox chkC2Chemicals 
      Caption         =   "Use C2 chemical names"
      Height          =   255
      Left            =   120
      TabIndex        =   21
      Top             =   3360
      Value           =   2  'Grayed
      Width           =   3015
   End
   Begin VB.ComboBox cboTarget 
      Height          =   315
      ItemData        =   "Stim.frx":000C
      Left            =   1440
      List            =   "Stim.frx":001F
      TabIndex        =   3
      Top             =   360
      Width           =   975
   End
   Begin VB.TextBox txtSignificance 
      Height          =   285
      Left            =   120
      TabIndex        =   5
      Text            =   "10"
      Top             =   1080
      Width           =   615
   End
   Begin VB.CommandButton cmdInsert 
      Caption         =   "&Insert"
      Default         =   -1  'True
      Height          =   375
      Left            =   1140
      TabIndex        =   20
      Top             =   3840
      Width           =   975
   End
   Begin VB.TextBox txtAmount 
      Height          =   285
      Index           =   3
      Left            =   2400
      TabIndex        =   19
      Text            =   "0"
      Top             =   2880
      Width           =   735
   End
   Begin VB.ComboBox cboChemical 
      Height          =   315
      Index           =   3
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   18
      Top             =   2880
      Width           =   2175
   End
   Begin VB.TextBox txtAmount 
      Height          =   285
      Index           =   2
      Left            =   2400
      TabIndex        =   17
      Text            =   "0"
      Top             =   2520
      Width           =   735
   End
   Begin VB.ComboBox cboChemical 
      Height          =   315
      Index           =   2
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   16
      Top             =   2520
      Width           =   2175
   End
   Begin VB.TextBox txtAmount 
      Height          =   285
      Index           =   1
      Left            =   2400
      TabIndex        =   15
      Text            =   "0"
      Top             =   2160
      Width           =   735
   End
   Begin VB.ComboBox cboChemical 
      Height          =   315
      Index           =   1
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   14
      Top             =   2160
      Width           =   2175
   End
   Begin VB.TextBox txtAmount 
      Height          =   285
      Index           =   0
      Left            =   2400
      TabIndex        =   13
      Text            =   "0"
      Top             =   1800
      Width           =   735
   End
   Begin VB.ComboBox cboChemical 
      Height          =   315
      Index           =   0
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   11
      Top             =   1800
      Width           =   2175
   End
   Begin VB.TextBox txtIntensity 
      Height          =   285
      Left            =   1800
      TabIndex        =   9
      Text            =   "0"
      Top             =   1080
      Width           =   615
   End
   Begin VB.TextBox txtInput 
      Height          =   285
      Left            =   960
      TabIndex        =   7
      Text            =   "255"
      Top             =   1080
      Width           =   615
   End
   Begin VB.ComboBox cboRange 
      Height          =   315
      ItemData        =   "Stim.frx":0041
      Left            =   120
      List            =   "Stim.frx":0051
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   360
      Width           =   1095
   End
   Begin VB.Label lblRange 
      AutoSize        =   -1  'True
      Caption         =   "Range"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   480
   End
   Begin VB.Label lblSignificance 
      AutoSize        =   -1  'True
      Caption         =   "Signif."
      Height          =   195
      Left            =   120
      TabIndex        =   4
      Top             =   840
      Width           =   435
   End
   Begin VB.Label lblAmount 
      AutoSize        =   -1  'True
      Caption         =   "Amount"
      Height          =   195
      Left            =   2400
      TabIndex        =   12
      Top             =   1560
      Width           =   540
   End
   Begin VB.Label lblChemical 
      AutoSize        =   -1  'True
      Caption         =   "Chemical"
      Height          =   195
      Left            =   120
      TabIndex        =   10
      Top             =   1560
      Width           =   645
   End
   Begin VB.Label lblIntensity 
      AutoSize        =   -1  'True
      Caption         =   "Intensity"
      Height          =   195
      Left            =   1800
      TabIndex        =   8
      Top             =   840
      Width           =   585
   End
   Begin VB.Label lblInput 
      AutoSize        =   -1  'True
      Caption         =   "Input"
      Height          =   195
      Left            =   960
      TabIndex        =   6
      Top             =   840
      Width           =   360
   End
   Begin VB.Label lblTarget 
      AutoSize        =   -1  'True
      Caption         =   "Target"
      Height          =   195
      Left            =   1440
      TabIndex        =   2
      Top             =   120
      Width           =   465
   End
End
Attribute VB_Name = "frmStim"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_bCancel As Boolean
Private m_nChemicalCount As Integer
Private m_aChemicalNames() As String
Private m_sResult As String

Public Function Display() As String
    Display = ""
    
    m_bCancel = True
    
    Show vbModal
    
    If Not m_bCancel Then
        Display = m_sResult
    End If
End Function

Private Sub LoadChemicalNames(ByVal sFilename As String)
    Dim nFile As Integer
    Dim I As Integer
    Dim nLen As Byte
    Dim sName As String
    
    m_nChemicalCount = 0
    
    If Dir(sFilename) = "" Then
        MsgBox "Could not load chemical list from '" & sFilename & "'.", vbExclamation Or vbOKOnly
        Exit Sub
    End If
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Open sFilename For Binary Access Read As nFile
    
    If Err <> 0 Then
        MsgBox "Could not load chemical list from '" & sFilename & "'.", vbExclamation Or vbOKOnly
        Exit Sub
    End If
    
    Get nFile, , m_nChemicalCount
    
    ReDim m_aChemicalNames(0 To m_nChemicalCount - 1)
    
    For I = 0 To m_nChemicalCount - 1
        Get nFile, , nLen
        If nLen > 0 Then
            sName = String(nLen, " ")
            Get nFile, , sName
            m_aChemicalNames(I) = sName
        Else
            m_aChemicalNames(I) = "(Empty)"
        End If
    Next
    
    Close nFile
End Sub

Private Sub cboRange_Click()
    If cboRange.Text = "writ" Then
        lblTarget.Enabled = True
        cboTarget.Enabled = True
    Else
        lblTarget.Enabled = False
        cboTarget.Enabled = False
    End If
End Sub

Private Sub chkC2Chemicals_Click()
    If chkC2Chemicals.Value = vbUnchecked Then
        LoadChemicalNames sC1MainPath & "allchemicals.str"
    ElseIf chkC2Chemicals.Value = vbChecked Then
        LoadChemicalNames sC2MainPath & "allchemicals.str"
    End If
End Sub

Private Sub cmdInsert_Click()
    Dim I As Integer
    
    If cboTarget.Enabled And Trim(cboTarget.Text) = "" Then
        MsgBox "Please enter a valid target.", vbExclamation
        cboTarget.SetFocus
        Exit Sub
    End If
    
    For I = 0 To 3
        If Trim(txtAmount(I).Text) = "" Then
            txtAmount(I).Text = "0"
        End If
    Next
    
    If Trim(txtInput.Text) = "" Then
        txtInput.Text = "0"
    End If
    
    If Trim(txtIntensity.Text) = "" Then
        txtIntensity.Text = "0"
    End If
    
    If Trim(txtSignificance.Text) = "" Then
        txtSignificance.Text = "0"
    End If
    
    m_sResult = "stim " & cboRange.Text
    
    If cboRange.Text = "writ" Then
        m_sResult = m_sResult & " " & cboTarget.Text
    End If
    
    m_sResult = m_sResult & " " & txtSignificance.Text & " " & txtInput.Text & " " & txtIntensity.Text & " 0"
    
    For I = 0 To 3
        m_sResult = m_sResult & " " & cboChemical(I).ListIndex & " " & txtAmount(I)
    Next
    
    m_bCancel = False
    
    Unload Me
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    If KeyAscii = 27 Then
        Unload Me
    End If
End Sub

Private Sub Form_Load()
    Dim I As Integer
    
    If tCurrentCOB.COBType = ctcCreatures1 And g_bC1Installed Then
        chkC2Chemicals.Value = vbUnchecked
    ElseIf tCurrentCOB.COBType = ctcCreatures2 And g_bC2Installed Then
        chkC2Chemicals.Value = vbChecked
    End If
    
    If m_nChemicalCount > 0 Then
        For I = 0 To m_nChemicalCount - 1
            cboChemical(0).AddItem CStr(I) & " - " & m_aChemicalNames(I)
            cboChemical(1).AddItem CStr(I) & " - " & m_aChemicalNames(I)
            cboChemical(2).AddItem CStr(I) & " - " & m_aChemicalNames(I)
            cboChemical(3).AddItem CStr(I) & " - " & m_aChemicalNames(I)
        Next
    Else
        For I = 0 To 255
            cboChemical(0).AddItem CStr(I)
            cboChemical(1).AddItem CStr(I)
            cboChemical(2).AddItem CStr(I)
            cboChemical(3).AddItem CStr(I)
        Next
    End If
    
    cboChemical(0).ListIndex = 0
    cboChemical(1).ListIndex = 0
    cboChemical(2).ListIndex = 0
    cboChemical(3).ListIndex = 0
    
    cboRange.ListIndex = 3
    
    If Not g_bC1Installed Or Not g_bC2Installed Then
        chkC2Chemicals.Enabled = False
    End If
End Sub

Private Sub txtAmount_GotFocus(Index As Integer)
    SelectText txtAmount(Index)
End Sub

Private Sub txtAmount_KeyPress(Index As Integer, KeyAscii As Integer)
    CheckNumeric KeyAscii
End Sub

Private Sub txtInput_GotFocus()
    SelectText txtInput
End Sub

Private Sub txtInput_KeyPress(KeyAscii As Integer)
    CheckNumeric KeyAscii
End Sub

Private Sub txtIntensity_GotFocus()
    SelectText txtIntensity
End Sub

Private Sub txtIntensity_KeyPress(KeyAscii As Integer)
    CheckNumeric KeyAscii
End Sub

Private Sub txtSignificance_GotFocus()
    SelectText txtSignificance
End Sub

Private Sub cboTarget_GotFocus()
    SelectText cboTarget
End Sub

Private Sub txtSignificance_KeyPress(KeyAscii As Integer)
    CheckNumeric KeyAscii
End Sub

