VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmScriptEditor 
   Caption         =   "Script Editor"
   ClientHeight    =   4695
   ClientLeft      =   825
   ClientTop       =   1380
   ClientWidth     =   6375
   Icon            =   "ScriptEditor.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   4695
   ScaleWidth      =   6375
   Begin MSComDlg.CommonDialog ctlScriptCommonDialog 
      Left            =   5640
      Top             =   3960
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327681
   End
   Begin VB.TextBox txtScript 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4695
      HideSelection   =   0   'False
      Left            =   0
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   0
      Width           =   6375
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileSave 
         Caption         =   "Save and Close"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFileSeparator1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileClose 
         Caption         =   "Close"
         Shortcut        =   ^W
      End
   End
   Begin VB.Menu mnuTools 
      Caption         =   "&Tools"
      Begin VB.Menu mnuToolsOptions 
         Caption         =   "&Options..."
      End
      Begin VB.Menu mnuToolsSeparator1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuToolsAttributes 
         Caption         =   "A&ttributes..."
         Shortcut        =   ^T
      End
      Begin VB.Menu mnuToolsBehaviour 
         Caption         =   "&Behaviour..."
         Shortcut        =   ^B
      End
      Begin VB.Menu mnuToolsClass 
         Caption         =   "C&lass..."
         Shortcut        =   ^L
      End
      Begin VB.Menu mnuToolsStim 
         Caption         =   "St&im..."
         Shortcut        =   ^I
      End
   End
End
Attribute VB_Name = "frmScriptEditor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_nFormWidthDiff As Long
Private m_nFormHeightDiff As Long
Private m_nIndentBy As Long
Private m_bIgnoreTab As Boolean

Private bClose As Boolean
Private bSave As Boolean
Private bChanged As Boolean

Private sSavedScript As String

Public Function Display(sCaption As String, sScript As String) As Boolean
    Display = False
    
    Caption = sCaption
    txtScript.Text = sScript
    
    bSave = False
    bChanged = False
    
    Show vbModal, frmBoBCoB
    
    If bSave Then
        sScript = sSavedScript
        bSave = False
        bChanged = False
        Display = True
    End If
End Function

Private Sub ContextHelp()
    With ctlScriptCommonDialog
        .HelpKey = HelpStringSearch(txtScript)
        .HelpCommand = cdlHelpPartialKey
        .ShowHelp
    End With
End Sub

Private Sub Form_Load()
    If nScriptEditorLeft >= 0 Then
        Me.Left = nScriptEditorLeft
        Me.Top = nScriptEditorTop
        Me.Width = nScriptEditorWidth
        Me.Height = nScriptEditorHeight
    Else
        Me.Left = frmBoBCoB.Left + (frmBoBCoB.Width / 2) - (Me.Width / 2)
        Me.Top = frmBoBCoB.Top + (frmBoBCoB.Height / 2) - (Me.Height / 2)
    End If
    
    If bScriptEditorMaximised Then
        Me.WindowState = vbMaximized
    End If
    
    m_nFormWidthDiff = ScaleWidth - txtScript.Width
    m_nFormHeightDiff = ScaleHeight - txtScript.Height
    
    txtScript.FontName = sScriptEditorFontName
    txtScript.FontSize = nScriptEditorFontSize
    
    TextBoxSetTabSize txtScript, nScriptEditorTabSize
    txtScript.Refresh
    
    ctlScriptCommonDialog.HelpFile = frmBoBCoB.ctlCommonDialog.HelpFile
    
    mnuToolsBehaviour.Enabled = (tCurrentCOB.COBType = ctcCreatures2)
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    Dim nYesNoCancel As Integer
    
    If Not bSave And bChanged Then
        nYesNoCancel = MsgBox("Save changes to this script?", vbYesNoCancel Or vbQuestion)
        
        If nYesNoCancel = vbYes Then
            bSave = True
        ElseIf nYesNoCancel = vbNo Then
            bSave = False
            bChanged = False
        ElseIf nYesNoCancel = vbCancel Then
            Cancel = 1
            Exit Sub
        End If
    End If
    
    If bSave Then
        sSavedScript = txtScript.Text
    End If
End Sub

Private Sub Form_Resize()
    If Me.WindowState <> vbMinimized Then
        If ScaleWidth - m_nFormWidthDiff > 0 Then
            txtScript.Width = ScaleWidth - m_nFormWidthDiff
        End If
        
        If ScaleHeight - m_nFormHeightDiff > 0 Then
            txtScript.Height = ScaleHeight - m_nFormHeightDiff
        End If
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    bScriptEditorMaximised = False
    If Me.WindowState = vbMinimized Then
        Me.WindowState = vbNormal
    ElseIf Me.WindowState = vbMaximized Then
        bScriptEditorMaximised = True
    End If
    nScriptEditorLeft = Me.Left
    nScriptEditorTop = Me.Top
    nScriptEditorWidth = Me.Width
    nScriptEditorHeight = Me.Height
End Sub

Private Sub mnuFileClose_Click()
    Unload Me
End Sub

Private Sub mnuFileSave_Click()
    bSave = True
    Unload Me
End Sub

Private Sub mnuToolsAttributes_Click()
    Dim nAttribute As Integer
    
    nAttribute = frmAttributes.Display
    
    If nAttribute >= 0 Then
        txtScript.SelText = CStr(nAttribute)
    End If
End Sub

Private Sub mnuToolsBehaviour_Click()
    Dim nClick As Integer
    Dim nTouch As Integer
    
    If frmBehaviour.Display(nClick, nTouch) Then
        txtScript.SelText = CStr(nClick) & " " & CStr(nTouch)
    End If
End Sub

Private Sub mnuToolsClass_Click()
    Dim nClass As Long
    
    nClass = frmClass.Display
    
    If nClass >= 0 Then
        txtScript.SelText = CStr(nClass)
    End If
End Sub

Private Sub mnuToolsOptions_Click()
    If frmScriptEditorOptions.Display(nScriptEditorTabSize, sScriptEditorFontName, nScriptEditorFontSize) Then
        txtScript.FontName = sScriptEditorFontName
        txtScript.FontSize = nScriptEditorFontSize
        TextBoxSetTabSize txtScript, nScriptEditorTabSize
    End If
End Sub

Private Sub mnuToolsStim_Click()
    Dim sResult As String
    
    sResult = frmStim.Display
    
    If sResult <> "" Then
        txtScript.SelText = sResult
    End If
End Sub

Private Sub txtScript_Change()
    bChanged = True
End Sub

Private Sub txtScript_KeyDown(KeyCode As Integer, Shift As Integer)
    Dim nLine As Long
    Dim nLineStart As Long
    Dim nLastLine As Long
    Dim nOldSelStart As Long
    Dim nOldSelLength As Long
    
    If KeyCode = vbKeyF1 And Shift = 0 Then
        ContextHelp
    ElseIf KeyCode = vbKeyReturn And Shift = 0 Then
        nLine = TextBoxLineFromChar(txtScript, txtScript.SelStart)
        nLineStart = TextBoxLineIndex(txtScript, nLine)
        If Mid(txtScript.Text, nLineStart + 1, 1) <> vbTab Then
            Exit Sub
        End If
        
        m_nIndentBy = 1
        Do While Mid(txtScript.Text, nLineStart + m_nIndentBy + 1, 1) = vbTab
            m_nIndentBy = m_nIndentBy + 1
        Loop
    ElseIf KeyCode = vbKeyTab And txtScript.SelLength > 0 Then
        nOldSelStart = txtScript.SelStart
        nOldSelLength = txtScript.SelLength
        
        nLine = TextBoxLineFromChar(txtScript, nOldSelStart)
        nLineStart = TextBoxLineIndex(txtScript, nLine)
        If nLineStart < nOldSelStart Then
            nOldSelLength = nOldSelLength + (nOldSelStart - nLineStart)
            nOldSelStart = nLineStart
        End If
        
        nLastLine = TextBoxLineFromChar(txtScript, nOldSelStart + nOldSelLength)
        nLineStart = TextBoxLineIndex(txtScript, nLastLine)
        If nLineStart < nOldSelStart + nOldSelLength Then
            nLastLine = nLastLine + 1
            If TextBoxLineIndex(txtScript, nLastLine) > 0 Then
                nOldSelLength = TextBoxLineIndex(txtScript, nLastLine) - nOldSelStart
            Else
                nOldSelLength = Len(txtScript.Text) - nOldSelStart
            End If
        End If
        
        Do While nLine < nLastLine
            nLineStart = TextBoxLineIndex(txtScript, nLine)
            txtScript.SelStart = nLineStart
            If Shift = vbShiftMask Then
                txtScript.SelLength = 1
                If txtScript.SelText = vbTab Then
                    txtScript.SelText = ""
                    nOldSelLength = nOldSelLength - 1
                Else
                    txtScript.SelLength = nScriptEditorTabSize
                    If txtScript.SelText = "    " Then
                        txtScript.SelText = ""
                        nOldSelLength = nOldSelLength - 4
                    Else
                        txtScript.SelLength = 1
                        Do While txtScript.SelText = " "
                            txtScript.SelText = ""
                            nOldSelLength = nOldSelLength - 1
                            txtScript.SelLength = 1
                        Loop
                    End If
                End If
            Else
                txtScript.SelLength = 0
                txtScript.SelText = vbTab
                nOldSelLength = nOldSelLength + 1
            End If
            nLine = nLine + 1
        Loop
        
        txtScript.SelStart = nOldSelStart
        txtScript.SelLength = nOldSelLength
        KeyCode = 0
        m_bIgnoreTab = True
    ElseIf KeyCode = vbKeyA And Shift = vbCtrlMask Then
        txtScript.SelStart = 0
        txtScript.SelLength = Len(txtScript.Text)
    End If
End Sub

Private Sub txtScript_KeyPress(KeyAscii As Integer)
    If m_bIgnoreTab And KeyAscii = 9 Then
        KeyAscii = 0
        m_bIgnoreTab = False
    End If
End Sub

Private Sub txtScript_KeyUp(KeyCode As Integer, Shift As Integer)
    If KeyCode = vbKeyReturn And Shift = 0 And m_nIndentBy > 0 Then
        txtScript.SelText = String(m_nIndentBy, Asc(vbTab))
        m_nIndentBy = 0
    End If
End Sub
