VERSION 5.00
Object = "{BDC217C8-ED16-11CD-956C-0000C04E4C0A}#1.1#0"; "TABCTL32.OCX"
Begin VB.Form frmPreferences 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Preferences"
   ClientHeight    =   3255
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4695
   Icon            =   "Preferences.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3255
   ScaleWidth      =   4695
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   WhatsThisButton =   -1  'True
   WhatsThisHelp   =   -1  'True
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   2280
      TabIndex        =   19
      Top             =   2760
      Width           =   1095
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   3480
      TabIndex        =   20
      Top             =   2760
      Width           =   1095
   End
   Begin TabDlg.SSTab tabPreferences 
      Height          =   2415
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4455
      _ExtentX        =   7858
      _ExtentY        =   4260
      _Version        =   327681
      Style           =   1
      TabsPerRow      =   4
      TabHeight       =   520
      ForeColor       =   -2147483630
      TabCaption(0)   =   "File Associations"
      TabPicture(0)   =   "Preferences.frx":000C
      Tab(0).ControlEnabled=   -1  'True
      Tab(0).Control(0)=   "cmdSetAll"
      Tab(0).Control(0).Enabled=   0   'False
      Tab(0).Control(1)=   "cmdClearAll"
      Tab(0).Control(1).Enabled=   0   'False
      Tab(0).Control(2)=   "fraAssociations"
      Tab(0).Control(2).Enabled=   0   'False
      Tab(0).ControlCount=   3
      TabCaption(1)   =   "Cheats"
      TabPicture(1)   =   "Preferences.frx":0028
      Tab(1).ControlEnabled=   0   'False
      Tab(1).Control(0)=   "fraC1Cheats"
      Tab(1).Control(1)=   "fraC2Cheats"
      Tab(1).ControlCount=   2
      TabCaption(2)   =   "Defaults"
      TabPicture(2)   =   "Preferences.frx":0044
      Tab(2).ControlEnabled=   0   'False
      Tab(2).Control(0)=   "fraDefaultVersion"
      Tab(2).Control(1)=   "cmdBrowseForSaveFolder"
      Tab(2).Control(2)=   "cmdBrowseForLoadFolder"
      Tab(2).Control(3)=   "txtLoadFolder"
      Tab(2).Control(4)=   "txtSaveFolder"
      Tab(2).Control(5)=   "lblSaveFolder"
      Tab(2).Control(6)=   "lblLoadFolder"
      Tab(2).ControlCount=   7
      Begin VB.Frame fraDefaultVersion 
         Caption         =   "Use defaults for"
         Height          =   855
         Left            =   -74880
         TabIndex        =   27
         Top             =   1320
         Width           =   1455
         Begin VB.OptionButton optVersionCreatures2 
            Caption         =   "Creatures 2"
            Height          =   255
            Left            =   120
            TabIndex        =   29
            Top             =   480
            Width           =   1215
         End
         Begin VB.OptionButton optVersionCreatures1 
            Caption         =   "Creatures 1"
            Height          =   255
            Left            =   120
            TabIndex        =   28
            Top             =   240
            Width           =   1215
         End
      End
      Begin VB.CommandButton cmdBrowseForSaveFolder 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Symbol"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   -70920
         TabIndex        =   24
         Top             =   855
         Width           =   255
      End
      Begin VB.CommandButton cmdBrowseForLoadFolder 
         Caption         =   ""
         BeginProperty Font 
            Name            =   "Symbol"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   -70920
         TabIndex        =   23
         Top             =   495
         Width           =   255
      End
      Begin VB.TextBox txtLoadFolder 
         Height          =   285
         Left            =   -73920
         TabIndex        =   22
         Top             =   480
         Width           =   2895
      End
      Begin VB.TextBox txtSaveFolder 
         Height          =   285
         Left            =   -73920
         TabIndex        =   21
         Top             =   840
         Width           =   2895
      End
      Begin VB.Frame fraC2Cheats 
         Caption         =   "C&2 Cheats"
         Height          =   1575
         Left            =   -72720
         TabIndex        =   14
         Top             =   360
         Width           =   2055
         Begin VB.CheckBox chkDisableCDCheck 
            Caption         =   "Disable CD Check"
            Height          =   255
            Left            =   120
            TabIndex        =   18
            Top             =   1200
            Width           =   1815
         End
         Begin VB.OptionButton optC2CheatCoconutGrove 
            Caption         =   "Coconut Grove"
            Height          =   255
            Left            =   120
            TabIndex        =   16
            Top             =   480
            Width           =   1455
         End
         Begin VB.OptionButton optC2CheatBlueberry 
            Caption         =   "Blueberry4$"
            Height          =   255
            Left            =   120
            TabIndex        =   17
            Top             =   720
            Width           =   1455
         End
         Begin VB.OptionButton optC2CheatNone 
            Caption         =   "None"
            Height          =   255
            Left            =   120
            TabIndex        =   15
            Top             =   240
            Width           =   1455
         End
      End
      Begin VB.Frame fraC1Cheats 
         Caption         =   "C&1 Cheats"
         Height          =   1575
         Left            =   -74880
         TabIndex        =   8
         Top             =   360
         Width           =   2055
         Begin VB.OptionButton optC1CheatSkirty 
            Caption         =   "Skirty"
            Height          =   255
            Left            =   120
            TabIndex        =   13
            Top             =   1200
            WhatsThisHelpID =   5
            Width           =   975
         End
         Begin VB.OptionButton optC1CheatCheese 
            Caption         =   "Cheese"
            Height          =   255
            Left            =   120
            TabIndex        =   10
            Top             =   480
            WhatsThisHelpID =   2
            Width           =   975
         End
         Begin VB.OptionButton optC1CheatDarwin 
            Caption         =   "Darwin"
            Height          =   255
            Left            =   120
            TabIndex        =   11
            Top             =   720
            WhatsThisHelpID =   3
            Width           =   975
         End
         Begin VB.OptionButton optC1CheatDoctor 
            Caption         =   "Doctor"
            Height          =   255
            Left            =   120
            TabIndex        =   12
            Top             =   960
            WhatsThisHelpID =   4
            Width           =   975
         End
         Begin VB.OptionButton optC1CheatNone 
            Caption         =   "None"
            Height          =   255
            Left            =   120
            TabIndex        =   9
            Top             =   240
            WhatsThisHelpID =   1
            Width           =   975
         End
      End
      Begin VB.Frame fraAssociations 
         Caption         =   "&Associations"
         Height          =   1335
         Left            =   120
         TabIndex        =   1
         Top             =   360
         Width           =   3015
         Begin VB.CheckBox chkS16 
            Caption         =   "S16  - Creatures2 Sprite File"
            Height          =   255
            Left            =   120
            TabIndex        =   5
            Top             =   960
            Width           =   2775
         End
         Begin VB.CheckBox chkSPR 
            Caption         =   "SPR - Creatures Sprite File"
            Height          =   255
            Left            =   120
            TabIndex        =   4
            Top             =   720
            Width           =   2775
         End
         Begin VB.CheckBox chkRCB 
            Caption         =   "RCB - Creatures Object Remover"
            Height          =   255
            Left            =   120
            TabIndex        =   3
            Top             =   480
            Width           =   2775
         End
         Begin VB.CheckBox chkCOB 
            Caption         =   "COB - Creatures Object File"
            Height          =   255
            Left            =   120
            TabIndex        =   2
            Top             =   240
            Width           =   2775
         End
      End
      Begin VB.CommandButton cmdClearAll 
         Caption         =   "C&lear All"
         Height          =   375
         Left            =   3240
         TabIndex        =   7
         Top             =   960
         Width           =   1095
      End
      Begin VB.CommandButton cmdSetAll 
         Caption         =   "&Set All"
         Height          =   375
         Left            =   3240
         TabIndex        =   6
         Top             =   480
         Width           =   1095
      End
      Begin VB.Label lblSaveFolder 
         AutoSize        =   -1  'True
         Caption         =   "&Save folder:"
         Height          =   195
         Left            =   -74880
         TabIndex        =   26
         Top             =   885
         Width           =   855
      End
      Begin VB.Label lblLoadFolder 
         AutoSize        =   -1  'True
         Caption         =   "&Load folder:"
         Height          =   195
         Left            =   -74880
         TabIndex        =   25
         Top             =   525
         Width           =   840
      End
   End
End
Attribute VB_Name = "frmPreferences"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub LoadFileAssociationsTab()
    Dim oFileType As New FileType
    
    oFileType.Load "cob"
    If oFileType.Name = "BoBCoB.COB" Then
        chkCOB.Value = vbChecked
    End If
    
    oFileType.Load "rcb"
    If oFileType.Name = "BoBCoB.RCB" Then
        chkRCB.Value = vbChecked
    End If
    
    oFileType.Load "spr"
    If oFileType.Name = "BoBCoB.SPR" Then
        chkSPR.Value = vbChecked
    End If
    
    oFileType.Load "s16"
    If oFileType.Name = "BoBCoB.S16" Then
        chkS16.Value = vbChecked
    End If
End Sub

Private Sub LoadCheatsTab()
    Dim oRegKey As New RegistryKey
    Dim sCheat As String
    Dim sCreaturesBuildID As String
    Dim sDisableCDCheck As String

    If oRegKey.OpenKey(HKEY_CURRENT_USER, sCreatures1RegistryKey) Then
        If oRegKey.GetKeyValue("Privileges", REG_SZ, sCheat) Then
            Select Case LCase(sCheat)
                Case "user"
                    optC1CheatNone.Value = True
                
                Case "cheese"
                    optC1CheatCheese.Value = True
        
                Case "darwin"
                    optC1CheatDarwin.Value = True
        
                Case "doctor"
                    optC1CheatDoctor.Value = True
                    
                Case "skirty"
                    optC1CheatSkirty.Value = True
            End Select
        End If
        
        oRegKey.CloseKey
        
        If oRegKey.OpenKey(HKEY_LOCAL_MACHINE, sCreatures1PatchRegistryKey, False) Then
            If Not oRegKey.GetKeyValue("Build ID", REG_SZ, sCreaturesBuildID) Then
                sCreaturesBuildID = "1.0.0"
            End If
            
            oRegKey.CloseKey
        Else
            sCreaturesBuildID = "1.0.0"
        End If
        
        If sCreaturesBuildID = "1.0.2" Or sCreaturesBuildID = "1.0.3" Or sCreaturesBuildID = "1.0.4" Then
            optC1CheatCheese.Enabled = False
            optC1CheatDarwin.Enabled = False
        Else
            optC1CheatDoctor.Enabled = False
            optC1CheatSkirty.Enabled = False
        End If
    Else
        optC1CheatNone.Enabled = False
        optC1CheatCheese.Enabled = False
        optC1CheatDarwin.Enabled = False
        optC1CheatDoctor.Enabled = False
        optC1CheatSkirty.Enabled = False
    End If
    
    If oRegKey.OpenKey(HKEY_CURRENT_USER, sCreatures2RegistryKey) Then
        If oRegKey.GetKeyValue("Privileges", REG_SZ, sCheat) Then
            Select Case LCase(sCheat)
                Case "user"
                    optC2CheatNone.Value = True
                
                Case "the coconut grove"
                    optC2CheatCoconutGrove.Value = True
        
                Case "blueberry4$"
                    optC2CheatBlueberry.Value = True
            End Select
        End If
        
        'oRegKey.GetKeyValue "Build ID", REG_SZ, sCreaturesBuildID, True
        
        oRegKey.CloseKey
    Else
        optC2CheatNone.Enabled = False
        optC2CheatCoconutGrove.Enabled = False
        optC2CheatBlueberry.Enabled = False
    End If
    
    If oRegKey.OpenKey(HKEY_LOCAL_MACHINE, sCreatures2RegistryKey) Then
        If Not oRegKey.GetKeyValue("No CD-ROM needed", REG_SZ, sDisableCDCheck) Then
            chkDisableCDCheck.Value = vbUnchecked
        Else
            chkDisableCDCheck.Value = vbChecked
        End If
        
        oRegKey.CloseKey
    End If
End Sub

Private Sub LoadDefaultsTab()
    txtLoadFolder.Text = g_sDefaultLoadFolder
    txtSaveFolder.Text = g_sDefaultSaveFolder
    
    Select Case nCreaturesVersion
        Case cvcCreatures1
            optVersionCreatures1.Value = True
            
        Case cvcCreatures2
            optVersionCreatures2.Value = True
    End Select
End Sub

Private Function SaveFileAssociationsTab() As Boolean
    Dim nRes As Long
    Dim hKey As Long
    Dim sValue As String
    Dim oFileType As FileType
    
    SaveFileAssociationsTab = False
    
    If chkCOB.Value = vbChecked Then
        Set oFileType = New FileType
        oFileType.Extension = "cob"
        oFileType.Name = "BoBCoB.COB"
        oFileType.Description = "Creatures Object File"
        oFileType.DefaultIcon = App.Path & "\" & App.EXEName & ".exe,0"
        oFileType.AddShellCommand "Open", App.Path & "\" & App.EXEName & ".exe -loadcob %1", True
        oFileType.Save
    Else
        Set oFileType = New FileType
        oFileType.Delete "cob", "BoBCoB.COB"
    End If
    
    If chkRCB.Value = vbChecked Then
        Set oFileType = New FileType
        oFileType.Extension = "rcb"
        oFileType.Name = "BoBCoB.RCB"
        oFileType.Description = "Creatures Object Remover"
        oFileType.DefaultIcon = App.Path & "\" & App.EXEName & ".exe,0"
        oFileType.AddShellCommand "Open", App.Path & "\" & App.EXEName & ".exe -loadcob %1", True
        oFileType.Save
    Else
        Set oFileType = New FileType
        oFileType.Delete "rcb", "BoBCoB.RCB"
    End If
    
    If chkSPR.Value = vbChecked Then
        Set oFileType = New FileType
        oFileType.Extension = "spr"
        oFileType.Name = "BoBCoB.SPR"
        oFileType.Description = "Creatures Sprite File"
        oFileType.DefaultIcon = App.Path & "\SpriteEditor.exe,0"
        oFileType.AddShellCommand "Open", App.Path & "\SpriteEditor.exe -loadspr %1", True
        oFileType.Save
    Else
        Set oFileType = New FileType
        oFileType.Delete "spr", "BoBCoB.SPR"
    End If
    
    If chkS16.Value = vbChecked Then
        Set oFileType = New FileType
        oFileType.Extension = "s16"
        oFileType.Name = "BoBCoB.S16"
        oFileType.Description = "Creatures2 Sprite File"
        oFileType.DefaultIcon = App.Path & "\SpriteEditor.exe,0"
        oFileType.AddShellCommand "Open", App.Path & "\SpriteEditor.exe -loads16 %1", True
        oFileType.Save
    Else
        Set oFileType = New FileType
        oFileType.Delete "s16", "BoBCoB.S16"
    End If
    
    SaveFileAssociationsTab = True
End Function

Private Function SaveCheatsTab() As Boolean
    Dim oRegKey As New RegistryKey
    
    SaveCheatsTab = False
    
    If oRegKey.OpenKey(HKEY_CURRENT_USER, sCreatures1RegistryKey) Then
        If optC1CheatNone.Value = True Then
            oRegKey.SetKeyValue "Privileges", REG_SZ, "user"
        ElseIf optC1CheatCheese.Value = True Then
            oRegKey.SetKeyValue "Privileges", REG_SZ, "cheese"
        ElseIf optC1CheatDarwin.Value = True Then
            oRegKey.SetKeyValue "Privileges", REG_SZ, "darwin"
        ElseIf optC1CheatDoctor.Value = True Then
            oRegKey.SetKeyValue "Privileges", REG_SZ, "doctor"
        ElseIf optC1CheatSkirty.Value = True Then
            oRegKey.SetKeyValue "Privileges", REG_SZ, "skirty"
        End If
        
        oRegKey.CloseKey
    End If
    
    If oRegKey.OpenKey(HKEY_CURRENT_USER, sCreatures2RegistryKey) Then
        If optC2CheatNone.Value = True Then
            oRegKey.SetKeyValue "Privileges", REG_SZ, "user"
        ElseIf optC2CheatCoconutGrove.Value = True Then
            oRegKey.SetKeyValue "Privileges", REG_SZ, "the coconut grove"
        ElseIf optC2CheatBlueberry.Value = True Then
            oRegKey.SetKeyValue "Privileges", REG_SZ, "blueberry4$"
        End If
        
        oRegKey.CloseKey
    End If
    
    If oRegKey.OpenKey(HKEY_LOCAL_MACHINE, sCreatures2RegistryKey) Then
        If chkDisableCDCheck.Value = vbChecked Then
            oRegKey.SetKeyValue "No CD-ROM needed", REG_SZ, ""
        Else
            oRegKey.DeleteKeyValue "No CD-ROM needed"
        End If
        
        oRegKey.CloseKey
    End If
    
    SaveCheatsTab = True
End Function

Private Function SaveDefaultsTab() As Boolean
    Dim nAttr As Integer
    
    SaveDefaultsTab = False
    
    txtLoadFolder.Text = Trim(txtLoadFolder.Text)
    txtSaveFolder.Text = Trim(txtSaveFolder.Text)
    
    If txtLoadFolder.Text <> "" Then
        On Error Resume Next
        
        nAttr = GetAttr(txtLoadFolder.Text)
        
        If (nAttr And vbDirectory) = 0 Or Err <> 0 Then
            Err.Clear
            MsgBox txtLoadFolder.Text & " does not exist or is not a folder.", vbOKOnly Or vbExclamation
            txtLoadFolder.SetFocus
            Exit Function
        End If
        
        On Error GoTo 0
    End If
    
    g_sDefaultLoadFolder = txtLoadFolder.Text
    
    If txtSaveFolder.Text <> "" Then
        On Error Resume Next
        
        nAttr = GetAttr(txtSaveFolder.Text)
        
        If (nAttr And vbDirectory) = 0 Or Err <> 0 Then
            Err.Clear
            MsgBox txtSaveFolder.Text & " does not exist or is not a folder.", vbOKOnly Or vbExclamation
            txtSaveFolder.SetFocus
            Exit Function
        End If
        
        On Error GoTo 0
    End If
    
    g_sDefaultSaveFolder = txtSaveFolder.Text
    
    If optVersionCreatures1.Value Then
        nCreaturesVersion = cvcCreatures1
    ElseIf optVersionCreatures2.Value Then
        nCreaturesVersion = cvcCreatures2
    End If
    
    SaveDefaultsTab = True
End Function

Private Sub cmdBrowseForLoadFolder_Click()
    Dim sFolder As String * 512
    Dim nRet As Long
    
    sFolder = txtLoadFolder.Text
    nRet = BrowseForFolder(Me.hwnd, "Select default folder from which to load COBs:", sFolder)
    
    If nRet Then
        txtLoadFolder.Text = Trim(sFolder)
    End If
End Sub

Private Sub cmdBrowseForSaveFolder_Click()
    Dim sFolder As String * 512
    Dim nRet As Long
    
    sFolder = txtSaveFolder.Text
    nRet = BrowseForFolder(Me.hwnd, "Select default folder in which to save COBs:", sFolder)
    
    If nRet Then
        txtSaveFolder.Text = Trim(sFolder)
    End If
End Sub

Private Sub cmdCancel_Click()
    Unload Me
End Sub

Private Sub cmdClearAll_Click()
    chkCOB.Value = vbUnchecked
    chkRCB.Value = vbUnchecked
    chkSPR.Value = vbUnchecked
    chkS16.Value = vbUnchecked
End Sub

Private Sub cmdOK_Click()
    If Not SaveFileAssociationsTab Then
        Exit Sub
    End If
    
    If Not SaveCheatsTab Then
        Exit Sub
    End If
    
    If Not SaveDefaultsTab Then
        Exit Sub
    End If
    
    Unload Me
End Sub

Private Sub cmdSetAll_Click()
    chkCOB.Value = vbChecked
    chkRCB.Value = vbChecked
    chkSPR.Value = vbChecked
    chkS16.Value = vbChecked
End Sub

Private Sub Form_Load()
    LoadFileAssociationsTab
    LoadCheatsTab
    LoadDefaultsTab
End Sub

