Attribute VB_Name = "modCreaturesCommunication"
Option Explicit

Private m_oSFC As Object
Private m_eConnectedVersion As CreaturesVersionConstants

Private m_bCreatures2WindowFound As Boolean

Declare Function EnumWindows Lib "user32" (ByVal lpEnumFunc As Long, ByVal lParam As Long) As Long
Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long

Public Function ConnectCreatures(eCreaturesVersion As CreaturesVersionConstants) As Boolean
    ConnectCreatures = False
    
    'If eCreaturesVersion <> m_eConnectedVersion Then
        DisconnectCreatures
    'End If
    
    Sleep 1000
    
    If m_oSFC Is Nothing Then
        If eCreaturesVersion = cvcCreatures1 Then
            'Set m_oSFC = CreateObject("SFC.OLE")
            Load frmDDE
            
            If frmDDE.DDEControl.LinkMode = vbLinkManual Then
                ConnectCreatures = True
                Exit Function
            End If
            
            On Error Resume Next
            
            frmDDE.DDEControl.LinkMode = vbLinkManual
            If Err = 282 Then
                Err.Clear
                MsgBox "Could not connect to Creatures 1. Make sure it's running and try this operation again.", vbExclamation Or vbOKOnly
                Exit Function
            ElseIf Err <> 0 Then
                Err.Clear
                MsgBox "An unknown error occurred while initiating a DDE link to Creatures 1: [" & Err & "] " & Err.Description, vbCritical
                Exit Function
            End If
        
            On Error GoTo 0
        ElseIf eCreaturesVersion = cvcCreatures2 Then
            On Error Resume Next
            
            Set m_oSFC = CreateObject("SFC2.OLE")
            
            If Err <> 0 Or m_oSFC Is Nothing Then
                If Err <> 0 Then
                    MsgBox "An error occurred while trying to connect to Creatures: " & vbCrLf & Err.Description, vbOKOnly Or vbCritical
                    Err.Clear
                Else
                    MsgBox "An unknown error occurred while trying to connect to Creatures.", vbOKOnly Or vbCritical
                End If
                Exit Function
            End If
            
            On Error GoTo 0
        End If
        
        m_eConnectedVersion = eCreaturesVersion
    End If
    
    ConnectCreatures = True
End Function

Public Function SendCreaturesCommand(ByVal eVersion As CreaturesVersionConstants, ByVal sCommand As String, ByRef sResult As String) As Boolean
    Dim nConnected As Integer
    Dim nOKCancel As Integer
    Dim nOrigPointer As Integer
    Dim sData As String
    
    SendCreaturesCommand = False
    
    nOrigPointer = Screen.MousePointer
    Screen.MousePointer = vbHourglass
    
    If Not ConnectCreatures(eVersion) Then
        Screen.MousePointer = nOrigPointer
        Exit Function
    End If
    
    If m_eConnectedVersion = cvcCreatures1 Then
        On Error Resume Next
        
        Err.Clear
        
        frmDDE.DDEControl.Caption = sCommand
        
        Do
            frmDDE.DDEControl.LinkPoke
            
            If Err = 286 Then
                If MsgBox("The Creatures DDE link has timed out. Close any Creatures dialog boxes that might be open and then click OK to retry.", vbCritical Or vbOKCancel) <> vbOK Then
                    Screen.MousePointer = nOrigPointer
                    Exit Function
                End If
            ElseIf Err <> 0 Then
                Err.Clear
                MsgBox "An unknown error occurred while sending a macro to Creatures: [" & Err & "] " & Err.Description, vbCritical
                Screen.MousePointer = nOrigPointer
                Exit Function
            End If
            
            frmDDE.DDEControl.LinkRequest
            
            sResult = frmDDE.DDEControl.Caption
        Loop While Err <> 0
        
        On Error GoTo 0
    ElseIf m_eConnectedVersion = cvcCreatures2 Then
        On Error Resume Next
        
        m_oSFC.FireCommand 1, sCommand, sResult
        If Err <> 0 Then
            MsgBox "An error ocurred while sending a command to Creatures: " & Err.Number & ": " & Err.Description
            Err.Clear
            Screen.MousePointer = nOrigPointer
            Exit Function
        End If
        
        On Error GoTo 0
    End If
    
    Screen.MousePointer = nOrigPointer
    
    SendCreaturesCommand = True
End Function

Public Sub DisconnectCreatures()
    Set m_oSFC = Nothing
    frmDDE.DDEControl.LinkMode = vbLinkNone
    Unload frmDDE
End Sub

Public Sub CheckCreaturesCommunication()
    If Not m_oSFC Is Nothing Then
        m_bCreatures2WindowFound = False
        EnumWindows AddressOf EnumWindowsProc, 0
        If Not m_bCreatures2WindowFound Then
            Set m_oSFC = Nothing
        End If
    End If
End Sub

Public Function EnumWindowsProc(ByVal hwnd As Long, ByVal lParam As Long) As Boolean
    Dim sTitle As String * 256
    
    GetWindowText hwnd, sTitle, 256
    
    If InStr(1, sTitle, "Creatures 2", vbTextCompare) Then
        m_bCreatures2WindowFound = True
        EnumWindowsProc = False
    Else
        EnumWindowsProc = True
    End If
End Function

