VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "COB"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_eType As COBTypeContstants
Private m_tC1COB As COBType
Private m_tC2Agents() As C2AgentType
Private m_nSelectedAgent As Long
Private m_nNumberOfAgents As Long
Private m_bAuthorBlock As Boolean
Private m_tC2Auth As C2AuthType
Private m_tC2EmbeddedFiles() As C2EmbeddedFileType
Private m_nNumberOfEmbeddedFiles As Long
Private m_bChanged As Boolean

Public Property Get COBType() As COBTypeContstants
    COBType = m_eType
End Property

Public Property Let COBType(ByVal vNewValue As COBTypeContstants)
    If m_eType <> vNewValue Then
        Select Case m_eType
            Case ctcCreatures1
                ConvertC1ToC2
                
            Case ctcCreatures2
                ConvertC2ToC1
        End Select
        
        m_eType = vNewValue
    End If
End Property

Public Property Get SelectedAgent() As Long
    SelectedAgent = m_nSelectedAgent
End Property

Public Property Let SelectedAgent(ByVal vNewValue As Long)
    m_nSelectedAgent = vNewValue
End Property

Public Property Get NumberOfAgents() As Long
    NumberOfAgents = m_nNumberOfAgents
End Property

Public Property Get AgentName(ByVal Index As Long) As String
    AgentName = m_tC2Agents(Index).sCOBName
End Property

Public Property Get AuthorBlock() As Boolean
    AuthorBlock = m_bAuthorBlock
End Property

Public Property Let AuthorBlock(ByVal vNewValue As Boolean)
    m_bAuthorBlock = vNewValue
End Property

Public Property Get AuthorName() As String
    AuthorName = m_tC2Auth.sName
End Property

Public Property Let AuthorName(ByVal vNewValue As String)
    m_tC2Auth.sName = vNewValue
End Property

Public Property Get AuthorEmail() As String
    AuthorEmail = m_tC2Auth.sEmail
End Property

Public Property Let AuthorEmail(ByVal vNewValue As String)
    m_tC2Auth.sEmail = vNewValue
End Property

Public Property Get AuthorURL() As String
    AuthorURL = m_tC2Auth.sURL
End Property

Public Property Let AuthorURL(ByVal vNewValue As String)
    m_tC2Auth.sURL = vNewValue
End Property

Public Property Get AuthorComments() As String
    AuthorComments = m_tC2Auth.sComments
End Property

Public Property Let AuthorComments(ByVal vNewValue As String)
    m_tC2Auth.sComments = vNewValue
End Property

Public Property Get AuthorDay() As Integer
    AuthorDay = m_tC2Auth.nDay
End Property

Public Property Let AuthorDay(ByVal vNewValue As Integer)
    m_tC2Auth.nDay = vNewValue
End Property

Public Property Get AuthorMonth() As Integer
    AuthorMonth = m_tC2Auth.nMonth
End Property

Public Property Let AuthorMonth(ByVal vNewValue As Integer)
    m_tC2Auth.nMonth = vNewValue
End Property

Public Property Get AuthorYear() As Integer
    AuthorYear = m_tC2Auth.nYear
End Property

Public Property Let AuthorYear(ByVal vNewValue As Integer)
    m_tC2Auth.nYear = vNewValue
End Property

'Public Property Get AuthorDate() As String
'    AuthorDate = Format(m_tC2Auth.nDay, "00") & "/" & Format(m_tC2Auth.nMonth, "00") & "/" & m_tC2Auth.nYear
'End Property
'
'Public Property Let AuthorDate(ByVal vNewValue As String)
'    Dim dTemp As Date
'
'    If IsDate(vNewValue) Then
'        dTemp = CDate(vNewValue)
'        m_tC2Auth.nDay = Day(dTemp)
'        m_tC2Auth.nMonth = Month(dTemp)
'        m_tC2Auth.nYear = Year(dTemp)
'    End If
'End Property

Public Property Get AuthorVersion() As Byte
    AuthorVersion = m_tC2Auth.nVersion
End Property

Public Property Let AuthorVersion(vNewValue As Byte)
    m_tC2Auth.nVersion = vNewValue
End Property

Public Property Get AuthorRevision() As Byte
    AuthorRevision = m_tC2Auth.nRevision
End Property

Public Property Let AuthorRevision(vNewValue As Byte)
    m_tC2Auth.nRevision = vNewValue
End Property

Public Property Get NumberOfRequiredFiles() As Integer
    NumberOfRequiredFiles = m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles
End Property

Public Property Get RequiredFiles(ByVal Index As Integer) As String
    If Index >= 0 And Index < m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles Then
        RequiredFiles = m_tC2Agents(m_nSelectedAgent).aRequiredFiles(Index).sName
    End If
End Property

Public Sub AddRequiredFile(ByVal FileName As String)
    ReDim Preserve m_tC2Agents(m_nSelectedAgent).aRequiredFiles(0 To m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles)
    Select Case LCase(Right(FileName, 3))
        Case "s16"
            m_tC2Agents(m_nSelectedAgent).aRequiredFiles(m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles).nType = rftcSprite
            
        Case "wav"
            m_tC2Agents(m_nSelectedAgent).aRequiredFiles(m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles).nType = rftcSound
    End Select
    m_tC2Agents(m_nSelectedAgent).aRequiredFiles(m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles).sName = FileName
    m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles = m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles + 1
End Sub

Public Sub DeleteRequiredFile(ByVal Index As Integer)
    Dim I As Integer
    
    If m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles <= 0 Then
        Exit Sub
    End If
    
    For I = Index To m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles - 2
        m_tC2Agents(m_nSelectedAgent).aRequiredFiles(I) = m_tC2Agents(m_nSelectedAgent).aRequiredFiles(I + 1)
    Next
    
    m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles = m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles - 1
    
    If m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles > 0 Then
        ReDim Preserve m_tC2Agents(m_nSelectedAgent).aRequiredFiles(0 To m_tC2Agents(m_nSelectedAgent).nNumberOfRequiredFiles - 1)
    Else
        Erase m_tC2Agents(m_nSelectedAgent).aRequiredFiles
    End If
End Sub

Public Property Get NumberOfEmbeddedFiles() As Long
    NumberOfEmbeddedFiles = m_nNumberOfEmbeddedFiles
End Property

Public Property Get EmbeddedFileByName(ByVal Name As String) As Long
    Dim I As Long
    
    For I = 0 To m_nNumberOfEmbeddedFiles - 1
        If LCase(Name) = LCase(m_tC2EmbeddedFiles(I).sName) Then
            EmbeddedFileByName = I
            Exit Property
        End If
    Next
    
    EmbeddedFileByName = -1
End Property

Public Property Get EmbeddedFileType(ByVal Index As Long) As Integer
    EmbeddedFileType = m_tC2EmbeddedFiles(Index).nType
End Property

Public Property Get EmbeddedFileLength(ByVal Index As Long) As Long
    EmbeddedFileLength = m_tC2EmbeddedFiles(Index).nFileLength
End Property

Public Property Get EmbeddedFileName(ByVal Index As Long) As String
    EmbeddedFileName = m_tC2EmbeddedFiles(Index).sName
End Property

Public Sub GetEmbeddedFileDataArray(ByVal Index As Long, aData() As Byte)
    ReDim aData(0 To m_tC2EmbeddedFiles(Index).nFileLength - 1)
    aData = m_tC2EmbeddedFiles(Index).aFileData
End Sub

Public Function AddEmbeddedFile(sName As String, aData() As Byte) As Long
    Dim tC2EmbeddedFile As C2EmbeddedFileType
    
    With tC2EmbeddedFile
        Select Case LCase(Right(sName, 3))
            Case "s16"
                .nType = rftcSprite
                
            Case "wav"
                .nType = rftcSound
        End Select
        
        .sName = sName
        .nFileLength = UBound(aData) + 1
        .aFileData = aData
    End With
    
    ReDim Preserve m_tC2EmbeddedFiles(0 To m_nNumberOfEmbeddedFiles)
    m_tC2EmbeddedFiles(m_nNumberOfEmbeddedFiles) = tC2EmbeddedFile
    AddEmbeddedFile = m_nNumberOfEmbeddedFiles
    m_nNumberOfEmbeddedFiles = m_nNumberOfEmbeddedFiles + 1
End Function

Public Sub DeleteEmbeddedFile(ByVal Index As Long)
    Dim I As Integer
    
    For I = Index To m_nNumberOfEmbeddedFiles - 2
        m_tC2EmbeddedFiles(I) = m_tC2EmbeddedFiles(I + 1)
    Next
    
    m_nNumberOfEmbeddedFiles = m_nNumberOfEmbeddedFiles - 1
    
    If m_nNumberOfEmbeddedFiles > 0 Then
        ReDim Preserve m_tC2EmbeddedFiles(0 To m_nNumberOfEmbeddedFiles - 1)
    Else
        Erase m_tC2EmbeddedFiles
    End If
End Sub

Public Property Get nCOBVersion()
    nCOBVersion = m_tC1COB.nCOBVersion
End Property

Public Property Let nCOBVersion(ByVal vNewValue)
    m_tC1COB.nCOBVersion = vNewValue
End Property

Public Property Get nQuantityAvailable()
    Select Case m_eType
        Case ctcCreatures1
            nQuantityAvailable = m_tC1COB.nQuantityAvailable
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            nQuantityAvailable = m_tC2Agents(m_nSelectedAgent).nQuantityAvailable
    End Select
End Property

Public Property Let nQuantityAvailable(ByVal vNewValue)
    Select Case m_eType
        Case ctcCreatures1
            m_tC1COB.nQuantityAvailable = vNewValue
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            m_tC2Agents(m_nSelectedAgent).nQuantityAvailable = vNewValue
    End Select
End Property

Public Property Get nQuantityUsed()
    nQuantityUsed = m_tC1COB.nQuantityUsed
End Property

Public Property Let nQuantityUsed(ByVal vNewValue)
    m_tC1COB.nQuantityUsed = vNewValue
End Property

Public Property Get nExpirationDay()
    nExpirationDay = m_tC1COB.nExpirationDay
End Property

Public Property Let nExpirationDay(ByVal vNewValue)
    m_tC1COB.nExpirationDay = vNewValue
End Property

Public Property Get nExpirationMonth()
    nExpirationMonth = m_tC1COB.nExpirationMonth
End Property

Public Property Let nExpirationMonth(ByVal vNewValue)
    m_tC1COB.nExpirationMonth = vNewValue
End Property

Public Property Get nExpirationYear()
    nExpirationYear = m_tC1COB.nExpirationYear
End Property

Public Property Let nExpirationYear(ByVal vNewValue)
    m_tC1COB.nExpirationYear = vNewValue
End Property

Public Property Get nNumberOfObjectScripts()
    Select Case m_eType
        Case ctcCreatures1
            nNumberOfObjectScripts = m_tC1COB.nNumberOfObjectScripts
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            nNumberOfObjectScripts = m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts
    End Select
End Property

Public Property Let nNumberOfObjectScripts(ByVal vNewValue)
    Select Case m_eType
        Case ctcCreatures1
            m_tC1COB.nNumberOfObjectScripts = vNewValue
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts = vNewValue
    End Select
End Property

Public Property Get nNumberOfInstallScripts()
    Select Case m_eType
        Case ctcCreatures1
            nNumberOfInstallScripts = m_tC1COB.nNumberOfInstallScripts
            
        Case ctcCreatures2
            nNumberOfInstallScripts = 1
    End Select
End Property

Public Property Let nNumberOfInstallScripts(ByVal vNewValue)
    If m_eType = ctcCreatures1 Then
        m_tC1COB.nNumberOfInstallScripts = vNewValue
    End If
End Property

Public Property Get aObjectScripts(ByVal Index)
    Select Case m_eType
        Case ctcCreatures1
            aObjectScripts = m_tC1COB.aObjectScripts(Index)
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            aObjectScripts = m_tC2Agents(m_nSelectedAgent).aObjectScripts(Index)
    End Select
End Property

Public Property Let aObjectScripts(ByVal Index, ByVal vNewValue)
    Select Case m_eType
        Case ctcCreatures1
            m_tC1COB.aObjectScripts(Index) = vNewValue
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            m_tC2Agents(m_nSelectedAgent).aObjectScripts(Index) = vNewValue
    End Select
End Property

Public Property Get aInstallScripts(ByVal Index)
    If Index = 0 And m_eType = ctcCreatures2 Then
        If m_nSelectedAgent < 0 Then
            Exit Property
        End If
        aInstallScripts = m_tC2Agents(m_nSelectedAgent).sInjectionScript
    Else
        aInstallScripts = m_tC1COB.aInstallScripts(Index)
    End If
End Property

Public Property Let aInstallScripts(ByVal Index, ByVal vNewValue)
    If Index = 0 And m_eType = ctcCreatures2 Then
        If m_nSelectedAgent < 0 Then
            Exit Property
        End If
        m_tC2Agents(m_nSelectedAgent).sInjectionScript = vNewValue
    Else
        m_tC1COB.aInstallScripts(Index) = vNewValue
    End If
End Property

Public Property Get nPicWidth()
    Select Case m_eType
        Case ctcCreatures1
            nPicWidth = m_tC1COB.oPicture.Width
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            nPicWidth = m_tC2Agents(m_nSelectedAgent).oPicture.Width
    End Select
End Property

Public Property Let nPicWidth(ByVal vNewValue)
    Select Case m_eType
        Case ctcCreatures1
            m_tC1COB.oPicture.Width = nPicWidth
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            m_tC2Agents(m_nSelectedAgent).oPicture.Width = nPicWidth
    End Select
End Property

Public Property Get nPicHeight()
    Select Case m_eType
        Case ctcCreatures1
            nPicHeight = m_tC1COB.oPicture.Height
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            nPicHeight = m_tC2Agents(m_nSelectedAgent).oPicture.Height
    End Select
End Property

Public Property Let nPicHeight(ByVal vNewValue)
    Select Case m_eType
        Case ctcCreatures1
            m_tC1COB.oPicture.Height = nPicHeight
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            m_tC2Agents(m_nSelectedAgent).oPicture.Height = nPicHeight
    End Select
End Property

Public Property Get nPicUnknown()
    nPicUnknown = m_tC1COB.nPicUnknown
End Property

Public Property Let nPicUnknown(ByVal vNewValue)
    m_tC1COB.nPicUnknown = vNewValue
End Property

Public Property Get Picture() As Bitmap
    Select Case m_eType
        Case ctcCreatures1
            Set Picture = m_tC1COB.oPicture
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            Set Picture = m_tC2Agents(m_nSelectedAgent).oPicture
    End Select
End Property

Public Property Get sCOBName()
    Select Case m_eType
        Case ctcCreatures1
            sCOBName = m_tC1COB.sCOBName
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            sCOBName = m_tC2Agents(m_nSelectedAgent).sCOBName
    End Select
End Property

Public Property Let sCOBName(ByVal vNewValue)
    Select Case m_eType
        Case ctcCreatures1
            m_tC1COB.sCOBName = vNewValue
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Property
            End If
            m_tC2Agents(m_nSelectedAgent).sCOBName = vNewValue
    End Select
End Property

Public Property Get bChanged() As Boolean
    bChanged = m_bChanged
End Property

Public Property Let bChanged(ByVal vNewValue As Boolean)
    m_bChanged = vNewValue
End Property

Public Property Get nInjectionDelay()
    If m_nSelectedAgent < 0 Then
        Exit Property
    End If
    nInjectionDelay = m_tC2Agents(m_nSelectedAgent).nInjectionDelay
End Property

Public Property Let nInjectionDelay(ByVal vNewValue)
    If m_nSelectedAgent < 0 Then
        Exit Property
    End If
    m_tC2Agents(m_nSelectedAgent).nInjectionDelay = vNewValue
End Property

'Public Property Get nUnknown1()
'    If m_nSelectedAgent < 0 Then
'        Exit Property
'    End If
'    nUnknown1 = m_tC2Agents(m_nSelectedAgent).nUnknown1
'End Property
'
'Public Property Let nUnknown1(ByVal vNewValue)
'    If m_nSelectedAgent < 0 Then
'        Exit Property
'    End If
'    m_tC2Agents(m_nSelectedAgent).nUnknown1 = vNewValue
'End Property
'
'Public Property Get nUnknown2()
'    If m_nSelectedAgent < 0 Then
'        Exit Property
'    End If
'    nUnknown2 = m_tC2Agents(m_nSelectedAgent).nUnknown2
'End Property
'
'Public Property Let nUnknown2(ByVal vNewValue)
'    If m_nSelectedAgent < 0 Then
'        Exit Property
'    End If
'    m_tC2Agents(m_nSelectedAgent).nUnknown2 = vNewValue
'End Property
'
'Public Property Get nUnknown3()
'    If m_nSelectedAgent < 0 Then
'        Exit Property
'    End If
'    nUnknown3 = m_tC2Agents(m_nSelectedAgent).nUnknown3
'End Property
'
'Public Property Let nUnknown3(ByVal vNewValue)
'    If m_nSelectedAgent < 0 Then
'        Exit Property
'    End If
'    m_tC2Agents(m_nSelectedAgent).nUnknown3 = vNewValue
'End Property
'
'Public Property Get nUnknown4()
'    If m_nSelectedAgent < 0 Then
'        Exit Property
'    End If
'    nUnknown4 = m_tC2Agents(m_nSelectedAgent).nUnknown4
'End Property
'
'Public Property Let nUnknown4(ByVal vNewValue)
'    If m_nSelectedAgent < 0 Then
'        Exit Property
'    End If
'    m_tC2Agents(m_nSelectedAgent).nUnknown4 = vNewValue
'End Property
'
Public Property Get sCOBDescription()
    If m_nSelectedAgent < 0 Then
        Exit Property
    End If
    sCOBDescription = m_tC2Agents(m_nSelectedAgent).sCOBDescription
End Property

Public Property Let sCOBDescription(ByVal vNewValue)
    If m_nSelectedAgent < 0 Then
        Exit Property
    End If
    m_tC2Agents(m_nSelectedAgent).sCOBDescription = vNewValue
End Property

Public Property Get sInjectionScript()
    If m_nSelectedAgent < 0 Then
        Exit Property
    End If
    sInjectionScript = m_tC2Agents(m_nSelectedAgent).sInjectionScript
End Property

Public Property Let sInjectionScript(ByVal vNewValue)
    If m_nSelectedAgent < 0 Then
        Exit Property
    End If
    m_tC2Agents(m_nSelectedAgent).sInjectionScript = vNewValue
End Property

Public Property Get sRemoverScript()
    If m_nSelectedAgent < 0 Then
        Exit Property
    End If
    sRemoverScript = m_tC2Agents(m_nSelectedAgent).sRemoverScript
End Property

Public Property Let sRemoverScript(ByVal vNewValue)
    If m_nSelectedAgent < 0 Then
        Exit Property
    End If
    m_tC2Agents(m_nSelectedAgent).sRemoverScript = vNewValue
End Property

Public Sub Initialise()
    InitialiseC1
    InitialiseC2
End Sub

Private Sub InitialiseC1()
    With m_tC1COB
        .nCOBVersion = 1
        .nQuantityAvailable = 255
        .nQuantityUsed = 0
        .nExpirationDay = 0
        .nExpirationMonth = 0
        .nExpirationYear = 0
        .nNumberOfObjectScripts = 0
        .nNumberOfInstallScripts = 0
        Erase .aObjectScripts
        Erase .aInstallScripts
        .nPicWidth = 0
        .nPicHeight = 0
        .nPicUnknown = 0
        Erase .aPicture
        .sCOBName = ""
        Set .oPicture = New Bitmap
    End With
End Sub

Private Sub InitialiseC2()
    Erase m_tC2Agents
    
    m_nNumberOfAgents = 0
    m_nSelectedAgent = -1
    m_bAuthorBlock = False
    
    With m_tC2Auth
        .nDay = 0
        .nMonth = 0
        .nRevision = 0
        .nVersion = 0
        .nYear = 0
        .sName = ""
        .sEmail = ""
        .sURL = ""
        .sComments = ""
    End With
End Sub

Private Sub InitialiseC2Agent(tAgent As C2AgentType)
    With tAgent
        .nQuantityAvailable = -1
        .nLastInjectedTime = 0
        .nInjectionDelay = 0
        .nUseByDay = 0
        .nUseByMonth = 0
        .nUseByYear = 0
        .nReserved1 = 0
        .nReserved2 = 0
        .nReserved3 = 0
        .sCOBName = "New Agent"
        .sCOBDescription = ""
        .sInjectionScript = ""
        .sRemoverScript = ""
        .nNumberOfObjectScripts = 0
        Erase .aObjectScripts
        .nPicWidth = 0
        .nPicHeight = 0
        Erase .aPicture
        Set .oPicture = New Bitmap
    End With
End Sub

Public Function ExportPicture(ByVal sFilename As String) As Boolean
    Dim oSprite As Sprite
    Dim I As Integer
    Dim oPicture As Bitmap
    
    ExportPicture = False
    
    Select Case LCase(Right(sFilename, 3))
        Case "spr"
            Set oSprite = New Sprite
            
'            Select Case m_eType
'                Case ctcCreatures1
'                    oSprite.SpriteType = stcSPR
'
'                Case ctcCreatures2
'                    oSprite.SpriteType = stcS16_565
'            End Select
            
            oSprite.SpriteType = stcSPR
            
            oSprite.AddSpriteImage Picture
            
            oSprite.Save sFilename
            
        Case "s16"
            Set oSprite = New Sprite
            
'            Select Case m_eType
'                Case ctcCreatures1
'                    oSprite.SpriteType = stcSPR
'
'                Case ctcCreatures2
'                    oSprite.SpriteType = stcS16_565
'            End Select
            
            oSprite.SpriteType = stcS16_565
            
            oSprite.AddSpriteImage Picture
            
            oSprite.Save sFilename
            
        Case "bmp"
            Picture.SaveBitmapFile sFilename
    End Select
    
    ExportPicture = True
End Function

Public Function ImportPicture(ByVal sFilename As String) As Boolean
    Dim oSprite As Sprite
    Dim I As Integer
    Dim oPicture As Bitmap
    
    ImportPicture = False
    
    Select Case LCase(Right(sFilename, 3))
        Case "spr"
            Set oSprite = New Sprite
            
            If Not oSprite.LoadSpriteFile(sFilename) Then
                Exit Function
            End If
            
            Select Case m_eType
                Case ctcCreatures1
                    Set m_tC1COB.oPicture = oSprite.SpriteImages(1)
                    
                Case ctcCreatures2
                    For I = 2 To oSprite.NumberOfSpritesInFile
                        oSprite.DeleteSpriteImage 2
                    Next
                    
                    oSprite.SpriteType = stcS16_565
                    
                    Set m_tC2Agents(m_nSelectedAgent).oPicture = oSprite.SpriteImages(1)
            End Select
            
        Case "s16"
            Set oSprite = New Sprite
            
            If Not oSprite.LoadS16File(sFilename) Then
                Exit Function
            End If
            
            For I = 2 To oSprite.NumberOfSpritesInFile
                oSprite.DeleteSpriteImage 2
            Next
            
            Select Case m_eType
                Case ctcCreatures1
                    oSprite.SpriteType = stcSPR
                    Set m_tC1COB.oPicture = oSprite.SpriteImages(1)
                    
                Case ctcCreatures2
                    oSprite.SpriteType = stcS16_565
                    Set m_tC2Agents(m_nSelectedAgent).oPicture = oSprite.SpriteImages(1)
            End Select
            
        Case "bmp"
            Set oPicture = New Bitmap
            
'            Select Case m_eType
'                Case ctcCreatures1
'                    oPicture.BitsPerPixel = 8
'
'                Case ctcCreatures2
'                    oPicture.BitsPerPixel = 16
'                    If m_nSelectedAgent < 0 Then
'                        Exit Function
'                    End If
'            End Select
            
            If Not oPicture.LoadBitmapFile(sFilename) Then
                Exit Function
            End If
            
            Select Case m_eType
                Case ctcCreatures1
                    oPicture.ConvertToImageType stcSPR
                    Set m_tC1COB.oPicture = oPicture
                    
                Case ctcCreatures2
                    oPicture.ConvertToImageType stcS16_565
                    Set m_tC2Agents(m_nSelectedAgent).oPicture = oPicture
            End Select
    End Select
    
    ImportPicture = True
End Function

Public Function AddAgent() As Long
    ReDim Preserve m_tC2Agents(0 To m_nNumberOfAgents)
    InitialiseC2Agent m_tC2Agents(m_nNumberOfAgents)
    AddAgent = m_nNumberOfAgents
    m_nNumberOfAgents = m_nNumberOfAgents + 1
End Function

Public Sub DeleteAgent(ByVal Index As Long)
    Dim I As Integer
    
    If m_nNumberOfAgents <= 0 Then
        Exit Sub
    End If
    
    Set m_tC2Agents(Index).oPicture = Nothing
    
    For I = Index To m_nNumberOfAgents - 2
        m_tC2Agents(I) = m_tC2Agents(I + 1)
    Next
    
    m_nNumberOfAgents = m_nNumberOfAgents - 1
    
    If m_nNumberOfAgents > 0 Then
        ReDim Preserve m_tC2Agents(0 To m_nNumberOfAgents - 1)
    Else
        Erase m_tC2Agents
    End If
End Sub

Public Sub AddInstallScript(ByVal sScript As String)
    ReDim Preserve m_tC1COB.aInstallScripts(0 To m_tC1COB.nNumberOfInstallScripts)
    m_tC1COB.aInstallScripts(m_tC1COB.nNumberOfInstallScripts) = sScript
    m_tC1COB.nNumberOfInstallScripts = m_tC1COB.nNumberOfInstallScripts + 1
End Sub

Public Sub AddObjectScript(ByVal sScript As String)
    Select Case m_eType
        Case ctcCreatures1
            ReDim Preserve m_tC1COB.aObjectScripts(0 To m_tC1COB.nNumberOfObjectScripts)
            m_tC1COB.aObjectScripts(m_tC1COB.nNumberOfObjectScripts) = sScript
            m_tC1COB.nNumberOfObjectScripts = m_tC1COB.nNumberOfObjectScripts + 1
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Sub
            End If
            ReDim Preserve m_tC2Agents(m_nSelectedAgent).aObjectScripts(0 To m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts)
            m_tC2Agents(m_nSelectedAgent).aObjectScripts(m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts) = sScript
            m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts = m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts + 1
    End Select
End Sub

Public Sub DeleteInstallScript(ByVal nIndex As Integer)
    Dim I As Integer
    
    For I = nIndex To m_tC1COB.nNumberOfInstallScripts - 2
        m_tC1COB.aInstallScripts(I) = m_tC1COB.aInstallScripts(I + 1)
    Next
    
    m_tC1COB.nNumberOfInstallScripts = m_tC1COB.nNumberOfInstallScripts - 1
    
    If m_tC1COB.nNumberOfInstallScripts > 0 Then
        ReDim Preserve m_tC1COB.aInstallScripts(0 To m_tC1COB.nNumberOfInstallScripts - 1)
    Else
        Erase m_tC1COB.aInstallScripts
    End If
End Sub

Public Sub DeleteObjectScript(ByVal nIndex As Integer)
    Dim I As Integer
    
    Select Case m_eType
        Case ctcCreatures1
            For I = nIndex To m_tC1COB.nNumberOfObjectScripts - 2
                m_tC1COB.aObjectScripts(I) = m_tC1COB.aObjectScripts(I + 1)
            Next
            
            m_tC1COB.nNumberOfObjectScripts = m_tC1COB.nNumberOfObjectScripts - 1
            
            If m_tC1COB.nNumberOfObjectScripts > 0 Then
                ReDim Preserve m_tC1COB.aObjectScripts(0 To m_tC1COB.nNumberOfObjectScripts - 1)
            Else
                Erase m_tC1COB.aObjectScripts
            End If
            
        Case ctcCreatures2
            If m_nSelectedAgent < 0 Then
                Exit Sub
            End If
            For I = nIndex To m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts - 2
                m_tC2Agents(m_nSelectedAgent).aObjectScripts(I) = m_tC2Agents(m_nSelectedAgent).aObjectScripts(I + 1)
            Next
            
            m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts = m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts - 1
            
            If m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts > 0 Then
                ReDim Preserve m_tC2Agents(m_nSelectedAgent).aObjectScripts(0 To m_tC2Agents(m_nSelectedAgent).nNumberOfObjectScripts - 1)
            Else
                Erase m_tC2Agents(m_nSelectedAgent).aObjectScripts
            End If
    End Select
End Sub

Public Sub Save(ByVal sFilename As String)
    Dim bPreserveFormatting As Boolean
    
    Select Case LCase(Right(sFilename, 3))
        Case "cob", "rcb"
            bPreserveFormatting = False
            
        Case "bob"
            bPreserveFormatting = True
    End Select
    
    Select Case m_eType
        Case ctcCreatures1
            SaveCOBFile sFilename, bPreserveFormatting
            
        Case ctcCreatures2
            SaveC2COBFile sFilename, bPreserveFormatting
    End Select
End Sub

Public Function LoadCOBFile(ByVal sFilename As String) As Boolean
    Dim nFile As Integer
    Dim I As Integer
    Dim nHeader As Integer
    Dim nScriptSize As Byte
    Dim nExtScriptSize As Integer
    Dim J As Integer
    Dim nChar As Byte
    Dim nCOBNameSize As Byte
    Dim aPicture() As Byte
    Dim nPicWidth As Long
    Dim nPicHeight As Long
    Dim bWithFormatting As Boolean
    
    Select Case LCase(Right(sFilename, 3))
        Case "cob", "rcb"
            bWithFormatting = False
            
        Case "bob"
            bWithFormatting = True
    End Select
    
    LoadCOBFile = False
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Open sFilename For Binary Access Read As nFile
    If Err Then
        MsgBox "Error opening file '" & sFilename & "':" & vbCrLf & vbCrLf & Err.Description, vbExclamation, "Loading File..."
        Err.Clear
        Exit Function
    End If
    
    On Error GoTo 0
    
    Initialise
    
    Get nFile, , nHeader
    If nHeader <> 1 Then
        Close #nFile
        If nHeader = 28515 Then
            LoadCOBFile = LoadC2COBFile(sFilename, bWithFormatting)
        End If
        Exit Function
    End If
    
    m_eType = ctcCreatures1
    
    With m_tC1COB
        .nCOBVersion = nHeader
        Get nFile, , .nQuantityAvailable
        Get nFile, , .nExpirationMonth
        Get nFile, , .nExpirationDay
        Get nFile, , .nExpirationYear
        Get nFile, , .nNumberOfObjectScripts
        Get nFile, , .nNumberOfInstallScripts
        Get nFile, , .nQuantityUsed
    End With
    
    If m_tC1COB.nNumberOfObjectScripts > 0 Then
        ReDim m_tC1COB.aObjectScripts(0 To m_tC1COB.nNumberOfObjectScripts - 1) As String
        
        For I = 0 To m_tC1COB.nNumberOfObjectScripts - 1
            Get nFile, , nScriptSize
            If nScriptSize = 255 Then
                Get nFile, , nExtScriptSize
                For J = 1 To nExtScriptSize
                    Get nFile, , nChar
                    m_tC1COB.aObjectScripts(I) = m_tC1COB.aObjectScripts(I) & Chr(nChar)
                Next
            Else
                For J = 1 To nScriptSize
                    Get nFile, , nChar
                    m_tC1COB.aObjectScripts(I) = m_tC1COB.aObjectScripts(I) & Chr(nChar)
                Next
            End If
            
            If Not bWithFormatting Then
                m_tC1COB.aObjectScripts(I) = COBtoCOS(m_tC1COB.aObjectScripts(I))
            End If
        Next
    End If
    
    If m_tC1COB.nNumberOfInstallScripts > 0 Then
        ReDim m_tC1COB.aInstallScripts(0 To m_tC1COB.nNumberOfInstallScripts - 1)
        
        For I = 0 To m_tC1COB.nNumberOfInstallScripts - 1
            Get nFile, , nScriptSize
            If nScriptSize = 255 Then
                Get nFile, , nExtScriptSize
                For J = 1 To nExtScriptSize
                    Get nFile, , nChar
                    m_tC1COB.aInstallScripts(I) = m_tC1COB.aInstallScripts(I) & Chr(nChar)
                Next
            Else
                For J = 1 To nScriptSize
                    Get nFile, , nChar
                    m_tC1COB.aInstallScripts(I) = m_tC1COB.aInstallScripts(I) & Chr(nChar)
                Next
            End If
            
            If Not bWithFormatting Then
                m_tC1COB.aInstallScripts(I) = COBtoCOS(m_tC1COB.aInstallScripts(I))
            End If
        Next
    End If
    
    Get nFile, , nPicWidth
    Get nFile, , nPicHeight
    Get nFile, , m_tC1COB.nPicUnknown
    
    If nPicWidth > 0 Then
        ReDim aPicture(0 To nPicWidth * nPicHeight - 1) As Byte
        Get nFile, , aPicture
        
        Set m_tC1COB.oPicture = New Bitmap
        With m_tC1COB.oPicture
            .BitsPerPixel = 8
            .Width = nPicWidth
            .Height = nPicHeight
            .SetPixelArray aPicture
            .FlipPixelArray
        End With
    End If
    
    Get nFile, , nCOBNameSize
    
    m_tC1COB.sCOBName = ""
    
    For I = 1 To nCOBNameSize
        Get nFile, , nChar
        If nChar <> 0 Then
            m_tC1COB.sCOBName = m_tC1COB.sCOBName & Chr(nChar)
        End If
    Next
    
    Close nFile
    
    m_bChanged = False
    
    LoadCOBFile = True
End Function

Public Sub SaveCOBFile(ByVal sFilename As String, ByVal bPreserveFormatting As Boolean)
    Dim nFile As Integer
    Dim I As Integer
    Dim J As Integer
    Dim sScript As String
    Dim nScriptSize As Byte
    Dim nExtScriptSize As Integer
    Dim nCOBNameSize As Byte
    Dim nChar As Byte
    Dim aPicture() As Byte
    Dim nTemp As Long
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Kill sFilename
    Err.Clear
    
    Open sFilename For Binary Access Write As nFile
    If Err Then
        Err.Clear
        MsgBox "Error opening file '" & sFilename & "':" & vbCrLf & vbCrLf & Err.Description, vbExclamation, "Saving File..."
        Exit Sub
    End If
    
    On Error GoTo 0
    
    Put nFile, , m_tC1COB.nCOBVersion
    Put nFile, , m_tC1COB.nQuantityAvailable
    Put nFile, , m_tC1COB.nExpirationMonth
    Put nFile, , m_tC1COB.nExpirationDay
    Put nFile, , m_tC1COB.nExpirationYear
    Put nFile, , m_tC1COB.nNumberOfObjectScripts
    Put nFile, , m_tC1COB.nNumberOfInstallScripts
    Put nFile, , m_tC1COB.nQuantityUsed
    
    For I = 0 To m_tC1COB.nNumberOfObjectScripts - 1
        sScript = m_tC1COB.aObjectScripts(I)
        If Not bPreserveFormatting Then
            sScript = COStoCOB(sScript)
        End If
        If Len(sScript) < 255 Then
            nScriptSize = Len(sScript)
            Put nFile, , nScriptSize
            
            For J = 1 To nScriptSize
                nChar = Asc(Mid(sScript, J, 1))
                Put nFile, , nChar
            Next
        Else
            nScriptSize = 255
            nExtScriptSize = Len(sScript)
            Put nFile, , nScriptSize
            Put nFile, , nExtScriptSize
            
            For J = 1 To nExtScriptSize
                nChar = Asc(Mid(sScript, J, 1))
                Put nFile, , nChar
            Next
        End If
    Next
    
    For I = 0 To m_tC1COB.nNumberOfInstallScripts - 1
        sScript = m_tC1COB.aInstallScripts(I)
        If Not bPreserveFormatting Then
            sScript = COStoCOB(sScript)
        End If
        If Len(sScript) < 255 Then
            nScriptSize = Len(sScript)
            Put nFile, , nScriptSize
            
            For J = 1 To nScriptSize
                nChar = Asc(Mid(sScript, J, 1))
                Put nFile, , nChar
            Next
        Else
            nScriptSize = 255
            nExtScriptSize = Len(sScript)
            Put nFile, , nScriptSize
            Put nFile, , nExtScriptSize
            
            For J = 1 To nExtScriptSize
                nChar = Asc(Mid(sScript, J, 1))
                Put nFile, , nChar
            Next
        End If
    Next
    
    With m_tC1COB.oPicture
        nTemp = .Width
        Put nFile, , nTemp
        nTemp = .Height
        Put nFile, , nTemp
        Put nFile, , m_tC1COB.nPicUnknown
        
        If .Width > 0 Then
            .FlipPixelArray
            .GetPixelArray aPicture
            .FlipPixelArray
            Put nFile, , aPicture
        End If
    End With
    
    nCOBNameSize = Len(m_tC1COB.sCOBName) ' + 1
    
    Put nFile, , nCOBNameSize
    
    For I = 1 To nCOBNameSize ' - 1
        nChar = Asc(Mid(m_tC1COB.sCOBName, I, 1))
        Put nFile, , nChar
    Next
    
    nChar = 0
    
    Put nFile, , nChar
    
    Close nFile
End Sub

Public Function LoadC2COBFile(ByVal sFilename As String, bWithFormatting As Boolean) As Boolean
    Dim nFile As Integer
    Dim I As Integer
    Dim nChar As Byte
    Dim nTemp As Long
    Dim aPicture() As Byte
    Dim nPicWidth As Integer
    Dim nPicHeight As Integer
    Dim sTag As String * 4
    Dim tC2Agent As C2AgentType
    Dim tC2EmbeddedFile As C2EmbeddedFileType
    
    LoadC2COBFile = False
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Open sFilename For Binary Access Read As nFile
    If Err Then
        MsgBox "Error opening file '" & sFilename & "':" & vbCrLf & vbCrLf & Err.Description, vbOKOnly Or vbExclamation, "Loading File..."
        Err.Clear
        Exit Function
    End If
    
    On Error GoTo 0
    
    Get nFile, , sTag
    
    If sTag <> sC2COBTag Then
        MsgBox "'" & sFilename & "' is not valid C2 COB file.", vbOKOnly Or vbExclamation, "Loading File..."
        Exit Function
    End If
    
    m_eType = ctcCreatures2
    m_nNumberOfAgents = 0
    
    Do While Not EOF(nFile)
        sTag = ""
        Get nFile, , sTag
        If EOF(nFile) Then
            Exit Do
        End If
        
        If sTag = sC2AgentTag Then
            InitialiseC2Agent tC2Agent
            
            Get nFile, , nTemp
            
            With tC2Agent
                Get nFile, , .nQuantityAvailable
                Get nFile, , .nLastInjectedTime
                Get nFile, , .nInjectionDelay
                Get nFile, , .nUseByDay
                Get nFile, , .nUseByMonth
                Get nFile, , .nUseByYear
                Get nFile, , .nReserved1
                Get nFile, , .nReserved2
                Get nFile, , .nReserved3
            End With
            
            'Get COB Name
            tC2Agent.sCOBName = ""
            Get nFile, , nChar
            Do Until nChar = 0
                tC2Agent.sCOBName = tC2Agent.sCOBName & Chr(nChar)
                Get nFile, , nChar
            Loop
            
            'Get COB Description
            tC2Agent.sCOBDescription = ""
            Get nFile, , nChar
            Do Until nChar = 0
                tC2Agent.sCOBDescription = tC2Agent.sCOBDescription & Chr(nChar)
                Get nFile, , nChar
            Loop
            
            'Get Injection Script
            tC2Agent.sInjectionScript = ""
            Get nFile, , nChar
            Do Until nChar = 0
                tC2Agent.sInjectionScript = tC2Agent.sInjectionScript & Chr(nChar)
                Get nFile, , nChar
            Loop
            
            If Not bWithFormatting Then
                tC2Agent.sInjectionScript = COBtoCOS(tC2Agent.sInjectionScript)
            End If
            
            'Get Remover Script
            tC2Agent.sRemoverScript = ""
            Get nFile, , nChar
            Do Until nChar = 0
                tC2Agent.sRemoverScript = tC2Agent.sRemoverScript & Chr(nChar)
                Get nFile, , nChar
            Loop
            
            If Not bWithFormatting Then
                tC2Agent.sRemoverScript = COBtoCOS(tC2Agent.sRemoverScript)
            End If
            
            'Get Number of Object Scripts
            Get nFile, , tC2Agent.nNumberOfObjectScripts
            
            If tC2Agent.nNumberOfObjectScripts > 0 Then
                ReDim tC2Agent.aObjectScripts(0 To tC2Agent.nNumberOfObjectScripts - 1)
                
                For I = 0 To tC2Agent.nNumberOfObjectScripts - 1
                    Get nFile, , nChar
                    Do Until nChar = 0
                        tC2Agent.aObjectScripts(I) = tC2Agent.aObjectScripts(I) & Chr(nChar)
                        Get nFile, , nChar
                    Loop
                    
                    If Not bWithFormatting Then
                        tC2Agent.aObjectScripts(I) = COBtoCOS(tC2Agent.aObjectScripts(I))
                    End If
                Next
            End If
            
            'Get Required Files
            Get nFile, , tC2Agent.nNumberOfRequiredFiles
            
            If tC2Agent.nNumberOfRequiredFiles > 0 Then
            ReDim tC2Agent.aRequiredFiles(0 To tC2Agent.nNumberOfRequiredFiles - 1)
            
            For I = 0 To tC2Agent.nNumberOfRequiredFiles - 1
                With tC2Agent.aRequiredFiles(I)
                    Get nFile, , .nType
                    .sName = ""
                    Get nFile, , nChar
                    Do Until nChar = 0
                        .sName = .sName & Chr(nChar)
                        Get nFile, , nChar
                    Loop
                End With
            Next
            Else
                Erase tC2Agent.aRequiredFiles
            End If
            
            Get nFile, , nPicWidth
            Get nFile, , nPicHeight
            
            If nPicWidth > 0 Then
                ReDim aPicture(0 To CLng(nPicWidth) * CLng(nPicHeight) * 2 - 1) As Byte
                Get nFile, , aPicture
                
                Set tC2Agent.oPicture = New Bitmap
                With tC2Agent.oPicture
                    .BitsPerPixel = 16
                    .Width = nPicWidth
                    .Height = nPicHeight
                    .SetPixelArray aPicture
                End With
            End If
            
            ReDim Preserve m_tC2Agents(0 To m_nNumberOfAgents)
            m_tC2Agents(m_nNumberOfAgents) = tC2Agent
            m_nNumberOfAgents = m_nNumberOfAgents + 1
        ElseIf sTag = sC2AuthTag Then
            Get nFile, , nTemp
            
            With m_tC2Auth
                Get nFile, , .nDay
                Get nFile, , .nMonth
                Get nFile, , .nYear
                Get nFile, , .nVersion
                Get nFile, , .nRevision
                
                .sName = ""
                Get nFile, , nChar
                Do Until nChar = 0
                    .sName = .sName & Chr(nChar)
                    Get nFile, , nChar
                Loop
                
                .sEmail = ""
                Get nFile, , nChar
                Do Until nChar = 0
                    .sEmail = .sEmail & Chr(nChar)
                    Get nFile, , nChar
                Loop
            
                .sURL = ""
                Get nFile, , nChar
                Do Until nChar = 0
                    .sURL = .sURL & Chr(nChar)
                    Get nFile, , nChar
                Loop
            
                .sComments = ""
                Get nFile, , nChar
                Do Until nChar = 0
                    .sComments = .sComments & Chr(nChar)
                    Get nFile, , nChar
                Loop
            End With
            
            m_bAuthorBlock = True
        ElseIf sTag = sC2FileTag Then
            Get nFile, , nTemp
            
            With tC2EmbeddedFile
                Get nFile, , .nType
                Get nFile, , .nReserved
                Get nFile, , .nFileLength
                
                .sName = ""
                Get nFile, , nChar
                Do Until nChar = 0
                    .sName = .sName & Chr(nChar)
                    Get nFile, , nChar
                Loop
                
                ReDim .aFileData(0 To .nFileLength - 1)
                
                Get nFile, , .aFileData
            End With
            
            ReDim Preserve m_tC2EmbeddedFiles(0 To m_nNumberOfEmbeddedFiles)
            m_tC2EmbeddedFiles(m_nNumberOfEmbeddedFiles) = tC2EmbeddedFile
            m_nNumberOfEmbeddedFiles = m_nNumberOfEmbeddedFiles + 1
        Else
            Get nFile, , nTemp
            nTemp = nTemp + Seek(nFile)
            Seek nFile, nTemp
        End If
    Loop
    
    Close nFile
    
    If m_nNumberOfAgents > 0 Then
        m_nSelectedAgent = 0
    Else
        m_nSelectedAgent = -1
    End If
    
    m_bChanged = False
    
    LoadC2COBFile = True
End Function

Public Sub SaveC2COBFile(ByVal sFilename As String, ByVal bPreserveFormatting As Boolean)
    Dim nFile As Integer
    Dim nAgent As Integer
    Dim I As Integer
    Dim nTemp As Long
    Dim nTemp2 As Integer
    Dim sScript As String
    Dim nChar0 As Byte
    Dim aPicture() As Byte
    Dim nBlockStart As Long
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Kill sFilename
    Err.Clear
    
    Open sFilename For Binary Access Write As nFile
    If Err Then
        Err.Clear
        MsgBox "Error opening file '" & sFilename & "':" & vbCrLf & vbCrLf & Err.Description, vbExclamation, "Saving File..."
        Exit Sub
    End If
    
    On Error GoTo 0
    
    nChar0 = 0
    nTemp = 0
    
    Put nFile, , sC2COBTag
    
    For nAgent = 0 To m_nNumberOfAgents - 1
        Put nFile, , sC2AgentTag
        Put nFile, , nTemp  'placeholder for filesize
        
        nBlockStart = Seek(nFile)
        
        With m_tC2Agents(nAgent)
            Put nFile, , .nQuantityAvailable
            Put nFile, , .nLastInjectedTime
            Put nFile, , .nInjectionDelay
            Put nFile, , .nUseByDay
            Put nFile, , .nUseByMonth
            Put nFile, , .nUseByYear
            Put nFile, , .nReserved1
            Put nFile, , .nReserved2
            Put nFile, , .nReserved3
            'For I = 1 To 16
            '    Put nFile, , nChar0 '16 bytes of 0
            'Next
            Put nFile, , .sCOBName
            Put nFile, , nChar0 'char 0 terminator
            Put nFile, , .sCOBDescription
            Put nFile, , nChar0 'char 0 terminator
            sScript = .sInjectionScript
            If Not bPreserveFormatting Then
                sScript = COStoCOB(sScript)
            End If
            Put nFile, , sScript
            Put nFile, , nChar0 'char 0 terminator
            sScript = .sRemoverScript
            If Not bPreserveFormatting Then
                sScript = COStoCOB(sScript)
            End If
            Put nFile, , sScript
            Put nFile, , nChar0 'char 0 terminator
            Put nFile, , .nNumberOfObjectScripts
            
            For I = 0 To .nNumberOfObjectScripts - 1
                sScript = .aObjectScripts(I)
                If Not bPreserveFormatting Then
                    sScript = COStoCOB(sScript)
                End If
                Put nFile, , sScript
                Put nFile, , nChar0
            Next
            
            'Save Required Files list
            Put nFile, , .nNumberOfRequiredFiles
            
            For I = 0 To .nNumberOfRequiredFiles - 1
                Put nFile, , .aRequiredFiles(I).nType
                Put nFile, , .aRequiredFiles(I).sName
                Put nFile, , nChar0
            Next
            
            nTemp2 = .oPicture.Width
            Put nFile, , nTemp2
            nTemp2 = .oPicture.Height
            Put nFile, , nTemp2
            
            If .oPicture.Width > 0 Then
                .oPicture.GetPixelArray aPicture
                Put nFile, , aPicture
            End If
        End With
        
        nTemp = Seek(nFile) - nBlockStart
        
        Put nFile, nBlockStart - 4, nTemp
        Seek #nFile, nBlockStart + nTemp
    Next
    
    If m_nNumberOfEmbeddedFiles > 0 Then
        For I = 0 To m_nNumberOfEmbeddedFiles - 1
            Put nFile, , sC2FileTag
            Put nFile, , nTemp  'placeholder for filesize
            
            nBlockStart = Seek(nFile)
            
            With m_tC2EmbeddedFiles(I)
                Put nFile, , .nType
                Put nFile, , .nReserved
                Put nFile, , .nFileLength
                
                Put nFile, , .sName
                Put nFile, , nChar0
                
                Put nFile, , .aFileData
            End With
            
            nTemp = Seek(nFile) - nBlockStart
            
            Put nFile, nBlockStart - 4, nTemp
            Seek #nFile, nBlockStart + nTemp
        Next
    End If
    
    If m_bAuthorBlock Then
        Put nFile, , sC2AuthTag
        
        nTemp = 0
        Put nFile, , nTemp
        
        nBlockStart = Seek(nFile)
        
        With m_tC2Auth
            Put nFile, , .nDay
            Put nFile, , .nMonth
            Put nFile, , .nYear
            Put nFile, , .nVersion
            Put nFile, , .nRevision
            Put nFile, , .sName
            Put nFile, , nChar0
            Put nFile, , .sEmail
            Put nFile, , nChar0
            Put nFile, , .sURL
            Put nFile, , nChar0
            Put nFile, , .sComments
            Put nFile, , nChar0
        End With
        
        nTemp = Seek(nFile) - nBlockStart
        
        Put nFile, nBlockStart - 4, nTemp
        Seek #nFile, nBlockStart + nTemp
    End If
    Close nFile
End Sub

Private Sub ConvertC1ToC2()
    Dim nAgent As Long
    Dim I As Integer
    Dim oSprite As Sprite
    Dim X As Long
    Dim Y As Long
    Dim sScript As String
    
    InitialiseC2
    
    nAgent = AddAgent
    
    With m_tC2Agents(nAgent)
        .sCOBName = m_tC1COB.sCOBName
        .sCOBDescription = m_tC1COB.sCOBName
        
        If m_tC1COB.nQuantityAvailable = 255 Then
            .nQuantityAvailable = -1
        Else
            .nQuantityAvailable = m_tC1COB.nQuantityAvailable
        End If
        
        'Install Scripts
        If m_tC1COB.nNumberOfInstallScripts > 1 Then
            .sInjectionScript = "inst,"
            For I = 0 To m_tC1COB.nNumberOfInstallScripts - 1
                sScript = m_tC1COB.aInstallScripts(I)
                If Left(sScript, 4) = "inst" Then
                    sScript = Mid(sScript, 5)
                End If
                If Right(sScript, 4) = "endm" Then
                    sScript = Left(sScript, Len(sScript) - 4)
                End If
                sScript = Trim(sScript)
                If Left(sScript, 1) = "," Then
                    sScript = Mid(sScript, 2)
                End If
                If Right(sScript, 1) = "," Then
                    sScript = Left(sScript, Len(sScript) - 1)
                End If
                .sInjectionScript = .sInjectionScript & sScript & ","
            Next
            .sInjectionScript = .sInjectionScript & "endm"
        ElseIf m_tC1COB.nNumberOfInstallScripts = 1 Then
            .sInjectionScript = m_tC1COB.aInstallScripts(0)
        End If
        
        'Object Scripts
        .nNumberOfObjectScripts = m_tC1COB.nNumberOfObjectScripts
        
        If m_tC1COB.nNumberOfObjectScripts > 0 Then
            ReDim .aObjectScripts(0 To .nNumberOfObjectScripts - 1)
            
            For I = 0 To m_tC1COB.nNumberOfObjectScripts - 1
                .aObjectScripts(I) = m_tC1COB.aObjectScripts(I)
            Next
        End If
        
        'Picture
        Set oSprite = New Sprite
        oSprite.SpriteType = stcSPR
        oSprite.AddSpriteImage m_tC1COB.oPicture
        oSprite.SpriteType = stcS16_565
        If oSprite.NumberOfSpritesInFile > 0 Then
            Set .oPicture = oSprite.SpriteImages(1)
        Else
            Set .oPicture = New Bitmap
        End If
    End With
    
    InitialiseC1
    
    m_nSelectedAgent = nAgent
End Sub

Private Sub ConvertC2ToC1()
    Dim I As Integer
    Dim oSprite As Sprite
    Dim X As Long
    Dim Y As Long
    
    InitialiseC1
    
    If m_nSelectedAgent >= 0 Then
        With m_tC2Agents(m_nSelectedAgent)
            m_tC1COB.sCOBName = .sCOBName
            
            'Quantity Available
            If .nQuantityAvailable = -1 Or .nQuantityAvailable > 255 Then
                m_tC1COB.nQuantityAvailable = 255
            Else
                m_tC1COB.nQuantityAvailable = .nQuantityAvailable
            End If
                
            'Install Scripts
            m_tC1COB.nNumberOfInstallScripts = 1
            ReDim m_tC1COB.aInstallScripts(0 To 0) As String
            m_tC1COB.aInstallScripts(0) = .sInjectionScript
            
            'Object Scripts
            m_tC1COB.nNumberOfObjectScripts = .nNumberOfObjectScripts
            
            If .nNumberOfObjectScripts > 0 Then
                ReDim m_tC1COB.aObjectScripts(0 To m_tC1COB.nNumberOfObjectScripts - 1)
                
                For I = 0 To .nNumberOfObjectScripts - 1
                    m_tC1COB.aObjectScripts(I) = .aObjectScripts(I)
                Next
            End If
            
            'Picture
            Set oSprite = New Sprite
            oSprite.SpriteType = stcS16_565
            oSprite.AddSpriteImage .oPicture
            oSprite.SpriteType = stcSPR
            Set m_tC1COB.oPicture = oSprite.SpriteImages(1)
        End With
        
        InitialiseC2
    End If
End Sub

Public Function ExportCOS(ByVal sFilename As String) As Boolean
    Dim nFile As Integer
    Dim I As Integer
    Dim sLine As String
    Dim sCOSLine As String
    Dim nPos As Long
    
    ExportCOS = False
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Kill sFilename
    Err.Clear
    
    Open sFilename For Output Access Write As nFile
    
    Print #nFile, "********** Agent: " & sCOBName & " **********"
    Print #nFile, "*** Description: " & sCOBDescription
    Print #nFile,
    
    If nNumberOfInstallScripts > 0 Then
        Print #nFile, "*** Installation Script ***"
        Print #nFile, "iscr"
        
        For I = 0 To nNumberOfInstallScripts - 1
            sLine = aInstallScripts(I)
            Do While sLine <> ""
                nPos = InStr(sLine, vbCrLf)
                
                If nPos > 0 Then
                    sCOSLine = Left(sLine, nPos - 1)
                    sLine = Mid(sLine, nPos + 2)
                Else
                    sCOSLine = sLine
                    sLine = ""
                End If
                
                Print #nFile, sCOSLine
            Loop
            
            Print #nFile, "endm"
        Next
        
        Print #nFile,
    End If
    
    If sRemoverScript <> "" Then
        Print #nFile, "*** Removal Script ***"
        Print #nFile, "rscr"
        
        sLine = sRemoverScript
        Do While sLine <> ""
            nPos = InStr(sLine, vbCrLf)
            
            If nPos > 0 Then
                sCOSLine = Left(sLine, nPos - 1)
                sLine = Mid(sLine, nPos + 2)
            Else
                sCOSLine = sLine
                sLine = ""
            End If
            
            Print #nFile, sCOSLine
        Loop
        
        Print #nFile, "endm"
        Print #nFile,
    End If
    
    If nNumberOfObjectScripts > 0 Then
        For I = 0 To nNumberOfObjectScripts - 1
            Print #nFile, "*** Event Script ***"
            
            sLine = aObjectScripts(I)
            Do While sLine <> ""
                nPos = InStr(sLine, vbCrLf)
                
                If nPos > 0 Then
                    sCOSLine = Left(sLine, nPos - 1)
                    sLine = Mid(sLine, nPos + 2)
                Else
                    sCOSLine = sLine
                    sLine = ""
                End If
                
                Print #nFile, sCOSLine
            Loop
            
            Print #nFile, "endm"
            Print #nFile,
        Next
    End If
    
    Close nFile
End Function

Public Function ImportCOS(ByVal sFilename As String) As Boolean
    Dim nFile As Integer
    Dim sLine As String
    Dim I As Integer
    Dim sCOSLine As String
    Dim bInstallScript As Boolean
    Dim sInstallScript As String
    Dim bRemovalScript As Boolean
    Dim sRemovalScript As String
    Dim bEventScript As Boolean
    Dim aEventScripts() As String
    Dim nEventScripts As Integer
    
    ImportCOS = False
    
    nFile = FreeFile
    
    On Error Resume Next
    
    Open sFilename For Input Access Read As nFile
    
    If Err <> 0 Then
        Err.Clear
        Exit Function
    End If
    
    Do While Not EOF(nFile)
        Line Input #nFile, sLine
        
        sCOSLine = Trim(sLine)
        
        If StrComp(Left(sCOSLine, 4), "iscr", vbTextCompare) = 0 Then
            sInstallScript = ""
            bInstallScript = True
            bRemovalScript = False
            bEventScript = False
        ElseIf StrComp(Left(sCOSLine, 4), "rscr", vbTextCompare) = 0 Then
            sRemovalScript = ""
            bInstallScript = False
            bRemovalScript = True
            bEventScript = False
        ElseIf StrComp(Left(sCOSLine, 4), "scrp", vbTextCompare) = 0 Then
            nEventScripts = nEventScripts + 1
            ReDim aEventScripts(0 To nEventScripts - 1)
            aEventScripts(nEventScripts - 1) = sCOSLine & vbCrLf
            bInstallScript = False
            bRemovalScript = False
            bEventScript = True
        Else
            If bInstallScript Then
                sInstallScript = sInstallScript & sCOSLine & vbCrLf
            ElseIf bRemovalScript Then
                sRemovalScript = sRemovalScript & sCOSLine & vbCrLf
            ElseIf bEventScript Then
                aEventScripts(nEventScripts - 1) = aEventScripts(nEventScripts - 1) & sCOSLine & vbCrLf
            End If
        End If
    Loop
    
    Close nFile
    
    If m_eType = ctcCreatures1 Then
        If sInstallScript <> "" Then
            AddInstallScript "inst" & vbCrLf & sInstallScript
        End If
        
        For I = 0 To UBound(aEventScripts)
            AddObjectScript aEventScripts(I)
        Next
    ElseIf m_eType = ctcCreatures2 Then
        If sInstallScript <> "" Then
            sInjectionScript = sInjectionScript & sInstallScript
        End If
        
        If sRemovalScript <> "" Then
            sRemoverScript = sRemoverScript & sRemovalScript
        End If
        
        For I = 0 To UBound(aEventScripts)
            AddObjectScript aEventScripts(I)
        Next
    End If
    
    ImportCOS = True
End Function
