/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.annotations.semantic.simpledata.DirectBuffer;
import rebound.exceptions.DirectBufferException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.StructuredClassCastException;
import rebound.util.BasicExceptionUtilities;
import rebound.util.PlatformNIOBufferUtilities;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.PubliclyCloneable;

public class NIOBufferUtilities
implements JavaNamespace {
    public static void advance(Buffer b, int amount) {
        b.position(b.position() + amount);
    }

    @DirectBuffer
    public static ByteBuffer allocateDirectNativeEndianness(int capacityInBytes) {
        ByteBuffer b = ByteBuffer.allocateDirect(capacityInBytes);
        b.order(ByteOrder.nativeOrder());
        return b;
    }

    public static int getBufferBitlength(Buffer buffer) throws IllegalArgumentException {
        if (buffer instanceof ByteBuffer) {
            return 8;
        }
        if (buffer instanceof ShortBuffer) {
            return 16;
        }
        if (buffer instanceof CharBuffer) {
            return 16;
        }
        if (buffer instanceof IntBuffer) {
            return 32;
        }
        if (buffer instanceof FloatBuffer) {
            return 32;
        }
        if (buffer instanceof LongBuffer) {
            return 64;
        }
        if (buffer instanceof DoubleBuffer) {
            return 64;
        }
        if (buffer == null) {
            throw new NullPointerException();
        }
        throw new StructuredClassCastException(buffer.getClass());
    }

    public static <E extends Buffer> E cloneBuffer(E originalBuffer) {
        if (originalBuffer instanceof PubliclyCloneable) {
            return (E)((Buffer)((PubliclyCloneable)((Object)originalBuffer)).clone());
        }
        E newBuffer = PlatformNIOBufferUtilities.allocateCompatibleBuffer(originalBuffer);
        assert (newBuffer.capacity() == originalBuffer.capacity());
        NIOBufferUtilities.copyBuffers(originalBuffer, 0, newBuffer, 0, originalBuffer.capacity());
        return newBuffer;
    }

    public static void copyBuffers(Buffer sourceBuffer, Buffer destBuffer) {
        if (destBuffer.remaining() < sourceBuffer.remaining()) {
            throw new IndexOutOfBoundsException("Dest buffer (" + destBuffer.remaining() + " remaining) cannot hold as much as source buffer is providing! (" + sourceBuffer.remaining() + " remaining)");
        }
        if (destBuffer instanceof ExtendedBuffer) {
            ((ExtendedBuffer)((Object)destBuffer)).put(sourceBuffer);
        } else if (destBuffer instanceof ByteBuffer) {
            ((ByteBuffer)destBuffer).put((ByteBuffer)sourceBuffer);
        } else if (destBuffer instanceof CharBuffer) {
            ((CharBuffer)destBuffer).put((CharBuffer)sourceBuffer);
        } else if (destBuffer instanceof ShortBuffer) {
            ((ShortBuffer)destBuffer).put((ShortBuffer)sourceBuffer);
        } else if (destBuffer instanceof FloatBuffer) {
            ((FloatBuffer)destBuffer).put((FloatBuffer)sourceBuffer);
        } else if (destBuffer instanceof IntBuffer) {
            ((IntBuffer)destBuffer).put((IntBuffer)sourceBuffer);
        } else if (destBuffer instanceof DoubleBuffer) {
            ((DoubleBuffer)destBuffer).put((DoubleBuffer)sourceBuffer);
        } else if (destBuffer instanceof LongBuffer) {
            ((LongBuffer)destBuffer).put((LongBuffer)sourceBuffer);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(destBuffer);
        }
    }

    public static void copyBuffers(Buffer sourceBuffer, int sourceOffset, Buffer destBuffer, int destOffset, int numberOfElementsToCopy) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("Source start (" + sourceOffset + ") negative!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("Destination start (" + destOffset + ") negative!");
        }
        if (sourceOffset > sourceBuffer.capacity()) {
            throw new IndexOutOfBoundsException("Source end (" + sourceOffset + ") beyond source capacity (" + sourceBuffer.capacity() + ")!");
        }
        if (destOffset > destBuffer.capacity()) {
            throw new IndexOutOfBoundsException("Destination end (" + destOffset + ") beyond destination capacity (" + destBuffer.capacity() + ")!");
        }
        if (sourceOffset + numberOfElementsToCopy > sourceBuffer.capacity()) {
            throw new IndexOutOfBoundsException("Source end (" + (sourceOffset + numberOfElementsToCopy) + ") beyond source capacity (" + sourceBuffer.capacity() + ")!");
        }
        if (destOffset + numberOfElementsToCopy > destBuffer.capacity()) {
            throw new IndexOutOfBoundsException("Destination end (" + (destOffset + numberOfElementsToCopy) + ") beyond destination capacity (" + destBuffer.capacity() + ")!");
        }
        if (destBuffer instanceof ExtendedBuffer) {
            ((ExtendedBuffer)((Object)destBuffer)).put(destOffset, sourceBuffer, sourceOffset, numberOfElementsToCopy);
        } else if (destBuffer instanceof ByteBuffer || destBuffer instanceof CharBuffer || destBuffer instanceof ShortBuffer || destBuffer instanceof FloatBuffer || destBuffer instanceof IntBuffer || destBuffer instanceof DoubleBuffer || destBuffer instanceof LongBuffer) {
            int originalSourcePosition = sourceBuffer.position();
            int originalSourceLimit = sourceBuffer.limit();
            int originalDestPosition = destBuffer.position();
            int originalDestLimit = destBuffer.limit();
            NIOBufferUtilities.setPositionAndLimit(sourceBuffer, sourceOffset, sourceBuffer.capacity());
            NIOBufferUtilities.setPositionAndLimit(destBuffer, destOffset, destBuffer.capacity());
            if (destBuffer instanceof ByteBuffer) {
                ((ByteBuffer)destBuffer).put((ByteBuffer)sourceBuffer);
            } else if (destBuffer instanceof CharBuffer) {
                ((CharBuffer)destBuffer).put((CharBuffer)sourceBuffer);
            } else if (destBuffer instanceof ShortBuffer) {
                ((ShortBuffer)destBuffer).put((ShortBuffer)sourceBuffer);
            } else if (destBuffer instanceof FloatBuffer) {
                ((FloatBuffer)destBuffer).put((FloatBuffer)sourceBuffer);
            } else if (destBuffer instanceof IntBuffer) {
                ((IntBuffer)destBuffer).put((IntBuffer)sourceBuffer);
            } else if (destBuffer instanceof DoubleBuffer) {
                ((DoubleBuffer)destBuffer).put((DoubleBuffer)sourceBuffer);
            } else if (destBuffer instanceof LongBuffer) {
                ((LongBuffer)destBuffer).put((LongBuffer)sourceBuffer);
            } else {
                throw new StructuredClassCastException(destBuffer.getClass());
            }
            NIOBufferUtilities.setPositionAndLimit(sourceBuffer, originalSourcePosition, originalSourceLimit);
            NIOBufferUtilities.setPositionAndLimit(destBuffer, originalDestPosition, originalDestLimit);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(destBuffer);
        }
    }

    public static void setPositionAndLimit(Buffer buffer, int position, int limit) {
        if (position < 0) {
            throw new IndexOutOfBoundsException("Position (" + position + ") is negative!");
        }
        if (limit < 0) {
            throw new IndexOutOfBoundsException("Limit (" + limit + ") is negative!");
        }
        if (position > limit) {
            throw new IndexOutOfBoundsException("Position (" + position + ") beyond limit (" + limit + ")!");
        }
        buffer.limit(limit);
        buffer.position(position);
    }

    public static ByteBuffer insureCapacity(ByteBuffer extant, int minimumCapacity) {
        ByteBuffer rv = null;
        if (extant.capacity() < minimumCapacity) {
            int newCapacity = (int)((double)minimumCapacity * 1.2) + 256;
            rv = PlatformNIOBufferUtilities.allocateByteBuffer(newCapacity, PlatformNIOBufferUtilities.getBufferAllocationType(extant));
            rv.limit(extant.limit());
            rv.position(extant.position());
            rv.order(extant.order());
        } else {
            rv = extant;
        }
        return rv;
    }

    @LiveValue
    public static Slice getUnderlyingArrayOrThrowIfDirect(Buffer buffer) throws DirectBufferException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            Object array = buffer.array();
            return new Slice<Object>(array, buffer.arrayOffset(), buffer.remaining());
        }
        throw new DirectBufferException();
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Slice getUnderlyingArrayOrCopyIfDirect(Buffer buffer) throws DirectBufferException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            Object array = buffer.array();
            return new Slice<Object>(array, buffer.arrayOffset(), buffer.remaining());
        }
        return new Slice<Object>(NIOBufferUtilities.copyToNewArray(buffer), 0, buffer.remaining());
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static Object getArray(Buffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            Object array = buffer.array();
            if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
                return array;
            }
            Object subarray = Array.newInstance(array.getClass().getComponentType(), buffer.remaining());
            System.arraycopy(array, buffer.position(), subarray, 0, buffer.remaining());
            return subarray;
        }
        return NIOBufferUtilities.copyToNewArray(buffer);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static byte[] getArray(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            byte[] array = buffer.array();
            if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
                return array;
            }
            byte[] subarray = new byte[buffer.remaining()];
            System.arraycopy(array, buffer.position(), subarray, 0, subarray.length);
            return subarray;
        }
        return NIOBufferUtilities.copyToNewArray(buffer);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static char[] getArray(CharBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            char[] array = buffer.array();
            if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
                return array;
            }
            char[] subarray = new char[buffer.remaining()];
            System.arraycopy(array, buffer.position(), subarray, 0, subarray.length);
            return subarray;
        }
        return NIOBufferUtilities.copyToNewArray(buffer);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static short[] getArray(ShortBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            short[] array = buffer.array();
            if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
                return array;
            }
            short[] subarray = new short[buffer.remaining()];
            System.arraycopy(array, buffer.position(), subarray, 0, subarray.length);
            return subarray;
        }
        return NIOBufferUtilities.copyToNewArray(buffer);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static float[] getArray(FloatBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            float[] array = buffer.array();
            if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
                return array;
            }
            float[] subarray = new float[buffer.remaining()];
            System.arraycopy(array, buffer.position(), subarray, 0, subarray.length);
            return subarray;
        }
        return NIOBufferUtilities.copyToNewArray(buffer);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static int[] getArray(IntBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            int[] array = buffer.array();
            if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
                return array;
            }
            int[] subarray = new int[buffer.remaining()];
            System.arraycopy(array, buffer.position(), subarray, 0, subarray.length);
            return subarray;
        }
        return NIOBufferUtilities.copyToNewArray(buffer);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static double[] getArray(DoubleBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            double[] array = buffer.array();
            if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
                return array;
            }
            double[] subarray = new double[buffer.remaining()];
            System.arraycopy(array, buffer.position(), subarray, 0, subarray.length);
            return subarray;
        }
        return NIOBufferUtilities.copyToNewArray(buffer);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static long[] getArray(LongBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.hasArray()) {
            long[] array = buffer.array();
            if (buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
                return array;
            }
            long[] subarray = new long[buffer.remaining()];
            System.arraycopy(array, buffer.position(), subarray, 0, subarray.length);
            return subarray;
        }
        return NIOBufferUtilities.copyToNewArray(buffer);
    }

    @SnapshotValue
    @ThrowAwayValue
    public static Object copyToNewArray(Buffer buffer) {
        if (buffer instanceof ExtendedBuffer) {
            Object array = Array.newInstance(((ExtendedBuffer)((Object)buffer)).getComponentBaseType(), buffer.remaining());
            ((ExtendedBuffer)((Object)buffer)).get(buffer.position(), array);
            return array;
        }
        if (buffer instanceof ByteBuffer) {
            return NIOBufferUtilities.copyToNewArray((ByteBuffer)buffer);
        }
        if (buffer instanceof CharBuffer) {
            return NIOBufferUtilities.copyToNewArray((CharBuffer)buffer);
        }
        if (buffer instanceof ShortBuffer) {
            return NIOBufferUtilities.copyToNewArray((ShortBuffer)buffer);
        }
        if (buffer instanceof FloatBuffer) {
            return NIOBufferUtilities.copyToNewArray((FloatBuffer)buffer);
        }
        if (buffer instanceof IntBuffer) {
            return NIOBufferUtilities.copyToNewArray((IntBuffer)buffer);
        }
        if (buffer instanceof DoubleBuffer) {
            return NIOBufferUtilities.copyToNewArray((DoubleBuffer)buffer);
        }
        if (buffer instanceof LongBuffer) {
            return NIOBufferUtilities.copyToNewArray((LongBuffer)buffer);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(buffer);
    }

    @SnapshotValue
    @ThrowAwayValue
    public static byte[] copyToNewArray(ByteBuffer buffer) {
        byte[] array = new byte[buffer.remaining()];
        buffer.get(array);
        NIOBufferUtilities.advance(buffer, -array.length);
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static char[] copyToNewArray(CharBuffer buffer) {
        char[] array = new char[buffer.remaining()];
        buffer.get(array);
        NIOBufferUtilities.advance(buffer, -array.length);
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static short[] copyToNewArray(ShortBuffer buffer) {
        short[] array = new short[buffer.remaining()];
        buffer.get(array);
        NIOBufferUtilities.advance(buffer, -array.length);
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static float[] copyToNewArray(FloatBuffer buffer) {
        float[] array = new float[buffer.remaining()];
        buffer.get(array);
        NIOBufferUtilities.advance(buffer, -array.length);
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static int[] copyToNewArray(IntBuffer buffer) {
        int[] array = new int[buffer.remaining()];
        buffer.get(array);
        NIOBufferUtilities.advance(buffer, -array.length);
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static double[] copyToNewArray(DoubleBuffer buffer) {
        double[] array = new double[buffer.remaining()];
        buffer.get(array);
        NIOBufferUtilities.advance(buffer, -array.length);
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static long[] copyToNewArray(LongBuffer buffer) {
        long[] array = new long[buffer.remaining()];
        buffer.get(array);
        NIOBufferUtilities.advance(buffer, -array.length);
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static Object copyToNewArray(Buffer buffer, int absoluteOffset, int amount) {
        if (buffer instanceof ExtendedBuffer) {
            Object array = null;
            int originalPosition = buffer.position();
            int originalLimit = buffer.limit();
            NIOBufferUtilities.setPositionAndLimit(buffer, absoluteOffset, absoluteOffset + amount);
            try {
                array = Array.newInstance(((ExtendedBuffer)((Object)buffer)).getComponentBaseType(), buffer.remaining());
                ((ExtendedBuffer)((Object)buffer)).get(buffer.position(), array);
            }
            finally {
                NIOBufferUtilities.setPositionAndLimit(buffer, originalPosition, originalLimit);
            }
            return array;
        }
        if (buffer instanceof ByteBuffer) {
            return NIOBufferUtilities.copyToNewArray((ByteBuffer)buffer, absoluteOffset, amount);
        }
        if (buffer instanceof CharBuffer) {
            return NIOBufferUtilities.copyToNewArray((CharBuffer)buffer, absoluteOffset, amount);
        }
        if (buffer instanceof ShortBuffer) {
            return NIOBufferUtilities.copyToNewArray((ShortBuffer)buffer, absoluteOffset, amount);
        }
        if (buffer instanceof FloatBuffer) {
            return NIOBufferUtilities.copyToNewArray((FloatBuffer)buffer, absoluteOffset, amount);
        }
        if (buffer instanceof IntBuffer) {
            return NIOBufferUtilities.copyToNewArray((IntBuffer)buffer, absoluteOffset, amount);
        }
        if (buffer instanceof DoubleBuffer) {
            return NIOBufferUtilities.copyToNewArray((DoubleBuffer)buffer, absoluteOffset, amount);
        }
        if (buffer instanceof LongBuffer) {
            return NIOBufferUtilities.copyToNewArray((LongBuffer)buffer, absoluteOffset, amount);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(buffer);
    }

    @SnapshotValue
    @ThrowAwayValue
    public static byte[] copyToNewArray(ByteBuffer buffer, int absoluteOffset, int amount) {
        byte[] array = null;
        int originalPosition = buffer.position();
        int originalLimit = buffer.limit();
        NIOBufferUtilities.setPositionAndLimit(buffer, absoluteOffset, absoluteOffset + amount);
        try {
            array = new byte[amount];
            buffer.get(array);
        }
        finally {
            NIOBufferUtilities.setPositionAndLimit(buffer, originalPosition, originalLimit);
        }
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static char[] copyToNewArray(CharBuffer buffer, int absoluteOffset, int amount) {
        char[] array = null;
        int originalPosition = buffer.position();
        int originalLimit = buffer.limit();
        NIOBufferUtilities.setPositionAndLimit(buffer, absoluteOffset, absoluteOffset + amount);
        try {
            array = new char[amount];
            buffer.get(array);
        }
        finally {
            NIOBufferUtilities.setPositionAndLimit(buffer, originalPosition, originalLimit);
        }
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static short[] copyToNewArray(ShortBuffer buffer, int absoluteOffset, int amount) {
        short[] array = null;
        int originalPosition = buffer.position();
        int originalLimit = buffer.limit();
        NIOBufferUtilities.setPositionAndLimit(buffer, absoluteOffset, absoluteOffset + amount);
        try {
            array = new short[amount];
            buffer.get(array);
        }
        finally {
            NIOBufferUtilities.setPositionAndLimit(buffer, originalPosition, originalLimit);
        }
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static float[] copyToNewArray(FloatBuffer buffer, int absoluteOffset, int amount) {
        float[] array = null;
        int originalPosition = buffer.position();
        int originalLimit = buffer.limit();
        NIOBufferUtilities.setPositionAndLimit(buffer, absoluteOffset, absoluteOffset + amount);
        try {
            array = new float[amount];
            buffer.get(array);
        }
        finally {
            NIOBufferUtilities.setPositionAndLimit(buffer, originalPosition, originalLimit);
        }
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static int[] copyToNewArray(IntBuffer buffer, int absoluteOffset, int amount) {
        int[] array = null;
        int originalPosition = buffer.position();
        int originalLimit = buffer.limit();
        NIOBufferUtilities.setPositionAndLimit(buffer, absoluteOffset, absoluteOffset + amount);
        try {
            array = new int[amount];
            buffer.get(array);
        }
        finally {
            NIOBufferUtilities.setPositionAndLimit(buffer, originalPosition, originalLimit);
        }
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static double[] copyToNewArray(DoubleBuffer buffer, int absoluteOffset, int amount) {
        double[] array = null;
        int originalPosition = buffer.position();
        int originalLimit = buffer.limit();
        NIOBufferUtilities.setPositionAndLimit(buffer, absoluteOffset, absoluteOffset + amount);
        try {
            array = new double[amount];
            buffer.get(array);
        }
        finally {
            NIOBufferUtilities.setPositionAndLimit(buffer, originalPosition, originalLimit);
        }
        return array;
    }

    @SnapshotValue
    @ThrowAwayValue
    public static long[] copyToNewArray(LongBuffer buffer, int absoluteOffset, int amount) {
        long[] array = null;
        int originalPosition = buffer.position();
        int originalLimit = buffer.limit();
        NIOBufferUtilities.setPositionAndLimit(buffer, absoluteOffset, absoluteOffset + amount);
        try {
            array = new long[amount];
            buffer.get(array);
        }
        finally {
            NIOBufferUtilities.setPositionAndLimit(buffer, originalPosition, originalLimit);
        }
        return array;
    }

    public static Object wrapInBuffer(Object array) {
        if (array instanceof byte[]) {
            return NIOBufferUtilities.wrapInBuffer((byte[])array);
        }
        if (array instanceof char[]) {
            return NIOBufferUtilities.wrapInBuffer((char[])array);
        }
        if (array instanceof short[]) {
            return NIOBufferUtilities.wrapInBuffer((short[])array);
        }
        if (array instanceof float[]) {
            return NIOBufferUtilities.wrapInBuffer((float[])array);
        }
        if (array instanceof int[]) {
            return NIOBufferUtilities.wrapInBuffer((int[])array);
        }
        if (array instanceof double[]) {
            return NIOBufferUtilities.wrapInBuffer((double[])array);
        }
        if (array instanceof long[]) {
            return NIOBufferUtilities.wrapInBuffer((long[])array);
        }
        if (array == null) {
            return null;
        }
        throw new StructuredClassCastException("(Currently) Unsupported array type", array.getClass());
    }

    public static Object wrapInBuffer(Object array, int offset, int length) {
        if (array instanceof byte[]) {
            return NIOBufferUtilities.wrapInBuffer((byte[])array, offset, length);
        }
        if (array instanceof char[]) {
            return NIOBufferUtilities.wrapInBuffer((char[])array, offset, length);
        }
        if (array instanceof short[]) {
            return NIOBufferUtilities.wrapInBuffer((short[])array, offset, length);
        }
        if (array instanceof float[]) {
            return NIOBufferUtilities.wrapInBuffer((float[])array, offset, length);
        }
        if (array instanceof int[]) {
            return NIOBufferUtilities.wrapInBuffer((int[])array, offset, length);
        }
        if (array instanceof double[]) {
            return NIOBufferUtilities.wrapInBuffer((double[])array, offset, length);
        }
        if (array instanceof long[]) {
            return NIOBufferUtilities.wrapInBuffer((long[])array, offset, length);
        }
        if (array == null) {
            return null;
        }
        throw new StructuredClassCastException("(Currently) Unsupported array type", array.getClass());
    }

    public static ByteBuffer wrapInBuffer(byte[] array) {
        return ByteBuffer.wrap(array);
    }

    public static ByteBuffer wrapInBufferBySliceByte(Slice<byte[]> arraySlice) {
        return NIOBufferUtilities.wrapInBuffer(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static ByteBuffer wrapInBuffer(byte[] array, int offset, int length) {
        return ByteBuffer.wrap(array, offset, length);
    }

    public static CharBuffer wrapInBuffer(char[] array) {
        return CharBuffer.wrap(array);
    }

    public static CharBuffer wrapInBufferBySliceChar(Slice<char[]> arraySlice) {
        return NIOBufferUtilities.wrapInBuffer(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static CharBuffer wrapInBuffer(char[] array, int offset, int length) {
        return CharBuffer.wrap(array, offset, length);
    }

    public static ShortBuffer wrapInBuffer(short[] array) {
        return ShortBuffer.wrap(array);
    }

    public static ShortBuffer wrapInBufferBySliceShort(Slice<short[]> arraySlice) {
        return NIOBufferUtilities.wrapInBuffer(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static ShortBuffer wrapInBuffer(short[] array, int offset, int length) {
        return ShortBuffer.wrap(array, offset, length);
    }

    public static FloatBuffer wrapInBuffer(float[] array) {
        return FloatBuffer.wrap(array);
    }

    public static FloatBuffer wrapInBufferBySliceFloat(Slice<float[]> arraySlice) {
        return NIOBufferUtilities.wrapInBuffer(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static FloatBuffer wrapInBuffer(float[] array, int offset, int length) {
        return FloatBuffer.wrap(array, offset, length);
    }

    public static IntBuffer wrapInBuffer(int[] array) {
        return IntBuffer.wrap(array);
    }

    public static IntBuffer wrapInBufferBySliceInt(Slice<int[]> arraySlice) {
        return NIOBufferUtilities.wrapInBuffer(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static IntBuffer wrapInBuffer(int[] array, int offset, int length) {
        return IntBuffer.wrap(array, offset, length);
    }

    public static DoubleBuffer wrapInBuffer(double[] array) {
        return DoubleBuffer.wrap(array);
    }

    public static DoubleBuffer wrapInBufferBySliceDouble(Slice<double[]> arraySlice) {
        return NIOBufferUtilities.wrapInBuffer(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static DoubleBuffer wrapInBuffer(double[] array, int offset, int length) {
        return DoubleBuffer.wrap(array, offset, length);
    }

    public static LongBuffer wrapInBuffer(long[] array) {
        return LongBuffer.wrap(array);
    }

    public static LongBuffer wrapInBufferBySliceLong(Slice<long[]> arraySlice) {
        return NIOBufferUtilities.wrapInBuffer(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static LongBuffer wrapInBuffer(long[] array, int offset, int length) {
        return LongBuffer.wrap(array, offset, length);
    }

    public static void fillBytes(ByteBuffer buffer, int numberOfBytes, byte value) {
        int i = 0;
        while (i < numberOfBytes / 8) {
            buffer.putLong(0L);
            ++i;
        }
        i = 0;
        while (i < numberOfBytes % 8) {
            buffer.put((byte)0);
            ++i;
        }
    }

    public static void fillBytes(ByteBuffer buffer, int numberOfBytes) {
        NIOBufferUtilities.fillBytes(buffer, numberOfBytes, (byte)0);
    }

    public static void fillBytes(ByteBuffer buffer) {
        NIOBufferUtilities.fillBytes(buffer, buffer.remaining());
    }

    public static void fillBytes(byte[] buffer, int offset, int numberOfBytes, byte value) {
        int i = 0;
        while (i < numberOfBytes) {
            buffer[offset + i] = value;
            ++i;
        }
    }

    public static void fillBytes(byte[] buffer, int numberOfBytes, byte value) {
        NIOBufferUtilities.fillBytes(buffer, 0, numberOfBytes, value);
    }

    public static void fillBytes(byte[] buffer, int numberOfBytes) {
        NIOBufferUtilities.fillBytes(buffer, numberOfBytes, (byte)0);
    }

    public static void fillBytes(byte[] buffer) {
        NIOBufferUtilities.fillBytes(buffer, buffer.length);
    }

    public static void boundsCheckBuffer(Buffer buffer, int absolutePosition, int numberOfElements) {
        if (absolutePosition < 0) {
            throw new IndexOutOfBoundsException("Negative offset!");
        }
        if (numberOfElements < 0) {
            throw new IllegalArgumentException("Negative length!");
        }
        if (absolutePosition > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Starting position (" + absolutePosition + ") is beyond capacity of buffer (" + buffer.capacity() + ")!");
        }
        if (absolutePosition + numberOfElements > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Terminating position (" + (absolutePosition + numberOfElements) + ") is beyond capacity of buffer (" + buffer.capacity() + ")!");
        }
    }

    public static <B extends Buffer> B slice(B buffer) {
        if (buffer instanceof ByteBuffer) {
            return (B)((ByteBuffer)buffer).slice();
        }
        if (buffer instanceof CharBuffer) {
            return (B)((CharBuffer)buffer).slice();
        }
        if (buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)buffer).slice();
        }
        if (buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)buffer).slice();
        }
        if (buffer instanceof IntBuffer) {
            return (B)((IntBuffer)buffer).slice();
        }
        if (buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)buffer).slice();
        }
        if (buffer instanceof LongBuffer) {
            return (B)((LongBuffer)buffer).slice();
        }
        if (buffer instanceof SlicableBuffer) {
            return (B)((SlicableBuffer)((Object)buffer)).slice();
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(buffer);
    }

    public static int arrayOrBufferLength(Object source) {
        if (source instanceof Buffer) {
            return ((Buffer)source).capacity();
        }
        return Array.getLength(source);
    }

    public static void arrayOrBufferCopy(Object source, int sourceOffsetInElements, Object dest, int destOffsetInElements, int lengthInElements) {
        if (source instanceof Buffer) {
            if (dest instanceof Buffer) {
                throw new NotYetImplementedException();
            }
            if (dest.getClass().isArray()) {
                throw new NotYetImplementedException();
            }
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(dest);
        }
        if (dest instanceof Buffer) {
            if (source.getClass().isArray()) {
                throw new NotYetImplementedException();
            }
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(source);
        }
        System.arraycopy(source, sourceOffsetInElements, dest, destOffsetInElements, lengthInElements);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean arraysOrBuffersEqual(Object a, int aOffsetInElements, Object b, int bOffsetInElements, int lengthInElements) {
        if (a instanceof boolean[] && b instanceof boolean[]) {
            return ArrayUtilities.arrayEquals((boolean[])a, aOffsetInElements, (boolean[])b, bOffsetInElements, lengthInElements);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return ArrayUtilities.arrayEquals((byte[])a, aOffsetInElements, (byte[])b, bOffsetInElements, lengthInElements);
        }
        if (a instanceof char[] && b instanceof char[]) {
            return ArrayUtilities.arrayEquals((char[])a, aOffsetInElements, (char[])b, bOffsetInElements, lengthInElements);
        }
        if (a instanceof short[] && b instanceof short[]) {
            return ArrayUtilities.arrayEquals((short[])a, aOffsetInElements, (short[])b, bOffsetInElements, lengthInElements);
        }
        if (a instanceof float[] && b instanceof float[]) {
            return ArrayUtilities.arrayEquals((float[])a, aOffsetInElements, (float[])b, bOffsetInElements, lengthInElements);
        }
        if (a instanceof int[] && b instanceof int[]) {
            return ArrayUtilities.arrayEquals((int[])a, aOffsetInElements, (int[])b, bOffsetInElements, lengthInElements);
        }
        if (a instanceof double[] && b instanceof double[]) {
            return ArrayUtilities.arrayEquals((double[])a, aOffsetInElements, (double[])b, bOffsetInElements, lengthInElements);
        }
        if (a instanceof long[] && b instanceof long[]) {
            return ArrayUtilities.arrayEquals((long[])a, aOffsetInElements, (long[])b, bOffsetInElements, lengthInElements);
        }
        if (a instanceof Object[]) {
            if (!(b instanceof Object[])) throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(b);
            Arrays.equals((Object[])a, (Object[])b);
        } else if (b instanceof Object[]) {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(a);
        }
        if (!a.getClass().isArray() && !(a instanceof Buffer)) {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(a);
        }
        if (b.getClass().isArray() || b instanceof Buffer) throw new NotYetImplementedException();
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean arraysOrBuffersEqual(Object a, Object b) {
        if (a instanceof boolean[] && b instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof char[] && b instanceof char[]) {
            return Arrays.equals((char[])a, (char[])b);
        }
        if (a instanceof short[] && b instanceof short[]) {
            return Arrays.equals((short[])a, (short[])b);
        }
        if (a instanceof float[] && b instanceof float[]) {
            return Arrays.equals((float[])a, (float[])b);
        }
        if (a instanceof int[] && b instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof double[] && b instanceof double[]) {
            return Arrays.equals((double[])a, (double[])b);
        }
        if (a instanceof long[] && b instanceof long[]) {
            return Arrays.equals((long[])a, (long[])b);
        }
        if (a instanceof Object[]) {
            if (!(b instanceof Object[])) throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(b);
            Arrays.equals((Object[])a, (Object[])b);
        } else if (b instanceof Object[]) {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(a);
        }
        if (!a.getClass().isArray() && !(a instanceof Buffer)) {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(a);
        }
        if (b.getClass().isArray() || b instanceof Buffer) throw new NotYetImplementedException();
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(b);
    }

    public static Object getBoxing(Buffer buffer, int absoluteIndex) {
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).get(absoluteIndex);
        }
        if (buffer instanceof CharBuffer) {
            return Character.valueOf(((CharBuffer)buffer).get(absoluteIndex));
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).get(absoluteIndex);
        }
        if (buffer instanceof FloatBuffer) {
            return Float.valueOf(((FloatBuffer)buffer).get(absoluteIndex));
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).get(absoluteIndex);
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).get(absoluteIndex);
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).get(absoluteIndex);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(buffer);
    }

    public static void putUnboxing(Buffer buffer, int absoluteIndex, Object newValue) {
        if (buffer instanceof ByteBuffer) {
            ((ByteBuffer)buffer).put(absoluteIndex, (Byte)newValue);
        } else if (buffer instanceof CharBuffer) {
            ((CharBuffer)buffer).put(absoluteIndex, ((Character)newValue).charValue());
        } else if (buffer instanceof ShortBuffer) {
            ((ShortBuffer)buffer).put(absoluteIndex, (Short)newValue);
        } else if (buffer instanceof FloatBuffer) {
            ((FloatBuffer)buffer).put(absoluteIndex, ((Float)newValue).floatValue());
        } else if (buffer instanceof IntBuffer) {
            ((IntBuffer)buffer).put(absoluteIndex, (Integer)newValue);
        } else if (buffer instanceof DoubleBuffer) {
            ((DoubleBuffer)buffer).put(absoluteIndex, (Double)newValue);
        } else if (buffer instanceof LongBuffer) {
            ((LongBuffer)buffer).put(absoluteIndex, (Long)newValue);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(buffer);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ByteBuffer buffer, int bufferOffset, @WritableValue byte[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ByteBuffer buffer, int bufferOffset, @WritableValue byte[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ByteBuffer buffer, @WritableValue byte[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ByteBuffer buffer, @WritableValue byte[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ByteBuffer buffer, @WritableValue Slice<byte[]> arraySlice) {
        NIOBufferUtilities.getWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getWithoutMovingByte(@WritableValue ByteBuffer buffer, @ReadonlyValue PrimitiveCollections.ByteList list) {
        NIOBufferUtilities.getWithoutMoving(buffer, list.toByteArraySlicePossiblyLive());
    }

    public static void getMovingByte(@ReadonlyValue ByteBuffer buffer, @WritableValue Slice<byte[]> arraySlice) {
        buffer.get(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getMovingByte(@WritableValue ByteBuffer buffer, @ReadonlyValue PrimitiveCollections.ByteList list) {
        NIOBufferUtilities.getMovingByte(buffer, list.toByteArraySlicePossiblyLive());
    }

    public static byte[] getToNewArrayWithoutMoving(@ReadonlyValue ByteBuffer buffer, int length) {
        byte[] array = new byte[length];
        NIOBufferUtilities.getWithoutMoving(buffer, array);
        return array;
    }

    public static byte[] getToNewArrayMoving(@ReadonlyValue ByteBuffer buffer, int length) {
        byte[] array = new byte[length];
        buffer.get(array);
        return array;
    }

    public static PrimitiveCollections.ByteList getToNewListWithoutMovingByte(@ReadonlyValue ByteBuffer buffer, int length) {
        return PrimitiveCollections.byteArrayAsList(NIOBufferUtilities.getToNewArrayWithoutMoving(buffer, length));
    }

    public static PrimitiveCollections.ByteList getToNewListMovingByte(@ReadonlyValue ByteBuffer buffer, int length) {
        return PrimitiveCollections.byteArrayAsList(NIOBufferUtilities.getToNewArrayMoving(buffer, length));
    }

    public static void putWithoutMoving(@WritableValue ByteBuffer buffer, int bufferOffset, @ReadonlyValue byte[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue ByteBuffer buffer, int bufferOffset, @ReadonlyValue byte[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue ByteBuffer buffer, @ReadonlyValue byte[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue ByteBuffer buffer, @ReadonlyValue byte[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMovingByte(@WritableValue ByteBuffer buffer, @ReadonlyValue Slice<byte[]> arraySlice) {
        NIOBufferUtilities.putWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putWithoutMovingByte(@WritableValue ByteBuffer buffer, @ReadonlyValue PrimitiveCollections.ByteList list) {
        NIOBufferUtilities.putWithoutMovingByte(buffer, list.toByteArraySlicePossiblyLive());
    }

    public static void putMovingByte(@WritableValue ByteBuffer buffer, @ReadonlyValue Slice<byte[]> arraySlice) {
        buffer.put(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putMovingByte(@WritableValue ByteBuffer buffer, @ReadonlyValue PrimitiveCollections.ByteList list) {
        NIOBufferUtilities.putMovingByte(buffer, list.toByteArraySlicePossiblyLive());
    }

    public static ByteBuffer sliceToNIOBufferByte(Slice<byte[]> slice) {
        return ByteBuffer.wrap(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static void getWithoutMoving(@ReadonlyValue CharBuffer buffer, int bufferOffset, @WritableValue char[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue CharBuffer buffer, int bufferOffset, @WritableValue char[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue CharBuffer buffer, @WritableValue char[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue CharBuffer buffer, @WritableValue char[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue CharBuffer buffer, @WritableValue Slice<char[]> arraySlice) {
        NIOBufferUtilities.getWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getWithoutMovingChar(@WritableValue CharBuffer buffer, @ReadonlyValue PrimitiveCollections.CharacterList list) {
        NIOBufferUtilities.getWithoutMoving(buffer, list.toCharArraySlicePossiblyLive());
    }

    public static void getMovingChar(@ReadonlyValue CharBuffer buffer, @WritableValue Slice<char[]> arraySlice) {
        buffer.get(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getMovingChar(@WritableValue CharBuffer buffer, @ReadonlyValue PrimitiveCollections.CharacterList list) {
        NIOBufferUtilities.getMovingChar(buffer, list.toCharArraySlicePossiblyLive());
    }

    public static char[] getToNewArrayWithoutMoving(@ReadonlyValue CharBuffer buffer, int length) {
        char[] array = new char[length];
        NIOBufferUtilities.getWithoutMoving(buffer, array);
        return array;
    }

    public static char[] getToNewArrayMoving(@ReadonlyValue CharBuffer buffer, int length) {
        char[] array = new char[length];
        buffer.get(array);
        return array;
    }

    public static PrimitiveCollections.CharacterList getToNewListWithoutMovingChar(@ReadonlyValue CharBuffer buffer, int length) {
        return PrimitiveCollections.charArrayAsList(NIOBufferUtilities.getToNewArrayWithoutMoving(buffer, length));
    }

    public static PrimitiveCollections.CharacterList getToNewListMovingChar(@ReadonlyValue CharBuffer buffer, int length) {
        return PrimitiveCollections.charArrayAsList(NIOBufferUtilities.getToNewArrayMoving(buffer, length));
    }

    public static void putWithoutMoving(@WritableValue CharBuffer buffer, int bufferOffset, @ReadonlyValue char[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue CharBuffer buffer, int bufferOffset, @ReadonlyValue char[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue CharBuffer buffer, @ReadonlyValue char[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue CharBuffer buffer, @ReadonlyValue char[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMovingChar(@WritableValue CharBuffer buffer, @ReadonlyValue Slice<char[]> arraySlice) {
        NIOBufferUtilities.putWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putWithoutMovingChar(@WritableValue CharBuffer buffer, @ReadonlyValue PrimitiveCollections.CharacterList list) {
        NIOBufferUtilities.putWithoutMovingChar(buffer, list.toCharArraySlicePossiblyLive());
    }

    public static void putMovingChar(@WritableValue CharBuffer buffer, @ReadonlyValue Slice<char[]> arraySlice) {
        buffer.put(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putMovingChar(@WritableValue CharBuffer buffer, @ReadonlyValue PrimitiveCollections.CharacterList list) {
        NIOBufferUtilities.putMovingChar(buffer, list.toCharArraySlicePossiblyLive());
    }

    public static CharBuffer sliceToNIOBufferChar(Slice<char[]> slice) {
        return CharBuffer.wrap(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static void getWithoutMoving(@ReadonlyValue ShortBuffer buffer, int bufferOffset, @WritableValue short[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ShortBuffer buffer, int bufferOffset, @WritableValue short[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ShortBuffer buffer, @WritableValue short[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ShortBuffer buffer, @WritableValue short[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue ShortBuffer buffer, @WritableValue Slice<short[]> arraySlice) {
        NIOBufferUtilities.getWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getWithoutMovingShort(@WritableValue ShortBuffer buffer, @ReadonlyValue PrimitiveCollections.ShortList list) {
        NIOBufferUtilities.getWithoutMoving(buffer, list.toShortArraySlicePossiblyLive());
    }

    public static void getMovingShort(@ReadonlyValue ShortBuffer buffer, @WritableValue Slice<short[]> arraySlice) {
        buffer.get(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getMovingShort(@WritableValue ShortBuffer buffer, @ReadonlyValue PrimitiveCollections.ShortList list) {
        NIOBufferUtilities.getMovingShort(buffer, list.toShortArraySlicePossiblyLive());
    }

    public static short[] getToNewArrayWithoutMoving(@ReadonlyValue ShortBuffer buffer, int length) {
        short[] array = new short[length];
        NIOBufferUtilities.getWithoutMoving(buffer, array);
        return array;
    }

    public static short[] getToNewArrayMoving(@ReadonlyValue ShortBuffer buffer, int length) {
        short[] array = new short[length];
        buffer.get(array);
        return array;
    }

    public static PrimitiveCollections.ShortList getToNewListWithoutMovingShort(@ReadonlyValue ShortBuffer buffer, int length) {
        return PrimitiveCollections.shortArrayAsList(NIOBufferUtilities.getToNewArrayWithoutMoving(buffer, length));
    }

    public static PrimitiveCollections.ShortList getToNewListMovingShort(@ReadonlyValue ShortBuffer buffer, int length) {
        return PrimitiveCollections.shortArrayAsList(NIOBufferUtilities.getToNewArrayMoving(buffer, length));
    }

    public static void putWithoutMoving(@WritableValue ShortBuffer buffer, int bufferOffset, @ReadonlyValue short[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue ShortBuffer buffer, int bufferOffset, @ReadonlyValue short[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue ShortBuffer buffer, @ReadonlyValue short[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue ShortBuffer buffer, @ReadonlyValue short[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMovingShort(@WritableValue ShortBuffer buffer, @ReadonlyValue Slice<short[]> arraySlice) {
        NIOBufferUtilities.putWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putWithoutMovingShort(@WritableValue ShortBuffer buffer, @ReadonlyValue PrimitiveCollections.ShortList list) {
        NIOBufferUtilities.putWithoutMovingShort(buffer, list.toShortArraySlicePossiblyLive());
    }

    public static void putMovingShort(@WritableValue ShortBuffer buffer, @ReadonlyValue Slice<short[]> arraySlice) {
        buffer.put(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putMovingShort(@WritableValue ShortBuffer buffer, @ReadonlyValue PrimitiveCollections.ShortList list) {
        NIOBufferUtilities.putMovingShort(buffer, list.toShortArraySlicePossiblyLive());
    }

    public static ShortBuffer sliceToNIOBufferShort(Slice<short[]> slice) {
        return ShortBuffer.wrap(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static void getWithoutMoving(@ReadonlyValue FloatBuffer buffer, int bufferOffset, @WritableValue float[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue FloatBuffer buffer, int bufferOffset, @WritableValue float[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue FloatBuffer buffer, @WritableValue float[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue FloatBuffer buffer, @WritableValue float[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue FloatBuffer buffer, @WritableValue Slice<float[]> arraySlice) {
        NIOBufferUtilities.getWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getWithoutMovingFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue PrimitiveCollections.FloatList list) {
        NIOBufferUtilities.getWithoutMoving(buffer, list.toFloatArraySlicePossiblyLive());
    }

    public static void getMovingFloat(@ReadonlyValue FloatBuffer buffer, @WritableValue Slice<float[]> arraySlice) {
        buffer.get(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getMovingFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue PrimitiveCollections.FloatList list) {
        NIOBufferUtilities.getMovingFloat(buffer, list.toFloatArraySlicePossiblyLive());
    }

    public static float[] getToNewArrayWithoutMoving(@ReadonlyValue FloatBuffer buffer, int length) {
        float[] array = new float[length];
        NIOBufferUtilities.getWithoutMoving(buffer, array);
        return array;
    }

    public static float[] getToNewArrayMoving(@ReadonlyValue FloatBuffer buffer, int length) {
        float[] array = new float[length];
        buffer.get(array);
        return array;
    }

    public static PrimitiveCollections.FloatList getToNewListWithoutMovingFloat(@ReadonlyValue FloatBuffer buffer, int length) {
        return PrimitiveCollections.floatArrayAsList(NIOBufferUtilities.getToNewArrayWithoutMoving(buffer, length));
    }

    public static PrimitiveCollections.FloatList getToNewListMovingFloat(@ReadonlyValue FloatBuffer buffer, int length) {
        return PrimitiveCollections.floatArrayAsList(NIOBufferUtilities.getToNewArrayMoving(buffer, length));
    }

    public static void putWithoutMoving(@WritableValue FloatBuffer buffer, int bufferOffset, @ReadonlyValue float[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue FloatBuffer buffer, int bufferOffset, @ReadonlyValue float[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue FloatBuffer buffer, @ReadonlyValue float[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue FloatBuffer buffer, @ReadonlyValue float[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMovingFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue Slice<float[]> arraySlice) {
        NIOBufferUtilities.putWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putWithoutMovingFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue PrimitiveCollections.FloatList list) {
        NIOBufferUtilities.putWithoutMovingFloat(buffer, list.toFloatArraySlicePossiblyLive());
    }

    public static void putMovingFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue Slice<float[]> arraySlice) {
        buffer.put(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putMovingFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue PrimitiveCollections.FloatList list) {
        NIOBufferUtilities.putMovingFloat(buffer, list.toFloatArraySlicePossiblyLive());
    }

    public static FloatBuffer sliceToNIOBufferFloat(Slice<float[]> slice) {
        return FloatBuffer.wrap(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static void getWithoutMoving(@ReadonlyValue IntBuffer buffer, int bufferOffset, @WritableValue int[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue IntBuffer buffer, int bufferOffset, @WritableValue int[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue IntBuffer buffer, @WritableValue int[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue IntBuffer buffer, @WritableValue int[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue IntBuffer buffer, @WritableValue Slice<int[]> arraySlice) {
        NIOBufferUtilities.getWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getWithoutMovingInt(@WritableValue IntBuffer buffer, @ReadonlyValue PrimitiveCollections.IntegerList list) {
        NIOBufferUtilities.getWithoutMoving(buffer, list.toIntArraySlicePossiblyLive());
    }

    public static void getMovingInt(@ReadonlyValue IntBuffer buffer, @WritableValue Slice<int[]> arraySlice) {
        buffer.get(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getMovingInt(@WritableValue IntBuffer buffer, @ReadonlyValue PrimitiveCollections.IntegerList list) {
        NIOBufferUtilities.getMovingInt(buffer, list.toIntArraySlicePossiblyLive());
    }

    public static int[] getToNewArrayWithoutMoving(@ReadonlyValue IntBuffer buffer, int length) {
        int[] array = new int[length];
        NIOBufferUtilities.getWithoutMoving(buffer, array);
        return array;
    }

    public static int[] getToNewArrayMoving(@ReadonlyValue IntBuffer buffer, int length) {
        int[] array = new int[length];
        buffer.get(array);
        return array;
    }

    public static PrimitiveCollections.IntegerList getToNewListWithoutMovingInt(@ReadonlyValue IntBuffer buffer, int length) {
        return PrimitiveCollections.intArrayAsList(NIOBufferUtilities.getToNewArrayWithoutMoving(buffer, length));
    }

    public static PrimitiveCollections.IntegerList getToNewListMovingInt(@ReadonlyValue IntBuffer buffer, int length) {
        return PrimitiveCollections.intArrayAsList(NIOBufferUtilities.getToNewArrayMoving(buffer, length));
    }

    public static void putWithoutMoving(@WritableValue IntBuffer buffer, int bufferOffset, @ReadonlyValue int[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue IntBuffer buffer, int bufferOffset, @ReadonlyValue int[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue IntBuffer buffer, @ReadonlyValue int[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue IntBuffer buffer, @ReadonlyValue int[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMovingInt(@WritableValue IntBuffer buffer, @ReadonlyValue Slice<int[]> arraySlice) {
        NIOBufferUtilities.putWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putWithoutMovingInt(@WritableValue IntBuffer buffer, @ReadonlyValue PrimitiveCollections.IntegerList list) {
        NIOBufferUtilities.putWithoutMovingInt(buffer, list.toIntArraySlicePossiblyLive());
    }

    public static void putMovingInt(@WritableValue IntBuffer buffer, @ReadonlyValue Slice<int[]> arraySlice) {
        buffer.put(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putMovingInt(@WritableValue IntBuffer buffer, @ReadonlyValue PrimitiveCollections.IntegerList list) {
        NIOBufferUtilities.putMovingInt(buffer, list.toIntArraySlicePossiblyLive());
    }

    public static IntBuffer sliceToNIOBufferInt(Slice<int[]> slice) {
        return IntBuffer.wrap(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static void getWithoutMoving(@ReadonlyValue DoubleBuffer buffer, int bufferOffset, @WritableValue double[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue DoubleBuffer buffer, int bufferOffset, @WritableValue double[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue DoubleBuffer buffer, @WritableValue double[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue DoubleBuffer buffer, @WritableValue double[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue DoubleBuffer buffer, @WritableValue Slice<double[]> arraySlice) {
        NIOBufferUtilities.getWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getWithoutMovingDouble(@WritableValue DoubleBuffer buffer, @ReadonlyValue PrimitiveCollections.DoubleList list) {
        NIOBufferUtilities.getWithoutMoving(buffer, list.toDoubleArraySlicePossiblyLive());
    }

    public static void getMovingDouble(@ReadonlyValue DoubleBuffer buffer, @WritableValue Slice<double[]> arraySlice) {
        buffer.get(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getMovingDouble(@WritableValue DoubleBuffer buffer, @ReadonlyValue PrimitiveCollections.DoubleList list) {
        NIOBufferUtilities.getMovingDouble(buffer, list.toDoubleArraySlicePossiblyLive());
    }

    public static double[] getToNewArrayWithoutMoving(@ReadonlyValue DoubleBuffer buffer, int length) {
        double[] array = new double[length];
        NIOBufferUtilities.getWithoutMoving(buffer, array);
        return array;
    }

    public static double[] getToNewArrayMoving(@ReadonlyValue DoubleBuffer buffer, int length) {
        double[] array = new double[length];
        buffer.get(array);
        return array;
    }

    public static PrimitiveCollections.DoubleList getToNewListWithoutMovingDouble(@ReadonlyValue DoubleBuffer buffer, int length) {
        return PrimitiveCollections.doubleArrayAsList(NIOBufferUtilities.getToNewArrayWithoutMoving(buffer, length));
    }

    public static PrimitiveCollections.DoubleList getToNewListMovingDouble(@ReadonlyValue DoubleBuffer buffer, int length) {
        return PrimitiveCollections.doubleArrayAsList(NIOBufferUtilities.getToNewArrayMoving(buffer, length));
    }

    public static void putWithoutMoving(@WritableValue DoubleBuffer buffer, int bufferOffset, @ReadonlyValue double[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue DoubleBuffer buffer, int bufferOffset, @ReadonlyValue double[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue DoubleBuffer buffer, @ReadonlyValue double[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue DoubleBuffer buffer, @ReadonlyValue double[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMovingDouble(@WritableValue DoubleBuffer buffer, @ReadonlyValue Slice<double[]> arraySlice) {
        NIOBufferUtilities.putWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putWithoutMovingDouble(@WritableValue DoubleBuffer buffer, @ReadonlyValue PrimitiveCollections.DoubleList list) {
        NIOBufferUtilities.putWithoutMovingDouble(buffer, list.toDoubleArraySlicePossiblyLive());
    }

    public static void putMovingDouble(@WritableValue DoubleBuffer buffer, @ReadonlyValue Slice<double[]> arraySlice) {
        buffer.put(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putMovingDouble(@WritableValue DoubleBuffer buffer, @ReadonlyValue PrimitiveCollections.DoubleList list) {
        NIOBufferUtilities.putMovingDouble(buffer, list.toDoubleArraySlicePossiblyLive());
    }

    public static DoubleBuffer sliceToNIOBufferDouble(Slice<double[]> slice) {
        return DoubleBuffer.wrap(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static void getWithoutMoving(@ReadonlyValue LongBuffer buffer, int bufferOffset, @WritableValue long[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue LongBuffer buffer, int bufferOffset, @WritableValue long[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue LongBuffer buffer, @WritableValue long[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue LongBuffer buffer, @WritableValue long[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.get(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue LongBuffer buffer, @WritableValue Slice<long[]> arraySlice) {
        NIOBufferUtilities.getWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getWithoutMovingLong(@WritableValue LongBuffer buffer, @ReadonlyValue PrimitiveCollections.LongList list) {
        NIOBufferUtilities.getWithoutMoving(buffer, list.toLongArraySlicePossiblyLive());
    }

    public static void getMovingLong(@ReadonlyValue LongBuffer buffer, @WritableValue Slice<long[]> arraySlice) {
        buffer.get(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void getMovingLong(@WritableValue LongBuffer buffer, @ReadonlyValue PrimitiveCollections.LongList list) {
        NIOBufferUtilities.getMovingLong(buffer, list.toLongArraySlicePossiblyLive());
    }

    public static long[] getToNewArrayWithoutMoving(@ReadonlyValue LongBuffer buffer, int length) {
        long[] array = new long[length];
        NIOBufferUtilities.getWithoutMoving(buffer, array);
        return array;
    }

    public static long[] getToNewArrayMoving(@ReadonlyValue LongBuffer buffer, int length) {
        long[] array = new long[length];
        buffer.get(array);
        return array;
    }

    public static PrimitiveCollections.LongList getToNewListWithoutMovingLong(@ReadonlyValue LongBuffer buffer, int length) {
        return PrimitiveCollections.longArrayAsList(NIOBufferUtilities.getToNewArrayWithoutMoving(buffer, length));
    }

    public static PrimitiveCollections.LongList getToNewListMovingLong(@ReadonlyValue LongBuffer buffer, int length) {
        return PrimitiveCollections.longArrayAsList(NIOBufferUtilities.getToNewArrayMoving(buffer, length));
    }

    public static void putWithoutMoving(@WritableValue LongBuffer buffer, int bufferOffset, @ReadonlyValue long[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue LongBuffer buffer, int bufferOffset, @ReadonlyValue long[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.position(bufferOffset);
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue LongBuffer buffer, @ReadonlyValue long[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array, arrayOffset, length);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMoving(@WritableValue LongBuffer buffer, @ReadonlyValue long[] array) {
        int originalPosition = buffer.position();
        try {
            buffer.put(array);
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMovingLong(@WritableValue LongBuffer buffer, @ReadonlyValue Slice<long[]> arraySlice) {
        NIOBufferUtilities.putWithoutMoving(buffer, arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putWithoutMovingLong(@WritableValue LongBuffer buffer, @ReadonlyValue PrimitiveCollections.LongList list) {
        NIOBufferUtilities.putWithoutMovingLong(buffer, list.toLongArraySlicePossiblyLive());
    }

    public static void putMovingLong(@WritableValue LongBuffer buffer, @ReadonlyValue Slice<long[]> arraySlice) {
        buffer.put(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength());
    }

    public static void putMovingLong(@WritableValue LongBuffer buffer, @ReadonlyValue PrimitiveCollections.LongList list) {
        NIOBufferUtilities.putMovingLong(buffer, list.toLongArraySlicePossiblyLive());
    }

    public static LongBuffer sliceToNIOBufferLong(Slice<long[]> slice) {
        return LongBuffer.wrap(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static void getWithoutMoving(@ReadonlyValue FloatBuffer buffer, @WritableValue double[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            int i = 0;
            while (i < length) {
                array[arrayOffset + i] = buffer.get();
                ++i;
            }
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void getWithoutMoving(@ReadonlyValue FloatBuffer buffer, @WritableValue double[] array) {
        NIOBufferUtilities.getWithoutMoving(buffer, array, 0, array.length);
    }

    public static double[] getToNewDoubleArrayWithoutMoving(@ReadonlyValue FloatBuffer buffer, int length) {
        double[] array = new double[length];
        NIOBufferUtilities.getWithoutMoving(buffer, array);
        return array;
    }

    public static void putWithoutMovingDoubleIntoFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue double[] array, int arrayOffset, int length) {
        int originalPosition = buffer.position();
        try {
            int i = 0;
            while (i < length) {
                buffer.put((float)array[arrayOffset + i]);
                ++i;
            }
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void putWithoutMovingDoubleIntoFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue double[] array) {
        NIOBufferUtilities.putWithoutMovingDoubleIntoFloat(buffer, array, 0, array.length);
    }

    public static void putWithoutMovingDoubleIntoFloat(@WritableValue FloatBuffer buffer, @ReadonlyValue Slice<double[]> array) {
        NIOBufferUtilities.putWithoutMovingDoubleIntoFloat(buffer, array.getUnderlying(), array.getOffset(), array.getLength());
    }

    public static void withoutMovingBuffer(Buffer buffer, Runnable r) {
        int originalPosition = buffer.position();
        try {
            r.run();
        }
        finally {
            buffer.position(originalPosition);
        }
    }

    public static void setAllToZero(ByteBuffer b) {
        NIOBufferUtilities.setAll(b, (byte)0);
    }

    public static void setAll(ByteBuffer b, byte value) {
        NIOBufferUtilities.withoutMovingBuffer(b, () -> {
            while (b.hasRemaining()) {
                b.put((byte)0);
            }
        });
    }

    public static <B extends Buffer> B sliceNonmodifying(B buffer) {
        if (buffer instanceof ByteBuffer) {
            return (B)((ByteBuffer)buffer).slice();
        }
        if (buffer instanceof CharBuffer) {
            return (B)((CharBuffer)buffer).slice();
        }
        if (buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)buffer).slice();
        }
        if (buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)buffer).slice();
        }
        if (buffer instanceof IntBuffer) {
            return (B)((IntBuffer)buffer).slice();
        }
        if (buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)buffer).slice();
        }
        if (buffer instanceof LongBuffer) {
            return (B)((LongBuffer)buffer).slice();
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(buffer);
    }

    public static <B extends Buffer> B sliceAbsoluteNonmodifying(B buffer, int offset, int length) {
        B u;
        int p = buffer.position();
        int l = buffer.limit();
        if (offset != p || length != l - p) {
            if (offset + p + length > l) {
                throw new IndexOutOfBoundsException();
            }
            buffer.position(p + offset);
            buffer.limit(p + offset + length);
            u = NIOBufferUtilities.sliceNonmodifying(buffer);
            buffer.position(p);
            buffer.limit(l);
        } else {
            u = NIOBufferUtilities.sliceNonmodifying(buffer);
        }
        return u;
    }

    public static <B extends Buffer> B sliceRelativeAdvancing(B buffer, int offset, int length) {
        B u = NIOBufferUtilities.sliceNonmodifying(buffer);
        u.position(offset);
        u.limit(offset + length);
        NIOBufferUtilities.advance(buffer, length);
        return u;
    }

    public static <B extends Buffer> B sliceAbsoluteNonmodifying(Slice<B> bufferImmutablepositionslice) {
        return (B)NIOBufferUtilities.sliceAbsoluteNonmodifying((Buffer)bufferImmutablepositionslice.getUnderlying(), bufferImmutablepositionslice.getOffset(), bufferImmutablepositionslice.getLength());
    }

    public static <B extends Buffer> B sliceRelativeAdvancing(Slice<B> bufferImmutablepositionslice) {
        return (B)NIOBufferUtilities.sliceRelativeAdvancing((Buffer)bufferImmutablepositionslice.getUnderlying(), bufferImmutablepositionslice.getOffset(), bufferImmutablepositionslice.getLength());
    }

    public static ByteBuffer sliceNonmodifying(ByteBuffer buffer) {
        return buffer.slice();
    }

    public static CharBuffer sliceNonmodifying(CharBuffer buffer) {
        return buffer.slice();
    }

    public static ShortBuffer sliceNonmodifying(ShortBuffer buffer) {
        return buffer.slice();
    }

    public static FloatBuffer sliceNonmodifying(FloatBuffer buffer) {
        return buffer.slice();
    }

    public static IntBuffer sliceNonmodifying(IntBuffer buffer) {
        return buffer.slice();
    }

    public static DoubleBuffer sliceNonmodifying(DoubleBuffer buffer) {
        return buffer.slice();
    }

    public static LongBuffer sliceNonmodifying(LongBuffer buffer) {
        return buffer.slice();
    }

    public static void slicecopyBuffers(Slice source, Slice dest) {
        if (source.getLength() != dest.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Object sourceUnderlying = source.getUnderlying();
        Object destUnderlying = dest.getUnderlying();
        if (sourceUnderlying instanceof Buffer) {
            boolean cfr_ignored_0 = destUnderlying instanceof Buffer;
        } else if (!(destUnderlying instanceof Buffer)) {
            ArrayUtilities.slicecopy(source, dest);
        }
    }

    public static interface ExtendedBuffer<BufferBulkCopyConjugateType extends Buffer, ArrayType> {
        public void put(BufferBulkCopyConjugateType var1);

        public void put(int var1, BufferBulkCopyConjugateType var2, int var3, int var4);

        public Class getComponentBaseType();

        public void get(ArrayType var1);

        public void get(ArrayType var1, int var2, int var3);

        public void get(int var1, ArrayType var2);

        public void get(int var1, ArrayType var2, int var3, int var4);

        public void put(ArrayType var1);

        public void put(ArrayType var1, int var2, int var3);

        public void put(int var1, ArrayType var2);

        public void put(int var1, ArrayType var2, int var3, int var4);
    }

    public static interface SlicableBuffer {
        public Buffer slice();
    }
}

