/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.monk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.exceptions.ImpossibleException;
import rebound.io.util.FSIOUtilities;
import rebound.io.util.JRECompatIOUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.PathBoss;
import rebound.jagent.lib.caos2pray.CAOS2PRAY;
import rebound.jagent.lib.caos2pray.exc.ConfigReadException;
import rebound.jagent.lib.caos2pray.exc.DependencyException;
import rebound.jagent.lib.caos2pray.exc.ScanningException;
import rebound.jagent.lib.caos2pray.exc.ScriptReadException;
import rebound.jagent.lib.pray.Block;
import rebound.jagent.lib.pray.BlockHeader;
import rebound.jagent.lib.pray.InvalidNameException;
import rebound.jagent.lib.pray.PrayMaker;
import rebound.jagent.lib.pray.PrayParser;
import rebound.jagent.lib.pray.template.PrayTemplate;
import rebound.jagent.lib.pray.template.TemplateConstructor;
import rebound.jagent.lib.pray.template.TemplateParser;
import rebound.jagent.ui.gui.monk.Notifee;
import rebound.text.StringUtilities;
import rebound.util.BasicExceptionUtilities;

public class Monkifier {
    protected Notifee notifee;
    protected OutputType desiredOutput = OutputType.PrayChunk;
    protected boolean extractLowlevelOnPray2Pray = true;
    private TemplateParser temparser = new TemplateParser();
    private PrayMaker maker = new PrayMaker();
    private TemplateConstructor constructor = new TemplateConstructor();

    public Monkifier(Notifee n) {
        this.notifee = n;
    }

    public Monkifier() {
        this(new Notifee(){

            @Override
            public void notify(String message) {
                System.out.println("info: " + message);
            }

            @Override
            public void error(String prefix, Throwable cause) {
                this.error(String.valueOf(prefix) + " : (" + cause.getClass().getSimpleName() + ")\"" + cause.getMessage() + "\"");
                cause.printStackTrace();
            }

            @Override
            public void error(String message) {
                System.err.println("error: " + message);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public synchronized boolean monkifyMerging(Collection<File> files) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized boolean monkifySeparately(Collection<File> files) {
        Objects.requireNonNull(files);
        boolean allSuccess = true;
        for (File f : files) {
            allSuccess &= Objects.requireNonNull(this.monkify(f)) != SingleMonkificationResult.Errors;
        }
        return allSuccess;
    }

    @Nonnull
    public synchronized SingleMonkificationResult monkify(File sourceFile) {
        JagentPrayInputFormat inputFormat = this.getSourceFileFormat(sourceFile);
        OutputType outputFormat = this.getDesiredOutputType();
        if (inputFormat == JagentPrayInputFormat.CAOS2PRAY) {
            PrayTemplate data = this.monkifyToMemoryCAOS2PRAY(sourceFile);
            if (data == null) {
                return SingleMonkificationResult.Errors;
            }
            if (this.writePray(data, sourceFile.getName(), sourceFile.getAbsoluteFile().getParentFile(), outputFormat)) {
                this.notifee.notify("Done.");
                return SingleMonkificationResult.Success;
            }
            return SingleMonkificationResult.Errors;
        }
        if (inputFormat == JagentPrayInputFormat.PraySource) {
            if (outputFormat == OutputType.PrayTemplateSource) {
                this.notifee.notify("Nothing to do.");
                return SingleMonkificationResult.NothingToDo;
            }
            if (outputFormat == OutputType.PrayChunk) {
                PrayTemplate data = this.monkifyToMemoryPraySource(sourceFile);
                if (data == null) {
                    return SingleMonkificationResult.Errors;
                }
                if (this.writePray(data, sourceFile.getName(), sourceFile.getAbsoluteFile().getParentFile(), outputFormat)) {
                    this.notifee.notify("Done.");
                    return SingleMonkificationResult.Success;
                }
                return SingleMonkificationResult.Errors;
            }
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)outputFormat);
        }
        if (inputFormat == JagentPrayInputFormat.PrayChunk) {
            boolean chunkOut;
            if (outputFormat == OutputType.PrayTemplateSource) {
                chunkOut = false;
            } else if (outputFormat == OutputType.PrayChunk) {
                chunkOut = true;
            } else {
                throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)outputFormat);
            }
            if (!this.extractLowlevelOnPray2Pray && chunkOut) {
                this.notifee.notify("Nothing to do.");
                return SingleMonkificationResult.NothingToDo;
            }
            String basename = sourceFile.getName();
            this.notifee.notify("Parsing " + basename);
            File dir = new File(sourceFile.getParentFile(), String.valueOf(basename) + (chunkOut ? " lowlevel contents" : " files")).getAbsoluteFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!dir.isDirectory()) {
                this.notifee.error("Could not create destination directory " + dir);
                return SingleMonkificationResult.Errors;
            }
            boolean success = chunkOut ? this.monkifySplitPrayChunk(sourceFile, dir) : this.monkifyDecompilePrayChunkToPraySource(sourceFile, dir, basename);
            if (success) {
                this.notifee.notify("Done.");
            }
            return success ? SingleMonkificationResult.Success : SingleMonkificationResult.Errors;
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)inputFormat);
    }

    @Nullable
    public synchronized JagentPrayInputFormat getSourceFileFormat(File sourceFile) {
        Objects.requireNonNull(sourceFile);
        String lowercaseSourceFileName = sourceFile.getName().toLowerCase();
        if (lowercaseSourceFileName.endsWith(".cos")) {
            return JagentPrayInputFormat.CAOS2PRAY;
        }
        if (lowercaseSourceFileName.endsWith(".txt") || lowercaseSourceFileName.endsWith(".ps")) {
            return JagentPrayInputFormat.PraySource;
        }
        return JagentPrayInputFormat.PrayChunk;
    }

    @Nullable
    public synchronized PrayTemplate monkifyToMemoryCAOS2PRAY(File sourceFile) {
        this.notifee.notify("Analyzing " + sourceFile.getName());
        try {
            return CAOS2PRAY.convert(sourceFile);
        }
        catch (DependencyException exc) {
            this.notifee.error("Could not categorize dependency " + exc.getDependency(), exc);
            return null;
        }
        catch (ScriptReadException exc) {
            if (exc.isFileNotFound()) {
                this.notifee.error("Could not find " + (exc.isRemove() ? "remove " : "") + "script " + exc.getScript(), exc);
            } else {
                this.notifee.error("notifier.error analyzing " + (exc.isRemove() ? "remove " : "") + "script " + exc.getScript() + ": \"" + exc.getIOExc().getMessage() + "\"", exc);
            }
            return null;
        }
        catch (ScanningException exc) {
            this.notifee.error("CAOS2PRAY Analysis notifier.error: " + exc.getDetailMessage(), exc);
            return null;
        }
        catch (ConfigReadException exc) {
            throw new ImpossibleException("The config should have been read at main()!\t\tMsg:" + exc.getCause().getMessage());
        }
    }

    @Nullable
    public synchronized PrayTemplate monkifyToMemoryPraySource(File sourceFile) {
        this.notifee.notify("Parsing " + sourceFile.getName());
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileInputStream in = new FileInputStream(sourceFile);){
                this.temparser.setIn(in);
                this.temparser.parse();
                this.temparser.setContext(sourceFile);
                return this.temparser.getTemplate();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException exc) {
            this.notifee.error("Could not find " + sourceFile.getName(), exc);
            return null;
        }
        catch (IOException exc) {
            this.notifee.error("IOError parsing " + sourceFile.getName() + ": \"" + exc.getMessage() + "\"", exc);
            return null;
        }
    }

    @Nullable
    public synchronized List<Block> parsePrayChunkSimply(File sourceFile) {
        List<Block> parsed;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream in = new FileInputStream(sourceFile);){
                parsed = PrayParser.parseSimply(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FormatMismatchException exc) {
            this.notifee.error(String.valueOf(sourceFile.getName()) + " is not a supported PRAY chunk file.\n" + exc.getMessage(), exc);
            return null;
        }
        catch (IOException exc) {
            this.notifee.error("IOError parsing " + sourceFile.getName(), exc);
            return null;
        }
        return parsed;
    }

    public synchronized boolean monkifySplitPrayChunk(File sourceFile, File dir) {
        List<Block> parsed = this.parsePrayChunkSimply(sourceFile);
        if (parsed == null) {
            dir.delete();
            return false;
        }
        int index = 0;
        for (Block b : parsed) {
            block23: {
                BlockHeader h = b.getHeader();
                boolean compressed = h.isCompressed();
                String filename = "Block " + index + " - " + h.getIdTextBestEffort() + " - '" + StringUtilities.escapeJavaStandard(h.getName()) + "'" + (compressed ? " - compressed" : "") + ".rawprayblock";
                filename = PathBoss.getInstance().getEscapedNameOnCurrentHostOS(filename);
                File f = new File(dir, filename);
                try {
                    if (compressed) {
                        Throwable throwable = null;
                        Object var12_14 = null;
                        try (InputStream in = PrayParser.newInflaterInputStream(new ByteArrayInputStream(b.getData()));){
                            Throwable throwable2 = null;
                            Object var15_19 = null;
                            try (FileOutputStream out = new FileOutputStream(f);){
                                JRECompatIOUtilities.pump(in, (OutputStream)out);
                                break block23;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    FSIOUtilities.writeAll(f, b.getData());
                }
                catch (IOException exc) {
                    this.notifee.error("IOError constructing " + filename + ": \"" + exc.getMessage() + "\"", exc);
                    return false;
                }
            }
            ++index;
        }
        return true;
    }

    public synchronized boolean monkifyDecompilePrayChunkToPraySource(File sourceFile, File dir, String stemname) {
        PrayParser parser = new PrayParser();
        try {
            parser.setDir(dir);
            parser.setIn(sourceFile);
        }
        catch (FileNotFoundException exc) {
            this.notifee.error("Could not find " + sourceFile.getName(), exc);
            dir.delete();
            return false;
        }
        try {
            parser.parse();
            parser.getIn().close();
        }
        catch (FormatMismatchException exc) {
            this.notifee.error(String.valueOf(sourceFile.getName()) + " is not a supported PRAY chunk file.\n" + exc.getMessage(), exc);
            dir.delete();
            return false;
        }
        catch (IOException exc) {
            this.notifee.error("IOError parsing " + sourceFile.getName(), exc);
            dir.delete();
            return false;
        }
        PrayTemplate template = parser.getTemplate();
        this.notifee.notify("Generating " + stemname + ".txt");
        File out = new File(dir, String.valueOf(stemname) + ".txt");
        TemplateConstructor constructor = new TemplateConstructor();
        constructor.setTemplate(template);
        try {
            Throwable throwable = null;
            Object var9_15 = null;
            try (FileOutputStream cout = new FileOutputStream(out);){
                constructor.setOut(cout);
                constructor.construct();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException exc) {
            this.notifee.error("Strange, FileNotFound notifier.error from " + stemname + ".txt", exc);
            return false;
        }
        catch (IOException exc) {
            this.notifee.error("IOError constructing " + stemname + ".txt: \"" + exc.getMessage() + "\"", exc);
            return false;
        }
        return true;
    }

    public synchronized boolean writePray(PrayTemplate template, String sourceBasename, File dir, OutputType outputFormat) {
        block29: {
            int extdot = sourceBasename.lastIndexOf(".");
            if (extdot != -1) {
                sourceBasename = sourceBasename.substring(0, extdot);
            }
            String preferredOutputFile = template.getDesiredOutputFile();
            if (outputFormat == OutputType.PrayChunk) {
                String outputBasename = preferredOutputFile == null ? String.valueOf(sourceBasename) + ".agents" : preferredOutputFile;
                this.notifee.notify("Generating " + outputBasename);
                try {
                    Throwable throwable = null;
                    Object var9_19 = null;
                    try (FileOutputStream cout = new FileOutputStream(new File(dir, outputBasename));){
                        this.maker.setOut(cout);
                        this.maker.start();
                        this.maker.writePrayTemplate(template);
                        break block29;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FileNotFoundException exc) {
                    this.notifee.error("Strange, FileNotFound notifier.error from " + outputBasename, exc);
                    return false;
                }
                catch (IOException exc) {
                    this.notifee.error("IOError making PRAY chunk file " + outputBasename + ": \"" + exc.getMessage() + "\"", exc);
                    return false;
                }
                catch (InvalidNameException exc) {
                    this.notifee.error("Error making PRAY chunk file " + outputBasename + ": " + exc.getMessage(), exc);
                    return false;
                }
                catch (OutOfMemoryError err) {
                    this.notifee.error("Error making PRAY chunk file: program ran out of memory; it will now terminate.", err);
                    throw err;
                }
            }
            if (outputFormat == OutputType.PrayTemplateSource) {
                String out = preferredOutputFile == null ? String.valueOf(sourceBasename) + ".txt" : ((extdot = preferredOutputFile.lastIndexOf(".")) != -1 ? String.valueOf(preferredOutputFile.substring(0, extdot)) + ".txt" : preferredOutputFile);
                this.notifee.notify("Generating " + out);
                this.constructor.setTemplate(template);
                try {
                    Throwable err = null;
                    Object var9_21 = null;
                    try (FileOutputStream cout = new FileOutputStream(new File(dir, out));){
                        this.constructor.setOut(cout);
                        this.constructor.construct();
                        break block29;
                    }
                    catch (Throwable throwable) {
                        if (err == null) {
                            err = throwable;
                        } else if (err != throwable) {
                            err.addSuppressed(throwable);
                        }
                        throw err;
                    }
                }
                catch (FileNotFoundException exc) {
                    this.notifee.error("That's strange, we get a FileNotFound from " + out, exc);
                    return false;
                }
                catch (IOException exc) {
                    this.notifee.error("IOError constructing " + out + ": \"" + exc.getMessage() + "\"", exc);
                    return false;
                }
            }
            throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)outputFormat);
        }
        return true;
    }

    public synchronized Notifee getNotifee() {
        return this.notifee;
    }

    public synchronized void setNotifee(Notifee notifier) {
        this.notifee = notifier;
    }

    public synchronized OutputType getDesiredOutputType() {
        return this.desiredOutput;
    }

    public synchronized void setDesiredOutput(OutputType desiredOutput) {
        this.desiredOutput = desiredOutput;
    }

    public boolean isMergeScripts() {
        return this.maker.isMergeScripts();
    }

    public void setMergeScripts(boolean value) {
        this.maker.setMergeScripts(value);
    }

    public static enum JagentPrayInputFormat {
        CAOS2PRAY,
        PraySource,
        PrayChunk;

    }

    public static enum OutputType {
        PrayTemplateSource,
        PrayChunk;

    }

    public static enum SingleMonkificationResult {
        Success,
        NothingToDo,
        Errors;

    }
}

