/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.template;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Set;
import rebound.jagent.lib.pray.template.Group;
import rebound.jagent.lib.pray.template.PrayTemplate;

public class TemplateConstructor {
    protected Writer out;
    protected PrayTemplate template;

    public void construct() throws IOException {
        this.out.write("\"en-GB\"\n\n\n");
        int i = 0;
        while (i < this.template.getGroupCount()) {
            this.writeGroup(this.template.getGroup(i));
            ++i;
        }
        this.writeInlines();
        this.out.write("\n");
        this.out.flush();
    }

    protected void writeGroup(Group g) throws IOException {
        this.out.write("group ");
        this.writeEscaped(g.ID);
        this.out.write(" \"");
        this.writeEscaped(g.name);
        this.out.write("\"\n\n");
        int i = 0;
        while (i < g.getStrValCount()) {
            this.out.write("\"");
            this.writeEscaped(g.getStrTagName(i));
            this.out.write("\" \"");
            this.writeEscaped(g.getStrTagValue(i));
            this.out.write("\"\n");
            ++i;
        }
        this.out.write("\n");
        if (g.hasScripts()) {
            this.out.write("\"Script Count\" ");
            this.out.write(Integer.toString(g.getScriptFileNames().size()));
            this.out.write("\n");
            i = 0;
            while (i < g.getScriptFileNames().size()) {
                this.out.write("\"Script ");
                this.out.write(Integer.toString(i + 1));
                this.out.write("\" @ \"");
                this.writeEscaped(g.getScriptFileNames().get(i));
                this.out.write("\"\n");
                ++i;
            }
            this.out.write("\n");
        }
        i = 0;
        while (i < g.getIntValCount()) {
            if (!g.getIntTagName(i).equalsIgnoreCase("Script Count")) {
                this.out.write("\"");
                this.writeEscaped(g.getIntTagName(i));
                this.out.write("\" ");
                this.out.write(Integer.toString(g.getIntTagValue(i)));
                this.out.write("\n");
            }
            ++i;
        }
        this.out.write("\n\n\n");
    }

    protected void writeInlines() throws IOException {
        Object[] keys = null;
        Set<String> s = this.template.inlineFileNames.keySet();
        keys = s.toArray(new String[s.size()]);
        Arrays.sort(keys);
        String id = null;
        Object sourceFilename = null;
        String prayFilename = null;
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key;
            sourceFilename = key = objectArray[n2];
            id = this.template.getInlineFilePrayID((String)sourceFilename);
            prayFilename = this.template.getInlineFilePrayName((String)sourceFilename);
            this.out.write("inline ");
            this.out.write(id);
            this.out.write(" \"");
            this.writeEscaped((String)sourceFilename);
            this.out.write("\" \"");
            this.writeEscaped(prayFilename);
            this.out.write("\"\n");
            ++n2;
        }
    }

    protected void writeEscaped(String val) throws IOException {
        char c = '\u0000';
        int i = 0;
        while (i < val.length()) {
            c = val.charAt(i);
            if (c == '\n') {
                this.out.write("\\n");
            } else {
                if (c == '\"') {
                    this.out.write(92);
                }
                this.out.write(c);
            }
            ++i;
        }
    }

    public void setOut(Writer out) {
        this.out = out;
    }

    public void setOut(OutputStream bout) {
        this.out = new OutputStreamWriter(bout);
    }

    public void setTemplate(PrayTemplate template) {
        this.template = template;
    }

    public Writer getOut() {
        return this.out;
    }

    public PrayTemplate getTemplate() {
        return this.template;
    }
}

