/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.blocks.parsers;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import rebound.io.util.JRECompatIOUtilities;
import rebound.jagent.lib.PathBoss;
import rebound.jagent.lib.pray.BlockHeader;
import rebound.jagent.lib.pray.blocks.BlockParser;
import rebound.jagent.lib.pray.template.PrayTemplate;
import rebound.text.StringUtilities;

public class FileBlockParser
implements BlockParser {
    @Override
    public void parseBlock(BlockHeader b, InputStream data, PrayTemplate template) throws IOException {
        long fileLength;
        FileOutputStream fileout;
        long actual;
        File file = null;
        String preferredFilename = null;
        preferredFilename = b.getName();
        if (b.getID() == 13 && preferredFilename.endsWith(".photo")) {
            preferredFilename = String.valueOf(preferredFilename.substring(0, preferredFilename.length() - 6)) + ".s16";
        }
        preferredFilename = PathBoss.getInstance().getEscapedNameOnCurrentHostOS(preferredFilename);
        file = new File(template.getDir(), preferredFilename);
        if (file.exists()) {
            System.err.println("Warning: Possible PRAY Violation (duplicate inline file): Inline file \"" + b.getName() + "\" exists: " + file.getAbsolutePath());
            String pre = null;
            String post = null;
            String d = file.getParent();
            String n = file.getName();
            int ep = n.lastIndexOf(46);
            if (ep == -1) {
                pre = file.getPath();
                post = "";
            } else {
                pre = new File(d, n.substring(0, ep)).getPath();
                post = n.substring(ep);
            }
            File f = null;
            int i = 2;
            do {
                f = new File(String.valueOf(pre) + " (" + i + ")" + post);
                if (++i < 65536) continue;
                throw new IOException("Seriously?! How many files do you have?   {" + b.getName() + "," + file.getAbsolutePath() + "}");
            } while (f.exists());
            file = f;
        }
        if ((actual = JRECompatIOUtilities.pumpFixed(data, (OutputStream)(fileout = new FileOutputStream(file)), fileLength = (long)(b.isCompressed() ? b.getOriginalLength() : b.getLengthInFile()))) < fileLength) {
            try {
                fileout.close();
            }
            catch (IOException exc) {
                System.err.println("IOException closing file:");
                exc.printStackTrace();
            }
            throw new EOFException("Premature EOF detected in " + b.getIdTextBestEffort() + " block \"" + b.getName() + "\", correct length is specified to be " + fileLength + ", actual length in file is " + actual + ".    Most likely the file was truncated somehow (eg, incomplete download).");
        }
        fileout.close();
        template.addInline(StringUtilities.decodeTextToStringReporting(b.getId(), StandardCharsets.UTF_8), file.getName(), b.getName());
    }

    @Override
    public boolean canHandle(BlockHeader b) {
        return b.getID() == 0 || b.getID() == 13;
    }
}

