/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.template;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import rebound.jagent.lib.pray.template.Group;

public class PrayTemplate {
    protected File dir;
    protected Hashtable<String, String> inlineFileNames = new Hashtable(3);
    protected Hashtable<String, String> inlineFileIDs = new Hashtable(3);
    protected List<Group> groups = new ArrayList<Group>();
    protected String desiredOutputFile;

    public PrayTemplate() {
    }

    public PrayTemplate(File dir) {
        this();
        this.dir = dir;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof PrayTemplate)) {
            return false;
        }
        PrayTemplate o = (PrayTemplate)obj;
        return PrayTemplate.eq(this.inlineFileIDs, o.inlineFileIDs) && PrayTemplate.eq(this.inlineFileNames, o.inlineFileNames) && PrayTemplate.seteq(this.groups, o.groups);
    }

    private static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static boolean seteq(List a, List b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int length = a.size();
        if (b.size() != length) {
            return false;
        }
        ArrayList a2 = new ArrayList(a);
        ArrayList b2 = new ArrayList(b);
        int i = 0;
        while (i < length) {
            Object v = a2.get(i);
            int idx = b2.indexOf(v);
            if (idx == -1) {
                return false;
            }
            b2.remove(idx);
            ++i;
        }
        return true;
    }

    public void addGroup(Group g) {
        g.setDir(this.getDir());
        this.groups.add(g);
    }

    public void addInline(String id, String realFilename, String prayFilename) {
        this.inlineFileIDs.put(realFilename, id);
        this.inlineFileNames.put(realFilename, prayFilename);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Group getGroup(int index) {
        return this.groups.get(index);
    }

    public int getInlineFilesCount() {
        return this.inlineFileNames.size();
    }

    public void setDir(File dir) {
        this.dir = dir;
        int i = 0;
        while (i < this.groups.size()) {
            this.groups.get(i).setDir(dir);
            ++i;
        }
    }

    public File getDir() {
        return this.dir;
    }

    public String[] getInlineSourcefiles() {
        Set<String> keySet = this.inlineFileNames.keySet();
        Iterator<String> i = keySet.iterator();
        String[] rv = new String[keySet.size()];
        int e = 0;
        while (i.hasNext()) {
            rv[e++] = i.next();
        }
        return rv;
    }

    public String getInlineFilePrayName(String sourcename) {
        return this.inlineFileNames.get(sourcename);
    }

    public String getInlineFilePrayID(String sourcename) {
        return this.inlineFileIDs.get(sourcename);
    }

    public String getDesiredOutputFile() {
        return this.desiredOutputFile;
    }

    public void setDesiredOutputFile(String desiredOutputFile) {
        this.desiredOutputFile = desiredOutputFile;
    }
}

