/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.caos2pray.scanner;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import rebound.exceptions.ImpossibleException;
import rebound.io.util.UniversalNewlineReader;

public class CosParser {
    protected Token token = new Token();
    protected Reader in;
    boolean hasPushback = false;
    char pushbackChar = '\u0000';

    public CosParser() {
    }

    public CosParser(Reader r) {
        this();
        this.init(r);
    }

    public CosParser(String data) {
        this();
        this.init(data);
    }

    public CosParser(InputStream i) {
        this();
        this.init(new InputStreamReader(i));
    }

    public CosParser(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public void init(Reader r) {
        if (this.in != null) {
            throw new IllegalStateException("Parser is already committed. (it's disposable)");
        }
        UniversalNewlineReader unr = UniversalNewlineReader.wrap(r);
        this.in = unr;
        this.token = new Token();
    }

    public void init(InputStream i) throws IOException {
        this.init(new InputStreamReader(i, "UTF-8"));
    }

    public void init(String data) {
        this.init(new StringReader(data));
    }

    public Token next() throws IOException {
        try {
            StringBuilder buff;
            block18: {
                char c = this.read();
                buff = new StringBuilder();
                if (c == '\"') {
                    this.token.type = TokenType.STRING;
                    while ((c = this.read()) != '\"') {
                        if (c == '\\') {
                            c = this.read();
                            buff.append('\\');
                            buff.append(c);
                            continue;
                        }
                        buff.append(c);
                    }
                } else if (c == '\'') {
                    this.token.type = TokenType.CHAR;
                    while ((c = this.read()) != '\'') {
                        if (c == '\\') {
                            c = this.read();
                            buff.append('\\');
                            buff.append(c);
                            continue;
                        }
                        buff.append(c);
                    }
                } else {
                    if (c == '*') {
                        this.token.type = TokenType.COMMENT;
                        while (true) {
                            try {
                                c = this.read();
                            }
                            catch (EOFException exc) {
                                break block18;
                            }
                            if (c != '\n') {
                                buff.append(c);
                                continue;
                            }
                            break block18;
                            break;
                        }
                    }
                    this.token.type = TokenType.CAOS;
                    do {
                        buff.append(c);
                        try {
                            c = this.read();
                        }
                        catch (EOFException exc) {
                            break block18;
                        }
                    } while (c != '\"' && c != '\'' && c != '*');
                    this.pushback(c);
                }
            }
            this.token.text = buff.toString();
            return this.token;
        }
        catch (EOFException exc) {
            return null;
        }
    }

    protected char read() throws EOFException, IOException {
        if (this.hasPushback) {
            this.hasPushback = false;
            return this.pushbackChar;
        }
        int c = this.in.read();
        if (c == -1) {
            throw new EOFException();
        }
        return (char)c;
    }

    protected void pushback(char c) {
        if (this.hasPushback) {
            throw new IllegalStateException("Can only push back 1 char");
        }
        this.pushbackChar = c;
        this.hasPushback = true;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public static class Token {
        protected TokenType type;
        protected String text;

        public Token() {
        }

        public Token(TokenType type, String text) {
            this.type = type;
            this.text = text;
        }

        public TokenType getType() {
            return this.type;
        }

        public String getText() {
            return this.text;
        }

        public String getOriginalText() {
            switch (this.type) {
                case CAOS: {
                    return this.text;
                }
                case COMMENT: {
                    return "*" + this.text + "\n";
                }
                case STRING: {
                    return String.valueOf('\"') + this.text + '\"';
                }
                case CHAR: {
                    return "'" + this.text + "'";
                }
            }
            throw new ImpossibleException("enum escape");
        }

        public Token clone() {
            return new Token(this.getType(), this.getText());
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof Token) {
                Token o = (Token)obj;
                return o.getType() == this.getType() && (o.getText() == null && this.getText() == null || o.getText() != null && o.getText().equals(this.getText()));
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }
    }

    public static enum TokenType {
        CAOS,
        COMMENT,
        STRING,
        CHAR;

    }
}

