/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.json;

import from.java.io.forr.rebound.io.iio.ByteListInputByteStream;
import from.java.io.forr.rebound.io.iio.ByteListOutputByteStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import rebound.dataformats.json.JSONOptions;
import rebound.dataformats.json.JSONParserFactory;
import rebound.dataformats.json.contrib_rpmod_stringtree.JSONPrettyWriter;
import rebound.dataformats.json.contrib_rpmod_stringtree.JSONWriter;
import rebound.dataformats.json.rpslflexparser.SLFlexBasedJSONWCParserFactory;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.TextSyntaxCheckedException;
import rebound.exceptions.TextSyntaxException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.io.util.JRECompatIOUtilities;
import rebound.text.StringUtilities;
import rebound.util.collections.prim.PrimitiveCollections;

public class JSONUtilities {
    protected static final JSONParserFactory FactoryStandard = SLFlexBasedJSONWCParserFactory.Instance;
    protected static final JSONParserFactory FactoryWC = SLFlexBasedJSONWCParserFactory.Instance;

    public static Object parseJSONWC(String jsonwc) throws TextSyntaxException {
        JSONParserFactory factory = FactoryWC;
        try {
            return factory.newParser(JSONOptions.getJSONWCOptions(factory.getDefaultBigIntegerDecoding())).parse(jsonwc);
        }
        catch (TextSyntaxCheckedException exc) {
            throw exc.toSyntaxRuntimeException();
        }
    }

    public static Object parseJSON(String json) throws TextSyntaxException {
        JSONParserFactory factory = FactoryStandard;
        try {
            return factory.newStandardParser().parse(json);
        }
        catch (TextSyntaxCheckedException exc) {
            throw exc.toSyntaxRuntimeException();
        }
    }

    public static Object parseJSONWC(Reader jsonwc) throws IOException, TextSyntaxException {
        JSONParserFactory factory = FactoryWC;
        try {
            return factory.newParser(JSONOptions.getJSONWCOptions(factory.getDefaultBigIntegerDecoding())).parse(jsonwc);
        }
        catch (TextSyntaxCheckedException exc) {
            throw exc.toSyntaxRuntimeException();
        }
    }

    public static Object parseJSON(Reader json) throws IOException, TextSyntaxException {
        JSONParserFactory factory = FactoryStandard;
        try {
            return factory.newStandardParser().parse(json);
        }
        catch (TextSyntaxCheckedException exc) {
            throw exc.toSyntaxRuntimeException();
        }
    }

    public static boolean isValidJSON(String json) {
        try {
            JSONUtilities.parseJSON(json);
        }
        catch (TextSyntaxException exc) {
            return false;
        }
        return true;
    }

    public static boolean isValidJSON(Reader json) throws IOException {
        try {
            JSONUtilities.parseJSON(json);
        }
        catch (TextSyntaxException exc) {
            return false;
        }
        return true;
    }

    public static boolean isValidJSONWC(String json) {
        try {
            JSONUtilities.parseJSONWC(json);
        }
        catch (TextSyntaxException exc) {
            return false;
        }
        return true;
    }

    public static boolean isValidJSONWC(Reader json) throws IOException {
        try {
            JSONUtilities.parseJSONWC(json);
        }
        catch (TextSyntaxException exc) {
            return false;
        }
        return true;
    }

    public static String serializeJSON(Object gds) {
        return JSONUtilities.serializeJSONEfficiently(gds);
    }

    public static String serializeJSONEfficiently(Object gds) {
        JSONWriter stringtreeWriter = new JSONWriter();
        return stringtreeWriter.write(gds);
    }

    public static String serializeJSONForHumans(Object gds) {
        JSONPrettyWriter stringtreePrettyWriter = new JSONPrettyWriter("\t");
        return ((JSONWriter)stringtreePrettyWriter).write(gds);
    }

    public static void serializeJSON(Object gds, Writer out) throws IOException {
        JSONUtilities.serializeJSONEfficiently(gds, out);
    }

    public static void serializeJSONEfficiently(Object gds, Writer out) throws IOException {
        out.write(JSONUtilities.serializeJSONEfficiently(gds));
    }

    public static void serializeJSONForHumans(Object gds, Writer out) throws IOException {
        out.write(JSONUtilities.serializeJSONForHumans(gds));
    }

    public static String serializeJSONListOneEntryPerLine(List gds) {
        return JRECompatIOUtilities.writeAllTextToMemory(w -> JSONUtilities.serializeJSONListOneEntryPerLine(gds, w));
    }

    public static void serializeJSONListOneEntryPerLine(List gds, Writer out) throws IOException {
        out.write("[\n");
        boolean first = true;
        for (Object o : gds) {
            if (first) {
                first = false;
            } else {
                out.write(",\n");
            }
            out.write("\t" + JSONUtilities.serializeJSONEfficiently(o));
        }
        out.write("\n]\n");
    }

    public static String prettifyJSON(String json) {
        return JSONUtilities.serializeJSONForHumans(JSONUtilities.parseJSON(json));
    }

    public static String prettifyJSONWCRemovingComments(String json) {
        return JSONUtilities.serializeJSONForHumans(JSONUtilities.parseJSONWC(json));
    }

    public static List parseJSONWCList(String jsonlist) {
        return (List)JSONUtilities.parseJSONWC(JSONUtilities.jsonlistToJson(jsonlist));
    }

    public static List parseJSONList(String jsonlist) {
        return (List)JSONUtilities.parseJSON(JSONUtilities.jsonlistToJson(jsonlist));
    }

    public static String jsonlistToJson(String jsonlist) {
        String j = jsonlist;
        j = j.trim();
        j = StringUtilities.rtrim(j, ',');
        j = "[" + j + "]";
        return j;
    }

    public static Object parseJSONWCfromUTF8(byte[] jsonwc) throws TextSyntaxException {
        try {
            return JSONUtilities.parseJSONWCfromUTF8(new ByteArrayInputStream(jsonwc));
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static Object parseJSONWCfromUTF8(PrimitiveCollections.ByteList jsonwc) throws TextSyntaxException {
        try {
            return JSONUtilities.parseJSONWCfromUTF8(new ByteListInputByteStream(jsonwc));
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static Object parseJSONWCfromUTF8(InputStream jsonwc) throws TextSyntaxException, IOException {
        return JSONUtilities.parseJSONWC(new InputStreamReader(jsonwc, StandardCharsets.UTF_8));
    }

    public static Object parseJSONfromUTF8(byte[] json) throws TextSyntaxException {
        try {
            return JSONUtilities.parseJSONfromUTF8(new ByteArrayInputStream(json));
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static Object parseJSONfromUTF8(PrimitiveCollections.ByteList json) throws TextSyntaxException {
        try {
            return JSONUtilities.parseJSONfromUTF8(new ByteListInputByteStream(json));
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static Object parseJSONfromUTF8(InputStream json) throws TextSyntaxException, IOException {
        return JSONUtilities.parseJSON(new InputStreamReader(json, StandardCharsets.UTF_8));
    }

    public static byte[] serializeJSONEfficientlyToUTF8Array(Object gds) {
        try {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            JSONUtilities.serializeJSONEfficientlyToUTF8(gds, buff);
            return buff.toByteArray();
        }
        catch (IOException exc) {
            throw new ImpossibleException();
        }
    }

    public static byte[] serializeJSONForHumansToUTF8Array(Object gds) {
        try {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            JSONUtilities.serializeJSONForHumansToUTF8(gds, buff);
            return buff.toByteArray();
        }
        catch (IOException exc) {
            throw new ImpossibleException();
        }
    }

    public static PrimitiveCollections.ByteList serializeJSONEfficientlyToUTF8List(Object gds) {
        try {
            ByteListOutputByteStream buff = new ByteListOutputByteStream();
            JSONUtilities.serializeJSONEfficientlyToUTF8(gds, buff);
            return buff.getByteListLive();
        }
        catch (IOException exc) {
            throw new ImpossibleException();
        }
    }

    public static PrimitiveCollections.ByteList serializeJSONForHumansToUTF8List(Object gds) {
        try {
            ByteListOutputByteStream buff = new ByteListOutputByteStream();
            JSONUtilities.serializeJSONForHumansToUTF8(gds, buff);
            return buff.getByteListLive();
        }
        catch (IOException exc) {
            throw new ImpossibleException();
        }
    }

    public static void serializeJSONEfficientlyToUTF8(Object gds, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        JSONUtilities.serializeJSONEfficiently(gds, w);
        ((Writer)w).flush();
    }

    public static void serializeJSONForHumansToUTF8(Object gds, OutputStream out) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        JSONUtilities.serializeJSONForHumans(gds, w);
        ((Writer)w).flush();
    }
}

