/*
 * Decompiled with CFR 0.152.
 */
package rebound.concurrency.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.hints.IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.semantic.temporal.concurrencyprimitives.threadspecification.AnyThreads;
import rebound.annotations.semantic.temporal.concurrencyprimitives.threadspecification.WhichThreads;
import rebound.concurrency.threads.GenericEventQueue;
import rebound.concurrency.threads.QueueIsShutdownException;
import rebound.exceptions.DeadlockException;
import rebound.util.collections.CollectionUtilities;
import rebound.util.container.SimpleContainers;
import rebound.util.functional.ContinueSignal;

public class SimpleEventQueue
implements GenericEventQueue,
GenericEventQueue.ShutdownableQueue,
Runnable {
    public static final int DefaultQueueCapacity = 1000;
    protected final Object lock = new Object();
    @GuardedBy(value="lock")
    protected Queue<Runnable> queue;
    protected Thread dispatchThread;

    public SimpleEventQueue() {
        this(null, 1000);
    }

    public SimpleEventQueue(int queueCapacity) {
        this(null, queueCapacity);
    }

    public SimpleEventQueue(@Nullable Thread dispatchThread) {
        this(dispatchThread, 1000);
    }

    public SimpleEventQueue(@Nullable Thread dispatchThread, int queueCapacity) {
        this.dispatchThread = dispatchThread;
        this.queue = CollectionUtilities.newArrayQueue(queueCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeLater(Runnable task) {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                Queue<Runnable> q = this.queue;
                if (q != null) {
                    if (q.offer(task)) {
                        this.lock.notifyAll();
                        return;
                    }
                    if (this.isDispatchThread()) {
                        throw new DeadlockException("Queue ran out of capacity enqueing something from its own dispatch thread!  It would be waiting on itself!!");
                    }
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    throw new QueueIsShutdownException();
                }
            }
        }
    }

    @Override
    public boolean isDispatchThread() {
        Thread d = this.dispatchThread;
        if (d == null) {
            throw new IllegalStateException("We don't know our dispatch thread yet!!");
        }
        return Thread.currentThread() == d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AnyThreads
    public List<Runnable> shutdown() {
        ArrayList<Runnable> remnants;
        Object object = this.lock;
        synchronized (object) {
            remnants = new ArrayList<Runnable>(this.queue);
            this.queue = null;
            this.lock.notifyAll();
        }
        return remnants;
    }

    @Override
    public boolean isShutdown() {
        return this.queue == null;
    }

    @Override
    @WhichThreads(value={"dispatch"})
    @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
    public void run() {
        if (this.dispatchThread != null) {
            if (Thread.currentThread() != this.dispatchThread) {
                throw new IllegalThreadStateException();
            }
        } else {
            this.dispatchThread = Thread.currentThread();
        }
        while (true) {
            ContinueSignal r;
            if ((r = this.queueLoopIteration()) == ContinueSignal.Continue) {
                continue;
            }
            if (r == ContinueSignal.Stop) break;
            GlobalCodeMetastuffContext.logBug();
        }
    }

    @WhichThreads(value={"dispatch"})
    @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
    @Nonnull
    protected ContinueSignal queueLoopIteration() {
        Result r = this.runTaskFromQueue();
        if (r == Result.RanTask) {
            return ContinueSignal.Continue;
        }
        if (r == Result.TryAgain) {
            return ContinueSignal.Continue;
        }
        if (r == Result.ShutdownDetected) {
            return ContinueSignal.Stop;
        }
        GlobalCodeMetastuffContext.logBug();
        return ContinueSignal.Continue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WhichThreads(value={"dispatch"})
    @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
    @Nonnull
    protected Result runTaskFromQueue() {
        Runnable task;
        Object object = this.lock;
        synchronized (object) {
            if (this.queue == null) {
                return Result.ShutdownDetected;
            }
            task = this.queue.poll();
            if (task == null) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return Result.TryAgain;
            }
            this.lock.notifyAll();
        }
        try {
            task.run();
        }
        catch (Throwable exc) {
            this.handleUncaughtThrowable(exc);
        }
        return Result.RanTask;
    }

    @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
    protected void handleUncaughtThrowable(Throwable t) {
        t.printStackTrace();
    }

    public void setDispatchThreadToCurrentThread() {
        this.setDispatchThread(Thread.currentThread());
    }

    public void setDispatchThread(Thread dispatchThread) {
        this.dispatchThread = dispatchThread;
    }

    public Thread getDispatchThread() {
        return this.dispatchThread;
    }

    @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
    @AnyThreads
    public void queueToShutdownOnlyWhenAllTasksAreCompleteSusceptiblyToLivelocks(@Nullable Runnable callback) {
        SimpleContainers.SimpleObjectContainer<Runnable> safeShutdownTask_C = new SimpleContainers.SimpleObjectContainer<Runnable>();
        Runnable safeShutdownTask = () -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.queue != null && this.queue.isEmpty()) {
                    this.queue = null;
                    this.lock.notifyAll();
                    callback.run();
                    return;
                }
            }
            this.invokeLater((Runnable)safeShutdownTask_C.get());
        };
        safeShutdownTask_C.set(safeShutdownTask);
        this.invokeLater(safeShutdownTask);
    }

    public static enum Result {
        RanTask,
        ShutdownDetected,
        TryAgain;

    }
}

