/*
 * Decompiled with CFR 0.152.
 */
package rebound.concurrency.threads;

import javax.annotation.Nonnull;
import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.semantic.temporal.concurrencyprimitives.threadspecification.WhichThreads;
import rebound.concurrency.ConcurrencyUtilities;
import rebound.concurrency.threads.SimpleEventQueue;
import rebound.util.functional.ContinueSignal;

public class RateLimitingQueue
extends SimpleEventQueue {
    protected final long minimumDelayMS;
    protected boolean hasLastRun = false;
    protected long lastRun;

    public RateLimitingQueue(long minimumDelayMS) {
        this.minimumDelayMS = minimumDelayMS;
    }

    public RateLimitingQueue(int queueCapacity, long minimumDelayMS) {
        super(queueCapacity);
        this.minimumDelayMS = minimumDelayMS;
    }

    public RateLimitingQueue(Thread dispatchThread, long minimumDelayMS) {
        super(dispatchThread);
        this.minimumDelayMS = minimumDelayMS;
    }

    public RateLimitingQueue(Thread dispatchThread, int queueCapacity, long minimumDelayMS) {
        super(dispatchThread, queueCapacity);
        this.minimumDelayMS = minimumDelayMS;
    }

    @Override
    @WhichThreads(value={"dispatch"})
    @Nonnull
    protected ContinueSignal queueLoopIteration() {
        long start;
        long now = System.currentTimeMillis();
        if (this.hasLastRun) {
            long since = now - this.lastRun;
            if (since < this.minimumDelayMS) {
                long wait = this.minimumDelayMS - since;
                ConcurrencyUtilities.sleepFullyMS(wait);
                start = System.currentTimeMillis();
            } else {
                start = now;
            }
        } else {
            start = now;
        }
        SimpleEventQueue.Result r = super.runTaskFromQueue();
        if (r == SimpleEventQueue.Result.RanTask) {
            this.hasLastRun = true;
            this.lastRun = start;
            return ContinueSignal.Continue;
        }
        if (r == SimpleEventQueue.Result.TryAgain) {
            return ContinueSignal.Continue;
        }
        if (r == SimpleEventQueue.Result.ShutdownDetected) {
            return ContinueSignal.Stop;
        }
        GlobalCodeMetastuffContext.logBug();
        return ContinueSignal.Continue;
    }
}

