/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.monastery;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import rebound.jagent.ResourceHog;
import rebound.jagent.ui.gui.DropData;
import rebound.jagent.ui.gui.monastery.Monasterifier;
import rebound.jagent.ui.gui.monastery.MonasteryApplicationCoordinator;
import rebound.jagent.ui.gui.monastery.Notifee;

public class MonasteryWindow
extends JFrame
implements DropTargetListener,
Notifee {
    public static final boolean UseAboutMenuItem = !MonasteryApplicationCoordinator.AppleJavaExtentionsPresent;
    public static final boolean UseQuitMenuItem = !MonasteryApplicationCoordinator.AppleJavaExtentionsPresent;
    protected MonasteryApplicationCoordinator coordinator;
    protected JLabel currAction;
    protected JLabel bg;
    protected JPanel body;
    protected DropTarget target;
    protected Monasterifier zeal;
    protected JMenuBar mnu;
    protected JMenu mnuFile;
    protected JMenuItem mnuFileQuit;
    protected JMenu mnuHelp;
    protected JMenuItem mnuHelpAbout;

    public MonasteryWindow() {
        super("Monastery");
        this.setDefaultCloseOperation(3);
        this.zeal = new Monasterifier(this);
        JPanel body = this.getBody();
        if (body != null) {
            this.setContentPane(body);
            this.setJMenuBar(this.getMnu());
            Icon i = this.getBG().getIcon();
            if (i == null) {
                this.setSize(250, 250);
            } else {
                this.setSize(i.getIconWidth(), i.getIconHeight());
            }
        }
    }

    public JPanel getBody() {
        if (this.body == null) {
            this.body = new JPanel(null, false){

                @Override
                public void doLayout() {
                    super.doLayout();
                    int w = this.getWidth();
                    int h = this.getHeight();
                    MonasteryWindow.this.getBG().setSize(w, h);
                    MonasteryWindow.this.getCurrAction().setSize(w, 20);
                    MonasteryWindow.this.getCurrAction().setLocation(0, h - MonasteryWindow.this.getCurrAction().getHeight());
                }
            };
            JLabel bg = this.getBG();
            if (bg != null) {
                this.body.add(this.getCurrAction());
                this.body.add(bg);
            } else {
                JLabel errorLbl = new JLabel();
                errorLbl.setHorizontalAlignment(0);
                errorLbl.setBackground(new Color(128, 0, 0));
                errorLbl.setForeground(Color.YELLOW);
                errorLbl.setText("Face image could not be found.");
                this.getContentPane().add(errorLbl);
                this.setSize(250, 250);
                this.getContentPane().setBackground(Color.RED);
                return null;
            }
        }
        return this.body;
    }

    public JLabel getBG() {
        if (this.bg == null) {
            this.bg = new JLabel();
            URL u = ResourceHog.getResource("monk-face.png");
            if (u == null) {
                return null;
            }
            ImageIcon i = new ImageIcon(u);
            this.bg.setIcon(i);
            this.bg.setSize(i.getIconWidth(), i.getIconHeight());
            this.target = new DropTarget(this.bg, this);
        }
        return this.bg;
    }

    public JLabel getCurrAction() {
        if (this.currAction == null) {
            this.currAction = new JLabel();
            this.currAction.setHorizontalAlignment(0);
            this.currAction.setText("Awaiting files");
            this.currAction.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    MonasteryWindow.this.currAction.setText("Awaiting files");
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }
            });
        }
        return this.currAction;
    }

    public JMenuBar getMnu() {
        if (this.mnu == null) {
            this.mnu = new JMenuBar();
            if (UseQuitMenuItem) {
                this.mnu.add(this.getMnuFile());
            }
            if (UseAboutMenuItem) {
                this.mnu.add(this.getMnuHelp());
            }
        }
        return this.mnu;
    }

    public JMenu getMnuFile() {
        if (this.mnuFile == null) {
            this.mnuFile = new JMenu("File");
            if (UseQuitMenuItem) {
                this.mnuFile.add(this.getMnuFileQuit());
            }
        }
        return this.mnuFile;
    }

    public JMenuItem getMnuFileQuit() {
        if (this.mnuFileQuit == null) {
            this.mnuFileQuit = new JMenuItem("Quit");
            this.mnuFileQuit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonasteryWindow.this.getApplicationCoordinator().quitClicked();
                }
            });
        }
        return this.mnuFileQuit;
    }

    public JMenu getMnuHelp() {
        if (this.mnuHelp == null) {
            this.mnuHelp = new JMenu("Help");
            if (UseAboutMenuItem) {
                this.mnuHelp.add(this.getMnuHelpAbout());
            }
        }
        return this.mnuHelp;
    }

    public JMenuItem getMnuHelpAbout() {
        if (this.mnuHelpAbout == null) {
            this.mnuHelpAbout = new JMenuItem("About");
            this.mnuHelpAbout.setAccelerator(KeyStroke.getKeyStroke(112, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuHelpAbout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonasteryWindow.this.getApplicationCoordinator().aboutClicked();
                }
            });
        }
        return this.mnuHelpAbout;
    }

    @Override
    public void notify(String message) {
        System.out.println("info: " + message);
        this.setStatus(message);
    }

    @Override
    public void error(String prefix, Throwable cause) {
        this.error(String.valueOf(prefix) + " : (" + cause.getClass().getSimpleName() + ")\"" + cause.getMessage() + "\"");
        cause.printStackTrace();
    }

    @Override
    public void error(String message) {
        System.err.println("error: " + message);
        if (!GraphicsEnvironment.isHeadless()) {
            this.setStatus("Error");
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
    }

    public void setStatus(String s) {
        this.getCurrAction().setText(s);
    }

    public MonasteryApplicationCoordinator getApplicationCoordinator() {
        return this.coordinator;
    }

    public void setApplicationCoordinator(MonasteryApplicationCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void process(final List<File> files) {
        new Thread(){

            @Override
            public void run() {
                MonasteryWindow.this.zeal.monasterify(files);
            }
        }.start();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            List<File> files = DropData.getFileList(dtde);
            if (files != null) {
                this.process(files);
            } else {
                dtde.rejectDrop();
                dtde.dropComplete(false);
            }
        }
        catch (IOException exc) {
            this.error("Error occurred dropping: \"" + exc.getMessage() + "\"");
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }
}

