/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.monastery;

import java.io.File;
import java.util.Collections;
import rebound.annotations.semantic.meta.dependencies.DependencyDirectory;
import rebound.apps.reboundcommonsbuilding.packaging.jar.annotations.PackageAsSimpleJar;
import rebound.exceptions.ImpossibleException;
import rebound.jagent.ui.gui.AboutDialog;
import rebound.jagent.ui.gui.monastery.Monasterifier;
import rebound.jagent.ui.gui.monastery.MonasteryWindow;
import rebound.osint.modapple.eawtproxy.ApplicationEventProxy;
import rebound.osint.modapple.eawtproxy.ApplicationListenerClone;
import rebound.osint.modapple.eawtproxy.ApplicationProxy;
import rebound.util.collections.CollectionUtilities;

@PackageAsSimpleJar(value="Monastery.jar")
@DependencyDirectory(value="rebound/jagent/res")
public class MonasteryApplicationCoordinator {
    public static final String ABOUT_RESOURCE = "about-monastery.html";
    public static final boolean AppleJavaExtentionsPresent = ApplicationProxy.canGetApplication();
    protected MonasteryWindow brendan;
    protected AboutDialog aboutDialog;

    public static void main(String[] args) {
        if (args.length == 0) {
            MonasteryApplicationCoordinator coordinator = new MonasteryApplicationCoordinator();
            if (AppleJavaExtentionsPresent) {
                coordinator.setupMacExtensions();
            }
            coordinator.initWindow();
        } else {
            Monasterifier chimp = new Monasterifier();
            boolean success = chimp.monasterify(CollectionUtilities.mapToList(File::new, CollectionUtilities.asList(args)));
            System.exit(success ? 0 : 1);
        }
    }

    public void initWindow() {
        this.brendan = new MonasteryWindow();
        this.brendan.setApplicationCoordinator(this);
        this.brendan.setVisible(true);
    }

    public AboutDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(ABOUT_RESOURCE);
        }
        return this.aboutDialog;
    }

    public void setupMacExtensions() {
        ApplicationProxy application = ApplicationProxy.getApplication();
        if (application == null) {
            throw new ImpossibleException("com.apple.eawt.Application exists, but it also doesn't exist...  Aren't computers are supposed to make sense?!");
        }
        application.removePreferencesMenuItem();
        application.addAboutMenuItem();
        application.addApplicationListener(new ApplicationListenerClone(){

            @Override
            public void handleAbout(ApplicationEventProxy e) {
                e.setHandled(true);
                MonasteryApplicationCoordinator.this.aboutClicked();
            }

            @Override
            public void handleOpenFile(ApplicationEventProxy e) {
                e.setHandled(true);
                MonasteryApplicationCoordinator.this.load(e.getFilename());
            }

            @Override
            public void handleQuit(ApplicationEventProxy e) {
                e.setHandled(false);
                MonasteryApplicationCoordinator.this.quitClicked();
            }

            @Override
            public void handleReOpenApplication(ApplicationEventProxy e) {
            }

            @Override
            public void handleOpenApplication(ApplicationEventProxy e) {
            }

            @Override
            public void handlePreferences(ApplicationEventProxy e) {
            }

            @Override
            public void handlePrintFile(ApplicationEventProxy e) {
            }
        });
    }

    public void load(String filename) {
        this.load(new File(filename));
    }

    public void load(File file) {
        this.brendan.process(Collections.singletonList(file));
    }

    public void aboutClicked() {
        this.getAboutDialog().display();
    }

    public void quitClicked() {
        System.exit(0);
    }
}

