/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.monastery;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rebound.file.FSUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.pray.Block;
import rebound.jagent.lib.pray.PrayMaker;
import rebound.jagent.lib.pray.PrayParser;
import rebound.jagent.ui.gui.monastery.Notifee;

public class Monasterifier {
    protected Notifee notifee;

    public Monasterifier(Notifee n) {
        this.notifee = n;
    }

    public Monasterifier() {
        this(new Notifee(){

            @Override
            public void notify(String message) {
                System.out.println("info: " + message);
            }

            @Override
            public void error(String prefix, Throwable cause) {
                this.error(String.valueOf(prefix) + " : (" + cause.getClass().getSimpleName() + ")\"" + cause.getMessage() + "\"");
                cause.printStackTrace();
            }

            @Override
            public void error(String message) {
                System.err.println("error: " + message);
            }
        });
    }

    public boolean monasterify(List<File> files) {
        if (files.isEmpty()) {
            return true;
        }
        return this.monasterify(files, Monasterifier.findDefaultOutputFile(files));
    }

    public static File findDefaultOutputFile(List<File> files) {
        if (files.isEmpty()) {
            throw new IllegalArgumentException();
        }
        File first = files.get(0);
        return FSUtilities.getUniqueFileOrThrow(first.getParentFile(), String.valueOf(FSUtilities.getFilenameStem(first)) + "_bundled", FSUtilities.getFilenameSuffix(first));
    }

    /*
     * WARNING - void declaration
     */
    public boolean monasterify(List<File> files, File output) {
        ArrayList<Block> allblocks = new ArrayList<Block>();
        for (File file : files) {
            List<Block> blocks;
            try {
                try {
                    Throwable throwable = null;
                    Object var8_17 = null;
                    try (FileInputStream in = new FileInputStream(file);){
                        blocks = PrayParser.parseSimply(in);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (FormatMismatchException exc) {
                    this.notifee.error("File " + file.getAbsolutePath() + " seems not to be a valid PRAY file!!", exc);
                    return false;
                }
            }
            catch (IOException exc) {
                this.notifee.error("I/O Error reading " + file.getAbsolutePath() + "!!", exc);
                return false;
            }
            allblocks.addAll(blocks);
        }
        try {
            Throwable throwable = null;
            Iterator<File> iterator = null;
            try (FileOutputStream out = new FileOutputStream(output);){
                PrayMaker.makeSimply(allblocks, out);
            }
            catch (Throwable throwable3) {
                void var4_10;
                if (throwable == null) {
                    Throwable throwable4 = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw var4_10;
            }
        }
        catch (IOException iOException) {
            this.notifee.error("I/O Error writing " + output.getAbsolutePath() + "!!", iOException);
            return false;
        }
        return true;
    }
}

