/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import rebound.jagent.lib.pray.Block;
import rebound.jagent.lib.pray.InvalidNameException;
import rebound.jagent.lib.pray.PrayMakerNotifee;
import rebound.jagent.lib.pray.PrayParser;
import rebound.jagent.lib.pray.blocks.MetaBlockMaker;
import rebound.jagent.lib.pray.blocks.makers.InlineFileBlockMaker;
import rebound.jagent.lib.pray.blocks.makers.TagBlockMaker;
import rebound.jagent.lib.pray.template.Group;
import rebound.jagent.lib.pray.template.PrayTemplate;

public class PrayMaker {
    protected InlineFileBlockMaker fileBlockMaker = new InlineFileBlockMaker();
    protected TagBlockMaker tagBlockMaker = new TagBlockMaker();
    protected OutputStream out;
    protected int overallIndex = 0;
    protected PrayMakerNotifee notifee;

    public PrayMaker() {
    }

    public PrayMaker(PrayMakerNotifee n) {
        this();
        this.notifee = n;
    }

    public void start() throws IOException {
        this.out.write(PrayParser.PRAYMAGIC);
        this.overallIndex = 0;
    }

    public void writePrayTemplate(PrayTemplate template) throws IOException, InvalidNameException {
        int n = template.getGroupCount();
        int i = 0;
        while (i < n) {
            Group g = template.getGroup(i);
            this.tagBlockMaker.make(this.out, g);
            if (this.notifee != null) {
                this.notifee.finWritingBlock(this.overallIndex);
            }
            ++this.overallIndex;
            ++i;
        }
        String[] FILEsrcs = template.getInlineSourcefiles();
        int i2 = 0;
        while (i2 < FILEsrcs.length) {
            String source = FILEsrcs[i2];
            File src = new File(String.valueOf(template.getDir().getPath()) + '/' + source);
            if (!src.exists()) {
                throw new FileNotFoundException("Inline File \"" + source + "\" not found!");
            }
            this.fileBlockMaker.make(this.out, src, template.getInlineFilePrayID(source), template.getInlineFilePrayName(source));
            if (this.notifee != null) {
                this.notifee.finWritingBlock(this.overallIndex);
            }
            ++this.overallIndex;
            ++i2;
        }
    }

    public void writeLowlevelBlocks(List<Block> blocks) throws IOException {
        for (Block b : blocks) {
            this.writeLowlevelBlock(b);
        }
    }

    public void writeLowlevelBlock(Block block) throws IOException {
        MetaBlockMaker.writeHeader(this.out, block.getHeader());
        this.out.write(block.getData());
    }

    public static void makeSimply(List<Block> blocks, OutputStream out) throws IOException {
        out.write(PrayParser.PRAYMAGIC);
        for (Block b : blocks) {
            MetaBlockMaker.writeHeader(out, b.getHeader());
            out.write(b.getData());
        }
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public boolean isMergeScripts() {
        return this.tagBlockMaker.isMergeScripts();
    }

    public void setMergeScripts(boolean value) {
        this.tagBlockMaker.setMergeScripts(value);
    }
}

