/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray;

import java.nio.charset.StandardCharsets;
import rebound.text.StringUtilities;

public class BlockHeader {
    public static final int ID_UNKNOWN = -1;
    public static final int ID_FILE = 0;
    public static final int ID_PHOT = 13;
    public static final int ID_AGNT = 1;
    public static final int ID_DSAG = 2;
    public static final int ID_LIVE = 3;
    public static final int ID_EGGS = 4;
    public static final int ID_DFAM = 5;
    public static final int ID_SFAM = 6;
    public static final int ID_CHUM = 7;
    public static final int ID_EXPC = 8;
    public static final int ID_DSEX = 9;
    public static final int ID_DSGB = 14;
    public static final int ID_GLST = 10;
    public static final int ID_CREA = 11;
    public static final int ID_GENE = 12;
    protected static final byte[][] ids = new byte[][]{{70, 73, 76, 69}, {65, 71, 78, 84}, {68, 83, 65, 71}, {76, 73, 86, 69}, {69, 71, 71, 83}, {68, 70, 65, 77}, {83, 70, 65, 77}, {67, 72, 85, 77}, {69, 88, 80, 67}, {68, 83, 69, 88}, {71, 76, 83, 84}, {67, 82, 69, 65}, {71, 69, 78, 69}, {80, 72, 79, 84}, {68, 83, 71, 66}};
    int lengthInFile;
    int originalLength;
    boolean compressed;
    byte[] id;
    String name;
    String sId;

    public static byte[] getIDCode(int id) {
        return ids[id];
    }

    public int getID() {
        boolean allClean = false;
        int ID = 0;
        while (ID < ids.length) {
            allClean = true;
            int b = 0;
            while (b < 4 && allClean) {
                allClean &= this.id[b] == ids[ID][b];
                ++b;
            }
            if (allClean) {
                return ID;
            }
            ++ID;
        }
        return -1;
    }

    public byte[] getRawID() {
        return this.id;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public byte[] getId() {
        return this.id;
    }

    public String getIdTextBestEffort() {
        if (this.sId == null) {
            this.sId = StringUtilities.decodeTextToStringReplacing(this.id, StandardCharsets.UTF_8);
        }
        return this.sId;
    }

    public int getLengthInFile() {
        return this.lengthInFile;
    }

    public String getName() {
        return this.name;
    }

    public int getOriginalLength() {
        return this.originalLength;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public void setId(byte[] id) {
        this.id = id;
        this.sId = null;
    }

    public void setLengthInFile(int lengthInFile) {
        this.lengthInFile = lengthInFile;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginalLength(int originalLength) {
        this.originalLength = originalLength;
    }
}

