/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.caos2pray;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import rebound.io.util.TextIOUtilities;
import rebound.jagent.lib.caos2pray.FriendlyTags;
import rebound.jagent.lib.caos2pray.exc.C2PSyntaxException;
import rebound.jagent.lib.caos2pray.exc.DependencyException;
import rebound.jagent.lib.caos2pray.exc.NotIntegerTagException;
import rebound.jagent.lib.caos2pray.exc.ScanningException;
import rebound.jagent.lib.caos2pray.exc.ScriptReadException;
import rebound.jagent.lib.caos2pray.scanner.C2PCosFile;
import rebound.jagent.lib.caos2pray.scanner.C2PParser;
import rebound.jagent.lib.caos2pray.scanner.CosParser;
import rebound.jagent.lib.pray.template.Group;
import rebound.jagent.lib.pray.template.PrayTemplate;

public class TemplateConverter {
    public static final String[] COMMANDS = new String[]{"pray-file", "c3-name", "ds-name", "inline", "attach", "depend", "link", "rscr"};
    protected File entryFile = null;
    protected CosParser cosparser = new CosParser();
    protected C2PParser c2pparser = new C2PParser();
    protected PrayTemplate template = null;

    public static String getCommand(String directive) {
        String cmdtoken = directive.split(" ")[0];
        String ld = cmdtoken.toLowerCase();
        if (ld.length() == "XXXX-name".length() && ld.endsWith("-name")) {
            return cmdtoken;
        }
        String[] stringArray = COMMANDS;
        int n = COMMANDS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (ld.startsWith(s)) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    public TemplateConverter(File entryFile, CosParser cosparser, C2PParser c2pparser) {
        this.entryFile = entryFile;
        this.cosparser = cosparser;
        this.c2pparser = c2pparser;
    }

    public void convert() throws ScriptReadException, ScanningException, DependencyException {
        if (this.entryFile == null) {
            throw new IllegalStateException("No source file set");
        }
        C2PCosFile c2p = this.parseFile(this.entryFile);
        FriendlyTags.postProcess(c2p);
        this.template = new PrayTemplate();
        this.construct(c2p);
    }

    protected C2PCosFile parseFile(File file) throws NotIntegerTagException, C2PSyntaxException, ScriptReadException {
        C2PCosFile c2p = null;
        try {
            this.cosparser.init(new FileInputStream(file));
            this.c2pparser.init(this.cosparser);
            this.c2pparser.scan();
            c2p = this.c2pparser.getC2PCosFile();
            this.cosparser.close();
        }
        catch (IOException exc) {
            throw new ScriptReadException(exc, file.getName());
        }
        c2p.setThisFile(file);
        return c2p;
    }

    protected PrayTemplate construct(C2PCosFile c2PCosFile) throws ScriptReadException, C2PSyntaxException, DependencyException {
        int[] inlines;
        int[] attaches;
        File dir = this.entryFile.getParentFile();
        this.template.setDir(dir);
        int i = c2PCosFile.getSingletonCommandIndexOf("pray-file");
        if (i != -1) {
            this.template.setDesiredOutputFile(c2PCosFile.getCommandSingletonArg(i));
        }
        HashMap<String, String> blocktypes = null;
        blocktypes = new HashMap<String, String>();
        int i2 = c2PCosFile.getSingletonCommandIndexOf("ds-name");
        if (i2 != -1) {
            blocktypes.put("DSAG", c2PCosFile.getCommandSingletonArg(i2));
        }
        if ((i2 = c2PCosFile.getSingletonCommandIndexOf("c3-name")) != -1) {
            String c3name = null;
            String[] args = c2PCosFile.getCommandArgs(i2);
            if (args.length == 1) {
                c3name = args[0];
            } else if (args.length == 0) {
                if (!blocktypes.containsKey("DSAG")) {
                    throw new C2PSyntaxException("The c3-name command may only lack an argument if there is a ds-name to default to.");
                }
                c3name = String.valueOf((String)blocktypes.get("DSAG")) + " C3";
            } else {
                throw new C2PSyntaxException("The c3-name command takes no more than 1 argument.");
            }
            blocktypes.put("AGNT", c3name);
        }
        i2 = 0;
        while (i2 < c2PCosFile.getCommandCount()) {
            String id;
            String cmd = c2PCosFile.getCommand(i2);
            if (cmd.toLowerCase().endsWith("-name") && (id = cmd.substring(0, cmd.length() - 5)).length() == 4) {
                String name = c2PCosFile.getCommandSingletonArg(i2);
                if (blocktypes.containsKey(id)) {
                    throw new C2PSyntaxException("Duplicate block types: " + id);
                }
                blocktypes.put(id, name);
            }
            ++i2;
        }
        for (String id : blocktypes.keySet()) {
            String name = (String)blocktypes.get(id);
            byte[] encodedName = name.getBytes(StandardCharsets.UTF_8);
            if (encodedName.length >= 127) {
                throw new C2PSyntaxException("Invalid name, 127 bytes is the maximum for a PRAY block name (name was " + encodedName.length + "; \"" + name + "\")");
            }
            this.template.addGroup(this.makeTheGenericBlock(c2PCosFile, dir, id, name));
        }
        int[] nArray = attaches = c2PCosFile.findCommands("attach");
        int n = attaches.length;
        int cmd = 0;
        while (cmd < n) {
            String[] args;
            int index = nArray[cmd];
            String[] stringArray = args = c2PCosFile.getCommandArgs(index);
            int n2 = args.length;
            int n3 = 0;
            while (n3 < n2) {
                String s = stringArray[n3];
                this.template.addInline("FILE", s, s);
                ++n3;
            }
            ++cmd;
        }
        int[] nArray2 = inlines = c2PCosFile.findCommands("inline");
        int n4 = inlines.length;
        n = 0;
        while (n < n4) {
            int index = nArray2[n];
            String[] args = c2PCosFile.getCommandArgs(index);
            if (args.length == 2) {
                this.template.addInline("FILE", args[0], args[1]);
            } else if (args.length == 1) {
                this.template.addInline("FILE", args[0], args[0]);
            } else {
                throw new C2PSyntaxException("The inline command takes either 1 or 2 arguments, no more, no less.");
            }
            ++n;
        }
        return this.template;
    }

    protected Group makeTheGenericBlock(C2PCosFile c2p, File dir, String id, String name) throws ScriptReadException, C2PSyntaxException, DependencyException {
        Group g = new Group();
        g.setID(id);
        g.setName(name);
        this.makeTheBlock_Common(c2p, dir, g);
        return g;
    }

    protected void makeTheBlock_Common(C2PCosFile c2p, File dir, Group g) throws C2PSyntaxException, ScriptReadException, DependencyException {
        int i;
        String s;
        int n;
        int n2;
        String[] stringArray;
        int n3;
        g.addIntTag("Agent Type", 0);
        g.addScript(c2p.getThisFile().getName());
        g.setCutOutRemoveScriptFromFirstScript(true);
        int[] nArray = c2p.findCommands("link");
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            int index = nArray[n5];
            String[] stringArray2 = c2p.getCommandArgs(index);
            int n6 = stringArray2.length;
            n3 = 0;
            while (n3 < n6) {
                String arg = stringArray2[n3];
                g.addScript(arg);
                ++n3;
            }
            ++n5;
        }
        ArrayList<String> deps = new ArrayList<String>();
        int[] indices = c2p.findCommands("attach");
        String[] args = null;
        int[] nArray2 = indices;
        n3 = indices.length;
        int arg = 0;
        while (arg < n3) {
            int i2 = nArray2[arg];
            stringArray = args = c2p.getCommandArgs(i2);
            n2 = args.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                deps.add(s);
                ++n;
            }
            ++arg;
        }
        indices = c2p.findCommands("depend");
        args = null;
        nArray2 = indices;
        n3 = indices.length;
        arg = 0;
        while (arg < n3) {
            int i3 = nArray2[arg];
            stringArray = args = c2p.getCommandArgs(i3);
            n2 = args.length;
            n = 0;
            while (n < n2) {
                s = stringArray[n];
                deps.add(s);
                ++n;
            }
            ++arg;
        }
        g.addIntTag("Dependency Count", deps.size());
        int c = 0;
        int i4 = 0;
        while (i4 < deps.size()) {
            g.addStringTag("Dependency " + (i4 + 1), (String)deps.get(i4));
            c = TemplateConverter.getDependencyCategoryByExtension((String)deps.get(i4));
            g.addIntTag("Dependency Category " + (i4 + 1), c);
            ++i4;
        }
        if (c2p.getIndexOfStringTag("Agent Animation Callery") == -1 && (i = c2p.getIndexOfStringTag("Agent Animation File")) != -1) {
            String file = c2p.getStringTagValue(i);
            if (file.length() > 4) {
                g.addStringTag("Agent Animation Gallery", file.substring(0, file.length() - 4));
            } else {
                g.addStringTag("Agent Animation Gallery", file);
            }
        }
        i = 0;
        while (i < c2p.getStringTagCount()) {
            g.addStringTag(c2p.getStringTagName(i), c2p.getStringTagValue(i));
            ++i;
        }
        i = 0;
        while (i < c2p.getIntegerTagCount()) {
            g.addIntTag(c2p.getIntegerTagName(i), c2p.getIntegerTagValue(i));
            ++i;
        }
        i = c2p.getSingletonCommandIndexOf("rscr");
        if (i != -1) {
            String[] args2 = c2p.getCommandArgs(i);
            if (args2.length != 1) {
                throw new C2PSyntaxException("rscr takes exactly one argument.");
            }
            try {
                File f = new File(dir, args2[0]).getAbsoluteFile();
                char[] cdata = TextIOUtilities.readAll(new InputStreamReader(new FileInputStream(f)));
                g.addStringTag("Remove script", new String(cdata));
            }
            catch (IOException exc) {
                throw new ScriptReadException(exc, args2[0], true);
            }
        } else if (c2p.getCAOSRemoveScript() != null) {
            g.addStringTag("Remove script", c2p.getCAOSRemoveScript());
        }
    }

    public PrayTemplate getTemplate() {
        return this.template;
    }

    public static int getDependencyCategoryByExtension(String depFilename) throws DependencyException {
        String ldep = depFilename.toLowerCase();
        if (ldep.endsWith(".c16") || depFilename.endsWith(".s16")) {
            return 2;
        }
        if (ldep.endsWith(".blk")) {
            return 6;
        }
        if (ldep.endsWith(".wav") || depFilename.endsWith(".mng")) {
            return 1;
        }
        if (ldep.endsWith(".catalogue")) {
            return 7;
        }
        throw new DependencyException(depFilename);
    }
}

