/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.json.contrib_rpmod_stringtree;

import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import rebound.exceptions.GenericDataStructuresFormatException;
import rebound.exceptions.UnsupportedOptionException;
import rebound.util.Primitives;
import rebound.util.objectutil.BasicObjectUtilities;

public class JSONWriter {
    protected StringBuilder buf = new StringBuilder();
    protected Stack<Object> calls = new Stack();
    protected boolean emitClassName = true;
    static char[] hex = "0123456789ABCDEF".toCharArray();

    public JSONWriter(boolean emitClassName) {
        this.emitClassName = emitClassName;
    }

    public JSONWriter() {
        this(true);
    }

    public String write(Object object) {
        this.buf.setLength(0);
        this.value(object);
        return this.buf.toString();
    }

    public String write(long n) {
        return String.valueOf(n);
    }

    public String write(double d) {
        return String.valueOf(d);
    }

    public String write(char c) {
        return "\"" + c + "\"";
    }

    public String write(boolean b) {
        return String.valueOf(b);
    }

    protected void value(Object object) {
        if (object == null) {
            this.add("null");
        } else {
            if (this.cyclic(object)) {
                throw new GenericDataStructuresFormatException("Cycle detected while producing JSON!!!");
            }
            this.calls.push(object);
            if (object instanceof Class) {
                this.string(object);
            } else if (object instanceof Boolean) {
                this.bool((Boolean)object);
            } else if (object instanceof Number) {
                this.add(object);
            } else if (object instanceof String || object instanceof CharSequence) {
                this.string(object);
            } else if (object instanceof Character) {
                this.string(object);
            } else if (object instanceof Map) {
                this.map((Map)object);
            } else if (object.getClass().isArray()) {
                this.array(Arrays.asList(new Object[]{object instanceof Object[] ? object : Primitives.box(object)}));
            } else if (object instanceof Collection) {
                this.array((Collection)object);
            } else {
                throw new UnsupportedOptionException("Unsupported Class: " + object.getClass().getName());
            }
            this.calls.pop();
        }
    }

    protected boolean cyclic(Object object) {
        for (Object e : this.calls) {
            if (e != object) continue;
            return true;
        }
        return false;
    }

    protected void add(String name, Object value) {
        this.add('\"');
        this.add(name);
        this.add("\":");
        this.value(value);
    }

    protected void map(Map<String, Object> map) {
        this.add("{");
        Set<Map.Entry<String, Object>> s = map.entrySet();
        Map.Entry[] entries = s.toArray(new Map.Entry[s.size()]);
        Arrays.sort(entries, (a, b) -> BasicObjectUtilities.cmp2(a.getKey(), b.getKey()));
        boolean first = true;
        Map.Entry[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry e = entryArray[n2];
            if (!first) {
                this.add(',');
            } else {
                first = false;
            }
            this.value(e.getKey());
            this.add(":");
            this.value(e.getValue());
            ++n2;
        }
        this.add("}");
    }

    protected void array(Collection<?> c) {
        this.add("[");
        boolean first = true;
        for (Object e : c) {
            if (!first) {
                this.add(',');
            } else {
                first = false;
            }
            this.value(e);
        }
        this.add("]");
    }

    protected void bool(boolean b) {
        this.add(b ? "true" : "false");
    }

    protected void string(Object obj) {
        this.add('\"');
        StringCharacterIterator it = new StringCharacterIterator(obj.toString());
        char c = it.first();
        while (c != '\uffff') {
            if (c == '\"') {
                this.add("\\\"");
            } else if (c == '\\') {
                this.add("\\\\");
            } else if (c == '\b') {
                this.add("\\b");
            } else if (c == '\f') {
                this.add("\\f");
            } else if (c == '\n') {
                this.add("\\n");
            } else if (c == '\r') {
                this.add("\\r");
            } else if (c == '\t') {
                this.add("\\t");
            } else if (Character.isISOControl(c)) {
                this.unicode(c);
            } else {
                this.add(c);
            }
            c = it.next();
        }
        this.add('\"');
    }

    protected void add(Object obj) {
        this.buf.append(obj);
    }

    protected void add(char c) {
        this.buf.append(c);
    }

    protected void unicode(char c) {
        this.add("\\u");
        int n = c;
        int i = 0;
        while (i < 4) {
            int digit = (n & 0xF000) >> 12;
            this.add(hex[digit]);
            n <<= 4;
            ++i;
        }
    }
}

