/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.objectutil;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.Buffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.annotations.purelyforhumans.DeprecatedInFavorOfMember;
import rebound.annotations.semantic.AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse;
import rebound.concurrency.immutability.JavaImmutability;
import rebound.concurrency.immutability.StaticallyConcurrentlyImmutable;
import rebound.concurrency.immutability.StaticallyMutable;
import rebound.concurrency.immutability.StaticallyThreadUnsafelyImmutable;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.ReturnPath;
import rebound.exceptions.UnexpectedHardcodedEnumValueException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.util.AngryReflectionUtility;
import rebound.util.ExceptionUtilities;
import rebound.util.Primitives;
import rebound.util.ValueType;
import rebound.util.classhacking.jre.BetterJREGlassbox;
import rebound.util.classhacking.jre.JREGlassBox;
import rebound.util.collections.ArrayUtilities;
import rebound.util.functional.EqualityComparator;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.CompareNotSupportedException;
import rebound.util.objectutil.CopyNotSupportedException;
import rebound.util.objectutil.Copyable;
import rebound.util.objectutil.InstantiationNotSupportedException;
import rebound.util.objectutil.Instantiator;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.NoArgsDefaultInstantiator;
import rebound.util.objectutil.ProvidesInstantiator;
import rebound.util.objectutil.PubliclyCloneable;
import rebound.util.objectutil.RuntimeIdentityfulness;
import rebound.util.objectutil.RuntimeImmutability;
import rebound.util.objectutil.SingletonInstantiator;
import rebound.util.objectutil.StaticallyIdentityful;
import rebound.util.objectutil.StaticallyIdentityless;
import rebound.util.objectutil.Trimmable;

@AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse
public class ObjectUtilities
implements JavaNamespace {
    protected static final EqualityComparator EquivalenceOrIdentityEqualityComparatorByDefaultIdentityfulnessTest = BasicObjectUtilities.getEquivalenceOrIdentityEqualityComparator(o -> Primitives.isTrueAndNotNull(ObjectUtilities.hasIdentity(o)));
    public static final String[] Recognized_Instantiation_Static_Method_Names = new String[]{"newInstance", "getNewInstance", "createInstance", "createNewInstance", "createNew", "inst", "instantiate", "getInstance", "instance"};
    public static final String[] Recognized_Singleton_Static_Field_Names = new String[]{"I", "instance", "Instance", "INSTANCE", "SingletonInstance", "Singleton_Instance", "SINGLETON_INSTANCE"};

    @AccessedDynamicallyOrExternallyToJavaOrKnownToBeInImportantSerializedUse
    @Deprecated
    @DeprecatedInFavorOfMember(cls=BasicObjectUtilities.class, member="int cmp(Object,Object)")
    public static int cmp(Object a, Object b) throws CompareNotSupportedException {
        if (a == null && b == null) {
            return 0;
        }
        if (a instanceof Comparable) {
            return ((Comparable)a).compareTo(b);
        }
        if (b instanceof Comparable) {
            return -((Comparable)b).compareTo(a);
        }
        throw new CompareNotSupportedException();
    }

    public static JavaImmutability isImmutable(@Nullable Object object) {
        if (object == null) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (object.getClass().isAnnotation()) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object) == 0 ? JavaImmutability.Concurrently_Immutable : JavaImmutability.Mutable;
        }
        if (object instanceof StaticallyMutable) {
            return JavaImmutability.Mutable;
        }
        if (object instanceof StaticallyConcurrentlyImmutable) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (object instanceof StaticallyThreadUnsafelyImmutable) {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }
        if (object instanceof RuntimeImmutability) {
            return ((RuntimeImmutability)object).isImmutable();
        }
        JavaImmutability rv = ObjectUtilities.grandfatheringIsImmutableOperations(object);
        if (rv != null) {
            return rv;
        }
        return null;
    }

    public static JavaImmutability isImmutableIncludingSlowReflectionTests(@Nullable Object object) {
        JavaImmutability rv = ObjectUtilities.isImmutable(object);
        if (rv != null) {
            return rv;
        }
        if (AngryReflectionUtility.areAllInstanceFieldsFinal(object.getClass())) {
            return JavaImmutability.Concurrently_Immutable;
        }
        return null;
    }

    public static JavaImmutability grandfatheringIsImmutableOperations(Object x) {
        if (x == null) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == Object.class) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x instanceof Appendable) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == Boolean.class || x.getClass() == Character.class || x.getClass() == Byte.class || x.getClass() == Short.class || x.getClass() == Integer.class || x.getClass() == Long.class || x.getClass() == Float.class || x.getClass() == Double.class) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == String.class) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == Class.class || x.getClass() == Package.class || x.getClass() == Method.class || x.getClass() == Field.class || x.getClass() == Constructor.class) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == ClassLoader.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == Thread.class || x.getClass() == ThreadGroup.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == Process.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == BigInteger.class) {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }
        if (x.getClass() == BigDecimal.class) {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }
        if (x.getClass() == ArrayList.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == Vector.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == Stack.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == LinkedList.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == BitSet.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == ArrayDeque.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == PriorityQueue.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == HashSet.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == LinkedHashSet.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == TreeSet.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == HashMap.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == Hashtable.class || x.getClass() == Properties.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == IdentityHashMap.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == EnumMap.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == LinkedHashMap.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == TreeMap.class) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == UUID.class) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == Date.class || x.getClass() == java.sql.Date.class) {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }
        if (x.getClass() == File.class) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == URL.class) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == URI.class) {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }
        if (x.getClass() == BetterJREGlassbox.Type_Arrays_asList) {
            return JavaImmutability.Mutable;
        }
        if (x.getClass() == BetterJREGlassbox.Type_Collections_emptyEnumeration) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == BetterJREGlassbox.Type_Collections_emptyIterator) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == BetterJREGlassbox.Type_Collections_emptyList) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == BetterJREGlassbox.Type_Collections_emptyListIterator) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == BetterJREGlassbox.Type_Collections_emptyMap) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == BetterJREGlassbox.Type_Collections_emptySet) {
            return JavaImmutability.Concurrently_Immutable;
        }
        if (x.getClass() == Cursor.class) {
            return JavaImmutability.Non_Thread_Safe_Immutable;
        }
        if (x.getClass() == Color.class) {
            return JavaImmutability.Concurrently_Immutable;
        }
        return null;
    }

    public static Boolean isThreadUnsafelyImmutable(Object object) {
        JavaImmutability imt = ObjectUtilities.isImmutable(object);
        if (imt == JavaImmutability.Concurrently_Immutable) {
            return true;
        }
        if (imt == JavaImmutability.Non_Thread_Safe_Immutable) {
            return true;
        }
        if (imt == JavaImmutability.Mutable) {
            return false;
        }
        if (imt == null) {
            return null;
        }
        throw new UnexpectedHardcodedEnumValueException((Object)imt);
    }

    public static Boolean grandfatheringIsThreadUnsafelyImmutable(Object x) {
        if (x.getClass().isArray()) {
            if (Array.getLength(x) == 0) {
                return true;
            }
            return false;
        }
        if (x.getClass() == BigInteger.class) {
            return true;
        }
        if (x.getClass() == BigDecimal.class) {
            return true;
        }
        if (x.getClass() == Date.class || x.getClass() == java.sql.Date.class) {
            return true;
        }
        if (x.getClass() == URI.class) {
            return true;
        }
        return null;
    }

    public static Boolean hasIdentity(Object object) {
        if (object == null) {
            return true;
        }
        if (Primitives.isFalseAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(object))) {
            return true;
        }
        if (object instanceof StaticallyIdentityless) {
            return false;
        }
        if (object instanceof StaticallyIdentityful) {
            return true;
        }
        if (object instanceof RuntimeIdentityfulness) {
            return ((RuntimeIdentityfulness)object).hasIdentity();
        }
        return ObjectUtilities.grandfatheringHasIdentity(object);
    }

    public static Boolean grandfatheringHasIdentity(Object x) {
        if (x instanceof Enum) {
            return true;
        }
        if (x.getClass() == Object.class) {
            return true;
        }
        if (Primitives.isPrimitiveWrapperInstance(x)) {
            return false;
        }
        if (x.getClass().isAnnotation()) {
            return false;
        }
        if (x instanceof String) {
            return false;
        }
        if (x.getClass() == Class.class || x.getClass() == Package.class || x.getClass() == Method.class || x.getClass() == Field.class || x.getClass() == Constructor.class) {
            return true;
        }
        if (x.getClass() == BigInteger.class || x.getClass() == BigDecimal.class) {
            return false;
        }
        if (x.getClass() == UUID.class) {
            return false;
        }
        if (x.getClass() == File.class) {
            return false;
        }
        if (x.getClass() == URL.class) {
            return false;
        }
        if (x.getClass() == URI.class) {
            return false;
        }
        if (x instanceof Collection) {
            return false;
        }
        if (x instanceof Map) {
            return false;
        }
        if (x instanceof CharSequence) {
            return false;
        }
        if (x instanceof Buffer) {
            return false;
        }
        if (x.getClass().isArray()) {
            return false;
        }
        return null;
    }

    public static boolean eqr(Object a, Object b) {
        if (a == null || b == null || Primitives.isTrueOrNull(ObjectUtilities.hasIdentity(a)) || Primitives.isTrueOrNull(ObjectUtilities.hasIdentity(b))) {
            return a == b;
        }
        return BasicObjectUtilities.eq(a, b);
    }

    public static boolean eqr(Object ... many) {
        if (many.length < 2) {
            return true;
        }
        Object first = many[0];
        int i = 1;
        while (i < many.length) {
            if (!ObjectUtilities.eqr(first, many[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> EqualityComparator<T> getEquivalenceOrIdentityEqualityComparator() {
        return EquivalenceOrIdentityEqualityComparatorByDefaultIdentityfulnessTest;
    }

    public static <E> Comparator<E> makeReverseComparator(Comparator<E> original) {
        return (a, b) -> -original.compare(a, b);
    }

    public static <E> E attemptCloneRp(E object) throws CloneNotSupportedReturnPath {
        try {
            return ObjectUtilities.attemptClone(object);
        }
        catch (WrappedThrowableRuntimeException exc) {
            if (exc.getCause() instanceof CloneNotSupportedException) {
                throw CloneNotSupportedReturnPath.I;
            }
            throw exc;
        }
    }

    public static <E> E attemptClone(E object) throws WrappedThrowableRuntimeException {
        if (object == null) {
            return object;
        }
        if (object.getClass().isEnum()) {
            if (Primitives.isFalseAndNotNull(ObjectUtilities.hasIdentity(object))) {
                return object;
            }
            throw new WrappedThrowableRuntimeException(new CloneNotSupportedException());
        }
        if (object.getClass().isArray()) {
            return ArrayUtilities.cloneArray(object);
        }
        if (Primitives.isFalseAndNotNull(ObjectUtilities.hasIdentity(object))) {
            assert (!Primitives.isFalseAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(object)));
            return object;
        }
        if (object instanceof PubliclyCloneable) {
            return (E)((PubliclyCloneable)object).clone();
        }
        if (object instanceof Copyable && object instanceof ProvidesInstantiator) {
            Object newInstance = ObjectUtilities.newInstance(((ProvidesInstantiator)object).getInstantiator());
            ((Copyable)newInstance).setFrom(object);
            return (E)newInstance;
        }
        return ObjectUtilities.grandfatheringCloneOperations(object);
    }

    public static <E> E grandfatheringCloneOperations(E object) throws WrappedThrowableRuntimeException {
        if (object == null) {
            return object;
        }
        if (Primitives.isFalseAndNotNull(ObjectUtilities.hasIdentity(object))) {
            return object;
        }
        if (object.getClass() == BigInteger.class) {
            return object;
        }
        if (object.getClass() == BigDecimal.class) {
            return object;
        }
        if (object.getClass() == Date.class || object.getClass() == java.sql.Date.class) {
            return object;
        }
        if (object.getClass() == URI.class) {
            return object;
        }
        if (object.getClass() == StringBuilder.class) {
            return (E)new StringBuilder((StringBuilder)object);
        }
        if (object.getClass() == StringBuffer.class) {
            return (E)new StringBuilder((StringBuffer)object);
        }
        if (object.getClass() == PriorityQueue.class) {
            return (E)new PriorityQueue((PriorityQueue)object);
        }
        if (object instanceof ArrayList) {
            return (E)((ArrayList)object).clone();
        }
        if (object.getClass() == JREGlassBox.ArraysGlassBox.ArrayList) {
            return (E)Arrays.asList(((Collection)object).toArray());
        }
        if (object instanceof Vector) {
            return (E)((Vector)object).clone();
        }
        if (object instanceof Stack) {
            return (E)((Stack)object).clone();
        }
        if (object instanceof LinkedList) {
            return (E)((LinkedList)object).clone();
        }
        if (object instanceof BitSet) {
            return (E)((BitSet)object).clone();
        }
        if (object instanceof ArrayDeque) {
            return (E)((ArrayDeque)object).clone();
        }
        if (object instanceof HashSet) {
            return (E)((HashSet)object).clone();
        }
        if (object instanceof LinkedHashSet) {
            return (E)((LinkedHashSet)object).clone();
        }
        if (object instanceof TreeSet) {
            return (E)((TreeSet)object).clone();
        }
        if (object instanceof HashMap) {
            return (E)((HashMap)object).clone();
        }
        if (object instanceof Hashtable) {
            return (E)((Hashtable)object).clone();
        }
        if (object instanceof IdentityHashMap) {
            return (E)((IdentityHashMap)object).clone();
        }
        if (object instanceof EnumMap) {
            return (E)((EnumMap)object).clone();
        }
        if (object instanceof LinkedHashMap) {
            return (E)((LinkedHashMap)object).clone();
        }
        if (object instanceof TreeMap) {
            return (E)((TreeMap)object).clone();
        }
        if (object instanceof RectangularShape) {
            return (E)((RectangularShape)object).clone();
        }
        if (object instanceof Path2D) {
            return (E)((Path2D)object).clone();
        }
        if (object instanceof Area) {
            return (E)((Area)object).clone();
        }
        if (object instanceof Line2D) {
            return (E)((Line2D)object).clone();
        }
        if (object instanceof QuadCurve2D) {
            return (E)((QuadCurve2D)object).clone();
        }
        if (object instanceof CubicCurve2D) {
            return (E)((CubicCurve2D)object).clone();
        }
        if (object.getClass() == Polygon.class) {
            return (E)new Polygon(((Polygon)object).xpoints, ((Polygon)object).ypoints, ((Polygon)object).npoints);
        }
        throw new WrappedThrowableRuntimeException(new CloneNotSupportedException());
    }

    public static <E> E attemptCloneWithReflection(E object) throws WrappedThrowableRuntimeException {
        try {
            return ObjectUtilities.attemptClone(object);
        }
        catch (WrappedThrowableRuntimeException exc) {
            Constructor<?> constructor;
            Class<?> c;
            block26: {
                Method cloneMethod;
                if (!(exc.getCause() instanceof CloneNotSupportedException)) {
                    throw exc;
                }
                c = object.getClass();
                if (object instanceof Copyable) {
                    Object instantiator;
                    block24: {
                        instantiator = null;
                        if (object instanceof ProvidesInstantiator) {
                            instantiator = ((ProvidesInstantiator)object).getInstantiator();
                        } else {
                            try {
                                instantiator = ObjectUtilities.getInstantiatorOrClass(object.getClass());
                            }
                            catch (WrappedThrowableRuntimeException exc2) {
                                if (exc2.getCause() instanceof InstantiationNotSupportedException) {
                                    instantiator = null;
                                    break block24;
                                }
                                throw exc2;
                            }
                        }
                    }
                    if (instantiator != null) {
                        Object newInstance = ObjectUtilities.newInstance(instantiator);
                        ((Copyable)newInstance).setFrom(object);
                        return (E)newInstance;
                    }
                }
                if ((cloneMethod = AngryReflectionUtility.getMethod(c, "clone", new Class[0], AngryReflectionUtility.JavaVisibility.Public, null, false, true)) != null) {
                    Object raw;
                    block25: {
                        raw = cloneMethod.invoke(object, new Object[0]);
                        if (raw != null) break block25;
                        return null;
                    }
                    try {
                        if (!c.isAssignableFrom(raw.getClass())) {
                            throw new ClassCastException();
                        }
                        return (E)raw;
                    }
                    catch (IllegalArgumentException exc3) {
                        throw new ImpossibleException();
                    }
                    catch (IllegalAccessException exc4) {
                        throw new ImpossibleException();
                    }
                    catch (InvocationTargetException exc5) {
                        if (exc5.getTargetException() instanceof CloneNotSupportedException) break block26;
                        throw ExceptionUtilities.rewrapToUnchecked(exc5);
                    }
                }
            }
            if ((constructor = AngryReflectionUtility.getConstructor(c, new Class[]{c}, AngryReflectionUtility.JavaVisibility.Public)) != null) {
                try {
                    return (E)constructor.newInstance(object);
                }
                catch (IllegalArgumentException exc6) {
                    throw new ImpossibleException();
                }
                catch (IllegalAccessException exc7) {
                    throw new ImpossibleException();
                }
                catch (InvocationTargetException exc8) {
                    if (!(exc8.getTargetException() instanceof CloneNotSupportedException)) {
                        throw ExceptionUtilities.rewrapToUnchecked(exc8);
                    }
                }
                catch (InstantiationException exc9) {
                    throw new ImpossibleException("How could we have an instance whose runtime type is an abstract class!  (" + c + ")");
                }
            }
            throw new WrappedThrowableRuntimeException(new CloneNotSupportedException());
        }
    }

    public static void copy(Object source, Object dest) throws CopyNotSupportedException, ClassCastException {
        if (dest instanceof Copyable) {
            ((Copyable)dest).setFrom(source);
        } else {
            ObjectUtilities.grandfatheringCopyOperations(source, dest);
        }
    }

    public static void grandfatheringCopyOperations(Object source, Object dest) throws CopyNotSupportedException, ClassCastException {
        if (dest instanceof Collection) {
            if (source instanceof Collection) {
                ((Collection)dest).clear();
                ((Collection)dest).addAll((Collection)source);
                return;
            }
            if (source instanceof Object[]) {
                ((Collection)dest).clear();
                Object[] objectArray = (Object[])source;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object e = objectArray[n2];
                    ((Collection)dest).add(e);
                    ++n2;
                }
            } else if (source instanceof Iterable) {
                ((Collection)dest).clear();
                for (Object e : (Iterable)source) {
                    ((Collection)dest).add(e);
                }
            } else {
                throw new ClassCastException(ObjectUtilities.getClassNameNT(source));
            }
        }
        throw new CopyNotSupportedException();
    }

    public static Object newInstance(Object instantiationObject) throws InstantiationNotSupportedException {
        if (instantiationObject instanceof Class) {
            Class instantiationClass = (Class)instantiationObject;
            if (AngryReflectionUtility.getPublicNoArgsConstructor(instantiationClass) != null) {
                try {
                    return instantiationClass.newInstance();
                }
                catch (InstantiationException exc) {
                    throw new WrappedThrowableRuntimeException(exc);
                }
                catch (IllegalAccessException exc) {
                    throw new WrappedThrowableRuntimeException(exc);
                }
            }
            return ObjectUtilities.getInstantiator(instantiationClass).newInstance();
        }
        if (instantiationObject instanceof Instantiator) {
            return ((Instantiator)instantiationObject).newInstance();
        }
        throw new IllegalArgumentException("Unsupported instantiator type: " + (instantiationObject == null ? "null" : instantiationObject.getClass()));
    }

    public static Object getInstantiatorOrClass(Class c) throws InstantiationNotSupportedException {
        if (JavaNamespace.class.isAssignableFrom(c)) {
            throw new InstantiationNotSupportedException.InputlessInstantiationNotSupportedException();
        }
        if (AngryReflectionUtility.getPublicNoArgsConstructor(c) != null) {
            return c;
        }
        AccessibleObject m = AngryReflectionUtility.getMethod(c, "getInstantiator", new Class[0], AngryReflectionUtility.JavaVisibility.Public, Instantiator.class, true, false);
        if (m != null) {
            try {
                return ((Method)m).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException exc) {
                throw new ImpossibleException("But it's public! (isn't it?)");
            }
            catch (IllegalArgumentException exc) {
                throw new ImpossibleException("But we checked the signature!");
            }
            catch (InvocationTargetException exc) {
                throw ExceptionUtilities.rewrapToUnchecked(exc);
            }
        }
        m = AngryReflectionUtility.getField(c, "Instantiator", AngryReflectionUtility.JavaVisibility.Public, Instantiator.class, true, false);
        if (m != null) {
            try {
                return ((Field)m).get(null);
            }
            catch (IllegalAccessException exc) {
                throw new ImpossibleException("But it's public! (isn't it?)");
            }
            catch (IllegalArgumentException exc) {
                throw new ImpossibleException("But we checked the signature!");
            }
        }
        m = AngryReflectionUtility.getField(c, "INSTANTIATOR", AngryReflectionUtility.JavaVisibility.Public, Instantiator.class, true, false);
        if (m != null) {
            try {
                return ((Field)m).get(null);
            }
            catch (IllegalAccessException exc) {
                throw new ImpossibleException("But it's public! (isn't it?)");
            }
            catch (IllegalArgumentException exc) {
                throw new ImpossibleException("But we checked the signature!");
            }
        }
        String[] stringArray = Recognized_Instantiation_Static_Method_Names;
        int n = Recognized_Instantiation_Static_Method_Names.length;
        int n2 = 0;
        while (n2 < n) {
            String recognizedInstantiationMethodName = stringArray[n2];
            Method m2 = AngryReflectionUtility.getMethod(c, recognizedInstantiationMethodName, new Class[0], AngryReflectionUtility.JavaVisibility.Public, null, true, false);
            if (m2 != null && m2.getReturnType() != Void.class && !m2.getReturnType().isPrimitive()) {
                final Method m_f = m2;
                return new Instantiator(){

                    public Object newInstance() throws WrappedThrowableRuntimeException {
                        try {
                            return m_f.invoke(null, new Object[0]);
                        }
                        catch (IllegalAccessException exc) {
                            throw new ImpossibleException("But it's public! (isn't it?)");
                        }
                        catch (IllegalArgumentException exc) {
                            throw new ImpossibleException("But we checked the signature!");
                        }
                        catch (InvocationTargetException exc) {
                            throw ExceptionUtilities.rewrapToUnchecked(exc);
                        }
                    }
                };
            }
            ++n2;
        }
        if (c.isEnum()) {
            T[] constants = c.getEnumConstants();
            if (constants.length == 1) {
                return new SingletonInstantiator(constants[0]);
            }
        } else {
            stringArray = Recognized_Singleton_Static_Field_Names;
            n = Recognized_Singleton_Static_Field_Names.length;
            n2 = 0;
            while (n2 < n) {
                String recognizedSingletonStaticFieldName = stringArray[n2];
                Field f = AngryReflectionUtility.getField(c, recognizedSingletonStaticFieldName, AngryReflectionUtility.JavaVisibility.Public, null, true, false);
                if (f != null && !f.getType().isPrimitive()) {
                    Object singleton = null;
                    try {
                        singleton = f.get(null);
                    }
                    catch (IllegalAccessException exc) {
                        throw new ImpossibleException("But it's public! (isn't it?)");
                    }
                    catch (IllegalArgumentException exc) {
                        throw new ImpossibleException("But we checked the signature!");
                    }
                    return new SingletonInstantiator<Object>(singleton);
                }
                ++n2;
            }
        }
        throw new InstantiationNotSupportedException.InputlessInstantiationNotSupportedException();
    }

    public static Instantiator getInstantiatorFromInstantiationObject(Object c) throws InstantiationNotSupportedException, IllegalArgumentException {
        if (c instanceof Instantiator) {
            return (Instantiator)c;
        }
        if (c instanceof Class) {
            return new NoArgsDefaultInstantiator((Class)c);
        }
        throw new IllegalArgumentException("Unsupported instantiator type: " + (c == null ? "null" : c.getClass()));
    }

    public static <T> Instantiator<T> getInstantiator(Class<T> c) throws InstantiationNotSupportedException {
        return ObjectUtilities.getInstantiatorFromInstantiationObject(ObjectUtilities.getInstantiatorOrClass(c));
    }

    @Nonnull
    public static Trimmable.TrimmableTrimRV trimThing(Object o, boolean trimAllTheWay) {
        if (trimAllTheWay) {
            while (ObjectUtilities.trimThing(o, false) == Trimmable.TrimmableTrimRV.CouldKeepInvoking) {
            }
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }
        if (o instanceof Trimmable) {
            return ((Trimmable)o).couldYouMaybeUseALittleLessMemoryIfYouDontMind();
        }
        if (o instanceof ArrayList) {
            ((ArrayList)o).trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }
        if (o instanceof Vector) {
            ((Vector)o).trimToSize();
            return Trimmable.TrimmableTrimRV.DontKeepInvoking;
        }
        return Trimmable.TrimmableTrimRV.DontKeepInvoking;
    }

    public static int hashr(Object o) {
        if (o == null) {
            return 0;
        }
        if (Primitives.isTrueOrNull(ObjectUtilities.hasIdentity(o))) {
            return System.identityHashCode(o);
        }
        return o.hashCode();
    }

    public static int arrayHashCodeByContentsRespectingFundamentalProperties(Object[] a, int offset, int length) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        int i = offset;
        while (i < offset + length) {
            Object element = a[i];
            result = 31 * result + (element == null ? 0 : ObjectUtilities.hashr(element));
            ++i;
        }
        return result;
    }

    public static int arrayHashCodeByContentsRespectingFundamentalProperties(Object[] a) {
        return ObjectUtilities.arrayHashCodeByContentsRespectingFundamentalProperties(a, 0, a.length);
    }

    public static String toStringNT(Object o) {
        return o != null ? o.toString() : "<null>";
    }

    public static String getClassNameNT(Object o) {
        return o != null ? o.getClass().getName() : "<null-type>";
    }

    public static <T> T defaultIfNullOrPass(T o, T def) {
        return o == null ? def : o;
    }

    public static Boolean isConcurrentlyImmutable(Object object) {
        JavaImmutability imt = ObjectUtilities.isImmutable(object);
        if (imt == JavaImmutability.Concurrently_Immutable) {
            return true;
        }
        if (imt == JavaImmutability.Non_Thread_Safe_Immutable) {
            return false;
        }
        if (imt == JavaImmutability.Mutable) {
            return false;
        }
        if (imt == null) {
            return null;
        }
        throw new UnexpectedHardcodedEnumValueException((Object)imt);
    }

    public static boolean isDefinitelyValueType(@Nullable Object object) {
        return Primitives.isTrueAndNotNull(ObjectUtilities.isValueType(object));
    }

    @Nullable
    public static Boolean isValueType(@Nullable Object object) {
        return object instanceof ValueType ? ((ValueType)object).isValueType() : ObjectUtilities.isDefinitelyValueTypeGrandfathering(object);
    }

    public static Boolean isDefinitelyValueTypeGrandfathering(@Nullable Object object) {
        if (object == null || object instanceof Boolean || object instanceof Number || object instanceof Character || object instanceof String || object instanceof Enum || object instanceof UUID) {
            return true;
        }
        if (ObjectUtilities.isImmutable(object) == JavaImmutability.Mutable) {
            return false;
        }
        return null;
    }

    public static void requireNull(Object x) {
        if (x != null) {
            throw new IllegalArgumentException("Object is not null when it should be null!");
        }
    }

    public static class CloneNotSupportedReturnPath
    extends ReturnPath.SingletonReturnPath {
        private static final long serialVersionUID = 1L;
        public static final CloneNotSupportedReturnPath I = new CloneNotSupportedReturnPath();

        protected CloneNotSupportedReturnPath() {
        }

        @Override
        public RuntimeException toException() {
            return new WrappedThrowableRuntimeException(new CloneNotSupportedException());
        }
    }
}

