/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.lexing.apis.tokenless.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import rebound.exceptions.TextSyntaxCheckedException;
import rebound.io.PerformanceFlagSmallReadsOrWritesAreOk;
import rebound.text.lexing.apis.tokenless.SimpleLexer;
import rebound.util.NIOBufferUtilities;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;

public class SimpleLexerUtilities
implements JavaNamespace {
    public static Reader getReaderSource(Object source) throws IllegalArgumentException {
        if (source instanceof String) {
            return new StringReader((String)source);
        }
        if (source instanceof CharSequence) {
            return new StringReader(((CharSequence)source).toString());
        }
        if (source instanceof char[]) {
            return new StringReader(new String((char[])source));
        }
        if (source instanceof CharBuffer) {
            return new StringReader(new String(NIOBufferUtilities.copyToNewArray((CharBuffer)source)));
        }
        if (source instanceof Reader) {
            return (Reader)source;
        }
        if (source == null) {
            throw new IllegalArgumentException("Unsupported lexing source: null  (umm, yeah, we can't parse that yo  xD )");
        }
        if (source instanceof InputStream) {
            throw new IllegalArgumentException("Unsupported lexing source class: " + source.getClass().getName() + "  (Didn't anyone ever tell ya?  Don't use binary streams for text, man!!  XD)");
        }
        throw new IllegalArgumentException("Unsupported lexing source class: " + source.getClass().getName());
    }

    public static Reader getReaderSourceBuffered(Object source) throws IllegalArgumentException {
        if (source instanceof Reader) {
            if (source instanceof PerformanceFlagSmallReadsOrWritesAreOk) {
                return (Reader)source;
            }
            return new BufferedReader((Reader)source);
        }
        return SimpleLexerUtilities.getReaderSource(source);
    }

    public static List<Object[]> readAllFromSimpleLexer(SimpleLexer lexer) throws TextSyntaxCheckedException, IOException {
        ArrayList<Object[]> rv = new ArrayList<Object[]>();
        while (true) {
            lexer.next();
            if (lexer.isEOF()) break;
            Object tokenType = lexer.getTokenType();
            if (lexer.isLogicalValueUsed()) {
                Object logicalValue = lexer.getLogicalTokenValue();
                rv.add(new Object[]{tokenType, logicalValue, lexer.getLiteralTokenText()});
                continue;
            }
            rv.add(new Object[]{tokenType, lexer.getLiteralTokenText()});
        }
        return rv;
    }

    public static boolean isLexerOutputAllValueless(List<Object[]> lexerOutput) {
        for (Object[] x : lexerOutput) {
            if (x.length != 3) continue;
            return false;
        }
        return true;
    }

    public static boolean isLexerOutputAllStringValued(List<Object[]> lexerOutput) {
        for (Object[] x : lexerOutput) {
            if (x.length == 2) {
                return false;
            }
            if (x[1] instanceof CharSequence) continue;
            return false;
        }
        return true;
    }

    public static Collection<Class> getRuntimeTokenTypeTypes(List<Object[]> lexerOutput) {
        HashSet<Class> tokentypetypes = new HashSet<Class>();
        for (Object[] x : lexerOutput) {
            tokentypetypes.add(x[0].getClass());
        }
        return tokentypetypes;
    }

    public static List<Object[]> mergeAllAdjacentTokensOfSameTokenTypeOutofplace(List<Object[]> input) {
        return SimpleLexerUtilities.mergeAdjacentTokensByTokenTypeOutofplace(input, (Object t) -> true);
    }

    public static List<Object[]> mergeAdjacentTokensByTokenTypeOutofplace(List<Object[]> input, Set<?> tokenTypes) {
        return SimpleLexerUtilities.mergeAdjacentTokensByTokenTypeOutofplace(input, tokenTypes::contains);
    }

    public static List<Object[]> mergeAdjacentTokensByTokenTypeOutofplace(List<Object[]> input, Predicate<Object> tokenTypes) {
        ArrayList<Object[]> output = new ArrayList<Object[]>(input.size());
        boolean hasLast = false;
        Object[] last = null;
        boolean hasCurrentMerging = false;
        boolean avoidThisToken = false;
        StringBuilder currentMerging = new StringBuilder();
        for (Object[] t : input) {
            if (t.length != 2) {
                throw new IllegalArgumentException("Expected List of new Object[]{Object tokenType, String matchedText}");
            }
            Object thisTokenType = t[0];
            String thisTokenMatchedInput = (String)t[1];
            if (!hasLast) {
                last = t;
                hasLast = true;
                continue;
            }
            Object lastTokenType = last[0];
            String lastTokenMatchedInput = (String)last[1];
            if (BasicObjectUtilities.eq(thisTokenType, lastTokenType)) {
                if (hasCurrentMerging) {
                    currentMerging.append(thisTokenMatchedInput);
                    continue;
                }
                if (avoidThisToken) {
                    output.add(t);
                    continue;
                }
                if (tokenTypes.test(lastTokenType)) {
                    currentMerging.append(lastTokenMatchedInput);
                    currentMerging.append(thisTokenMatchedInput);
                    hasCurrentMerging = true;
                    avoidThisToken = false;
                    continue;
                }
                output.add(t);
                avoidThisToken = true;
                continue;
            }
            if (hasCurrentMerging) {
                Object[] merged = new Object[]{lastTokenType, currentMerging.toString()};
                output.add(merged);
                currentMerging.setLength(0);
                hasCurrentMerging = false;
            } else {
                output.add(last);
            }
            last = t;
            avoidThisToken = false;
        }
        if (hasLast) {
            void lastTokenType = last[0];
            if (hasCurrentMerging) {
                Object[] merged = new Object[]{lastTokenType, currentMerging.toString()};
                output.add(merged);
            } else {
                output.add(last);
            }
        }
        return output;
    }
}

