/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import rebound.exceptions.ImpossibleException;
import rebound.text.StringUtilities;

public class DropData {
    public static final DataFlavor URILIST_FLAVOR;

    static {
        try {
            URILIST_FLAVOR = new DataFlavor("text/uri-list; class=java.lang.String");
        }
        catch (ClassNotFoundException exc) {
            throw new ImpossibleException("java.lang.String not found!!", exc);
        }
    }

    public static List<File> getFileList(DropTargetDropEvent dtde) throws IOException {
        Transferable t = dtde.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrop(dtde.getDropAction());
            try {
                List data = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                dtde.dropComplete(true);
                return data;
            }
            catch (UnsupportedFlavorException exc) {
                throw new ImpossibleException(exc);
            }
        }
        if (t.isDataFlavorSupported(URILIST_FLAVOR)) {
            dtde.acceptDrop(dtde.getDropAction());
            try {
                String data = (String)t.getTransferData(URILIST_FLAVOR);
                List<File> files = DropData.parseURIList(data);
                dtde.dropComplete(true);
                return files;
            }
            catch (UnsupportedFlavorException exc) {
                throw new ImpossibleException(exc);
            }
        }
        System.out.println("Unsupported drop object; with the flavors:");
        DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor f = dataFlavorArray[n2];
            System.out.println("\t" + f.getMimeType());
            ++n2;
        }
        return null;
    }

    public static List<File> parseURIList(String data) {
        data = StringUtilities.universalNewlines(data);
        String[] uris = StringUtilities.split(data, '\n');
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri;
            String rawuri = stringArray[n2];
            if (!rawuri.equals("") && "file".equalsIgnoreCase((uri = URI.create(rawuri)).getScheme())) {
                files.add(new File(uri));
            }
            ++n2;
        }
        return files;
    }
}

