/*
 * Decompiled with CFR 0.152.
 */
package rebound.concurrency;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.semantic.simpledata.Positive;
import rebound.bits.BitfieldSafeCasts;
import rebound.concurrency.SimpleBackgroundThreadImpl;
import rebound.concurrency.async.external.AsynchronousOperation;
import rebound.concurrency.async.external.AsynchronousOperationSentinel;
import rebound.concurrency.data.ConcurrentComputation;
import rebound.concurrency.data.ConcurrentComputationFactory;
import rebound.concurrency.data.ConcurrentIndirectCache;
import rebound.concurrency.threads.GenericEventQueue;
import rebound.concurrency.threads.QueueDelegatingDecorator;
import rebound.concurrency.threads.QueueIsShutdownException;
import rebound.concurrency.threads.RateLimitingQueue;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.UnreachableCodeException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.math.MathUtilities;
import rebound.text.StringUtilities;
import rebound.util.ExceptionUtilities;
import rebound.util.Primitives;
import rebound.util.collections.ArrayUtilities;
import rebound.util.container.SimpleContainers;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;
import rebound.util.functional.throwing.InterruptibleFunctionalInterfaces;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.simplecomp.SimpleCachingState;
import rebound.util.simplecomp.SimpleComputation;
import rebound.util.simplecomp.SimpleComputationFactory;
import rebound.util.simplecomp.SimpleComputationUtilities;
import rebound.util.simplecomp.SimpleNullaryComputorFactory;

public class ConcurrencyUtilities
implements JavaNamespace {
    protected static final long NewFifoDontAllocateAllAtOnceCapacityThreshold = 4097L;

    public static void uninterruptiblyDo(InterruptibleFunctionalInterfaces.InterruptibleRunnable task) {
        while (true) {
            try {
                task.run();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static <T> T uninterruptiblyGet(InterruptibleFunctionalInterfaces.InterruptibleNullaryFunction<T> task) {
        while (true) {
            try {
                return task.f();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void asynchronizeProcedure(FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingAnything task, Executor threadPool, @Nullable Runnable callbackOnSuccess, @Nullable FunctionInterfaces.UnaryProcedure<Throwable> callbackOnError) {
        ConcurrencyUtilities.asynchronizeFunction(() -> null, threadPool, r -> {
            if (r == null) {
                callbackOnSuccess.run();
            } else if (r instanceof Throwable) {
                callbackOnError.f((Throwable)r);
            } else {
                GlobalCodeMetastuffContext.logBug("It somehow returned: " + StringUtilities.repr(r));
                callbackOnError.f(new Throwable());
            }
        });
    }

    public static void asynchronizeFunction(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingAnything<Object> taskReturningAnythingExceptSentinels, Executor threadPool, @Nullable FunctionInterfaces.UnaryProcedure<Object> callback) {
        threadPool.execute(() -> {
            Object rv;
            try {
                rv = taskReturningAnythingExceptSentinels.f();
                if (rv instanceof AsynchronousOperationSentinel || rv instanceof Throwable) {
                    GlobalCodeMetastuffContext.logBug();
                    rv = null;
                }
            }
            catch (Throwable t) {
                rv = t;
            }
            if (callback != null) {
                callback.f(rv);
            }
        });
    }

    public static AsynchronousOperation richlyAsynchronizeProcedure(FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingAnything task, Executor threadPool, @Nullable Runnable callbackOnSuccess, @Nullable FunctionInterfaces.UnaryProcedure<Throwable> callbackOnError) {
        return ConcurrencyUtilities.richlyAsynchronizeFunction(() -> null, threadPool, r -> {
            if (r == null) {
                callbackOnSuccess.run();
            } else if (r instanceof Throwable) {
                callbackOnError.f((Throwable)r);
            } else {
                GlobalCodeMetastuffContext.logBug("It somehow returned: " + StringUtilities.repr(r));
                callbackOnError.f(new Throwable());
            }
        });
    }

    public static AsynchronousOperation richlyAsynchronizeFunction(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingAnything<Object> taskReturningAnythingExceptSentinels, Executor threadPool, @Nullable FunctionInterfaces.UnaryProcedure<Object> callback) {
        final AtomicBoolean finished = new AtomicBoolean(false);
        final SimpleContainers.SimpleObjectContainer returnValue = new SimpleContainers.SimpleObjectContainer();
        threadPool.execute(() -> {
            Object rv;
            try {
                rv = taskReturningAnythingExceptSentinels.f();
                if (rv instanceof AsynchronousOperationSentinel || rv instanceof Throwable) {
                    GlobalCodeMetastuffContext.logBug();
                    rv = null;
                }
            }
            catch (Throwable t) {
                rv = t;
            }
            AtomicBoolean atomicBoolean2 = finished;
            synchronized (atomicBoolean2) {
                finished.set(true);
                returnValue.set(rv);
                finished.notifyAll();
            }
            if (callback != null) {
                callback.f(rv);
            }
        });
        return new AsynchronousOperation(){

            @Override
            public Object peek() {
                boolean f = finished.get();
                return f ? returnValue.get() : AsynchronousOperationSentinel.StillActive;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object get(long timeoutNanoseconds) throws InterruptedException {
                while (true) {
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        if (finished.get()) {
                            return returnValue.get();
                        }
                        ConcurrencyUtilities.timedWaitNanoseconds(finished, timeoutNanoseconds);
                    }
                }
            }
        };
    }

    public static <RV> RV synchronizeOnAll(FunctionInterfaces.NullaryFunction<RV> closureToRunWithinSynchronizedBlocks, Object ... objectsToSynchronizeOn) {
        return ConcurrencyUtilities.synchronizeOnAll(closureToRunWithinSynchronizedBlocks, objectsToSynchronizeOn, 0, objectsToSynchronizeOn.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <RV> RV synchronizeOnAll(FunctionInterfaces.NullaryFunction<RV> closureToRunWithinSynchronizedBlocks, Object[] objectsToSynchronizeOn, int offset, int length) {
        if (length == 0) {
            return closureToRunWithinSynchronizedBlocks.f();
        }
        if (offset < 0 || length < 0 || offset + length > objectsToSynchronizeOn.length) {
            throw new IndexOutOfBoundsException(String.valueOf(offset) + ":" + length + " in " + objectsToSynchronizeOn.length);
        }
        Object object = objectsToSynchronizeOn[offset];
        synchronized (object) {
            return ConcurrencyUtilities.synchronizeOnAll(closureToRunWithinSynchronizedBlocks, objectsToSynchronizeOn, offset + 1, length - 1);
        }
    }

    public static void synchronizeOnAll(Runnable closureToRunWithinSynchronizedBlocks, Object ... objectsToSynchronizeOn) {
        ConcurrencyUtilities.synchronizeOnAll(closureToRunWithinSynchronizedBlocks, objectsToSynchronizeOn, 0, objectsToSynchronizeOn.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizeOnAll(Runnable closureToRunWithinSynchronizedBlocks, Object[] objectsToSynchronizeOn, int offset, int length) {
        if (length == 0) {
            closureToRunWithinSynchronizedBlocks.run();
        } else {
            if (offset < 0 || length < 0 || offset + length > objectsToSynchronizeOn.length) {
                throw new IndexOutOfBoundsException(String.valueOf(offset) + ":" + length + " in " + objectsToSynchronizeOn.length);
            }
            Object object = objectsToSynchronizeOn[offset];
            synchronized (object) {
                ConcurrencyUtilities.synchronizeOnAll(closureToRunWithinSynchronizedBlocks, objectsToSynchronizeOn, offset + 1, length - 1);
            }
        }
    }

    public static void timedSleepNanoseconds(long timeoutNanoseconds) throws InterruptedException {
        if (timeoutNanoseconds <= 0L) {
            throw new IllegalArgumentException(String.valueOf(timeoutNanoseconds));
        }
        long ms = timeoutNanoseconds / 1000000L;
        int ns = BitfieldSafeCasts.safeCastS64toS32(timeoutNanoseconds % 1000000L);
        Thread.sleep(ms, ns);
    }

    public static void timedWaitNanoseconds(Object monitor, long timeoutNanoseconds) throws InterruptedException {
        if (timeoutNanoseconds <= 0L) {
            throw new IllegalArgumentException(String.valueOf(timeoutNanoseconds));
        }
        TimeUnit.NANOSECONDS.timedWait(monitor, timeoutNanoseconds);
    }

    public static void timedJoinNanoseconds(Thread thread, long timeoutNanoseconds) throws InterruptedException {
        if (timeoutNanoseconds <= 0L) {
            throw new IllegalArgumentException(String.valueOf(timeoutNanoseconds));
        }
        TimeUnit.NANOSECONDS.timedJoin(thread, timeoutNanoseconds);
    }

    public static void trySleepMS(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepFullySeconds(double durationSeconds) {
        ConcurrencyUtilities.sleepFullyMS(Math.round(durationSeconds * 1000.0));
    }

    public static void sleepFullyMS(long durationMilliseconds) {
        ConcurrencyUtilities.sleepFullyNS(durationMilliseconds * 1000000L);
    }

    public static void sleepFullyNS(long durationNanoseconds) {
        long amount;
        if (durationNanoseconds <= 0L) {
            return;
        }
        long start = System.nanoTime();
        long end = start + durationNanoseconds;
        long now = start;
        while ((amount = end - now) > 0L) {
            try {
                Thread.sleep((int)(amount / 1000000L), (int)(amount % 1000000L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.nanoTime();
        }
    }

    public static void sleepFullyUntilNS(long endNanotime) {
        long now;
        long amount;
        while ((amount = endNanotime - (now = System.nanoTime())) > 0L) {
            try {
                Thread.sleep((int)(amount / 1000000L), (int)(amount % 1000000L));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static ThreadFactory newThreadFactory(final String namePrefix, final String nameSuffix, final ThreadGroup threadGroup, final boolean daemon, final long stackSize) {
        return new ThreadFactory(){
            long i = 0L;

            @Override
            public Thread newThread(Runnable r) {
                String name = String.valueOf(namePrefix) + this.i + nameSuffix;
                Thread t = new Thread(threadGroup, r, name, stackSize);
                t.setDaemon(daemon);
                return t;
            }
        };
    }

    public static ThreadFactory newThreadFactory(String namePrefix, String nameSuffix, ThreadGroup threadGroup, boolean daemon) {
        return ConcurrencyUtilities.newThreadFactory(namePrefix, nameSuffix, threadGroup, daemon, 0L);
    }

    public static ThreadFactory newThreadFactory(ThreadGroup threadGroup, boolean daemon) {
        return ConcurrencyUtilities.newThreadFactory("Factory produced thread ", null, threadGroup, daemon);
    }

    public static Thread newThread(Runnable task) {
        return new Thread(task);
    }

    public static Thread newThread(String name, Runnable task) {
        return new Thread(task, name);
    }

    public static Thread newThread(String name, boolean daemon, Runnable task) {
        Thread thread = new Thread(task, name);
        thread.setDaemon(daemon);
        return thread;
    }

    public static Thread newThread(ThreadGroup threadGroup, String name, boolean daemon, Runnable task) {
        Thread thread = new Thread(threadGroup, task, name);
        thread.setDaemon(daemon);
        return thread;
    }

    public static Thread newThread(Runnable task, String name, boolean daemon, ThreadGroup threadGroup, long stackSize) {
        Thread thread = new Thread(threadGroup, task, name, stackSize);
        thread.setDaemon(daemon);
        return thread;
    }

    public static Thread spawnDaemon(Runnable task) {
        Thread t = new Thread(task);
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static Thread spawnNonDaemon(Runnable task) {
        Thread t = new Thread(task);
        t.setDaemon(false);
        t.start();
        return t;
    }

    public static Thread spawnNonDaemon(String name, Runnable task) {
        Thread t = new Thread(task, name);
        t.setDaemon(false);
        t.start();
        return t;
    }

    public static ThreadPoolExecutor newThreadPool() {
        return new ThreadPoolExecutor(4, 4096, 1L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1024));
    }

    public static Thread[] enumerateThreadsSafely(ThreadGroup group, boolean recurseSubgroups) {
        Thread[] list = new Thread[group.activeCount()];
        int size = 0;
        while ((size = group.enumerate(list, recurseSubgroups)) >= list.length) {
            list = new Thread[(int)((double)list.length * 1.2) + 256];
        }
        return ArrayUtilities.slice(list, 0, size);
    }

    public static ThreadGroup[] enumerateThreadGroupsSafely(ThreadGroup group, boolean recurseSubgroups) {
        ThreadGroup[] list = new ThreadGroup[group.activeGroupCount()];
        int size = 0;
        while ((size = group.enumerate(list, recurseSubgroups)) >= list.length) {
            list = new ThreadGroup[(int)((double)list.length * 1.2) + 256];
        }
        return ArrayUtilities.slice(list, 0, size);
    }

    public static <Output> ConcurrentComputation<Output> concurrentify(final SimpleComputation<Output> underlying) {
        return new ConcurrentComputation<Output>(){

            @Override
            public synchronized SimpleCachingState isCaching() {
                return underlying.isCaching();
            }

            @Override
            public synchronized Output get() throws RuntimeException {
                return underlying.get();
            }

            @Override
            public synchronized boolean dropCache(SimpleCachingState onlyIfSuccess) {
                return underlying.dropCache(onlyIfSuccess);
            }

            @Override
            public synchronized Output recompute(SimpleCachingState onlyIfSuccess) throws RuntimeException {
                underlying.dropCache(onlyIfSuccess);
                return underlying.get();
            }
        };
    }

    public static <Input, Output> ConcurrentComputationFactory<Input, Output> concurrentify(final SimpleComputationFactory<Input, Output> underlying) {
        return new ConcurrentComputationFactory<Input, Output>(){

            @Override
            public ConcurrentComputation<Output> newComputation(Input input) {
                return ConcurrencyUtilities.concurrentify(underlying.newComputation(input));
            }
        };
    }

    public static <Input, Output> ConcurrentIndirectCache<Input, Output> makeConcurrentCache(final ConcurrentComputationFactory<Input, Output> maker, Map<Input, ConcurrentComputation<Output>> backing) {
        return new ConcurrentIndirectCacheImplthingy<Input, Output>(backing){

            @Override
            protected ConcurrentComputation<Output> newComputation(Input input) {
                return ConcurrencyUtilities.concurrentify(maker.newComputation(input));
            }
        };
    }

    public static <Input, Output> ConcurrentIndirectCache<Input, Output> makeConcurrentCache(final SimpleNullaryComputorFactory<Input, Output> maker, Map<Input, ConcurrentComputation<Output>> backing) {
        return new ConcurrentIndirectCacheImplthingy<Input, Output>(backing){

            @Override
            protected ConcurrentComputation<Output> newComputation(Input input) {
                return ConcurrencyUtilities.concurrentify(SimpleComputationUtilities.makeCacher(maker.newComputor(input)));
            }
        };
    }

    public static <Input, Output> ConcurrentIndirectCache<Input, Output> makeConcurrentCache(final FunctionInterfaces.UnaryFunction<Input, Output> computor, Map<Input, ConcurrentComputation<Output>> backing) {
        return new ConcurrentIndirectCacheImplthingy<Input, Output>(backing){

            @Override
            protected ConcurrentComputation<Output> newComputation(Input input) {
                return ConcurrencyUtilities.concurrentify(SimpleComputationUtilities.makeCacher(computor, input));
            }
        };
    }

    public static <E> BlockingQueue<E> newConcurrentFIFO(Long capacity, Class tokenClass, Boolean mergeOrUnboxTokensInStorage, Boolean offerPrimitiveOrNoninstantiatingInterface, boolean longPausesAllowedForGeneralPerformance, boolean unfairnessAllowedForPerformance) {
        if (Primitives.isTrueAndNotNull(offerPrimitiveOrNoninstantiatingInterface)) {
            throw new NotYetImplementedException();
        }
        if (Primitives.isTrueAndNotNull(mergeOrUnboxTokensInStorage)) {
            throw new NotYetImplementedException();
        }
        if (capacity == null) {
            if (!longPausesAllowedForGeneralPerformance) {
                return new LinkedBlockingQueue();
            }
            return new LinkedBlockingQueue();
        }
        if (capacity > 4097L) {
            if (!longPausesAllowedForGeneralPerformance) {
                return new LinkedBlockingQueue(MathUtilities.safeCastIntegerToS32(capacity));
            }
            return new LinkedBlockingQueue(MathUtilities.safeCastIntegerToS32(capacity));
        }
        return new ArrayBlockingQueue(MathUtilities.safeCastIntegerToS32(capacity), !unfairnessAllowedForPerformance);
    }

    public static void awaitTermination(ExecutorService executorService) throws InterruptedException {
        while (!executorService.isTerminated()) {
            executorService.awaitTermination(1000L, TimeUnit.SECONDS);
        }
    }

    public static void shutdownNowCleanlyAndAwaitTermination(ExecutorService executorService) throws InterruptedException {
        executorService.shutdownNow();
        ConcurrencyUtilities.awaitTermination(executorService);
    }

    public static void shutdownNowCleanlyAndForceAwaitTermination(ExecutorService executorService) {
        executorService.shutdownNow();
        while (true) {
            try {
                ConcurrencyUtilities.awaitTermination(executorService);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void doInLock(Lock l, Runnable r) {
        l.lock();
        try {
            r.run();
        }
        finally {
            l.unlock();
        }
    }

    public static void shutdownManyQueuesAsync(List<GenericEventQueue.ShutdownableQueue> queuesInOrder, FunctionInterfaces.UnaryProcedure<List<Runnable>> queueRemnantsHandler, @Nullable Runnable callbackAfterLastOneIsOver, boolean immediate) {
        int n = queuesInOrder.size();
        if (n == 0) {
            if (callbackAfterLastOneIsOver != null) {
                callbackAfterLastOneIsOver.run();
            }
        } else {
            try {
                if (immediate) {
                    for (GenericEventQueue.ShutdownableQueue queue : queuesInOrder) {
                        List<Runnable> remnants2 = queue.shutdown();
                        queueRemnantsHandler.f(remnants2);
                    }
                    if (callbackAfterLastOneIsOver != null) {
                        callbackAfterLastOneIsOver.run();
                    }
                } else {
                    queuesInOrder.get(0).queueToShutdownIfNotDispatchThreadOrRightNowIfSo(remnants -> {
                        try {
                            queueRemnantsHandler.f((List<Runnable>)remnants);
                        }
                        finally {
                            ConcurrencyUtilities.shutdownManyQueuesAsync(queuesInOrder.subList(1, n), queueRemnantsHandler, callbackAfterLastOneIsOver, immediate);
                        }
                    });
                }
            }
            catch (QueueIsShutdownException exc) {
                ConcurrencyUtilities.shutdownManyQueuesAsync(queuesInOrder.subList(1, n), queueRemnantsHandler, callbackAfterLastOneIsOver, immediate);
            }
        }
    }

    public static void shutdownManyQueuesAsync(List<GenericEventQueue.ShutdownableQueue> queuesInOrder, @Nullable Runnable callbackAfterLastOneIsOver, boolean immediate) {
        ConcurrencyUtilities.shutdownManyQueuesAsync(queuesInOrder, GenericEventQueue.ShutdownableQueue.DefaultRemnantsHandler, callbackAfterLastOneIsOver, immediate);
    }

    public static SimpleBackgroundThread spawnBackgroundTaskRunner(boolean daemon, FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingAnything task) {
        SimpleBackgroundThreadImpl t = new SimpleBackgroundThreadImpl(task);
        t.setDaemon(daemon);
        t.start();
        return t;
    }

    public static Runnable startCounterAndProvideEarlyCallback(@Nonnull FunctionInterfaces.UnaryProcedure<Boolean> callbackTrueIfTimedout, @Positive long timeoutMS, @Nonnull ScheduledExecutorService scheduler) {
        Objects.requireNonNull(callbackTrueIfTimedout);
        Objects.requireNonNull(scheduler);
        if (timeoutMS <= 0L) {
            throw new IllegalArgumentException();
        }
        AtomicBoolean already = new AtomicBoolean(false);
        scheduler.schedule(() -> {
            if (already.compareAndSet(false, true)) {
                callbackTrueIfTimedout.f(true);
            }
        }, timeoutMS, TimeUnit.MILLISECONDS);
        return () -> {
            if (already.compareAndSet(false, true)) {
                callbackTrueIfTimedout.f(false);
            }
        };
    }

    public static GenericEventQueue.ShutdownableQueue newRateLimitingQueueDecorator(GenericEventQueue underlyingQueue, int queueCapacity, long minimumDelayInMilliseconds) {
        RateLimitingQueue realQueue = new RateLimitingQueue(queueCapacity, minimumDelayInMilliseconds);
        ConcurrencyUtilities.spawnNonDaemon("Event Queue Rate Limiter", realQueue);
        return new QueueDelegatingDecorator(realQueue, underlyingQueue);
    }

    protected static abstract class ConcurrentIndirectCacheImplthingy<Input, Output>
    implements ConcurrentIndirectCache<Input, Output> {
        protected Map<Input, ConcurrentComputation<Output>> backing;

        public ConcurrentIndirectCacheImplthingy(Map<Input, ConcurrentComputation<Output>> backing) {
            this.backing = backing;
        }

        @Override
        public synchronized ConcurrentComputation<Output> get(Input input) {
            ConcurrentComputation<Output> indirectEvaluationNexus = this.backing.get(input);
            if (indirectEvaluationNexus == null) {
                indirectEvaluationNexus = this.newComputation(input);
                this.backing.put(input, indirectEvaluationNexus);
            }
            return indirectEvaluationNexus;
        }

        @Override
        public synchronized boolean isCaching(Input input) {
            return this.backing.containsKey(input);
        }

        @Override
        public synchronized boolean dropCache(Input input) {
            return this.backing.remove(input) != null;
        }

        @Override
        public synchronized ConcurrentComputation<Output> remake(Input input) {
            this.dropCache(input);
            return this.get(input);
        }

        protected abstract ConcurrentComputation<Output> newComputation(Input var1);
    }

    public static interface GuardedRunnableAsbOthers {
        public Throwable awaitGuardCompletion();
    }

    public static interface GuardedRunnableAsbRunner
    extends Runnable {
    }

    public static interface SimpleBackgroundThread {
        public void shutdownCleanlyWhenFinished();

        public boolean isTaskProbablyInProgress();

        public void runAgainOrQueueThisMessageIfAlreadyRunning();

        default public void runAgainOrDiscardThisMessageIfProbablyAlreadyInProgress() {
            if (!this.isTaskProbablyInProgress()) {
                this.runAgainOrQueueThisMessageIfAlreadyRunning();
            }
        }
    }

    public static class SimpleGuardedRunnable
    implements GuardedRunnableAsbOthers,
    GuardedRunnableAsbRunner {
        protected final BlockingQueue resultFifo = new ArrayBlockingQueue(1);
        protected final Runnable guardRunnable;
        protected final Runnable taskRunnable;

        public SimpleGuardedRunnable(Runnable guardRunnable, Runnable taskRunnable) {
            this.guardRunnable = guardRunnable;
            this.taskRunnable = taskRunnable;
        }

        @Override
        public Throwable awaitGuardCompletion() {
            Object x = null;
            try {
                x = this.resultFifo.take();
            }
            catch (InterruptedException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
            if (x == this) {
                x = null;
            }
            return x;
        }

        @Override
        public void run() {
            try {
                this.guardRunnable.run();
            }
            catch (Throwable t) {
                this.resultFifo.add(t);
                ExceptionUtilities.throwGeneralThrowableAttemptingUnverifiedThrow(t);
                throw new UnreachableCodeException();
            }
            this.resultFifo.add(this);
            this.taskRunnable.run();
        }
    }

    public static enum WhatToDoWithInterruptedException {
        Throw,
        Ignore;

    }
}

