/*
 * Decompiled with CFR 0.152.
 */
package from.java.io.forr.rebound.io.iio;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import rebound.io.iio.RandomAccessInputByteStream;
import rebound.io.iio.unions.CloseableInputByteStreamInterface;

@NotThreadSafe
public class ByteArrayInputByteStream
extends InputStream
implements RandomAccessInputByteStream,
CloseableInputByteStreamInterface {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public ByteArrayInputByteStream(byte[] buf) {
        this.buf = buf;
        this.pos = 0;
        this.count = buf.length;
    }

    public ByteArrayInputByteStream(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
        this.mark = offset;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = this.count - this.pos;
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + k);
        return k;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pos;
    }

    @Override
    public long length() throws IOException {
        return this.count;
    }

    @Override
    public void seek(long newFilePointerPosition) throws IOException {
        if (newFilePointerPosition < 0L) {
            throw new IOException("Seek requested before beginning of buffer!");
        }
        if (newFilePointerPosition > (long)this.count) {
            throw new IOException("Seek requested after end of buffer!");
        }
        this.pos = (int)newFilePointerPosition;
    }

    public boolean isAtEOF() {
        return this.pos == this.count;
    }
}

