/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.edos;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import rebound.annotations.semantic.meta.dependencies.DependencyDirectory;
import rebound.apps.reboundcommonsbuilding.packaging.jar.annotations.PackageAsSimpleJar;
import rebound.jagent.ui.gui.AboutDialog;
import rebound.jagent.ui.gui.edos.EdosWindow;
import rebound.jagent.ui.gui.monk.MonkApplicationCoordinator;
import rebound.osint.modapple.eawtproxy.ApplicationEventProxy;
import rebound.osint.modapple.eawtproxy.ApplicationListenerClone;
import rebound.osint.modapple.eawtproxy.ApplicationProxy;

@PackageAsSimpleJar(value="Edos.jar")
@DependencyDirectory(value="./res")
public class EdosApplicationCoordinator
implements WindowListener {
    public static final String ABOUT_RESOURCE = "about-edos.html";
    public static final boolean AppleJavaExtentionsPresent = ApplicationProxy.canGetApplication();
    protected List<EdosWindow> windowRegistry = new ArrayList<EdosWindow>();
    protected AboutDialog aboutDialog;

    public static void main(String[] args) {
        EdosApplicationCoordinator coordinator = new EdosApplicationCoordinator();
        if (AppleJavaExtentionsPresent) {
            coordinator.setupMacExtensions();
        }
        if (args.length == 0) {
            coordinator.newWindow();
        } else {
            coordinator.load(args);
        }
    }

    public void setupMacExtensions() {
        ApplicationProxy application = ApplicationProxy.getApplication();
        application.removePreferencesMenuItem();
        application.addAboutMenuItem();
        application.addApplicationListener(new ApplicationListenerClone(){

            @Override
            public void handleAbout(ApplicationEventProxy e) {
                e.setHandled(true);
                EdosApplicationCoordinator.this.aboutClicked();
            }

            @Override
            public void handleOpenFile(ApplicationEventProxy e) {
                System.out.println("Open Document(" + e.getFilename() + ")");
                e.setHandled(true);
                EdosApplicationCoordinator.this.load(e.getFilename());
            }

            @Override
            public void handleQuit(ApplicationEventProxy e) {
                EdosApplicationCoordinator.this.safeQuit();
                e.setHandled(false);
            }

            @Override
            public void handleReOpenApplication(ApplicationEventProxy e) {
            }

            @Override
            public void handleOpenApplication(ApplicationEventProxy e) {
            }

            @Override
            public void handlePreferences(ApplicationEventProxy e) {
            }

            @Override
            public void handlePrintFile(ApplicationEventProxy e) {
            }
        });
    }

    public void load(String[] filenames) {
        File[] files = new File[filenames.length];
        int i = 0;
        while (i < files.length) {
            files[i] = new File(filenames[i]);
            ++i;
        }
        this.load(files);
    }

    public void load(File[] files) {
        File file;
        EdosWindow looseImageTarget = null;
        boolean atleastOneNonSprite = false;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (!EdosApplicationCoordinator.isSpriteFile(file)) {
                atleastOneNonSprite = true;
                break;
            }
            ++n2;
        }
        if (atleastOneNonSprite) {
            looseImageTarget = this.newWindow();
        }
        fileArray = files;
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (EdosApplicationCoordinator.isSpriteFile(file)) {
                EdosWindow fresh = this.newWindow();
                fresh.openSafe(file);
            } else {
                looseImageTarget.importImageSafe(file);
            }
            ++n2;
        }
    }

    public void load(String filename) {
        this.load(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) {
        if (EdosApplicationCoordinator.isSpriteFile(file)) {
            EdosWindow window = this.newWindow();
            window.openSafe(file);
        } else {
            List<EdosWindow> list = this.windowRegistry;
            synchronized (list) {
                EdosWindow target = null;
                target = this.windowRegistry.isEmpty() ? this.newWindow() : this.windowRegistry.get(0);
                target.importImageSafe(file);
            }
        }
    }

    public boolean safeQuit() {
        if (JOptionPane.showConfirmDialog(null, "Are you sure you wish to quit?", "Quit, really?", 0) == 0) {
            System.exit(0);
            return true;
        }
        return false;
    }

    public AboutDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            String r = String.valueOf(MonkApplicationCoordinator.class.getPackage().getName().replace('.', '/')) + "/res/" + ABOUT_RESOURCE;
            this.aboutDialog = new AboutDialog(r);
        }
        return this.aboutDialog;
    }

    public void aboutClicked() {
        this.getAboutDialog().display();
    }

    public EdosWindow newWindow() {
        EdosWindow e = new EdosWindow();
        e.setApplicationCoordinator(this);
        this.registerWindow(e);
        e.addWindowListener(this);
        e.setVisible(true);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeWindow(EdosWindow window) {
        List<EdosWindow> list = this.windowRegistry;
        synchronized (list) {
            block4: {
                if (this.windowRegistry.size() != 1 || !this.windowRegistry.contains(window) || this.safeQuit()) break block4;
                return false;
            }
            window.setVisible(false);
            this.windowRegistry.remove(window);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWindow(EdosWindow window) {
        List<EdosWindow> list = this.windowRegistry;
        synchronized (list) {
            this.windowRegistry.add(window);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getWindow() instanceof EdosWindow) {
            EdosWindow window = (EdosWindow)e.getWindow();
            this.closeWindow(window);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public static boolean isSpriteFile(File file) {
        String ln = file.getName().toLowerCase();
        return ln.endsWith(".c16") || ln.endsWith(".s16") || ln.endsWith(".spr") || ln.endsWith(".blk");
    }
}

