/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.template;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nullable;
import rebound.io.util.FSIOUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.PathBoss;
import rebound.text.StringUtilities;
import rebound.util.Either;

public class Group {
    protected String ID;
    protected String name;
    protected String dir;
    protected Vector<String> scriptFileNames;
    protected boolean cutOutRemoveScriptFromFirstScript = false;
    protected List<String> intTagNames = new ArrayList<String>();
    protected List<String> strTagNames;
    protected List<Integer> intTagVals = new ArrayList<Integer>();
    protected List<String> strTagVals;
    @Nullable
    protected String removeScriptFilename;

    public Group() {
        this.strTagNames = new ArrayList<String>();
        this.strTagVals = new ArrayList<String>();
        this.scriptFileNames = new Vector();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Group)) {
            return false;
        }
        Group o = (Group)obj;
        return Group.eq(this.ID, o.ID) && Group.eq(this.name, o.name) && Group.eq(this.scriptFileNames, o.scriptFileNames) && Group.mapeq(this.intTagNames, this.intTagVals, o.intTagNames, o.intTagVals) && Group.mapeq(this.strTagNames, this.strTagVals, o.strTagNames, o.strTagVals) && Group.eq(this.removeScriptFilename, this.removeScriptFilename);
    }

    private static boolean eq(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private static boolean mapeq(List ak, List av, List bk, List bv) {
        if (ak == bk && av == bv) {
            return true;
        }
        if (ak == null || av == null || bk == null || bv == null) {
            return false;
        }
        int length = ak.size();
        if (av.size() != length || bk.size() != length || bv.size() != length) {
            return false;
        }
        Hashtable a = null;
        a = new Hashtable();
        int i = 0;
        while (i < length) {
            a.put(ak.get(i), av.get(i));
            ++i;
        }
        Hashtable b = null;
        b = new Hashtable();
        int i2 = 0;
        while (i2 < length) {
            b.put(bk.get(i2), bv.get(i2));
            ++i2;
        }
        return a.equals(b);
    }

    public void addTag(String key, Either<Integer, String> val) {
        if (val.isA()) {
            this.addIntTag(key, val.getValueIfA());
        } else {
            this.addStringTag(key, val.getValueIfB());
        }
    }

    public void addIntTag(String key, int val) {
        this.intTagNames.add(key);
        this.intTagVals.add(val);
    }

    public void addStringTag(String key, String val) {
        this.strTagNames.add(key);
        this.strTagVals.add(val);
    }

    public static boolean isScriptTag(String key) {
        if (key.startsWith("Script ") && !key.equals("Script Count")) {
            try {
                Integer.parseInt(key.substring("Script ".length()));
            }
            catch (NumberFormatException exc) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void addScript(String file) {
        this.scriptFileNames.add(file);
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String id) {
        this.ID = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDir(File dir) {
        this.dir = String.valueOf(dir.getAbsolutePath()) + File.separatorChar;
    }

    public String getDir() {
        return this.dir;
    }

    public int getIntTagValue(int index) {
        return this.intTagVals.get(index);
    }

    public String getStrTagValue(int index) {
        return this.strTagVals.get(index);
    }

    public String getIntTagName(int index) {
        return this.intTagNames.get(index);
    }

    public String getStrTagName(int index) {
        return this.strTagNames.get(index);
    }

    public int getIntValCount() {
        return this.intTagNames.size();
    }

    public int getStrValCount() {
        return this.strTagNames.size();
    }

    public boolean hasScripts() {
        return this.scriptFileNames.size() > 0;
    }

    public boolean getCutOutRemoveScriptFromFirstScript() {
        return this.cutOutRemoveScriptFromFirstScript;
    }

    public void setCutOutRemoveScriptFromFirstScript(boolean cutOutRemoveScriptFromFirstScript) {
        this.cutOutRemoveScriptFromFirstScript = cutOutRemoveScriptFromFirstScript;
    }

    public List<String> getScriptFileNames() {
        return this.scriptFileNames;
    }

    public List<File> getScriptFiles() {
        ArrayList<File> files = new ArrayList<File>(this.scriptFileNames.size());
        for (String name : this.scriptFileNames) {
            files.add(new File(this.dir, name));
        }
        return files;
    }

    @Nullable
    public String getRemoveScriptFilename() {
        return this.removeScriptFilename;
    }

    @Nullable
    public File getRemoveScriptFile() {
        return this.removeScriptFilename == null ? null : new File(this.dir, this.removeScriptFilename);
    }

    public void recognizeSingletonScript() {
        if (this.scriptFileNames.size() == 1) {
            File oldScriptFile = this.getIndexedScriptFileName(1);
            if (!this.scriptFileNames.get(0).equals(oldScriptFile.getName())) {
                throw new AssertionError((Object)("Internal Inconsistency: #wSTF=\"" + this.scriptFileNames.get(0) + "\"     #rSS=\"" + oldScriptFile.getName() + "\""));
            }
            File newScriptFile = this.getSingletonScriptFileName();
            boolean success = oldScriptFile.renameTo(newScriptFile);
            if (success) {
                this.scriptFileNames.set(0, newScriptFile.getName());
            }
        }
    }

    public void writeRemoveScriptToFile(String scriptData) throws IOException, FormatMismatchException {
        File f = this.getRemoveScriptFileName();
        this.writeToCosFile(scriptData, f);
        this.removeScriptFilename = f.getName();
    }

    public void writeScriptToFile(String scriptData, int scriptNumber) throws IOException, FormatMismatchException {
        this._writeScriptToFile(scriptData, scriptNumber);
    }

    public void writeRawScriptToFile(byte[] scriptData, int scriptNumber) throws IOException, FormatMismatchException {
        this._writeScriptToFile(scriptData, scriptNumber);
    }

    protected void _writeScriptToFile(Object scriptData, int scriptNumber) throws IOException, FormatMismatchException {
        if (scriptNumber < 1) {
            throw new FormatMismatchException("Invalid script number: " + scriptNumber + "   for block \"" + this.getName() + "\"");
        }
        if (scriptNumber <= this.scriptFileNames.size() && this.scriptFileNames.get(scriptNumber - 1) != null) {
            throw new FormatMismatchException("Duplicate scripts at \"Script " + scriptNumber + "\"   for block \"" + this.getName() + "\"");
        }
        File f = this.getIndexedScriptFileName(scriptNumber);
        this.writeToCosFile(scriptData, f);
        if (scriptNumber > this.scriptFileNames.size()) {
            this.scriptFileNames.setSize(scriptNumber);
        }
        this.scriptFileNames.set(scriptNumber - 1, f.getName());
    }

    protected void writeToCosFile(Object scriptData, File f) throws IOException, FormatMismatchException {
        if (f.exists()) {
            System.err.println("Script file exists: " + f.getAbsolutePath());
            throw new IOException("Script file exists: " + f.getName());
        }
        if (scriptData instanceof String) {
            String d = (String)scriptData;
            d = StringUtilities.universalNewlines(d);
            FSIOUtilities.writeAllText(f, d);
        } else {
            byte[] d = (byte[])scriptData;
            FSIOUtilities.writeAll(f, d);
        }
    }

    protected File getIndexedScriptFileName(int scriptNumber) {
        return new File(this.dir, PathBoss.getInstance().getEscapedNameOnCurrentHostOS(String.valueOf(this.getName()) + " script " + scriptNumber + ".cos"));
    }

    protected File getSingletonScriptFileName() {
        return new File(this.dir, PathBoss.getInstance().getEscapedNameOnCurrentHostOS(String.valueOf(this.getName()) + " script.cos"));
    }

    protected File getRemoveScriptFileName() {
        return new File(this.dir, PathBoss.getInstance().getEscapedNameOnCurrentHostOS(String.valueOf(this.getName()) + " remove script.cos"));
    }

    public static int getScriptNumber(String scriptTagName) {
        return Integer.parseInt(scriptTagName.substring(7));
    }
}

