/*
 * Decompiled with CFR 0.152.
 */
package rebound.hci.graphics2d.gui.util;

import java.awt.geom.Dimension2D;
import rebound.concurrency.immutability.StaticallyConcurrentlyImmutable;
import rebound.exceptions.ReadonlyUnsupportedOperationException;

public class ImmutableDimension2D
extends Dimension2D
implements StaticallyConcurrentlyImmutable {
    public static final ImmutableDimension2D ZeroSize = new ImmutableDimension2D(0.0, 0.0);
    protected final double width;
    protected final double height;

    public ImmutableDimension2D(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public ImmutableDimension2D(Dimension2D d) {
        this(d.getWidth(), d.getHeight());
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setSize(double width, double height) {
        throw new ReadonlyUnsupportedOperationException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dimension2D)) {
            return false;
        }
        Dimension2D other = (Dimension2D)obj;
        return ImmutableDimension2D.eqSane(this.getWidth(), other.getWidth()) && ImmutableDimension2D.eqSane(this.getHeight(), other.getHeight());
    }

    public String toString() {
        return String.valueOf(this.getWidth()) + " x " + this.getHeight();
    }

    private static boolean eqSane(double a, double b) {
        return a == b || a != a && b != b;
    }
}

