/*
 * Decompiled with CFR 0.152.
 */
package rebound.concurrency.threads;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import rebound.concurrency.threads.BasicSchedulerService;
import rebound.exceptions.NotYetImplementedException;
import rebound.util.TimeUtilities;

public class Scheduler
implements BasicSchedulerService {
    protected static final ThreadGroup GlobalGroup = new ThreadGroup("Global Scheduler Group");
    protected Object dataLock;
    protected Collection<Task> tasks;
    protected Distributer distributer;
    protected ThreadGroup group;
    protected ThreadGroup henchmanGroup;
    protected boolean spinoffsDaemons;
    protected long spinoffGrace = 500L;
    protected static final TaskPattern ALL_PATTERN = new TaskPattern(){

        @Override
        public boolean test(Task task) {
            return true;
        }
    };

    public Scheduler() {
        this(false);
    }

    public Scheduler(boolean distributerDamon) {
        this(distributerDamon, false);
    }

    public Scheduler(boolean distributerDamon, boolean spinoffsDamons) {
        this.spinoffsDaemons = spinoffsDamons;
        this.tasks = new LinkedList<Task>();
        this.group = new ThreadGroup(GlobalGroup, "Group for " + this);
        this.henchmanGroup = new ThreadGroup(this.group, "Henchman Group for " + this);
        this.dataLock = this.tasks;
        this.distributer = new Distributer(this.getThreadGroup());
        this.distributer.setDaemon(distributerDamon);
        this.distributer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Task task) {
        Object object = this.distributer.waiter;
        synchronized (object) {
            Object object2 = this.dataLock;
            synchronized (object2) {
                this.tasks.add(task);
                this.poke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unregister(TaskPattern pattern, boolean all) {
        int count = 0;
        Object object = this.dataLock;
        synchronized (object) {
            Iterator<Task> i = this.tasks.iterator();
            while (i.hasNext()) {
                Task task = i.next();
                if (!pattern.test(task)) continue;
                i.remove();
                ++count;
            }
        }
        return count;
    }

    @Override
    public void scheduleRelative(Runnable task, long nanosecondsFromNowToExecute) {
        this.register(task, System.currentTimeMillis() + nanosecondsFromNowToExecute / 1000000L);
    }

    @Override
    public void scheduleAbsolute(Runnable task, long systemNanotimeToExecuteAt) {
        this.register(task, TimeUtilities.convertNanotimeToMSUX(systemNanotimeToExecuteAt));
    }

    @Override
    public void shutdownCleanlyEventually() {
        throw new NotYetImplementedException();
    }

    @Override
    public void shutdownCleanlyNow() {
        this.distributer.die = true;
        this.poke();
    }

    public void register(Runnable taskbody, long timeMSUX) {
        this.register(new Task(timeMSUX, taskbody));
    }

    public void unregister(final Runnable taskbody) {
        this.unregister(new TaskPattern(){

            @Override
            public boolean test(Task task) {
                return task.getBody().equals(taskbody);
            }
        }, false);
    }

    public void unregisterAll(final Class runnableClass) {
        if (runnableClass == null) {
            return;
        }
        this.unregister(new TaskPattern(){

            @Override
            public boolean test(Task task) {
                return runnableClass.isInstance(task.getBody());
            }
        }, false);
    }

    public void unregisterAll() {
        this.unregister(ALL_PATTERN, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstTask() {
        boolean first = true;
        long nearest = 0L;
        Object object = this.dataLock;
        synchronized (object) {
            for (Task task : this.tasks) {
                if (!first && task.getTimeMSUX() >= nearest) continue;
                first = false;
                nearest = task.getTimeMSUX();
            }
        }
        return nearest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTaskCount() {
        Object object = this.dataLock;
        synchronized (object) {
            return this.tasks.size();
        }
    }

    public static ThreadGroup getGlobalThreadGroup() {
        return GlobalGroup;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }

    public ThreadGroup getSpinoffThreadGroup() {
        return this.henchmanGroup;
    }

    public boolean isDistributerDaemon() {
        return this.distributer.isDaemon();
    }

    public boolean areSpinoffsDaemons() {
        return this.spinoffsDaemons;
    }

    public void setFutureSpinoffsDaemons(boolean daemons) {
        this.spinoffsDaemons = daemons;
    }

    public long getSpinoffGrace() {
        return this.spinoffGrace;
    }

    public void setSpinoffGrace(long spinoffGrace) {
        this.spinoffGrace = spinoffGrace;
    }

    public void kill() {
        this.distributer.die = true;
        this.poke();
        try {
            this.distributer.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poke() {
        Object object = this.distributer.waiter;
        synchronized (object) {
            this.distributer.waiter.notify();
        }
    }

    protected class Distributer
    extends Thread {
        protected volatile boolean die;
        protected Object waiter;

        public Distributer() {
            super("Distributer");
            this.waiter = new Object();
        }

        public Distributer(ThreadGroup group) {
            super(group, "Distributer");
            this.waiter = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        var1_1 = this.waiter;
                        synchronized (var1_1) {
                            if (this.die) {
                                return;
                            }
                            isEmpty = false;
                            nextSpinoff = 0L;
                            var5_5 = Scheduler.this.dataLock;
                            synchronized (var5_5) {
                                i = Scheduler.this.tasks.iterator();
                                while (i.hasNext()) {
                                    task = i.next();
                                    spinoffGrace = Scheduler.this.getSpinoffGrace();
                                    taskTime = task.getTimeMSUX();
                                    if (taskTime - spinoffGrace > (now = System.currentTimeMillis())) continue;
                                    henchman = new Spinoff(task);
                                    henchman.start();
                                    i.remove();
                                }
                                if (Scheduler.this.tasks.isEmpty()) {
                                    isEmpty = true;
                                } else {
                                    isEmpty = false;
                                    nextTask = 0L;
                                    nextTaskSet = false;
                                    for (Task task : Scheduler.this.tasks) {
                                        if (!nextTaskSet) {
                                            nextTask = task.getTimeMSUX();
                                            nextTaskSet = true;
                                            continue;
                                        }
                                        if (task.getTimeMSUX() >= nextTask) continue;
                                        nextTask = task.getTimeMSUX();
                                    }
                                    nextSpinoff = nextTask - Scheduler.this.getSpinoffGrace();
                                }
                            }
                            if (isEmpty) {
                                this.waiter.wait();
                            } else {
                                now = System.currentTimeMillis();
                                timeToNextSpinoff = nextSpinoff - now;
                                if (timeToNextSpinoff > 0L) {
                                    this.waiter.wait(timeToNextSpinoff);
                                }
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException var1_2) {
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }
    }

    protected class Spinoff
    extends Thread {
        protected Task task;

        public Spinoff(Task task) {
            super(Scheduler.this.getSpinoffThreadGroup(), "Henchman #" + (Scheduler.this.getSpinoffThreadGroup().activeCount() + 1) + " for " + Scheduler.this);
            this.setDaemon(Scheduler.this.spinoffsDaemons);
            this.task = task;
        }

        @Override
        public void run() {
            long now;
            Runnable runnable = this.task.getBody();
            long taskTime = this.task.getTimeMSUX();
            long diff = taskTime - (now = System.currentTimeMillis());
            if (diff > 0L) {
                try {
                    Spinoff.sleep(diff);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            runnable.run();
        }
    }

    public class Task {
        protected long timeMSUX;
        protected Runnable body;

        public Task() {
        }

        public Task(long time, Runnable body) {
            this.timeMSUX = time;
            this.body = body;
        }

        public long getTimeMSUX() {
            return this.timeMSUX;
        }

        public void setTimeMSUX(long time) {
            this.timeMSUX = time;
        }

        public Runnable getBody() {
            return this.body;
        }

        public void setBody(Runnable body) {
            this.body = body;
        }
    }

    public static interface TaskPattern {
        public boolean test(Task var1);
    }
}

