/*
 * Decompiled with CFR 0.152.
 */
package rebound.apps.c3ds.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import rebound.io.util.JRECompatIOUtilities;

public class Main {
    public static final String HELP = "Usage: [un]compress.creatures -c [<compression-level>]\n       [un]compress.creatures <input-file> <output-file> [<compression-level>]\n\nThe -c option uses stdin and stdout instead of files.\nCompression level (used with compress mode) is 0-9 and has aliases: world, glist, caos.syntax";
    public static final byte[] HEADER = new byte[]{67, 114, 101, 97, 116, 117, 114, 101, 115, 32, 69, 118, 111, 108, 117, 116, 105, 111, 110, 32, 69, 110, 103, 105, 110, 101, 32, 45, 32, 65, 114, 99, 104, 105, 118, 101, 100, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 102, 105, 108, 101, 46, 32, 122, 76, 105, 98, 32, 49, 46, 49, 51, 32, 99, 111, 109, 112, 114, 101, 115, 115, 101, 100, 46, 26, 4};
    public static final int LEVEL_DEFAULT = 9;
    public static final int LEVEL_CAOS_SYNTAX = 6;
    public static final int LEVEL_WORLD = 5;
    public static final int LEVEL_GLIST = 6;

    public static void main(boolean compress, String[] args) {
        int ec = Main.doMain(compress, args);
        if (ec == 1) {
            Main.printHelp();
        }
        System.exit(ec);
    }

    public static void printHelp() {
        System.out.println(HELP);
    }

    public static int doMain(boolean compress, String[] args) {
        block16: {
            if (args.length == 0) {
                return 1;
            }
            if (args[0].equals("-c")) {
                int compressionLevel = 9;
                if (args.length > 1) {
                    compressionLevel = Main.getCompressionLevel(args[1]);
                }
                try {
                    InputStream in = System.in;
                    PrintStream out = System.out;
                    if (compress) {
                        Main.compress(in, out, compressionLevel);
                        break block16;
                    }
                    Main.uncompress(in, out);
                }
                catch (IOException exc) {
                    System.err.println("IO Error: " + exc.getMessage());
                    System.exit(32);
                }
            } else if (args.length >= 2) {
                int compressionLevel = 9;
                if (args.length > 2) {
                    compressionLevel = Main.getCompressionLevel(args[2]);
                }
                File inf = new File(args[0]);
                File outf = new File(args[1]);
                if (!inf.isFile()) {
                    System.err.println("Input " + inf + " is not a file.");
                    return 2;
                }
                if (outf.exists()) {
                    System.err.println("Output " + outf + " exists.");
                    return 2;
                }
                try {
                    FileInputStream in = new FileInputStream(inf);
                    FileOutputStream out = new FileOutputStream(outf);
                    if (compress) {
                        Main.compress(in, out, compressionLevel);
                    } else {
                        Main.uncompress(in, out);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                catch (IOException exc) {
                    System.err.println("IO Error: " + exc.getMessage());
                    System.exit(32);
                }
            } else {
                return 1;
            }
        }
        return 0;
    }

    public static int getCompressionLevel(String input) {
        if (input == null) {
            return 9;
        }
        int i = 0;
        try {
            i = Integer.parseInt(input);
        }
        catch (NumberFormatException exc) {
            i = input.equalsIgnoreCase("caos.syntax") ? 6 : (input.equalsIgnoreCase("world") ? 5 : (input.equalsIgnoreCase("glist") ? 6 : 9));
        }
        if (i < 0) {
            return 0;
        }
        if (i > 9) {
            return 9;
        }
        return i;
    }

    public static void uncompress(InputStream in, OutputStream out) throws IOException {
        byte[] h = new byte[HEADER.length];
        JRECompatIOUtilities.readFully(in, h);
        InflaterInputStream inflater = new InflaterInputStream(in, new Inflater(false));
        JRECompatIOUtilities.pump((InputStream)inflater, out);
    }

    public static void compress(InputStream in, OutputStream out, int level) throws IOException {
        out.write(HEADER);
        DeflaterOutputStream deflater = new DeflaterOutputStream(out, new Deflater(level, false));
        JRECompatIOUtilities.pump(in, (OutputStream)deflater);
        deflater.finish();
        deflater.flush();
    }
}

