/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections.prim;

import java.math.BigInteger;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.bits.BitfieldSafeCasts;
import rebound.exceptions.OverflowException;
import rebound.math.SmallIntegerMathUtilities;
import rebound.text.StringUtilities;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;

@ImplementationTransparency
public interface NonuniformMethodsForBooleanList
extends PrimitiveCollections.DefaultToArraysBooleanCollection {
    public static final /* synthetic */ boolean $assertionsDisabled;

    public boolean getBoolean(int var1);

    public void setBoolean(int var1, boolean var2);

    default public int getNumberOfOnes() {
        int n = this.size();
        int n1 = 0;
        int i = 0;
        while (i < n) {
            n1 += this.getBoolean(i) ? 1 : 0;
            ++i;
        }
        return n1;
    }

    default public int getNumberOfZeros() {
        return this.size() - this.getNumberOfOnes();
    }

    default public long getBitfield(int offset, int length) {
        long r = 0L;
        int i = 0;
        while (i < length) {
            boolean bit = this.getBoolean(offset + i);
            r |= (bit ? 1L : 0L) << i;
            ++i;
        }
        return r;
    }

    default public void setBitfield(int offset, int length, long bitfield) {
        int i = 0;
        while (i < length) {
            boolean bit = (1L << i & bitfield) != 0L;
            this.setBoolean(offset + i, bit);
            ++i;
        }
    }

    default public long getEntireByBitfield() {
        int s = this.size();
        if (s > 64) {
            throw new OverflowException();
        }
        return this.getBitfield(0, s);
    }

    default public BigInteger toBigIntegerLE() {
        BigInteger bigInteger = BigInteger.ZERO;
        int sizeInBits = this.size();
        int wordLength = SmallIntegerMathUtilities.ceilingDivision(sizeInBits, 64);
        int wordIndex = 0;
        while (wordIndex < wordLength) {
            int bitsUsedInWord;
            int n = bitsUsedInWord = wordIndex < wordLength - 1 ? 64 : sizeInBits - wordIndex * 64;
            assert (bitsUsedInWord > 0 && bitsUsedInWord <= 64);
            long maskedWord = this.getBitfield(wordIndex * 64, bitsUsedInWord);
            BigInteger operand = BigInteger.valueOf(maskedWord);
            operand = operand.shiftLeft(wordIndex * 64);
            bigInteger = bigInteger.or(operand);
            ++wordIndex;
        }
        return bigInteger;
    }

    default public void putArray(int destBitOffset, @ReadonlyValue byte[] bitfields, int sourceElementOffset, int elementCount, @ActuallyUnsigned int totalLengthOfDataToInsertInBits) {
        int primlen = 8;
        int lengthInBitsInt = BitfieldSafeCasts.safeCastU64toS32(totalLengthOfDataToInsertInBits);
        if (elementCount != -1 && SmallIntegerMathUtilities.ceilingDivision(lengthInBitsInt, primlen) > elementCount) {
            throw new IllegalArgumentException("Array bounds check failed; it would have gone past! :[!");
        }
        int numberOfFullElementsToUse = lengthInBitsInt / primlen;
        int i = 0;
        while (i < numberOfFullElementsToUse) {
            this.setBitfield(destBitOffset + i * primlen, primlen, bitfields[sourceElementOffset + i]);
            ++i;
        }
        int fullAmount = numberOfFullElementsToUse * primlen;
        int remainder = lengthInBitsInt - fullAmount;
        assert (remainder >= 0);
        assert (remainder < primlen);
        if (remainder != 0) {
            this.setBitfield(destBitOffset + fullAmount, remainder, bitfields[sourceElementOffset + numberOfFullElementsToUse]);
        }
    }

    default public void putArray(@ReadonlyValue byte[] bitfields) {
        this.putArray(0, bitfields, 0, bitfields.length, bitfields.length * 8);
    }

    default public void putArrayFromSliceByte(int destBitOffset, @ReadonlyValue Slice<byte[]> bitfields) {
        this.putArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), bitfields.getLength() * 8);
    }

    default public void putArrayFromSliceByte(@ReadonlyValue Slice<byte[]> bitfields) {
        this.putArrayFromSliceByte(0, bitfields);
    }

    default public void putUnpackedArray(int destBitOffset, @ReadonlyValue byte[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 8) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            this.setBitfield(destBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits, bitfields[sourceElementOffset + i]);
            ++i;
        }
    }

    default public void putUnpackedArray(@ReadonlyValue byte[] bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceByte(int destBitOffset, @ReadonlyValue Slice<byte[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceByte(@ReadonlyValue Slice<byte[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArrayFromSliceByte(0, bitfields, lengthOfEachElementInBits);
    }

    default public void getUnpackedArray(int sourceBitOffset, @WritableValue byte[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 8) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            bitfields[sourceElementOffset + i] = (byte)this.getBitfield(sourceBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits);
            ++i;
        }
    }

    default public void getUnpackedArray(@WritableValue byte[] bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceByte(int sourceBitOffset, @WritableValue Slice<byte[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(sourceBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceByte(@WritableValue Slice<byte[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArrayToSliceByte(0, bitfields, lengthOfEachElementInBits);
    }

    default public void putArray(int destBitOffset, @ReadonlyValue char[] bitfields, int sourceElementOffset, int elementCount, @ActuallyUnsigned int totalLengthOfDataToInsertInBits) {
        int primlen = 16;
        int lengthInBitsInt = BitfieldSafeCasts.safeCastU64toS32(totalLengthOfDataToInsertInBits);
        if (elementCount != -1 && SmallIntegerMathUtilities.ceilingDivision(lengthInBitsInt, primlen) > elementCount) {
            throw new IllegalArgumentException("Array bounds check failed; it would have gone past! :[!");
        }
        int numberOfFullElementsToUse = lengthInBitsInt / primlen;
        int i = 0;
        while (i < numberOfFullElementsToUse) {
            this.setBitfield(destBitOffset + i * primlen, primlen, bitfields[sourceElementOffset + i]);
            ++i;
        }
        int fullAmount = numberOfFullElementsToUse * primlen;
        int remainder = lengthInBitsInt - fullAmount;
        assert (remainder >= 0);
        assert (remainder < primlen);
        if (remainder != 0) {
            this.setBitfield(destBitOffset + fullAmount, remainder, bitfields[sourceElementOffset + numberOfFullElementsToUse]);
        }
    }

    default public void putArray(@ReadonlyValue char[] bitfields) {
        this.putArray(0, bitfields, 0, bitfields.length, bitfields.length * 16);
    }

    default public void putArrayFromSliceChar(int destBitOffset, @ReadonlyValue Slice<char[]> bitfields) {
        this.putArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), bitfields.getLength() * 16);
    }

    default public void putArrayFromSliceChar(@ReadonlyValue Slice<char[]> bitfields) {
        this.putArrayFromSliceChar(0, bitfields);
    }

    default public void putUnpackedArray(int destBitOffset, @ReadonlyValue char[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 16) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            this.setBitfield(destBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits, bitfields[sourceElementOffset + i]);
            ++i;
        }
    }

    default public void putUnpackedArray(@ReadonlyValue char[] bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceChar(int destBitOffset, @ReadonlyValue Slice<char[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceChar(@ReadonlyValue Slice<char[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArrayFromSliceChar(0, bitfields, lengthOfEachElementInBits);
    }

    default public void getUnpackedArray(int sourceBitOffset, @WritableValue char[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 16) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            bitfields[sourceElementOffset + i] = (char)this.getBitfield(sourceBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits);
            ++i;
        }
    }

    default public void getUnpackedArray(@WritableValue char[] bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceChar(int sourceBitOffset, @WritableValue Slice<char[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(sourceBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceChar(@WritableValue Slice<char[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArrayToSliceChar(0, bitfields, lengthOfEachElementInBits);
    }

    default public void putArray(int destBitOffset, @ReadonlyValue short[] bitfields, int sourceElementOffset, int elementCount, @ActuallyUnsigned int totalLengthOfDataToInsertInBits) {
        int primlen = 16;
        int lengthInBitsInt = BitfieldSafeCasts.safeCastU64toS32(totalLengthOfDataToInsertInBits);
        if (elementCount != -1 && SmallIntegerMathUtilities.ceilingDivision(lengthInBitsInt, primlen) > elementCount) {
            throw new IllegalArgumentException("Array bounds check failed; it would have gone past! :[!");
        }
        int numberOfFullElementsToUse = lengthInBitsInt / primlen;
        int i = 0;
        while (i < numberOfFullElementsToUse) {
            this.setBitfield(destBitOffset + i * primlen, primlen, bitfields[sourceElementOffset + i]);
            ++i;
        }
        int fullAmount = numberOfFullElementsToUse * primlen;
        int remainder = lengthInBitsInt - fullAmount;
        assert (remainder >= 0);
        assert (remainder < primlen);
        if (remainder != 0) {
            this.setBitfield(destBitOffset + fullAmount, remainder, bitfields[sourceElementOffset + numberOfFullElementsToUse]);
        }
    }

    default public void putArray(@ReadonlyValue short[] bitfields) {
        this.putArray(0, bitfields, 0, bitfields.length, bitfields.length * 16);
    }

    default public void putArrayFromSliceShort(int destBitOffset, @ReadonlyValue Slice<short[]> bitfields) {
        this.putArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), bitfields.getLength() * 16);
    }

    default public void putArrayFromSliceShort(@ReadonlyValue Slice<short[]> bitfields) {
        this.putArrayFromSliceShort(0, bitfields);
    }

    default public void putUnpackedArray(int destBitOffset, @ReadonlyValue short[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 16) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            this.setBitfield(destBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits, bitfields[sourceElementOffset + i]);
            ++i;
        }
    }

    default public void putUnpackedArray(@ReadonlyValue short[] bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceShort(int destBitOffset, @ReadonlyValue Slice<short[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceShort(@ReadonlyValue Slice<short[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArrayFromSliceShort(0, bitfields, lengthOfEachElementInBits);
    }

    default public void getUnpackedArray(int sourceBitOffset, @WritableValue short[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 16) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            bitfields[sourceElementOffset + i] = (short)this.getBitfield(sourceBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits);
            ++i;
        }
    }

    default public void getUnpackedArray(@WritableValue short[] bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceShort(int sourceBitOffset, @WritableValue Slice<short[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(sourceBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceShort(@WritableValue Slice<short[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArrayToSliceShort(0, bitfields, lengthOfEachElementInBits);
    }

    default public void putArray(int destBitOffset, @ReadonlyValue int[] bitfields, int sourceElementOffset, int elementCount, @ActuallyUnsigned int totalLengthOfDataToInsertInBits) {
        int primlen = 32;
        int lengthInBitsInt = BitfieldSafeCasts.safeCastU64toS32(totalLengthOfDataToInsertInBits);
        if (elementCount != -1 && SmallIntegerMathUtilities.ceilingDivision(lengthInBitsInt, primlen) > elementCount) {
            throw new IllegalArgumentException("Array bounds check failed; it would have gone past! :[!");
        }
        int numberOfFullElementsToUse = lengthInBitsInt / primlen;
        int i = 0;
        while (i < numberOfFullElementsToUse) {
            this.setBitfield(destBitOffset + i * primlen, primlen, bitfields[sourceElementOffset + i]);
            ++i;
        }
        int fullAmount = numberOfFullElementsToUse * primlen;
        int remainder = lengthInBitsInt - fullAmount;
        assert (remainder >= 0);
        assert (remainder < primlen);
        if (remainder != 0) {
            this.setBitfield(destBitOffset + fullAmount, remainder, bitfields[sourceElementOffset + numberOfFullElementsToUse]);
        }
    }

    default public void putArray(@ReadonlyValue int[] bitfields) {
        this.putArray(0, bitfields, 0, bitfields.length, bitfields.length * 32);
    }

    default public void putArrayFromSliceInt(int destBitOffset, @ReadonlyValue Slice<int[]> bitfields) {
        this.putArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), bitfields.getLength() * 32);
    }

    default public void putArrayFromSliceInt(@ReadonlyValue Slice<int[]> bitfields) {
        this.putArrayFromSliceInt(0, bitfields);
    }

    default public void putUnpackedArray(int destBitOffset, @ReadonlyValue int[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 32) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            this.setBitfield(destBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits, bitfields[sourceElementOffset + i]);
            ++i;
        }
    }

    default public void putUnpackedArray(@ReadonlyValue int[] bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceInt(int destBitOffset, @ReadonlyValue Slice<int[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceInt(@ReadonlyValue Slice<int[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArrayFromSliceInt(0, bitfields, lengthOfEachElementInBits);
    }

    default public void getUnpackedArray(int sourceBitOffset, @WritableValue int[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 32) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            bitfields[sourceElementOffset + i] = (int)this.getBitfield(sourceBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits);
            ++i;
        }
    }

    default public void getUnpackedArray(@WritableValue int[] bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceInt(int sourceBitOffset, @WritableValue Slice<int[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(sourceBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceInt(@WritableValue Slice<int[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArrayToSliceInt(0, bitfields, lengthOfEachElementInBits);
    }

    default public void putArray(int destBitOffset, @ReadonlyValue long[] bitfields, int sourceElementOffset, int elementCount, @ActuallyUnsigned int totalLengthOfDataToInsertInBits) {
        int primlen = 64;
        int lengthInBitsInt = BitfieldSafeCasts.safeCastU64toS32(totalLengthOfDataToInsertInBits);
        if (elementCount != -1 && SmallIntegerMathUtilities.ceilingDivision(lengthInBitsInt, primlen) > elementCount) {
            throw new IllegalArgumentException("Array bounds check failed; it would have gone past! :[!");
        }
        int numberOfFullElementsToUse = lengthInBitsInt / primlen;
        int i = 0;
        while (i < numberOfFullElementsToUse) {
            this.setBitfield(destBitOffset + i * primlen, primlen, bitfields[sourceElementOffset + i]);
            ++i;
        }
        int fullAmount = numberOfFullElementsToUse * primlen;
        int remainder = lengthInBitsInt - fullAmount;
        assert (remainder >= 0);
        assert (remainder < primlen);
        if (remainder != 0) {
            this.setBitfield(destBitOffset + fullAmount, remainder, bitfields[sourceElementOffset + numberOfFullElementsToUse]);
        }
    }

    default public void putArray(@ReadonlyValue long[] bitfields) {
        this.putArray(0, bitfields, 0, bitfields.length, bitfields.length * 64);
    }

    default public void putArrayFromSliceLong(int destBitOffset, @ReadonlyValue Slice<long[]> bitfields) {
        this.putArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), bitfields.getLength() * 64);
    }

    default public void putArrayFromSliceLong(@ReadonlyValue Slice<long[]> bitfields) {
        this.putArrayFromSliceLong(0, bitfields);
    }

    default public void putUnpackedArray(int destBitOffset, @ReadonlyValue long[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 64) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            this.setBitfield(destBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits, bitfields[sourceElementOffset + i]);
            ++i;
        }
    }

    default public void putUnpackedArray(@ReadonlyValue long[] bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceLong(int destBitOffset, @ReadonlyValue Slice<long[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArray(destBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void putUnpackedArrayFromSliceLong(@ReadonlyValue Slice<long[]> bitfields, int lengthOfEachElementInBits) {
        this.putUnpackedArrayFromSliceLong(0, bitfields, lengthOfEachElementInBits);
    }

    default public void getUnpackedArray(int sourceBitOffset, @WritableValue long[] bitfields, int sourceElementOffset, int elementCount, int lengthOfEachElementInBits) {
        if (lengthOfEachElementInBits < 0) {
            throw new IllegalArgumentException();
        }
        if (lengthOfEachElementInBits > 64) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < elementCount) {
            bitfields[sourceElementOffset + i] = this.getBitfield(sourceBitOffset + i * lengthOfEachElementInBits, lengthOfEachElementInBits);
            ++i;
        }
    }

    default public void getUnpackedArray(@WritableValue long[] bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(0, bitfields, 0, bitfields.length, lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceLong(int sourceBitOffset, @WritableValue Slice<long[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArray(sourceBitOffset, bitfields.getUnderlying(), bitfields.getOffset(), bitfields.getLength(), lengthOfEachElementInBits);
    }

    default public void getUnpackedArrayToSliceLong(@WritableValue Slice<long[]> bitfields, int lengthOfEachElementInBits) {
        this.getUnpackedArrayToSliceLong(0, bitfields, lengthOfEachElementInBits);
    }

    default public String toBinaryStringLE(long regionLength, String delimiter) {
        return this.toBinaryStringLE(regionLength, delimiter, "0", "1");
    }

    default public String toBinaryStringLE(long regionLength, String delimiter, String zeroRepr, String oneRepr) {
        return this.toBinaryStringLE(new long[]{regionLength}, new String[]{delimiter}, zeroRepr, oneRepr);
    }

    default public String toBinaryStringLENoDelimiters(String zeroRepr, String oneRepr) {
        return this.toBinaryStringLE(null, null, zeroRepr, oneRepr);
    }

    default public String toBinaryStringLENoDelimiters() {
        return this.toBinaryStringLENoDelimiters("0", "1");
    }

    default public String toBinaryStringLE(long[] regionLengths, String[] delimiters, String zeroRepr, String oneRepr) {
        StringBuilder rv = new StringBuilder();
        int i = 0;
        while (i < this.size()) {
            boolean bit = this.getBoolean(i);
            rv.append(bit ? oneRepr : zeroRepr);
            if (regionLengths != null && regionLengths.length != 0) {
                int regionIndexOfLongestMatchingRegion = 0;
                regionIndexOfLongestMatchingRegion = -1;
                int e = 0;
                while (e < regionLengths.length) {
                    if ((long)(i + 1) % regionLengths[e] == 0L && (regionIndexOfLongestMatchingRegion == -1 || regionLengths[e] > regionLengths[regionIndexOfLongestMatchingRegion])) {
                        regionIndexOfLongestMatchingRegion = e;
                    }
                    ++e;
                }
                if (regionIndexOfLongestMatchingRegion != -1 && i < this.size() - 1) {
                    rv.append(delimiters[regionIndexOfLongestMatchingRegion]);
                }
            }
            ++i;
        }
        return rv.toString();
    }

    default public void unsignedIntegerToStringBE(int radix, StringBuilder buff) {
        if (this.size() <= 63) {
            buff.append(Long.toString(this.getEntireByBitfield(), radix));
        } else if (this.size() == 64) {
            buff.append(StringUtilities.toStringU64(this.getEntireByBitfield(), radix));
        } else {
            BigInteger bi = this.toBigIntegerLE();
            buff.append(bi.toString(radix));
        }
    }

    default public String unsignedIntegerToStringBE(int radix) {
        if (this.size() <= 63) {
            return Long.toString(this.getEntireByBitfield(), radix);
        }
        if (this.size() == 64) {
            return StringUtilities.toStringU64(this.getEntireByBitfield(), radix);
        }
        StringBuilder buff = new StringBuilder();
        this.unsignedIntegerToStringBE(radix, buff);
        return buff.toString();
    }

    @Override
    default public String _toString() {
        return PrimitiveCollections.defaultBooleanListToString((PrimitiveCollections.BooleanList)this);
    }
}

