/*
 * Decompiled with CFR 0.152.
 */
package rebound.dataformats.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.bits.Endianness;
import rebound.exceptions.ImpossibleException;
import rebound.io.util.JRECompatIOUtilities;
import rebound.text.encodings.CharsetAndEncodingUtilities;
import rebound.text.encodings.UnicodeByteOrderMark;

public class XMLEncodingDetection {
    public static final Charset XMLDefaultCharset = StandardCharsets.UTF_8;
    private static final byte[] XMLDeclarationOpeningAfterSecond = new byte[]{120, 109, 108};
    private static final byte[] XMLDeclarationOpeningAfterFirstLE;
    private static final byte[] XMLDeclarationOpeningAfterFirstBE;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 109;
        byArray[2] = 108;
        XMLDeclarationOpeningAfterFirstLE = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[1] = 109;
        byArray2[3] = 108;
        XMLDeclarationOpeningAfterFirstBE = byArray2;
    }

    @Nonnull
    public static XMLDeclarationAndExtra readXMLDeclaration(InputStream in) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int b0 = in.read();
        if (b0 != -1) {
            buf.write(b0);
        }
        while (b0 == 0 || b0 == 32 || b0 == 9 || b0 == 13 || b0 == 10) {
            b0 = in.read();
            if (b0 == -1) continue;
            buf.write(b0);
        }
        if (b0 == 239) {
            int b1 = in.read();
            if (b1 != -1) {
                buf.write(b1);
            }
            if (b1 == 187) {
                int b2 = in.read();
                if (b2 != -1) {
                    buf.write(b2);
                }
                if (b2 == 191) {
                    return new XMLDeclarationAndExtra(buf.toByteArray(), true, (Object)UnicodeByteOrderMark.UTF8);
                }
                if (b2 == -1) {
                    return new XMLDeclarationAndExtra(buf.toByteArray(), false);
                }
                return new XMLDeclarationAndExtra(buf.toByteArray(), false);
            }
            if (b1 == -1) {
                return new XMLDeclarationAndExtra(buf.toByteArray(), false);
            }
            return new XMLDeclarationAndExtra(buf.toByteArray(), false);
        }
        if (b0 == 255) {
            int b1 = in.read();
            if (b1 != -1) {
                buf.write(b1);
            }
            if (b1 == 254) {
                return new XMLDeclarationAndExtra(buf.toByteArray(), true, (Object)UnicodeByteOrderMark.UTF16LE);
            }
            if (b1 == -1) {
                return new XMLDeclarationAndExtra(buf.toByteArray(), false);
            }
            return new XMLDeclarationAndExtra(buf.toByteArray(), false);
        }
        if (b0 == 254) {
            int b1 = in.read();
            if (b1 != -1) {
                buf.write(b1);
            }
            if (b1 == 255) {
                return new XMLDeclarationAndExtra(buf.toByteArray(), true, (Object)UnicodeByteOrderMark.UTF16BE);
            }
            if (b1 == -1) {
                return new XMLDeclarationAndExtra(buf.toByteArray(), false);
            }
            return new XMLDeclarationAndExtra(buf.toByteArray(), false);
        }
        if (b0 == -1) {
            return new XMLDeclarationAndExtra(buf.toByteArray(), false);
        }
        if (b0 == 60) {
            int b1 = in.read();
            if (b1 != -1) {
                buf.write(b1);
            }
            if (b1 == -1) {
                return new XMLDeclarationAndExtra(buf.toByteArray(), false);
            }
            if (b0 == 60 && b1 == 63) {
                byte[] open = JRECompatIOUtilities.readAsMuchAsPossibleToNew(in, 3);
                buf.write(open);
                if (!Arrays.equals(open, XMLDeclarationOpeningAfterSecond)) {
                    return new XMLDeclarationAndExtra(buf.toByteArray(), false);
                }
                boolean inQuestionMark = false;
                while (true) {
                    int c;
                    if ((c = in.read()) != -1) {
                        buf.write(c);
                    }
                    if (c == -1) {
                        return new XMLDeclarationAndExtra(buf.toByteArray(), false);
                    }
                    if (c == 63) {
                        inQuestionMark = true;
                        continue;
                    }
                    if (c == 62) {
                        if (!inQuestionMark) continue;
                        break;
                    }
                    inQuestionMark = false;
                }
                return new XMLDeclarationAndExtra(buf.toByteArray(), true);
            }
            if (b0 == 60 && b1 == 0) {
                boolean little;
                block45: {
                    int c;
                    int b;
                    int a;
                    boolean bl = little = buf.size() % 2 == 0;
                    if (little) {
                        a = in.read();
                        if (a == -1) {
                            return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                        }
                        buf.write(a);
                        b = in.read();
                        if (b == -1) {
                            return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                        }
                        buf.write(b);
                        c = a | b << 8;
                        if (c != 63) {
                            return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                        }
                    } else {
                        a = in.read();
                        if (a == -1) {
                            return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                        }
                        buf.write(a);
                        if (a != 63) {
                            return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                        }
                    }
                    do {
                        if ((a = in.read()) == -1) {
                            return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                        }
                        buf.write(a);
                        b = in.read();
                        if (b == -1) {
                            return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                        }
                        buf.write(b);
                        c = little ? a | b << 8 : b | a << 8;
                        if (c == 120) break block45;
                    } while (c == 32 || c == 0 || c == 9 || c == 10 || c == 13);
                    return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                }
                byte[] x = little ? XMLDeclarationOpeningAfterFirstLE : XMLDeclarationOpeningAfterFirstBE;
                byte[] open = JRECompatIOUtilities.readAsMuchAsPossibleToNew(in, x.length);
                buf.write(open);
                if (!Arrays.equals(open, x)) {
                    return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                }
                boolean inQuestionMark = false;
                while (true) {
                    int a;
                    if ((a = in.read()) == -1) {
                        return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                    }
                    buf.write(a);
                    int b = in.read();
                    if (b == -1) {
                        return new XMLDeclarationAndExtra(buf.toByteArray(), false, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
                    }
                    buf.write(b);
                    int c = little ? a | b << 8 : b | a << 8;
                    if (c == 63) {
                        inQuestionMark = true;
                        continue;
                    }
                    if (c == 62) {
                        if (!inQuestionMark) continue;
                        break;
                    }
                    inQuestionMark = false;
                }
                return new XMLDeclarationAndExtra(buf.toByteArray(), true, (Object)(little ? XMLWideCharDetection.LE : XMLWideCharDetection.BE));
            }
            return new XMLDeclarationAndExtra(buf.toByteArray(), false);
        }
        return new XMLDeclarationAndExtra(buf.toByteArray(), false);
    }

    @Nonnull
    public static XMLDeclarationAndExtra readXMLDeclarationFromMemory(byte[] b) {
        try {
            return XMLEncodingDetection.readXMLDeclaration(new ByteArrayInputStream(b));
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static XMLEncodingAndPushedbackStream readAndUnreadXMLDeclaration(InputStream in) throws IOException, UnsupportedCharsetException {
        XMLWideCharDetection wcd;
        XMLDeclarationAndExtra r = XMLEncodingDetection.readXMLDeclaration(in);
        XMLWideCharDetection xMLWideCharDetection = wcd = r.knownFromBOMOrXMLWideCharDetection instanceof XMLWideCharDetection ? (XMLWideCharDetection)((Object)r.knownFromBOMOrXMLWideCharDetection) : null;
        Object encoding = r.knownFromBOMOrXMLWideCharDetection instanceof UnicodeByteOrderMark ? r.knownFromBOMOrXMLWideCharDetection : (r.areBytesAnXMLDeclaration ? XMLEncodingDetection.getEncodingNameFromXMLDeclaration(r.bytes, wcd) : null);
        return new XMLEncodingAndPushedbackStream(encoding, wcd, new SequenceInputStream(new ByteArrayInputStream(r.bytes), in));
    }

    @Nonnull
    public static Charset readXMLDeclarationForEncoding(InputStream in) throws IOException, UnsupportedCharsetException {
        Charset c = XMLEncodingDetection.readXMLDeclarationForEncodingOrNull(in);
        return c == null ? XMLDefaultCharset : c;
    }

    @Nullable
    public static Charset readXMLDeclarationForEncodingOrNull(InputStream in) throws IOException, UnsupportedCharsetException {
        XMLWideCharDetection wcd;
        XMLDeclarationAndExtra r = XMLEncodingDetection.readXMLDeclaration(in);
        XMLWideCharDetection xMLWideCharDetection = wcd = r.knownFromBOMOrXMLWideCharDetection instanceof XMLWideCharDetection ? (XMLWideCharDetection)((Object)r.knownFromBOMOrXMLWideCharDetection) : null;
        Object encoding = r.knownFromBOMOrXMLWideCharDetection instanceof UnicodeByteOrderMark ? r.knownFromBOMOrXMLWideCharDetection : (r.areBytesAnXMLDeclaration ? XMLEncodingDetection.getEncodingNameFromXMLDeclaration(r.bytes, wcd) : null);
        return XMLEncodingDetection.encodingDeclarationTypeToSemanticEncoding(encoding, wcd);
    }

    @Nonnull
    public static Charset encodingDeclarationTypeToSemanticEncoding(@Nullable Object encoding, @Nullable XMLWideCharDetection wcd) throws UnsupportedCharsetException {
        Charset c = XMLEncodingDetection.encodingDeclarationTypeToSemanticEncodingOrNull(encoding, wcd);
        return c == null ? XMLDefaultCharset : c;
    }

    @Nullable
    public static Charset encodingDeclarationTypeToSemanticEncodingOrNull(@Nullable Object encoding, @Nullable XMLWideCharDetection wcd) throws UnsupportedCharsetException {
        if (encoding == null) {
            return null;
        }
        if (encoding instanceof UnicodeByteOrderMark) {
            return ((UnicodeByteOrderMark)((Object)encoding)).getEncoding();
        }
        return CharsetAndEncodingUtilities.forNameWithExplicitByteOrdering((String)encoding, XMLWideCharDetection.wcdToEndianness(wcd));
    }

    public static Charset getNominalCharsetForParsingXMLDeclaration(@Nullable XMLWideCharDetection wcd) {
        return wcd == null ? StandardCharsets.UTF_8 : (wcd == XMLWideCharDetection.LE ? StandardCharsets.UTF_16LE : StandardCharsets.UTF_16BE);
    }

    @Nullable
    public static String getEncodingNameFromXMLDeclaration(byte[] declaration, @Nullable XMLWideCharDetection wcd) {
        String decl = new String(declaration, XMLEncodingDetection.getNominalCharsetForParsingXMLDeclaration(wcd));
        String t = "encoding";
        int i = decl.toLowerCase().indexOf(t);
        if (i == -1) {
            return null;
        }
        i += t.length();
        int length = decl.length();
        while (i < length && Character.isWhitespace(decl.charAt(i))) {
            ++i;
        }
        if (i >= length || decl.charAt(i) != '=') {
            return null;
        }
        ++i;
        while (i < length && Character.isWhitespace(decl.charAt(i))) {
            ++i;
        }
        if (i >= length) {
            return null;
        }
        char q = decl.charAt(i);
        if (q == '\"' || q == '\'') {
            int start = ++i;
            while (i < length && decl.charAt(i) != q) {
                ++i;
            }
            if (i >= length) {
                return null;
            }
            assert (decl.charAt(i) == q);
            int end = i;
            return decl.substring(start, end);
        }
        return null;
    }

    public static class XMLDeclarationAndExtra {
        public byte[] bytes;
        public boolean areBytesAnXMLDeclaration;
        @Nullable
        public Object knownFromBOMOrXMLWideCharDetection;

        public XMLDeclarationAndExtra(byte[] bytes, boolean areBytesAnXMLDeclaration, @Nullable Object knownFromBOMOrXMLWideCharDetection) {
            this.bytes = bytes;
            this.areBytesAnXMLDeclaration = areBytesAnXMLDeclaration;
            this.knownFromBOMOrXMLWideCharDetection = knownFromBOMOrXMLWideCharDetection;
        }

        public XMLDeclarationAndExtra(byte[] bytes, boolean areBytesAnXMLDeclaration) {
            this(bytes, areBytesAnXMLDeclaration, null);
        }
    }

    public static class XMLEncodingAndPushedbackStream {
        @Nullable
        public Object encoding;
        @Nullable
        public XMLWideCharDetection wcd;
        @Nonnull
        public InputStream stream;

        public XMLEncodingAndPushedbackStream(@Nullable Object encoding, @Nullable XMLWideCharDetection wcd, @Nonnull InputStream stream) {
            this.encoding = encoding;
            this.wcd = wcd;
            this.stream = Objects.requireNonNull(stream);
        }

        @Nonnull
        public Charset encodingToCharset() {
            return XMLEncodingDetection.encodingDeclarationTypeToSemanticEncoding(this.encoding, this.wcd);
        }

        @Nullable
        public Charset encodingToCharsetOrNull() {
            return XMLEncodingDetection.encodingDeclarationTypeToSemanticEncoding(this.encoding, this.wcd);
        }
    }

    public static enum XMLWideCharDetection {
        LE,
        BE;


        @Nullable
        public static Endianness wcdToEndianness(XMLWideCharDetection wcd) {
            return wcd == null ? null : (wcd == LE ? Endianness.Little : Endianness.Big);
        }
    }
}

