/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import rebound.annotations.hints.IntendedToBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.exceptions.NoSuchElementReturnPath;
import rebound.exceptions.NonrectangularException;
import rebound.exceptions.NotSupportedReturnPath;
import rebound.exceptions.NotYetImplementedException;
import rebound.util.functional.ContinueSignal;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.Copyable;
import rebound.util.objectutil.Equivalenceable;

public interface SimpleTable<E>
extends Copyable,
Equivalenceable {
    @Nonnegative
    public int getNumberOfColumns();

    @Nonnegative
    public int getNumberOfRows();

    public boolean isReadableTable();

    public boolean isWritableTable();

    default public int getNumberOfCells() {
        return this.getNumberOfColumns() * this.getNumberOfRows();
    }

    default public boolean isEmpty() {
        return this.getNumberOfCells() == 0;
    }

    @Nullable
    public E getCellContents(int var1, int var2) throws IndexOutOfBoundsException;

    public void setCellContents(int var1, int var2, @Nullable E var3) throws IndexOutOfBoundsException;

    default public E getrpCellContents(int columnIndex, int rowIndex) throws NoSuchElementReturnPath {
        if (columnIndex < 0 || columnIndex >= this.getNumberOfColumns()) {
            throw NoSuchElementReturnPath.I;
        }
        if (rowIndex < 0 || rowIndex >= this.getNumberOfRows()) {
            throw NoSuchElementReturnPath.I;
        }
        return this.getCellContents(columnIndex, rowIndex);
    }

    public void deleteColumn(int var1);

    public void deleteRow(int var1);

    public void insertEmptyColumn(int var1);

    public void insertEmptyRow(int var1);

    default public void appendEmptyColumn() {
        this.insertEmptyColumn(this.getNumberOfColumns());
    }

    default public void appendEmptyRow() {
        this.insertEmptyRow(this.getNumberOfRows());
    }

    public void redimToZeroByZeroErasingAllContents();

    public void redimPossiblyWithoutClearing(int var1, int var2);

    @IntendedToBeSubclassedImplementedOrOverriddenByApiUser
    default public void clearAndRedim(int numberOfColumns, int numberOfRows) {
        this.redimPossiblyWithoutClearing(numberOfColumns, numberOfRows);
        this.redimToZeroByZeroErasingAllContents();
    }

    default public void reorderColumn(int oldIndex, int newIndex) {
        SimpleTable.defaultReorderColumn(oldIndex, newIndex);
    }

    default public void reorderRow(int oldIndex, int newIndex) {
        SimpleTable.defaultReorderRow(oldIndex, newIndex);
    }

    public static void defaultReorderColumn(int oldIndex, int newIndex) {
        throw new NotYetImplementedException();
    }

    public static void defaultReorderRow(int oldIndex, int newIndex) {
        throw new NotYetImplementedException();
    }

    public static <E> void defaultCopyRegion(SimpleTable<E> source, int columnOffsetInSource, int rowOffsetInSource, SimpleTable<? super E> dest, int columnOffsetInDest, int rowOffsetInDest, int widthInColumns, int heightInRows) {
        int r = 0;
        while (r < heightInRows) {
            int c = 0;
            while (c < widthInColumns) {
                E v = source.getCellContents(c + columnOffsetInSource, r + rowOffsetInSource);
                dest.setCellContents(c + columnOffsetInDest, r + rowOffsetInDest, v);
                ++c;
            }
            ++r;
        }
    }

    @Override
    default public void setFrom(@ReadonlyValue @SnapshotValue Object source) throws ClassCastException {
        SimpleTable.defaultSetFrom(this, source);
    }

    public static <E> void defaultSetFrom(SimpleTable<E> self, @ReadonlyValue @SnapshotValue Object source) throws ClassCastException {
        SimpleTable sourceTable = (SimpleTable)source;
        int w = sourceTable.getNumberOfColumns();
        int h = sourceTable.getNumberOfRows();
        self.clearAndRedim(w, h);
        SimpleTable.defaultCopyRegion(sourceTable, 0, 0, self, 0, 0, w, h);
    }

    default public void setFromListOfRows(@ReadonlyValue @SnapshotValue List<List<E>> rows) throws NonrectangularException {
        SimpleTable.defaultSetFromListOfRows(this, rows);
    }

    public static <E> void defaultSetFromListOfRows(SimpleTable<E> self, @ReadonlyValue @SnapshotValue List<List<E>> rows) throws NonrectangularException {
        if (rows.isEmpty()) {
            self.clearAndRedim(0, 0);
        } else {
            int w = rows.get(0).size();
            self.clearAndRedim(w, rows.size());
            int r = 0;
            while (r < self.getNumberOfRows()) {
                List<E> row = rows.get(r);
                if (row.size() != w) {
                    throw new NonrectangularException("The list-of-lists was not rectangular!  Not all rows were the same size!");
                }
                int c = 0;
                while (c < self.getNumberOfColumns()) {
                    E cell = row.get(c);
                    self.setCellContents(c, r, cell);
                    ++c;
                }
                ++r;
            }
        }
    }

    default public void setFromArrayOfArrays(@ReadonlyValue @SnapshotValue E[][] source) throws NonrectangularException {
        SimpleTable.defaultSetFromArrayOfArrays(this, source);
    }

    public static <E> void defaultSetFromArrayOfArrays(SimpleTable<E> self, @ReadonlyValue @SnapshotValue E[][] source) throws NonrectangularException {
        if (source.length == 0) {
            self.clearAndRedim(0, 0);
        } else {
            int w = source[0].length;
            self.clearAndRedim(w, source.length);
            int r = 0;
            while (r < self.getNumberOfRows()) {
                E[] row = source[r];
                if (row.length != w) {
                    throw new NonrectangularException("The list-of-lists was not rectangular!  Not all rows were the same size!");
                }
                int c = 0;
                while (c < self.getNumberOfColumns()) {
                    E cell = row[c];
                    self.setCellContents(c, r, cell);
                    ++c;
                }
                ++r;
            }
        }
    }

    default public void setRowFromList(int r, @ReadonlyValue @SnapshotValue List<E> source) throws NonrectangularException {
        SimpleTable.defaultSetRowFromList(this, r, source);
    }

    public static <E> void defaultSetRowFromList(SimpleTable<E> self, int r, @ReadonlyValue @SnapshotValue List<E> source) throws NonrectangularException {
        int w = self.getNumberOfColumns();
        if (source.size() != w) {
            throw new IllegalArgumentException("Wrong size");
        }
        int c = 0;
        while (c < w) {
            E cell = source.get(c);
            self.setCellContents(c, r, cell);
            ++c;
        }
    }

    default public void setRowFromArray(int r, E ... source) throws NonrectangularException {
        SimpleTable.defaultSetRowFromArray(this, r, source);
    }

    public static <E> void defaultSetRowFromArray(SimpleTable<E> self, int r, E ... source) throws NonrectangularException {
        int w = self.getNumberOfColumns();
        if (source.length != w) {
            throw new IllegalArgumentException("Wrong size");
        }
        int c = 0;
        while (c < w) {
            E cell = source[c];
            self.setCellContents(c, r, cell);
            ++c;
        }
    }

    default public void setColumnFromList(int r, @ReadonlyValue @SnapshotValue List<E> source) throws NonrectangularException {
        SimpleTable.defaultSetColumnFromList(this, r, source);
    }

    public static <E> void defaultSetColumnFromList(SimpleTable<E> self, int c, @ReadonlyValue @SnapshotValue List<E> source) throws NonrectangularException {
        int h = self.getNumberOfRows();
        if (source.size() != h) {
            throw new IllegalArgumentException("Wrong size");
        }
        int r = 0;
        while (r < h) {
            E cell = source.get(r);
            self.setCellContents(c, r, cell);
            ++r;
        }
    }

    default public void setColumnFromArray(int r, E ... source) throws NonrectangularException {
        SimpleTable.defaultSetColumnFromArray(this, r, source);
    }

    public static <E> void defaultSetColumnFromArray(SimpleTable<E> self, int c, E ... source) throws NonrectangularException {
        int h = self.getNumberOfRows();
        if (source.length != h) {
            throw new IllegalArgumentException("Wrong size");
        }
        int r = 0;
        while (r < h) {
            E cell = source[r];
            self.setCellContents(c, r, cell);
            ++r;
        }
    }

    @ThrowAwayValue
    default public List<List<E>> toListOfRows() {
        return SimpleTable.defaultToListOfRows(this);
    }

    @ThrowAwayValue
    public static <E> List<List<E>> defaultToListOfRows(SimpleTable<E> self) {
        ArrayList<List<List<E>>> rows = new ArrayList<List<List<E>>>();
        int h = self.getNumberOfRows();
        int r = 0;
        while (r < h) {
            rows.add(self.rowToList(r));
            ++r;
        }
        return rows;
    }

    @ThrowAwayValue
    default public List<E> rowToList(int r) {
        return SimpleTable.defaultRowToList(this, r);
    }

    @ThrowAwayValue
    public static <E> List<E> defaultRowToList(SimpleTable<E> self, int r) {
        int w = self.getNumberOfColumns();
        ArrayList<E> row = new ArrayList<E>();
        int c = 0;
        while (c < w) {
            E cell = self.getCellContents(c, r);
            row.add(cell);
            ++c;
        }
        return row;
    }

    @ThrowAwayValue
    default public List<E> columnToList(int c) {
        return SimpleTable.defaultColumnToList(this, c);
    }

    @ThrowAwayValue
    public static <E> List<E> defaultColumnToList(SimpleTable<E> self, int c) {
        int h = self.getNumberOfRows();
        ArrayList<E> column = new ArrayList<E>();
        int r = 0;
        while (r < h) {
            E cell = self.getCellContents(c, r);
            column.add(cell);
            ++r;
        }
        return column;
    }

    @PossiblySnapshotPossiblyLiveValue
    default public List<List<E>> toListOfRowsPossiblyLive() {
        return this.toListOfRows();
    }

    @PossiblySnapshotPossiblyLiveValue
    default public List<E> rowToListPossiblyLive(int index) {
        return this.rowToList(index);
    }

    default public boolean forAll(Predicate<E> predicate) {
        return this.forAll(predicate, 0, 0, this.getNumberOfColumns(), this.getNumberOfRows());
    }

    default public boolean forAny(Predicate<E> predicate) {
        return this.forAny(predicate, 0, 0, this.getNumberOfColumns(), this.getNumberOfRows());
    }

    default public boolean forAllInColumn(Predicate<E> predicate, int columnIndex) {
        return this.forAll(predicate, columnIndex, 0, 1, this.getNumberOfRows());
    }

    default public boolean forAnyInColumn(Predicate<E> predicate, int columnIndex) {
        return this.forAny(predicate, columnIndex, 0, 1, this.getNumberOfRows());
    }

    default public boolean forAllInRow(Predicate<E> predicate, int rowIndex) {
        return this.forAll(predicate, 0, rowIndex, this.getNumberOfColumns(), 1);
    }

    default public boolean forAnyInRow(Predicate<E> predicate, int rowIndex) {
        return this.forAny(predicate, 0, rowIndex, this.getNumberOfColumns(), 1);
    }

    default public boolean forAll(Predicate<E> predicate, int firstColumn, int firstRow, int numberOfColumns, int numberOfRows) {
        int pastLastColumn = firstColumn + numberOfColumns;
        int pastLastRow = firstRow + numberOfRows;
        int r = firstRow;
        while (r < pastLastRow) {
            int c = firstColumn;
            while (c < pastLastColumn) {
                if (!predicate.test(this.getCellContents(c, r))) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    default public boolean forAny(Predicate<E> predicate, int firstColumn, int firstRow, int numberOfColumns, int numberOfRows) {
        int pastLastColumn = firstColumn + numberOfColumns;
        int pastLastRow = firstRow + numberOfRows;
        int r = firstRow;
        while (r < pastLastRow) {
            int c = firstColumn;
            while (c < pastLastColumn) {
                if (predicate.test(this.getCellContents(c, r))) {
                    return true;
                }
                ++c;
            }
            ++r;
        }
        return false;
    }

    default public void mapInPlace(FunctionInterfaces.UnaryFunction<E, E> mapper) {
        int w = this.getNumberOfColumns();
        int h = this.getNumberOfRows();
        int r = 0;
        while (r < h) {
            int c = 0;
            while (c < w) {
                this.setCellContents(c, r, mapper.f(this.getCellContents(c, r)));
                ++c;
            }
            ++r;
        }
    }

    default public void apply(FunctionInterfaces.UnaryProcedure<E> observer) {
        this.applyStoppable(v -> {
            observer.f(v);
            return ContinueSignal.Continue;
        });
    }

    default public ContinueSignal applyStoppable(FunctionInterfaces.UnaryFunction<E, ContinueSignal> observer) {
        int w = this.getNumberOfColumns();
        int h = this.getNumberOfRows();
        int r = 0;
        while (r < h) {
            int c = 0;
            while (c < w) {
                ContinueSignal rv = observer.f(this.getCellContents(c, r));
                if (rv == ContinueSignal.Stop) {
                    return rv;
                }
                ++c;
            }
            ++r;
        }
        return ContinueSignal.Continue;
    }

    default public void setAllToSameValue(E value) {
        this.setAllToSameValue(value, 0, 0, this.getNumberOfColumns(), this.getNumberOfRows());
    }

    default public void setAllToSameValue(E value, int firstColumn, int firstRow, int numberOfColumns, int numberOfRows) {
        int pastLastColumn = firstColumn + numberOfColumns;
        int pastLastRow = firstRow + numberOfRows;
        int r = firstRow;
        while (r < pastLastRow) {
            int c = firstColumn;
            while (c < pastLastColumn) {
                this.setCellContents(c, r, value);
                ++c;
            }
            ++r;
        }
    }

    @Override
    default public boolean equivalent(Object other) throws NotSupportedReturnPath {
        return other instanceof SimpleTable ? SimpleTable.defaultEquivalent(this, (SimpleTable)other) : false;
    }

    @Override
    default public int hashCodeOfContents() {
        return SimpleTable.defaultHashcodeOfContents(this);
    }

    public static boolean defaultEquivalent(SimpleTable<?> a, SimpleTable<?> b) {
        int w = a.getNumberOfColumns();
        int h = a.getNumberOfRows();
        if (b.getNumberOfColumns() != w || b.getNumberOfRows() != h) {
            return false;
        }
        return a.equalsRegion(b, 0, 0, w, h);
    }

    public static int defaultHashcodeOfContents(SimpleTable<?> t) {
        int hashCode = 1;
        int w = t.getNumberOfColumns();
        int h = t.getNumberOfRows();
        int r = 0;
        while (r < h) {
            int c = 0;
            while (c < w) {
                Object e = t.getCellContents(c, r);
                hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
                ++c;
            }
            ++r;
        }
        return hashCode;
    }

    default public boolean equalsRegion(SimpleTable<?> otherTable, int firstColumn, int firstRow, int numberOfColumns, int numberOfRows) {
        int pastLastColumn = firstColumn + numberOfColumns;
        int pastLastRow = firstRow + numberOfRows;
        int r = firstRow;
        while (r < pastLastRow) {
            int c = firstColumn;
            while (c < pastLastColumn) {
                if (!BasicObjectUtilities.eq(this.getCellContents(c, r), otherTable.getCellContents(c, r))) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    default public int indexOfInRow(E value, int row) {
        int i = 1;
        while (i < this.getNumberOfColumns()) {
            if (BasicObjectUtilities.eq(this.getCellContents(i, row), value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    default public int indexOfInColumn(String value, int column) {
        int i = 1;
        while (i < this.getNumberOfRows()) {
            if (BasicObjectUtilities.eq(this.getCellContents(column, i), (Object)value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

